/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@SystemApi
public class PinResult
implements Parcelable {
    public static final int PIN_RESULT_TYPE_SUCCESS = 0;
    public static final int PIN_RESULT_TYPE_INCORRECT = 1;
    public static final int PIN_RESULT_TYPE_FAILURE = 2;
    public static final int PIN_RESULT_TYPE_ABORTED = 3;
    private static final PinResult sFailedResult = new PinResult(2, -1);
    @PinResultType
    private final int mResult;
    private final int mAttemptsRemaining;
    public static final Parcelable.Creator<PinResult> CREATOR = new Parcelable.Creator<PinResult>(){

        @Override
        public PinResult createFromParcel(Parcel in) {
            return new PinResult(in);
        }

        public PinResult[] newArray(int size) {
            return new PinResult[size];
        }
    };

    @PinResultType
    public int getResult() {
        return this.mResult;
    }

    public int getAttemptsRemaining() {
        return this.mAttemptsRemaining;
    }

    public static PinResult getDefaultFailedResult() {
        return sFailedResult;
    }

    public PinResult(@PinResultType int result, int attemptsRemaining) {
        this.mResult = result;
        this.mAttemptsRemaining = attemptsRemaining;
    }

    private PinResult(Parcel in) {
        this.mResult = in.readInt();
        this.mAttemptsRemaining = in.readInt();
    }

    public String toString() {
        return "result: " + this.getResult() + ", attempts remaining: " + this.getAttemptsRemaining();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mResult);
        out.writeInt(this.mAttemptsRemaining);
    }

    public int hashCode() {
        return Objects.hash(this.mAttemptsRemaining, this.mResult);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PinResult other = (PinResult)obj;
        return this.mResult == other.mResult && this.mAttemptsRemaining == other.mAttemptsRemaining;
    }

    public static @interface PinResultType {
    }
}

