/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.RadioAccessSpecifier;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class AvailableNetworkInfo
implements Parcelable {
    public static final int PRIORITY_HIGH = 1;
    public static final int PRIORITY_MED = 2;
    public static final int PRIORITY_LOW = 3;
    private int mSubId;
    private int mPriority;
    private ArrayList<String> mMccMncs;
    @Deprecated
    private ArrayList<Integer> mBands;
    private ArrayList<RadioAccessSpecifier> mRadioAccessSpecifiers;
    public static final Parcelable.Creator<AvailableNetworkInfo> CREATOR = new Parcelable.Creator<AvailableNetworkInfo>(){

        @Override
        public AvailableNetworkInfo createFromParcel(Parcel in) {
            return new AvailableNetworkInfo(in);
        }

        public AvailableNetworkInfo[] newArray(int size) {
            return new AvailableNetworkInfo[size];
        }
    };

    public int getSubId() {
        return this.mSubId;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public List<String> getMccMncs() {
        return (List)this.mMccMncs.clone();
    }

    public List<Integer> getBands() {
        return (List)this.mBands.clone();
    }

    public List<RadioAccessSpecifier> getRadioAccessSpecifiers() {
        return (List)this.mRadioAccessSpecifiers.clone();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mSubId);
        dest.writeInt(this.mPriority);
        dest.writeStringList(this.mMccMncs);
        dest.writeList(this.mBands);
        dest.writeList(this.mRadioAccessSpecifiers);
    }

    private AvailableNetworkInfo(Parcel in) {
        this.mSubId = in.readInt();
        this.mPriority = in.readInt();
        this.mMccMncs = new ArrayList();
        in.readStringList(this.mMccMncs);
        this.mBands = new ArrayList();
        in.readList(this.mBands, Integer.class.getClassLoader(), Integer.class);
        this.mRadioAccessSpecifiers = new ArrayList();
        in.readList(this.mRadioAccessSpecifiers, RadioAccessSpecifier.class.getClassLoader(), RadioAccessSpecifier.class);
    }

    public AvailableNetworkInfo(int subId, int priority, List<String> mccMncs, List<Integer> bands) {
        this(subId, priority, mccMncs, bands, new ArrayList<RadioAccessSpecifier>());
    }

    private AvailableNetworkInfo(int subId, int priority, List<String> mccMncs, List<Integer> bands, List<RadioAccessSpecifier> radioAccessSpecifiers) {
        this.mSubId = subId;
        this.mPriority = priority;
        this.mMccMncs = new ArrayList<String>(mccMncs);
        this.mBands = new ArrayList<Integer>(bands);
        this.mRadioAccessSpecifiers = new ArrayList<RadioAccessSpecifier>(radioAccessSpecifiers);
    }

    public boolean equals(Object o) {
        AvailableNetworkInfo ani;
        try {
            ani = (AvailableNetworkInfo)o;
        }
        catch (ClassCastException ex) {
            return false;
        }
        if (o == null) {
            return false;
        }
        return this.mSubId == ani.mSubId && this.mPriority == ani.mPriority && this.mMccMncs != null && this.mMccMncs.equals(ani.mMccMncs) && this.mBands.equals(ani.mBands) && this.mRadioAccessSpecifiers.equals(ani.getRadioAccessSpecifiers());
    }

    public int hashCode() {
        return Objects.hash(this.mSubId, this.mPriority, this.mMccMncs, this.mBands, this.mRadioAccessSpecifiers);
    }

    public String toString() {
        return "AvailableNetworkInfo: mSubId: " + this.mSubId + " mPriority: " + this.mPriority + " mMccMncs: " + Arrays.toString(this.mMccMncs.toArray()) + " mBands: " + Arrays.toString(this.mBands.toArray()) + " mRadioAccessSpecifiers: " + Arrays.toString(this.mRadioAccessSpecifiers.toArray());
    }

    public static class Builder {
        private int mSubId = Integer.MIN_VALUE;
        private int mPriority = 3;
        private ArrayList<String> mMccMncs = new ArrayList();
        private ArrayList<RadioAccessSpecifier> mRadioAccessSpecifiers = new ArrayList();

        public Builder(int subId) {
            this.mSubId = subId;
        }

        public Builder setPriority(int priority) {
            if (priority > 3 || priority < 1) {
                throw new IllegalArgumentException("A valid priority must be set");
            }
            this.mPriority = priority;
            return this;
        }

        public Builder setMccMncs(List<String> mccMncs) {
            Objects.requireNonNull(mccMncs, "A non-null List of mccmncs must be set. An empty List is still accepted. Please read documentation in AvailableNetworkInfo to see consequences of an empty List.");
            this.mMccMncs = new ArrayList<String>(mccMncs);
            return this;
        }

        public Builder setRadioAccessSpecifiers(List<RadioAccessSpecifier> radioAccessSpecifiers) {
            Objects.requireNonNull(radioAccessSpecifiers, "A non-null List of RadioAccessSpecifiers must be set. An empty List is still accepted. Please read documentation in AvailableNetworkInfo to see consequences of an empty List.");
            this.mRadioAccessSpecifiers = new ArrayList<RadioAccessSpecifier>(radioAccessSpecifiers);
            return this;
        }

        public AvailableNetworkInfo build() {
            if (this.mSubId == Integer.MIN_VALUE) {
                throw new IllegalArgumentException("A valid subId must be set");
            }
            return new AvailableNetworkInfo(this.mSubId, this.mPriority, this.mMccMncs, new ArrayList<Integer>(), this.mRadioAccessSpecifiers);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AvailableNetworkInfoPriority {
    }
}

