/*
 * Decompiled with CFR 0.152.
 */
package android.service.persistentdata;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IPersistentDataBlockService
extends IInterface {
    public int write(byte[] var1) throws RemoteException;

    public byte[] read() throws RemoteException;

    public void wipe() throws RemoteException;

    public int getDataBlockSize() throws RemoteException;

    public long getMaximumDataBlockSize() throws RemoteException;

    public void setOemUnlockEnabled(boolean var1) throws RemoteException;

    public boolean getOemUnlockEnabled() throws RemoteException;

    public int getFlashLockState() throws RemoteException;

    public boolean hasFrpCredentialHandle() throws RemoteException;

    public String getPersistentDataPackageName() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IPersistentDataBlockService {
        public static final String DESCRIPTOR = "android.service.persistentdata.IPersistentDataBlockService";
        static final int TRANSACTION_write = 1;
        static final int TRANSACTION_read = 2;
        static final int TRANSACTION_wipe = 3;
        static final int TRANSACTION_getDataBlockSize = 4;
        static final int TRANSACTION_getMaximumDataBlockSize = 5;
        static final int TRANSACTION_setOemUnlockEnabled = 6;
        static final int TRANSACTION_getOemUnlockEnabled = 7;
        static final int TRANSACTION_getFlashLockState = 8;
        static final int TRANSACTION_hasFrpCredentialHandle = 9;
        static final int TRANSACTION_getPersistentDataPackageName = 10;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IPersistentDataBlockService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IPersistentDataBlockService) {
                return (IPersistentDataBlockService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "write";
                }
                case 2: {
                    return "read";
                }
                case 3: {
                    return "wipe";
                }
                case 4: {
                    return "getDataBlockSize";
                }
                case 5: {
                    return "getMaximumDataBlockSize";
                }
                case 6: {
                    return "setOemUnlockEnabled";
                }
                case 7: {
                    return "getOemUnlockEnabled";
                }
                case 8: {
                    return "getFlashLockState";
                }
                case 9: {
                    return "hasFrpCredentialHandle";
                }
                case 10: {
                    return "getPersistentDataPackageName";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    byte[] _arg0 = data.createByteArray();
                    data.enforceNoDataAvail();
                    int _result = this.write(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 2: {
                    byte[] _result = this.read();
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    break;
                }
                case 3: {
                    this.wipe();
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    int _result = this.getDataBlockSize();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 5: {
                    long _result = this.getMaximumDataBlockSize();
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 6: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setOemUnlockEnabled(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    boolean _result = this.getOemUnlockEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 8: {
                    int _result = this.getFlashLockState();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 9: {
                    boolean _result = this.hasFrpCredentialHandle();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 10: {
                    String _result = this.getPersistentDataPackageName();
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 9;
        }

        private static class Proxy
        implements IPersistentDataBlockService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int write(byte[] data) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeByteArray(data);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] read() throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void wipe() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDataBlockSize() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getMaximumDataBlockSize() throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOemUnlockEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean getOemUnlockEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getFlashLockState() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasFrpCredentialHandle() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getPersistentDataPackageName() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IPersistentDataBlockService {
        @Override
        public int write(byte[] data) throws RemoteException {
            return 0;
        }

        @Override
        public byte[] read() throws RemoteException {
            return null;
        }

        @Override
        public void wipe() throws RemoteException {
        }

        @Override
        public int getDataBlockSize() throws RemoteException {
            return 0;
        }

        @Override
        public long getMaximumDataBlockSize() throws RemoteException {
            return 0L;
        }

        @Override
        public void setOemUnlockEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public boolean getOemUnlockEnabled() throws RemoteException {
            return false;
        }

        @Override
        public int getFlashLockState() throws RemoteException {
            return 0;
        }

        @Override
        public boolean hasFrpCredentialHandle() throws RemoteException {
            return false;
        }

        @Override
        public String getPersistentDataPackageName() throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

