/*
 * Decompiled with CFR 0.152.
 */
package android.service.notification;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationChannelGroup;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.UserHandle;
import android.service.notification.IStatusBarNotificationHolder;
import android.service.notification.NotificationRankingUpdate;
import android.service.notification.NotificationStats;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;

public interface INotificationListener
extends IInterface {
    public void onListenerConnected(NotificationRankingUpdate var1) throws RemoteException;

    public void onNotificationPosted(IStatusBarNotificationHolder var1, NotificationRankingUpdate var2) throws RemoteException;

    public void onStatusBarIconsBehaviorChanged(boolean var1) throws RemoteException;

    public void onNotificationRemoved(IStatusBarNotificationHolder var1, NotificationRankingUpdate var2, NotificationStats var3, int var4) throws RemoteException;

    public void onNotificationRankingUpdate(NotificationRankingUpdate var1) throws RemoteException;

    public void onListenerHintsChanged(int var1) throws RemoteException;

    public void onInterruptionFilterChanged(int var1) throws RemoteException;

    public void onNotificationChannelModification(String var1, UserHandle var2, NotificationChannel var3, int var4) throws RemoteException;

    public void onNotificationChannelGroupModification(String var1, UserHandle var2, NotificationChannelGroup var3, int var4) throws RemoteException;

    public void onNotificationEnqueuedWithChannel(IStatusBarNotificationHolder var1, NotificationChannel var2, NotificationRankingUpdate var3) throws RemoteException;

    public void onNotificationSnoozedUntilContext(IStatusBarNotificationHolder var1, String var2) throws RemoteException;

    public void onNotificationsSeen(List<String> var1) throws RemoteException;

    public void onPanelRevealed(int var1) throws RemoteException;

    public void onPanelHidden() throws RemoteException;

    public void onNotificationVisibilityChanged(String var1, boolean var2) throws RemoteException;

    public void onNotificationExpansionChanged(String var1, boolean var2, boolean var3) throws RemoteException;

    public void onNotificationDirectReply(String var1) throws RemoteException;

    public void onSuggestedReplySent(String var1, CharSequence var2, int var3) throws RemoteException;

    public void onActionClicked(String var1, Notification.Action var2, int var3) throws RemoteException;

    public void onNotificationClicked(String var1) throws RemoteException;

    public void onAllowedAdjustmentsChanged() throws RemoteException;

    public void onNotificationFeedbackReceived(String var1, NotificationRankingUpdate var2, Bundle var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements INotificationListener {
        public static final String DESCRIPTOR = "android.service.notification.INotificationListener";
        static final int TRANSACTION_onListenerConnected = 1;
        static final int TRANSACTION_onNotificationPosted = 2;
        static final int TRANSACTION_onStatusBarIconsBehaviorChanged = 3;
        static final int TRANSACTION_onNotificationRemoved = 4;
        static final int TRANSACTION_onNotificationRankingUpdate = 5;
        static final int TRANSACTION_onListenerHintsChanged = 6;
        static final int TRANSACTION_onInterruptionFilterChanged = 7;
        static final int TRANSACTION_onNotificationChannelModification = 8;
        static final int TRANSACTION_onNotificationChannelGroupModification = 9;
        static final int TRANSACTION_onNotificationEnqueuedWithChannel = 10;
        static final int TRANSACTION_onNotificationSnoozedUntilContext = 11;
        static final int TRANSACTION_onNotificationsSeen = 12;
        static final int TRANSACTION_onPanelRevealed = 13;
        static final int TRANSACTION_onPanelHidden = 14;
        static final int TRANSACTION_onNotificationVisibilityChanged = 15;
        static final int TRANSACTION_onNotificationExpansionChanged = 16;
        static final int TRANSACTION_onNotificationDirectReply = 17;
        static final int TRANSACTION_onSuggestedReplySent = 18;
        static final int TRANSACTION_onActionClicked = 19;
        static final int TRANSACTION_onNotificationClicked = 20;
        static final int TRANSACTION_onAllowedAdjustmentsChanged = 21;
        static final int TRANSACTION_onNotificationFeedbackReceived = 22;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static INotificationListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof INotificationListener) {
                return (INotificationListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onListenerConnected";
                }
                case 2: {
                    return "onNotificationPosted";
                }
                case 3: {
                    return "onStatusBarIconsBehaviorChanged";
                }
                case 4: {
                    return "onNotificationRemoved";
                }
                case 5: {
                    return "onNotificationRankingUpdate";
                }
                case 6: {
                    return "onListenerHintsChanged";
                }
                case 7: {
                    return "onInterruptionFilterChanged";
                }
                case 8: {
                    return "onNotificationChannelModification";
                }
                case 9: {
                    return "onNotificationChannelGroupModification";
                }
                case 10: {
                    return "onNotificationEnqueuedWithChannel";
                }
                case 11: {
                    return "onNotificationSnoozedUntilContext";
                }
                case 12: {
                    return "onNotificationsSeen";
                }
                case 13: {
                    return "onPanelRevealed";
                }
                case 14: {
                    return "onPanelHidden";
                }
                case 15: {
                    return "onNotificationVisibilityChanged";
                }
                case 16: {
                    return "onNotificationExpansionChanged";
                }
                case 17: {
                    return "onNotificationDirectReply";
                }
                case 18: {
                    return "onSuggestedReplySent";
                }
                case 19: {
                    return "onActionClicked";
                }
                case 20: {
                    return "onNotificationClicked";
                }
                case 21: {
                    return "onAllowedAdjustmentsChanged";
                }
                case 22: {
                    return "onNotificationFeedbackReceived";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    NotificationRankingUpdate _arg0 = data.readTypedObject(NotificationRankingUpdate.CREATOR);
                    data.enforceNoDataAvail();
                    this.onListenerConnected(_arg0);
                    break;
                }
                case 2: {
                    IStatusBarNotificationHolder _arg0 = IStatusBarNotificationHolder.Stub.asInterface(data.readStrongBinder());
                    NotificationRankingUpdate _arg1 = data.readTypedObject(NotificationRankingUpdate.CREATOR);
                    data.enforceNoDataAvail();
                    this.onNotificationPosted(_arg0, _arg1);
                    break;
                }
                case 3: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onStatusBarIconsBehaviorChanged(_arg0);
                    break;
                }
                case 4: {
                    IStatusBarNotificationHolder _arg0 = IStatusBarNotificationHolder.Stub.asInterface(data.readStrongBinder());
                    NotificationRankingUpdate _arg1 = data.readTypedObject(NotificationRankingUpdate.CREATOR);
                    NotificationStats _arg2 = data.readTypedObject(NotificationStats.CREATOR);
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onNotificationRemoved(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 5: {
                    NotificationRankingUpdate _arg0 = data.readTypedObject(NotificationRankingUpdate.CREATOR);
                    data.enforceNoDataAvail();
                    this.onNotificationRankingUpdate(_arg0);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onListenerHintsChanged(_arg0);
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onInterruptionFilterChanged(_arg0);
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    UserHandle _arg1 = data.readTypedObject(UserHandle.CREATOR);
                    NotificationChannel _arg2 = data.readTypedObject(NotificationChannel.CREATOR);
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onNotificationChannelModification(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    UserHandle _arg1 = data.readTypedObject(UserHandle.CREATOR);
                    NotificationChannelGroup _arg2 = data.readTypedObject(NotificationChannelGroup.CREATOR);
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onNotificationChannelGroupModification(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 10: {
                    IStatusBarNotificationHolder _arg0 = IStatusBarNotificationHolder.Stub.asInterface(data.readStrongBinder());
                    NotificationChannel _arg1 = data.readTypedObject(NotificationChannel.CREATOR);
                    NotificationRankingUpdate _arg2 = data.readTypedObject(NotificationRankingUpdate.CREATOR);
                    data.enforceNoDataAvail();
                    this.onNotificationEnqueuedWithChannel(_arg0, _arg1, _arg2);
                    break;
                }
                case 11: {
                    IStatusBarNotificationHolder _arg0 = IStatusBarNotificationHolder.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.onNotificationSnoozedUntilContext(_arg0, _arg1);
                    break;
                }
                case 12: {
                    ArrayList<String> _arg0 = data.createStringArrayList();
                    data.enforceNoDataAvail();
                    this.onNotificationsSeen(_arg0);
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onPanelRevealed(_arg0);
                    break;
                }
                case 14: {
                    this.onPanelHidden();
                    break;
                }
                case 15: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onNotificationVisibilityChanged(_arg0, _arg1);
                    break;
                }
                case 16: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onNotificationExpansionChanged(_arg0, _arg1, _arg2);
                    break;
                }
                case 17: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.onNotificationDirectReply(_arg0);
                    break;
                }
                case 18: {
                    String _arg0 = data.readString();
                    CharSequence _arg1 = data.readTypedObject(TextUtils.CHAR_SEQUENCE_CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSuggestedReplySent(_arg0, _arg1, _arg2);
                    break;
                }
                case 19: {
                    String _arg0 = data.readString();
                    Notification.Action _arg1 = data.readTypedObject(Notification.Action.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onActionClicked(_arg0, _arg1, _arg2);
                    break;
                }
                case 20: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.onNotificationClicked(_arg0);
                    break;
                }
                case 21: {
                    this.onAllowedAdjustmentsChanged();
                    break;
                }
                case 22: {
                    String _arg0 = data.readString();
                    NotificationRankingUpdate _arg1 = data.readTypedObject(NotificationRankingUpdate.CREATOR);
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.onNotificationFeedbackReceived(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 21;
        }

        private static class Proxy
        implements INotificationListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onListenerConnected(NotificationRankingUpdate update) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(update, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationPosted(IStatusBarNotificationHolder notificationHolder, NotificationRankingUpdate update) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(notificationHolder);
                    _data.writeTypedObject(update, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStatusBarIconsBehaviorChanged(boolean hideSilentStatusIcons) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(hideSilentStatusIcons);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationRemoved(IStatusBarNotificationHolder notificationHolder, NotificationRankingUpdate update, NotificationStats stats, int reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(notificationHolder);
                    _data.writeTypedObject(update, 0);
                    _data.writeTypedObject(stats, 0);
                    _data.writeInt(reason);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationRankingUpdate(NotificationRankingUpdate update) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(update, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onListenerHintsChanged(int hints) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(hints);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onInterruptionFilterChanged(int interruptionFilter) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(interruptionFilter);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationChannelModification(String pkgName, UserHandle user, NotificationChannel channel, int modificationType) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkgName);
                    _data.writeTypedObject(user, 0);
                    _data.writeTypedObject(channel, 0);
                    _data.writeInt(modificationType);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationChannelGroupModification(String pkgName, UserHandle user, NotificationChannelGroup group, int modificationType) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkgName);
                    _data.writeTypedObject(user, 0);
                    _data.writeTypedObject(group, 0);
                    _data.writeInt(modificationType);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationEnqueuedWithChannel(IStatusBarNotificationHolder notificationHolder, NotificationChannel channel, NotificationRankingUpdate update) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(notificationHolder);
                    _data.writeTypedObject(channel, 0);
                    _data.writeTypedObject(update, 0);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationSnoozedUntilContext(IStatusBarNotificationHolder notificationHolder, String snoozeCriterionId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(notificationHolder);
                    _data.writeString(snoozeCriterionId);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationsSeen(List<String> keys) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringList(keys);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPanelRevealed(int items) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(items);
                    boolean bl = this.mRemote.transact(13, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onPanelHidden() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(14, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationVisibilityChanged(String key, boolean isVisible) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(key);
                    _data.writeBoolean(isVisible);
                    boolean bl = this.mRemote.transact(15, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationExpansionChanged(String key, boolean userAction, boolean expanded) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(key);
                    _data.writeBoolean(userAction);
                    _data.writeBoolean(expanded);
                    boolean bl = this.mRemote.transact(16, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationDirectReply(String key) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(key);
                    boolean bl = this.mRemote.transact(17, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuggestedReplySent(String key, CharSequence reply, int source) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(key);
                    if (reply != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(reply, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(source);
                    boolean bl = this.mRemote.transact(18, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onActionClicked(String key, Notification.Action action, int source) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(key);
                    _data.writeTypedObject(action, 0);
                    _data.writeInt(source);
                    boolean bl = this.mRemote.transact(19, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationClicked(String key) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(key);
                    boolean bl = this.mRemote.transact(20, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onAllowedAdjustmentsChanged() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(21, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationFeedbackReceived(String key, NotificationRankingUpdate update, Bundle feedback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(key);
                    _data.writeTypedObject(update, 0);
                    _data.writeTypedObject(feedback, 0);
                    boolean bl = this.mRemote.transact(22, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements INotificationListener {
        @Override
        public void onListenerConnected(NotificationRankingUpdate update) throws RemoteException {
        }

        @Override
        public void onNotificationPosted(IStatusBarNotificationHolder notificationHolder, NotificationRankingUpdate update) throws RemoteException {
        }

        @Override
        public void onStatusBarIconsBehaviorChanged(boolean hideSilentStatusIcons) throws RemoteException {
        }

        @Override
        public void onNotificationRemoved(IStatusBarNotificationHolder notificationHolder, NotificationRankingUpdate update, NotificationStats stats, int reason) throws RemoteException {
        }

        @Override
        public void onNotificationRankingUpdate(NotificationRankingUpdate update) throws RemoteException {
        }

        @Override
        public void onListenerHintsChanged(int hints) throws RemoteException {
        }

        @Override
        public void onInterruptionFilterChanged(int interruptionFilter) throws RemoteException {
        }

        @Override
        public void onNotificationChannelModification(String pkgName, UserHandle user, NotificationChannel channel, int modificationType) throws RemoteException {
        }

        @Override
        public void onNotificationChannelGroupModification(String pkgName, UserHandle user, NotificationChannelGroup group, int modificationType) throws RemoteException {
        }

        @Override
        public void onNotificationEnqueuedWithChannel(IStatusBarNotificationHolder notificationHolder, NotificationChannel channel, NotificationRankingUpdate update) throws RemoteException {
        }

        @Override
        public void onNotificationSnoozedUntilContext(IStatusBarNotificationHolder notificationHolder, String snoozeCriterionId) throws RemoteException {
        }

        @Override
        public void onNotificationsSeen(List<String> keys) throws RemoteException {
        }

        @Override
        public void onPanelRevealed(int items) throws RemoteException {
        }

        @Override
        public void onPanelHidden() throws RemoteException {
        }

        @Override
        public void onNotificationVisibilityChanged(String key, boolean isVisible) throws RemoteException {
        }

        @Override
        public void onNotificationExpansionChanged(String key, boolean userAction, boolean expanded) throws RemoteException {
        }

        @Override
        public void onNotificationDirectReply(String key) throws RemoteException {
        }

        @Override
        public void onSuggestedReplySent(String key, CharSequence reply, int source) throws RemoteException {
        }

        @Override
        public void onActionClicked(String key, Notification.Action action, int source) throws RemoteException {
        }

        @Override
        public void onNotificationClicked(String key) throws RemoteException {
        }

        @Override
        public void onAllowedAdjustmentsChanged() throws RemoteException {
        }

        @Override
        public void onNotificationFeedbackReceived(String key, NotificationRankingUpdate update, Bundle feedback) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

