/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore2;

import android.os.SystemProperties;
import android.security.KeyStore2;
import android.security.KeyStoreException;
import android.security.KeyStoreSecurityLevel;
import android.security.keystore.KeyPermanentlyInvalidatedException;
import android.security.keystore.KeyProperties;
import android.security.keystore.KeyStoreCryptoOperation;
import android.security.keystore2.AndroidKeyStoreBCWorkaroundProvider;
import android.security.keystore2.AndroidKeyStoreECPublicKey;
import android.security.keystore2.AndroidKeyStoreEdECPublicKey;
import android.security.keystore2.AndroidKeyStoreKey;
import android.security.keystore2.AndroidKeyStorePrivateKey;
import android.security.keystore2.AndroidKeyStorePublicKey;
import android.security.keystore2.AndroidKeyStoreRSAPublicKey;
import android.security.keystore2.AndroidKeyStoreSecretKey;
import android.security.keystore2.AndroidKeyStoreSpi;
import android.security.keystore2.AndroidKeyStoreXDHPublicKey;
import android.system.keystore2.Authorization;
import android.system.keystore2.KeyDescriptor;
import android.system.keystore2.KeyEntryResponse;
import android.system.keystore2.KeyMetadata;
import java.security.KeyPair;
import java.security.Provider;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.UnrecoverableKeyException;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;

public class AndroidKeyStoreProvider
extends Provider {
    private static final String PROVIDER_NAME = "AndroidKeyStore";
    private static final String PACKAGE_NAME = "android.security.keystore2";
    private static final String DESEDE_SYSTEM_PROPERTY = "ro.hardware.keystore_desede";
    private static final String ED25519_OID = "1.3.101.112";
    private static final String X25519_ALIAS = "XDH";

    public AndroidKeyStoreProvider() {
        super(PROVIDER_NAME, 1.0, "Android KeyStore security provider");
        boolean supports3DES = "true".equals(SystemProperties.get(DESEDE_SYSTEM_PROPERTY));
        this.put("KeyStore.AndroidKeyStore", "android.security.keystore2.AndroidKeyStoreSpi");
        this.put("KeyPairGenerator.EC", "android.security.keystore2.AndroidKeyStoreKeyPairGeneratorSpi$EC");
        this.put("KeyPairGenerator.RSA", "android.security.keystore2.AndroidKeyStoreKeyPairGeneratorSpi$RSA");
        this.put("KeyPairGenerator.XDH", "android.security.keystore2.AndroidKeyStoreKeyPairGeneratorSpi$XDH");
        this.putKeyFactoryImpl("EC");
        this.putKeyFactoryImpl("RSA");
        this.putKeyFactoryImpl(X25519_ALIAS);
        this.put("KeyGenerator.AES", "android.security.keystore2.AndroidKeyStoreKeyGeneratorSpi$AES");
        this.put("KeyGenerator.HmacSHA1", "android.security.keystore2.AndroidKeyStoreKeyGeneratorSpi$HmacSHA1");
        this.put("KeyGenerator.HmacSHA224", "android.security.keystore2.AndroidKeyStoreKeyGeneratorSpi$HmacSHA224");
        this.put("KeyGenerator.HmacSHA256", "android.security.keystore2.AndroidKeyStoreKeyGeneratorSpi$HmacSHA256");
        this.put("KeyGenerator.HmacSHA384", "android.security.keystore2.AndroidKeyStoreKeyGeneratorSpi$HmacSHA384");
        this.put("KeyGenerator.HmacSHA512", "android.security.keystore2.AndroidKeyStoreKeyGeneratorSpi$HmacSHA512");
        if (supports3DES) {
            this.put("KeyGenerator.DESede", "android.security.keystore2.AndroidKeyStoreKeyGeneratorSpi$DESede");
        }
        this.put("KeyAgreement.ECDH", "android.security.keystore2.AndroidKeyStoreKeyAgreementSpi$ECDH");
        this.put("KeyAgreement.XDH", "android.security.keystore2.AndroidKeyStoreKeyAgreementSpi$XDH");
        this.putSecretKeyFactoryImpl("AES");
        if (supports3DES) {
            this.putSecretKeyFactoryImpl("DESede");
        }
        this.putSecretKeyFactoryImpl("HmacSHA1");
        this.putSecretKeyFactoryImpl("HmacSHA224");
        this.putSecretKeyFactoryImpl("HmacSHA256");
        this.putSecretKeyFactoryImpl("HmacSHA384");
        this.putSecretKeyFactoryImpl("HmacSHA512");
    }

    public static void install() {
        Provider[] providers = Security.getProviders();
        int bcProviderIndex = -1;
        for (int i = 0; i < providers.length; ++i) {
            Provider provider = providers[i];
            if (!"BC".equals(provider.getName())) continue;
            bcProviderIndex = i;
            break;
        }
        Security.addProvider(new AndroidKeyStoreProvider());
        AndroidKeyStoreBCWorkaroundProvider workaroundProvider = new AndroidKeyStoreBCWorkaroundProvider();
        if (bcProviderIndex != -1) {
            Security.insertProviderAt(workaroundProvider, bcProviderIndex + 1);
        } else {
            Security.addProvider(workaroundProvider);
        }
    }

    private void putSecretKeyFactoryImpl(String algorithm) {
        this.put("SecretKeyFactory." + algorithm, "android.security.keystore2.AndroidKeyStoreSecretKeyFactorySpi");
    }

    private void putKeyFactoryImpl(String algorithm) {
        this.put("KeyFactory." + algorithm, "android.security.keystore2.AndroidKeyStoreKeyFactorySpi");
    }

    public static long getKeyStoreOperationHandle(Object cryptoPrimitive) {
        Object spi;
        if (cryptoPrimitive == null) {
            throw new NullPointerException();
        }
        if (cryptoPrimitive instanceof Signature) {
            spi = ((Signature)cryptoPrimitive).getCurrentSpi();
        } else if (cryptoPrimitive instanceof Mac) {
            spi = ((Mac)cryptoPrimitive).getCurrentSpi();
        } else if (cryptoPrimitive instanceof Cipher) {
            spi = ((Cipher)cryptoPrimitive).getCurrentSpi();
        } else {
            throw new IllegalArgumentException("Unsupported crypto primitive: " + cryptoPrimitive + ". Supported: Signature, Mac, Cipher");
        }
        if (spi == null) {
            throw new IllegalStateException("Crypto primitive not initialized");
        }
        if (!(spi instanceof KeyStoreCryptoOperation)) {
            throw new IllegalArgumentException("Crypto primitive not backed by AndroidKeyStore provider: " + cryptoPrimitive + ", spi: " + spi);
        }
        return ((KeyStoreCryptoOperation)spi).getOperationHandle();
    }

    static AndroidKeyStorePublicKey makeAndroidKeyStorePublicKeyFromKeyEntryResponse(KeyDescriptor descriptor, KeyMetadata metadata, KeyStoreSecurityLevel iSecurityLevel, int algorithm) throws UnrecoverableKeyException {
        if (metadata.certificate == null) {
            throw new UnrecoverableKeyException("Failed to obtain X.509 form of public key. Keystore has no public certificate stored.");
        }
        byte[] x509PublicCert = metadata.certificate;
        PublicKey publicKey = AndroidKeyStoreSpi.toCertificate(x509PublicCert).getPublicKey();
        String jcaKeyAlgorithm = publicKey.getAlgorithm();
        if ("EC".equalsIgnoreCase(jcaKeyAlgorithm)) {
            return new AndroidKeyStoreECPublicKey(descriptor, metadata, iSecurityLevel, (ECPublicKey)publicKey);
        }
        if ("RSA".equalsIgnoreCase(jcaKeyAlgorithm)) {
            return new AndroidKeyStoreRSAPublicKey(descriptor, metadata, iSecurityLevel, (RSAPublicKey)publicKey);
        }
        if (ED25519_OID.equalsIgnoreCase(jcaKeyAlgorithm)) {
            byte[] publicKeyEncoded = publicKey.getEncoded();
            return new AndroidKeyStoreEdECPublicKey(descriptor, metadata, ED25519_OID, iSecurityLevel, publicKeyEncoded);
        }
        if (X25519_ALIAS.equalsIgnoreCase(jcaKeyAlgorithm)) {
            return new AndroidKeyStoreXDHPublicKey(descriptor, metadata, X25519_ALIAS, iSecurityLevel, publicKey.getEncoded());
        }
        throw new ProviderException("Unsupported Android Keystore public key algorithm: " + jcaKeyAlgorithm);
    }

    public static AndroidKeyStorePublicKey loadAndroidKeyStorePublicKeyFromKeystore(KeyStore2 keyStore, String privateKeyAlias, int namespace) throws UnrecoverableKeyException, KeyPermanentlyInvalidatedException {
        AndroidKeyStoreKey key = AndroidKeyStoreProvider.loadAndroidKeyStoreKeyFromKeystore(keyStore, privateKeyAlias, namespace);
        if (key instanceof AndroidKeyStorePublicKey) {
            return (AndroidKeyStorePublicKey)key;
        }
        throw new UnrecoverableKeyException("No asymmetric key found by the given alias.");
    }

    public static KeyPair loadAndroidKeyStoreKeyPairFromKeystore(KeyStore2 keyStore, KeyDescriptor descriptor) throws UnrecoverableKeyException, KeyPermanentlyInvalidatedException {
        AndroidKeyStoreKey key = AndroidKeyStoreProvider.loadAndroidKeyStoreKeyFromKeystore(keyStore, descriptor);
        if (key instanceof AndroidKeyStorePublicKey) {
            AndroidKeyStorePublicKey publicKey = (AndroidKeyStorePublicKey)key;
            return new KeyPair(publicKey, publicKey.getPrivateKey());
        }
        throw new UnrecoverableKeyException("No asymmetric key found by the given alias.");
    }

    public static AndroidKeyStorePrivateKey loadAndroidKeyStorePrivateKeyFromKeystore(KeyStore2 keyStore, String privateKeyAlias, int namespace) throws UnrecoverableKeyException, KeyPermanentlyInvalidatedException {
        AndroidKeyStoreKey key = AndroidKeyStoreProvider.loadAndroidKeyStoreKeyFromKeystore(keyStore, privateKeyAlias, namespace);
        if (key instanceof AndroidKeyStorePublicKey) {
            return ((AndroidKeyStorePublicKey)key).getPrivateKey();
        }
        throw new UnrecoverableKeyException("No asymmetric key found by the given alias.");
    }

    public static SecretKey loadAndroidKeyStoreSecretKeyFromKeystore(KeyStore2 keyStore, KeyDescriptor descriptor) throws UnrecoverableKeyException, KeyPermanentlyInvalidatedException {
        AndroidKeyStoreKey key = AndroidKeyStoreProvider.loadAndroidKeyStoreKeyFromKeystore(keyStore, descriptor);
        if (key instanceof SecretKey) {
            return (SecretKey)((Object)key);
        }
        throw new UnrecoverableKeyException("No secret key found by the given alias.");
    }

    private static AndroidKeyStoreSecretKey makeAndroidKeyStoreSecretKeyFromKeyEntryResponse(KeyDescriptor descriptor, KeyEntryResponse response, int algorithm, int digest) throws UnrecoverableKeyException {
        String keyAlgorithmString;
        try {
            keyAlgorithmString = KeyProperties.KeyAlgorithm.fromKeymasterSecretKeyAlgorithm(algorithm, digest);
        }
        catch (IllegalArgumentException e) {
            throw (UnrecoverableKeyException)new UnrecoverableKeyException("Unsupported secret key type").initCause(e);
        }
        return new AndroidKeyStoreSecretKey(descriptor, response.metadata, keyAlgorithmString, new KeyStoreSecurityLevel(response.iSecurityLevel));
    }

    public static AndroidKeyStoreKey loadAndroidKeyStoreKeyFromKeystore(KeyStore2 keyStore, String alias, int namespace) throws UnrecoverableKeyException, KeyPermanentlyInvalidatedException {
        KeyDescriptor descriptor = new KeyDescriptor();
        if (namespace == -1) {
            descriptor.nspace = -1L;
            descriptor.domain = 0;
        } else {
            descriptor.nspace = namespace;
            descriptor.domain = 2;
        }
        descriptor.alias = alias;
        descriptor.blob = null;
        AndroidKeyStoreKey key = AndroidKeyStoreProvider.loadAndroidKeyStoreKeyFromKeystore(keyStore, descriptor);
        if (key instanceof AndroidKeyStorePublicKey) {
            return ((AndroidKeyStorePublicKey)key).getPrivateKey();
        }
        return key;
    }

    private static AndroidKeyStoreKey loadAndroidKeyStoreKeyFromKeystore(KeyStore2 keyStore, KeyDescriptor descriptor) throws UnrecoverableKeyException, KeyPermanentlyInvalidatedException {
        KeyEntryResponse response = null;
        try {
            response = keyStore.getKeyEntry(descriptor);
        }
        catch (KeyStoreException e) {
            switch (e.getErrorCode()) {
                case 7: {
                    return null;
                }
                case 17: {
                    throw new KeyPermanentlyInvalidatedException("User changed or deleted their auth credentials", e);
                }
            }
            throw (UnrecoverableKeyException)new UnrecoverableKeyException("Failed to obtain information about key").initCause(e);
        }
        if (response.iSecurityLevel == null) {
            return null;
        }
        Integer keymasterAlgorithm = null;
        int keymasterDigest = -1;
        block10: for (Authorization a : response.metadata.authorizations) {
            switch (a.keyParameter.tag) {
                case 0x10000002: {
                    keymasterAlgorithm = a.keyParameter.value.getAlgorithm();
                    continue block10;
                }
                case 0x20000005: {
                    if (keymasterDigest != -1) continue block10;
                    keymasterDigest = a.keyParameter.value.getDigest();
                }
            }
        }
        if (keymasterAlgorithm == null) {
            throw new UnrecoverableKeyException("Key algorithm unknown");
        }
        if (keymasterAlgorithm == 128 || keymasterAlgorithm == 32 || keymasterAlgorithm == 33) {
            return AndroidKeyStoreProvider.makeAndroidKeyStoreSecretKeyFromKeyEntryResponse(descriptor, response, keymasterAlgorithm, keymasterDigest);
        }
        if (keymasterAlgorithm == 1 || keymasterAlgorithm == 3) {
            return AndroidKeyStoreProvider.makeAndroidKeyStorePublicKeyFromKeyEntryResponse(descriptor, response.metadata, new KeyStoreSecurityLevel(response.iSecurityLevel), keymasterAlgorithm);
        }
        throw new UnrecoverableKeyException("Key algorithm unknown");
    }
}

