/*
 * Decompiled with CFR 0.152.
 */
package android.scheduling;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.scheduling.IRebootReadinessManager;
import android.scheduling.IRequestRebootReadinessStatusListener;
import android.text.TextUtils;
import android.util.ArrayMap;
import java.util.concurrent.Executor;

@SystemApi
public class RebootReadinessManager {
    private static final String TAG = "RebootReadinessManager";
    private final IRebootReadinessManager mService;
    private final Context mContext;
    private final ArrayMap<RequestRebootReadinessStatusListener, RebootReadinessCallbackProxy> mProxyList = new ArrayMap();
    @SystemApi
    public static final String ACTION_REBOOT_READY = "android.scheduling.action.REBOOT_READY";
    @SystemApi
    public static final String EXTRA_IS_READY_TO_REBOOT = "android.scheduling.extra.IS_READY_TO_REBOOT";
    public static final String IS_REBOOT_READY_KEY = "IS_REBOOT_READY";
    public static final String ESTIMATED_FINISH_TIME_KEY = "ESTIMATED_FINISH_TIME";
    public static final String SUBSYSTEM_NAME_KEY = "SUBSYSTEM_NAME";

    public RebootReadinessManager(Context context, IRebootReadinessManager binder) {
        this.mContext = context;
        this.mService = binder;
    }

    @RequiresPermission(value="android.permission.REBOOT")
    public void markRebootPending() {
        try {
            this.mService.markRebootPending(this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.REBOOT")
    public void cancelPendingReboot() {
        try {
            this.mService.cancelPendingReboot(this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.REBOOT")
    public boolean isReadyToReboot() {
        try {
            return this.mService.isReadyToReboot();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.SIGNAL_REBOOT_READINESS")
    public void addRequestRebootReadinessStatusListener(Executor executor, RequestRebootReadinessStatusListener callback) {
        try {
            RebootReadinessCallbackProxy proxy = new RebootReadinessCallbackProxy(callback, executor);
            this.mService.addRequestRebootReadinessStatusListener(proxy);
            this.mProxyList.put(callback, proxy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.SIGNAL_REBOOT_READINESS")
    public void removeRequestRebootReadinessStatusListener(RequestRebootReadinessStatusListener callback) {
        try {
            RebootReadinessCallbackProxy proxy = this.mProxyList.get(callback);
            if (proxy != null) {
                this.mService.removeRequestRebootReadinessStatusListener(proxy);
                this.mProxyList.remove(callback);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static class RebootReadinessCallbackProxy
    extends IRequestRebootReadinessStatusListener.Stub {
        private final RequestRebootReadinessStatusListener mCallback;
        private final Executor mExecutor;

        RebootReadinessCallbackProxy(RequestRebootReadinessStatusListener callback, Executor executor) {
            this.mCallback = callback;
            this.mExecutor = executor;
        }

        @Override
        public void onRequestRebootReadinessStatus(RemoteCallback callback) {
            this.mExecutor.execute(() -> {
                RebootReadinessStatus response = this.mCallback.onRequestRebootReadinessStatus();
                Bundle data = new Bundle();
                data.putBoolean(RebootReadinessManager.IS_REBOOT_READY_KEY, response.isReadyToReboot());
                data.putLong(RebootReadinessManager.ESTIMATED_FINISH_TIME_KEY, response.getEstimatedFinishTime());
                data.putString(RebootReadinessManager.SUBSYSTEM_NAME_KEY, response.getLogSubsystemName());
                callback.sendResult(data);
            });
        }
    }

    @SystemApi
    public static class RebootReadinessStatus {
        private final boolean mIsReadyToReboot;
        private final long mEstimatedFinishTime;
        private final String mLogSubsystemName;

        public RebootReadinessStatus(boolean isReadyToReboot, long estimatedFinishTime, String logSubsystemName) {
            this.mIsReadyToReboot = isReadyToReboot;
            this.mEstimatedFinishTime = estimatedFinishTime;
            if (TextUtils.isEmpty(logSubsystemName)) {
                throw new IllegalArgumentException("Subsystem name should not be empty.");
            }
            this.mLogSubsystemName = logSubsystemName;
        }

        public boolean isReadyToReboot() {
            return this.mIsReadyToReboot;
        }

        public long getEstimatedFinishTime() {
            return this.mEstimatedFinishTime;
        }

        public String getLogSubsystemName() {
            return this.mLogSubsystemName;
        }
    }

    public static interface RequestRebootReadinessStatusListener {
        public RebootReadinessStatus onRequestRebootReadinessStatus();
    }
}

