/*
 * Decompiled with CFR 0.152.
 */
package android.safetycenter.config;

import androidx.annotation.RequiresApi;
import java.util.Objects;

@RequiresApi(value=33)
class BuilderUtils {
    private BuilderUtils() {
    }

    private static void validateAttribute(Object attribute, String name, boolean required, boolean prohibited, Object defaultValue) {
        boolean checkProhibited;
        if (attribute == null && required) {
            throw new IllegalStateException(String.format("Required attribute %s missing", name));
        }
        boolean nonDefaultValueProvided = !Objects.equals(attribute, defaultValue);
        boolean bl = checkProhibited = prohibited && nonDefaultValueProvided;
        if (attribute != null && checkProhibited) {
            throw new IllegalStateException(String.format("Prohibited attribute %s present", name));
        }
    }

    static void validateAttribute(Object attribute, String name, boolean required, boolean prohibited) {
        BuilderUtils.validateAttribute(attribute, name, required, prohibited, null);
    }

    static int validateResId(Integer value, String name, boolean required, boolean prohibited) {
        BuilderUtils.validateAttribute(value, name, required, prohibited, 0);
        if (value == null) {
            return 0;
        }
        if (required && value == 0) {
            throw new IllegalStateException(String.format("Required attribute %s invalid", name));
        }
        return value;
    }

    static int validateIntDef(Integer value, String name, boolean required, boolean prohibited, int defaultValue, int ... validValues) {
        BuilderUtils.validateAttribute(value, name, required, prohibited, defaultValue);
        if (value == null) {
            return defaultValue;
        }
        boolean found = false;
        for (int i = 0; i < validValues.length; ++i) {
            found |= value == validValues[i];
        }
        if (!found) {
            throw new IllegalStateException(String.format("Attribute %s invalid", name));
        }
        return value;
    }

    static int validateInteger(Integer value, String name, boolean required, boolean prohibited, int defaultValue) {
        BuilderUtils.validateAttribute(value, name, required, prohibited, defaultValue);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    static boolean validateBoolean(Boolean value, String name, boolean required, boolean prohibited, boolean defaultValue) {
        BuilderUtils.validateAttribute(value, name, required, prohibited, defaultValue);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }
}

