/*
 * Decompiled with CFR 0.152.
 */
package android.safetycenter;

import android.annotation.SystemApi;
import android.app.PendingIntent;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.RequiresApi;
import java.util.Objects;

@SystemApi
@RequiresApi(value=33)
public class SafetyCenterStaticEntry
implements Parcelable {
    public static final Parcelable.Creator<SafetyCenterStaticEntry> CREATOR = new Parcelable.Creator<SafetyCenterStaticEntry>(){

        @Override
        public SafetyCenterStaticEntry createFromParcel(Parcel in) {
            CharSequence title = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            return new Builder(title).setSummary(TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in)).setPendingIntent(in.readTypedObject(PendingIntent.CREATOR)).build();
        }

        public SafetyCenterStaticEntry[] newArray(int size) {
            return new SafetyCenterStaticEntry[size];
        }
    };
    private final CharSequence mTitle;
    private final CharSequence mSummary;
    private final PendingIntent mPendingIntent;

    private SafetyCenterStaticEntry(CharSequence title, CharSequence summary, PendingIntent pendingIntent) {
        this.mTitle = title;
        this.mSummary = summary;
        this.mPendingIntent = pendingIntent;
    }

    public CharSequence getTitle() {
        return this.mTitle;
    }

    public CharSequence getSummary() {
        return this.mSummary;
    }

    public PendingIntent getPendingIntent() {
        return this.mPendingIntent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SafetyCenterStaticEntry)) {
            return false;
        }
        SafetyCenterStaticEntry that = (SafetyCenterStaticEntry)o;
        return TextUtils.equals(this.mTitle, that.mTitle) && TextUtils.equals(this.mSummary, that.mSummary) && Objects.equals(this.mPendingIntent, that.mPendingIntent);
    }

    public int hashCode() {
        return Objects.hash(this.mTitle, this.mSummary, this.mPendingIntent);
    }

    public String toString() {
        return "SafetyCenterStaticEntry{mTitle=" + this.mTitle + ", mSummary=" + this.mSummary + ", mPendingIntent=" + this.mPendingIntent + '}';
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        TextUtils.writeToParcel(this.mTitle, dest, flags);
        TextUtils.writeToParcel(this.mSummary, dest, flags);
        dest.writeTypedObject(this.mPendingIntent, flags);
    }

    public static class Builder {
        private CharSequence mTitle;
        private CharSequence mSummary;
        private PendingIntent mPendingIntent;

        public Builder(CharSequence title) {
            this.mTitle = Objects.requireNonNull(title);
        }

        public Builder(SafetyCenterStaticEntry safetyCenterStaticEntry) {
            this.mTitle = safetyCenterStaticEntry.mTitle;
            this.mSummary = safetyCenterStaticEntry.mSummary;
            this.mPendingIntent = safetyCenterStaticEntry.mPendingIntent;
        }

        public Builder setTitle(CharSequence title) {
            this.mTitle = Objects.requireNonNull(title);
            return this;
        }

        public Builder setSummary(CharSequence summary) {
            this.mSummary = summary;
            return this;
        }

        public Builder setPendingIntent(PendingIntent pendingIntent) {
            this.mPendingIntent = pendingIntent;
            return this;
        }

        public SafetyCenterStaticEntry build() {
            return new SafetyCenterStaticEntry(this.mTitle, this.mSummary, this.mPendingIntent);
        }
    }
}

