/*
 * Decompiled with CFR 0.152.
 */
package android.safetycenter;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.safetycenter.SafetyCenterEntryOrGroup;
import android.safetycenter.SafetyCenterIssue;
import android.safetycenter.SafetyCenterStaticEntryGroup;
import android.safetycenter.SafetyCenterStatus;
import androidx.annotation.RequiresApi;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@SystemApi
@RequiresApi(value=33)
public class SafetyCenterData
implements Parcelable {
    public static final Parcelable.Creator<SafetyCenterData> CREATOR = new Parcelable.Creator<SafetyCenterData>(){

        @Override
        public SafetyCenterData createFromParcel(Parcel in) {
            SafetyCenterStatus status = in.readTypedObject(SafetyCenterStatus.CREATOR);
            ArrayList<SafetyCenterIssue> issues = in.createTypedArrayList(SafetyCenterIssue.CREATOR);
            ArrayList<SafetyCenterEntryOrGroup> entryOrGroups = in.createTypedArrayList(SafetyCenterEntryOrGroup.CREATOR);
            ArrayList<SafetyCenterStaticEntryGroup> staticEntryGroups = in.createTypedArrayList(SafetyCenterStaticEntryGroup.CREATOR);
            return new SafetyCenterData(status, issues, entryOrGroups, staticEntryGroups);
        }

        public SafetyCenterData[] newArray(int size) {
            return new SafetyCenterData[size];
        }
    };
    private final SafetyCenterStatus mStatus;
    private final List<SafetyCenterIssue> mIssues;
    private final List<SafetyCenterEntryOrGroup> mEntriesOrGroups;
    private final List<SafetyCenterStaticEntryGroup> mStaticEntryGroups;

    public SafetyCenterData(SafetyCenterStatus status, List<SafetyCenterIssue> issues, List<SafetyCenterEntryOrGroup> entriesOrGroups, List<SafetyCenterStaticEntryGroup> staticEntryGroups) {
        this.mStatus = Objects.requireNonNull(status);
        this.mIssues = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(issues)));
        this.mEntriesOrGroups = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(entriesOrGroups)));
        this.mStaticEntryGroups = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(staticEntryGroups)));
    }

    public SafetyCenterStatus getStatus() {
        return this.mStatus;
    }

    public List<SafetyCenterIssue> getIssues() {
        return this.mIssues;
    }

    public List<SafetyCenterEntryOrGroup> getEntriesOrGroups() {
        return this.mEntriesOrGroups;
    }

    public List<SafetyCenterStaticEntryGroup> getStaticEntryGroups() {
        return this.mStaticEntryGroups;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SafetyCenterData)) {
            return false;
        }
        SafetyCenterData that = (SafetyCenterData)o;
        return Objects.equals(this.mStatus, that.mStatus) && Objects.equals(this.mIssues, that.mIssues) && Objects.equals(this.mEntriesOrGroups, that.mEntriesOrGroups) && Objects.equals(this.mStaticEntryGroups, that.mStaticEntryGroups);
    }

    public int hashCode() {
        return Objects.hash(this.mStatus, this.mIssues, this.mEntriesOrGroups, this.mStaticEntryGroups);
    }

    public String toString() {
        return "SafetyCenterData{mStatus=" + this.mStatus + ", mIssues=" + this.mIssues + ", mEntriesOrGroups=" + this.mEntriesOrGroups + ", mStaticEntryGroups=" + this.mStaticEntryGroups + '}';
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeTypedObject(this.mStatus, flags);
        dest.writeTypedList(this.mIssues);
        dest.writeTypedList(this.mEntriesOrGroups);
        dest.writeTypedList(this.mStaticEntryGroups);
    }
}

