/*
 * Decompiled with CFR 0.152.
 */
package android.permission;

import android.app.AppOpsManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.Attribution;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.icu.text.ListFormatter;
import android.location.LocationManager;
import android.media.AudioManager;
import android.os.Process;
import android.os.UserHandle;
import android.permission.PermissionGroupUsage;
import android.permission.PermissionManager;
import android.provider.DeviceConfig;
import android.telephony.TelephonyManager;
import android.util.ArrayMap;
import android.util.ArraySet;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.lang.System_Delegate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PermissionUsageHelper
implements AppOpsManager.OnOpActiveChangedListener,
AppOpsManager.OnOpStartedListener {
    private static final String PROPERTY_CAMERA_MIC_ICONS_ENABLED = "camera_mic_icons_enabled";
    private static final String PROPERTY_LOCATION_INDICATORS_ENABLED = "location_indicators_enabled";
    private static final String PROPERTY_PERMISSIONS_HUB_2_ENABLED = "permissions_hub_2_enabled";
    private static final String RECENT_ACCESS_TIME_MS = "recent_access_time_ms";
    private static final String RUNNING_ACCESS_TIME_MS = "running_access_time_ms";
    private static final String SYSTEM_PKG = "android";
    private static final long DEFAULT_RUNNING_TIME_MS = 5000L;
    private static final long DEFAULT_RECENT_TIME_MS = 15000L;
    private static final List<String> LOCATION_OPS = List.of("android:coarse_location", "android:fine_location");
    private static final List<String> MIC_OPS = List.of("android:phone_call_microphone", "android:receive_ambient_trigger_audio", "android:record_audio");
    private static final List<String> CAMERA_OPS = List.of("android:phone_call_camera", "android:camera");
    private Context mContext;
    private ArrayMap<UserHandle, Context> mUserContexts;
    private PackageManager mPkgManager;
    private AppOpsManager mAppOpsManager;
    @GuardedBy(value={"mAttributionChains"})
    private final ArrayMap<Integer, ArrayList<AccessChainLink>> mAttributionChains = new ArrayMap();

    private static boolean shouldShowPermissionsHub() {
        return DeviceConfig.getBoolean("privacy", PROPERTY_PERMISSIONS_HUB_2_ENABLED, false);
    }

    private static boolean shouldShowIndicators() {
        return DeviceConfig.getBoolean("privacy", PROPERTY_CAMERA_MIC_ICONS_ENABLED, true) || PermissionUsageHelper.shouldShowPermissionsHub();
    }

    private static boolean shouldShowLocationIndicator() {
        return DeviceConfig.getBoolean("privacy", PROPERTY_LOCATION_INDICATORS_ENABLED, false);
    }

    private static long getRecentThreshold(Long now) {
        return now - DeviceConfig.getLong("privacy", RECENT_ACCESS_TIME_MS, 15000L);
    }

    private static long getRunningThreshold(Long now) {
        return now - DeviceConfig.getLong("privacy", RUNNING_ACCESS_TIME_MS, 5000L);
    }

    private static String getGroupForOp(String op) {
        switch (op) {
            case "android:receive_ambient_trigger_audio": 
            case "android:record_audio": {
                return "android.permission-group.MICROPHONE";
            }
            case "android:camera": {
                return "android.permission-group.CAMERA";
            }
            case "android:phone_call_microphone": 
            case "android:phone_call_camera": {
                return op;
            }
            case "android:coarse_location": 
            case "android:fine_location": {
                return "android.permission-group.LOCATION";
            }
        }
        throw new IllegalArgumentException("Unknown app op: " + op);
    }

    public PermissionUsageHelper(Context context) {
        this.mContext = context;
        this.mPkgManager = context.getPackageManager();
        this.mAppOpsManager = context.getSystemService(AppOpsManager.class);
        this.mUserContexts = new ArrayMap();
        this.mUserContexts.put(Process.myUserHandle(), this.mContext);
        String[] opStrs = new String[]{"android:camera", "android:record_audio"};
        this.mAppOpsManager.startWatchingActive(opStrs, context.getMainExecutor(), this);
        int[] ops = new int[]{26, 27};
        this.mAppOpsManager.startWatchingStarted(ops, this);
    }

    private Context getUserContext(UserHandle user) {
        if (!this.mUserContexts.containsKey(user)) {
            this.mUserContexts.put(user, this.mContext.createContextAsUser(user, 0));
        }
        return this.mUserContexts.get(user);
    }

    public void tearDown() {
        this.mAppOpsManager.stopWatchingActive(this);
        this.mAppOpsManager.stopWatchingStarted(this);
    }

    @Override
    public void onOpActiveChanged(String op, int uid, String packageName, boolean active) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onOpActiveChanged(String op, int uid, String packageName, String attributionTag, boolean active, int attributionFlags, int attributionChainId) {
        if (active) {
            return;
        }
        ArrayMap<Integer, ArrayList<AccessChainLink>> arrayMap = this.mAttributionChains;
        synchronized (arrayMap) {
            this.mAttributionChains.remove(attributionChainId);
            int numChains = this.mAttributionChains.size();
            ArrayList<Integer> toRemove = new ArrayList<Integer>();
            block3: for (int i = 0; i < numChains; ++i) {
                int chainId = this.mAttributionChains.keyAt(i);
                ArrayList<AccessChainLink> chain = this.mAttributionChains.valueAt(i);
                int chainSize = chain.size();
                for (int j = 0; j < chainSize; ++j) {
                    AccessChainLink link = chain.get(j);
                    if (!link.packageAndOpEquals(op, packageName, attributionTag, uid)) continue;
                    toRemove.add(chainId);
                    continue block3;
                }
            }
            this.mAttributionChains.removeAll(toRemove);
        }
    }

    @Override
    public void onOpStarted(int op, int uid, String packageName, String attributionTag, int flags, int result) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onOpStarted(int op, int uid, String packageName, String attributionTag, int flags, int result, int startedType, int attributionFlags, int attributionChainId) {
        if (startedType == 0 || attributionChainId == -1 || attributionFlags == 0 || (attributionFlags & 8) == 0) {
            return;
        }
        ArrayMap<Integer, ArrayList<AccessChainLink>> arrayMap = this.mAttributionChains;
        synchronized (arrayMap) {
            this.addLinkToChainIfNotPresentLocked(AppOpsManager.opToPublicName(op), packageName, uid, attributionTag, attributionFlags, attributionChainId);
        }
    }

    private void addLinkToChainIfNotPresentLocked(String op, String packageName, int uid, String attributionTag, int attributionFlags, int attributionChainId) {
        AccessChainLink link;
        ArrayList currentChain = this.mAttributionChains.computeIfAbsent(attributionChainId, k -> new ArrayList());
        if (currentChain.contains(link = new AccessChainLink(op, packageName, attributionTag, uid, attributionFlags))) {
            return;
        }
        int currSize = currentChain.size();
        if (currSize == 0 || link.isEnd() || !((AccessChainLink)currentChain.get(currSize - 1)).isEnd()) {
            currentChain.add(link);
        } else if (link.isStart()) {
            currentChain.add(0, link);
        } else if (((AccessChainLink)currentChain.get(currentChain.size() - 1)).isEnd()) {
            currentChain.add(currSize - 1, link);
        }
    }

    public List<PermissionGroupUsage> getOpUsageData(boolean isMicMuted) {
        boolean hasPhoneCall;
        ArrayList<PermissionGroupUsage> usages = new ArrayList<PermissionGroupUsage>();
        if (!PermissionUsageHelper.shouldShowIndicators()) {
            return usages;
        }
        ArrayList<String> ops = new ArrayList<String>(CAMERA_OPS);
        if (PermissionUsageHelper.shouldShowLocationIndicator()) {
            ops.addAll(LOCATION_OPS);
        }
        if (!isMicMuted) {
            ops.addAll(MIC_OPS);
        }
        Map<String, List<OpUsage>> rawUsages = this.getOpUsages(ops);
        ArrayList<String> usedPermGroups = new ArrayList<String>(rawUsages.keySet());
        AudioManager audioManager = this.mContext.getSystemService(AudioManager.class);
        boolean bl = hasPhoneCall = usedPermGroups.contains("android:phone_call_camera") || usedPermGroups.contains("android:phone_call_microphone");
        if (hasPhoneCall && usedPermGroups.contains("android.permission-group.MICROPHONE") && audioManager.getMode() == 3) {
            TelephonyManager telephonyManager = this.mContext.getSystemService(TelephonyManager.class);
            List<OpUsage> permUsages = rawUsages.get("android.permission-group.MICROPHONE");
            for (int usageNum = 0; usageNum < permUsages.size(); ++usageNum) {
                if (telephonyManager.checkCarrierPrivilegesForPackage(permUsages.get((int)usageNum).packageName) != 1) continue;
                usedPermGroups.remove("android:phone_call_camera");
                usedPermGroups.remove("android:phone_call_microphone");
            }
        }
        ArrayMap<String, Map<String, String>> subAttributionLabelsMap = new ArrayMap<String, Map<String, String>>();
        for (int permGroupNum = 0; permGroupNum < usedPermGroups.size(); ++permGroupNum) {
            boolean isPhone = false;
            String permGroup = usedPermGroups.get(permGroupNum);
            ArrayMap<OpUsage, CharSequence> usagesWithLabels = this.getUniqueUsagesWithLabels(permGroup, rawUsages.get(permGroup));
            this.updateSubattributionLabelsMap(rawUsages.get(permGroup), subAttributionLabelsMap);
            if (permGroup.equals("android:phone_call_microphone")) {
                isPhone = true;
                permGroup = "android.permission-group.MICROPHONE";
            } else if (permGroup.equals("android:phone_call_camera")) {
                isPhone = true;
                permGroup = "android.permission-group.CAMERA";
            }
            for (int usageNum = 0; usageNum < usagesWithLabels.size(); ++usageNum) {
                OpUsage usage = usagesWithLabels.keyAt(usageNum);
                String attributionLabel = ((Map)subAttributionLabelsMap.getOrDefault(usage.packageName, new ArrayMap())).getOrDefault(usage.attributionTag, null);
                usages.add(new PermissionGroupUsage(usage.packageName, usage.uid, usage.lastAccessTime, permGroup, usage.isRunning, isPhone, usage.attributionTag, attributionLabel, usagesWithLabels.valueAt(usageNum)));
            }
        }
        return usages;
    }

    private void updateSubattributionLabelsMap(List<OpUsage> usages, ArrayMap<String, Map<String, String>> subAttributionLabelsMap) {
        if (usages == null || usages.isEmpty()) {
            return;
        }
        for (OpUsage usage : usages) {
            if (usage.attributionTag == null || subAttributionLabelsMap.containsKey(usage.packageName)) continue;
            subAttributionLabelsMap.put(usage.packageName, this.getSubattributionLabelsForPackage(usage.packageName, usage.uid));
        }
    }

    private ArrayMap<String, String> getSubattributionLabelsForPackage(String packageName, int uid) {
        ArrayMap<String, String> attributionLabelMap = new ArrayMap<String, String>();
        UserHandle user = UserHandle.getUserHandleForUid(uid);
        try {
            if (!this.isSubattributionSupported(packageName, uid)) {
                return attributionLabelMap;
            }
            Context userContext = this.getUserContext(user);
            PackageInfo packageInfo = userContext.getPackageManager().getPackageInfo(packageName, -2147479552);
            Context pkgContext = userContext.createPackageContext(packageInfo.packageName, 0);
            for (Attribution attribution : packageInfo.attributions) {
                try {
                    String resourceForLabel = pkgContext.getString(attribution.getLabel());
                    attributionLabelMap.put(attribution.getTag(), resourceForLabel);
                }
                catch (Resources.NotFoundException notFoundException) {
                    // empty catch block
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return attributionLabelMap;
    }

    private boolean isSubattributionSupported(String packageName, int uid) {
        try {
            if (!this.isLocationProvider(packageName)) {
                return false;
            }
            PackageManager userPkgManager = this.getUserContext(UserHandle.getUserHandleForUid(uid)).getPackageManager();
            ApplicationInfo appInfo = userPkgManager.getApplicationInfoAsUser(packageName, PackageManager.ApplicationInfoFlags.of(0L), UserHandle.getUserId(uid));
            if (appInfo != null) {
                return appInfo.areAttributionsUserVisible();
            }
            return false;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    private boolean isLocationProvider(String packageName) {
        return Objects.requireNonNull(this.mContext.getSystemService(LocationManager.class)).isProviderPackage(packageName);
    }

    private Map<String, List<OpUsage>> getOpUsages(List<String> opNames) {
        List<AppOpsManager.PackageOps> ops;
        try {
            ops = this.mAppOpsManager.getPackagesForOps(opNames.toArray(new String[opNames.size()]));
        }
        catch (NullPointerException e) {
            return Collections.emptyMap();
        }
        long now = System_Delegate.currentTimeMillis();
        long recentThreshold = PermissionUsageHelper.getRecentThreshold(now);
        long runningThreshold = PermissionUsageHelper.getRunningThreshold(now);
        int opFlags = 13;
        ArrayMap usages = new ArrayMap();
        int numPkgOps = ops.size();
        for (int pkgOpNum = 0; pkgOpNum < numPkgOps; ++pkgOpNum) {
            AppOpsManager.PackageOps pkgOps = ops.get(pkgOpNum);
            int uid = pkgOps.getUid();
            UserHandle user = UserHandle.getUserHandleForUid(uid);
            String packageName = pkgOps.getPackageName();
            int numOpEntries = pkgOps.getOps().size();
            for (int opEntryNum = 0; opEntryNum < numOpEntries; ++opEntryNum) {
                AppOpsManager.OpEntry opEntry = pkgOps.getOps().get(opEntryNum);
                String op = opEntry.getOpStr();
                ArrayList<String> attributionTags = new ArrayList<String>(opEntry.getAttributedOpEntries().keySet());
                int numAttrEntries = opEntry.getAttributedOpEntries().size();
                for (int attrOpEntryNum = 0; attrOpEntryNum < numAttrEntries; ++attrOpEntryNum) {
                    String attributionTag = (String)attributionTags.get(attrOpEntryNum);
                    AppOpsManager.AttributedOpEntry attrOpEntry = opEntry.getAttributedOpEntries().get(attributionTag);
                    long lastAccessTime = attrOpEntry.getLastAccessTime(opFlags);
                    if (attrOpEntry.isRunning()) {
                        lastAccessTime = now;
                    }
                    if (lastAccessTime < recentThreshold && !attrOpEntry.isRunning()) continue;
                    boolean isRunning = attrOpEntry.isRunning() || lastAccessTime >= runningThreshold;
                    OpUsage proxyUsage = null;
                    AppOpsManager.OpEventProxyInfo proxy = attrOpEntry.getLastProxyInfo(opFlags);
                    if (proxy != null && proxy.getPackageName() != null) {
                        proxyUsage = new OpUsage(proxy.getPackageName(), proxy.getAttributionTag(), op, proxy.getUid(), lastAccessTime, isRunning, null);
                    }
                    String permGroupName = PermissionUsageHelper.getGroupForOp(op);
                    OpUsage usage = new OpUsage(packageName, attributionTag, op, uid, lastAccessTime, isRunning, proxyUsage);
                    Integer packageAttr = usage.getPackageIdHash();
                    if (!usages.containsKey(permGroupName)) {
                        ArrayMap<Integer, OpUsage> map = new ArrayMap<Integer, OpUsage>();
                        map.put(packageAttr, usage);
                        usages.put(permGroupName, map);
                        continue;
                    }
                    Map permGroupUsages = (Map)usages.get(permGroupName);
                    if (!permGroupUsages.containsKey(packageAttr)) {
                        permGroupUsages.put(packageAttr, usage);
                        continue;
                    }
                    if (usage.lastAccessTime <= ((OpUsage)permGroupUsages.get((Object)packageAttr)).lastAccessTime) continue;
                    permGroupUsages.put(packageAttr, usage);
                }
            }
        }
        ArrayMap<String, List<OpUsage>> flattenedUsages = new ArrayMap<String, List<OpUsage>>();
        ArrayList permGroups = new ArrayList(usages.keySet());
        for (int i = 0; i < permGroups.size(); ++i) {
            String permGroupName = (String)permGroups.get(i);
            flattenedUsages.put(permGroupName, new ArrayList(((Map)usages.get(permGroupName)).values()));
        }
        return flattenedUsages;
    }

    private CharSequence formatLabelList(List<CharSequence> labels) {
        return ListFormatter.getInstance().format(labels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayMap<OpUsage, CharSequence> getUniqueUsagesWithLabels(String permGroup, List<OpUsage> usages) {
        OpUsage usage;
        ArrayMap<OpUsage, CharSequence> usagesAndLabels = new ArrayMap<OpUsage, CharSequence>();
        if (usages == null || usages.isEmpty()) {
            return usagesAndLabels;
        }
        ArrayMap<Integer, OpUsage> allUsages = new ArrayMap<Integer, OpUsage>();
        ArrayMap<Integer, OpUsage> mostRecentUsages = new ArrayMap<Integer, OpUsage>();
        ArraySet<Integer> proxyPackages = new ArraySet<Integer>();
        ArrayMap proxyLabels = new ArrayMap();
        ArrayMap<Integer, OpUsage> proxies = new ArrayMap<Integer, OpUsage>();
        for (int i = 0; i < usages.size(); ++i) {
            usage = usages.get(i);
            allUsages.put(usage.getPackageIdHash(), usage);
            if (usage.proxy == null) continue;
            proxies.put(usage.proxy.getPackageIdHash(), usage);
        }
        for (int usageNum = 0; usageNum < usages.size(); ++usageNum) {
            usage = usages.get(usageNum);
            if (usage == null) continue;
            int usageAttr = usage.getPackageIdHash();
            if (!proxies.containsKey(usageAttr) && usage.proxy != null && !"android.permission-group.MICROPHONE".equals(permGroup)) {
                proxyLabels.put(usage, new ArrayList());
                proxyPackages.add(usage.getPackageIdHash());
            }
            int usageId = usage.getPackageIdHash();
            OpUsage lastMostRecent = (OpUsage)mostRecentUsages.get(usageId);
            if (!this.shouldShowPackage(usage.packageName) || lastMostRecent != null && usage.lastAccessTime <= lastMostRecent.lastAccessTime) continue;
            mostRecentUsages.put(usageId, usage);
        }
        for (int numStart = 0; numStart < proxyLabels.size(); ++numStart) {
            OpUsage start = (OpUsage)proxyLabels.keyAt(numStart);
            mostRecentUsages.remove(start.getPackageIdHash());
            OpUsage currentUsage = (OpUsage)proxyLabels.keyAt(numStart);
            ArrayList proxyLabelList = (ArrayList)proxyLabels.get(currentUsage);
            if (currentUsage == null || proxyLabelList == null) continue;
            int iterNum = 0;
            int maxUsages = allUsages.size();
            while (currentUsage.proxy != null) {
                if (allUsages.containsKey(currentUsage.proxy.getPackageIdHash())) {
                    currentUsage = (OpUsage)allUsages.get(currentUsage.proxy.getPackageIdHash());
                } else {
                    OpUsage proxy = currentUsage.proxy;
                    if (!this.shouldShowPackage(proxy.packageName)) break;
                    currentUsage = proxy;
                    ++maxUsages;
                }
                if (currentUsage == null || iterNum == maxUsages || currentUsage.getPackageIdHash() == start.getPackageIdHash()) break;
                proxyPackages.add(currentUsage.getPackageIdHash());
                if (!currentUsage.packageName.equals(start.packageName) && this.shouldShowPackage(currentUsage.packageName)) {
                    try {
                        PackageManager userPkgManager = this.getUserContext(currentUsage.getUser()).getPackageManager();
                        ApplicationInfo appInfo = userPkgManager.getApplicationInfo(currentUsage.packageName, 0);
                        CharSequence appLabel = appInfo.loadLabel(userPkgManager);
                        if (!proxyLabelList.contains(appLabel)) {
                            proxyLabelList.add(appLabel);
                        }
                    }
                    catch (PackageManager.NameNotFoundException userPkgManager) {
                        // empty catch block
                    }
                }
                ++iterNum;
            }
            if ("android.permission-group.MICROPHONE".equals(permGroup)) continue;
            usagesAndLabels.put(start, proxyLabelList.isEmpty() ? null : this.formatLabelList(proxyLabelList));
        }
        Object object = this.mAttributionChains;
        synchronized (object) {
            for (int i = 0; i < this.mAttributionChains.size(); ++i) {
                List usageList = this.mAttributionChains.valueAt(i);
                int lastVisible = usageList.size() - 1;
                if (usageList.isEmpty() || !((AccessChainLink)usageList.get(lastVisible)).isEnd() || !((AccessChainLink)usageList.get(0)).isStart() || !permGroup.equals(PermissionUsageHelper.getGroupForOp(((AccessChainLink)usageList.get((int)0)).usage.op)) || !"android.permission-group.MICROPHONE".equals(permGroup)) continue;
                for (AccessChainLink link : usageList) {
                    proxyPackages.add(link.usage.getPackageIdHash());
                }
                AccessChainLink start = (AccessChainLink)usageList.get(0);
                AccessChainLink lastVisibleLink = (AccessChainLink)usageList.get(lastVisible);
                while (lastVisible > 0 && !this.shouldShowPackage(lastVisibleLink.usage.packageName)) {
                    lastVisibleLink = (AccessChainLink)usageList.get(--lastVisible);
                }
                String proxyLabel = null;
                if (!lastVisibleLink.usage.packageName.equals(start.usage.packageName)) {
                    try {
                        PackageManager userPkgManager = this.getUserContext(lastVisibleLink.usage.getUser()).getPackageManager();
                        ApplicationInfo appInfo = userPkgManager.getApplicationInfo(lastVisibleLink.usage.packageName, 0);
                        proxyLabel = appInfo.loadLabel(userPkgManager).toString();
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        // empty catch block
                    }
                }
                usagesAndLabels.put(start.usage, proxyLabel);
            }
        }
        object = mostRecentUsages.keySet().iterator();
        while (object.hasNext()) {
            int packageHash = (Integer)object.next();
            if (proxyPackages.contains(packageHash)) continue;
            usagesAndLabels.put((OpUsage)mostRecentUsages.get(packageHash), null);
        }
        return usagesAndLabels;
    }

    private boolean shouldShowPackage(String packageName) {
        return PermissionManager.shouldShowPackageForIndicatorCached(this.mContext, packageName);
    }

    private static class AccessChainLink {
        public final OpUsage usage;
        public final int flags;

        AccessChainLink(String op, String packageName, String attributionTag, int uid, int flags) {
            this.usage = new OpUsage(packageName, attributionTag, op, uid, System_Delegate.currentTimeMillis(), true, null);
            this.flags = flags;
        }

        public boolean isEnd() {
            return (this.flags & 1) != 0;
        }

        public boolean isStart() {
            return (this.flags & 4) != 0;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AccessChainLink)) {
                return false;
            }
            AccessChainLink other = (AccessChainLink)obj;
            return other.flags == this.flags && this.packageAndOpEquals(other.usage.op, other.usage.packageName, other.usage.attributionTag, other.usage.uid);
        }

        public boolean packageAndOpEquals(String op, String packageName, String attributionTag, int uid) {
            return Objects.equals(op, this.usage.op) && Objects.equals(packageName, this.usage.packageName) && Objects.equals(attributionTag, this.usage.attributionTag) && uid == this.usage.uid;
        }
    }

    private static class OpUsage {
        public final String packageName;
        public final String attributionTag;
        public final String op;
        public final int uid;
        public final long lastAccessTime;
        public final OpUsage proxy;
        public final boolean isRunning;

        OpUsage(String packageName, String attributionTag, String op, int uid, long lastAccessTime, boolean isRunning, OpUsage proxy) {
            this.packageName = packageName;
            this.attributionTag = attributionTag;
            this.op = op;
            this.uid = uid;
            this.lastAccessTime = lastAccessTime;
            this.isRunning = isRunning;
            this.proxy = proxy;
        }

        public UserHandle getUser() {
            return UserHandle.getUserHandleForUid(this.uid);
        }

        public int getPackageIdHash() {
            return Objects.hash(this.packageName, this.uid);
        }

        public int hashCode() {
            return Objects.hash(this.packageName, this.attributionTag, this.op, this.uid, this.lastAccessTime, this.isRunning);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OpUsage)) {
                return false;
            }
            OpUsage other = (OpUsage)obj;
            return Objects.equals(this.packageName, other.packageName) && Objects.equals(this.attributionTag, other.attributionTag) && Objects.equals(this.op, other.op) && this.uid == other.uid && this.lastAccessTime == other.lastAccessTime && this.isRunning == other.isRunning;
        }
    }
}

