/*
 * Decompiled with CFR 0.152.
 */
package android.os.storage;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import android.os.storage.DiskInfo;
import android.os.storage.StorageManager;
import android.os.storage.StorageVolume;
import android.provider.DocumentsContract;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.DebugUtils;
import android.util.SparseArray;
import android.util.SparseIntArray;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.Preconditions;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.Writer;
import java.util.Comparator;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;

public class VolumeInfo
implements Parcelable {
    public static final String ACTION_VOLUME_STATE_CHANGED = "android.os.storage.action.VOLUME_STATE_CHANGED";
    public static final String EXTRA_VOLUME_ID = "android.os.storage.extra.VOLUME_ID";
    public static final String EXTRA_VOLUME_STATE = "android.os.storage.extra.VOLUME_STATE";
    public static final String ID_PRIVATE_INTERNAL = "private";
    public static final String ID_EMULATED_INTERNAL = "emulated";
    @UnsupportedAppUsage
    public static final int TYPE_PUBLIC = 0;
    public static final int TYPE_PRIVATE = 1;
    @UnsupportedAppUsage
    public static final int TYPE_EMULATED = 2;
    public static final int TYPE_ASEC = 3;
    public static final int TYPE_OBB = 4;
    public static final int TYPE_STUB = 5;
    public static final int STATE_UNMOUNTED = 0;
    public static final int STATE_CHECKING = 1;
    public static final int STATE_MOUNTED = 2;
    public static final int STATE_MOUNTED_READ_ONLY = 3;
    public static final int STATE_FORMATTING = 4;
    public static final int STATE_EJECTING = 5;
    public static final int STATE_UNMOUNTABLE = 6;
    public static final int STATE_REMOVED = 7;
    public static final int STATE_BAD_REMOVAL = 8;
    public static final int MOUNT_FLAG_PRIMARY = 1;
    public static final int MOUNT_FLAG_VISIBLE_FOR_READ = 2;
    public static final int MOUNT_FLAG_VISIBLE_FOR_WRITE = 4;
    private static SparseArray<String> sStateToEnvironment = new SparseArray();
    private static ArrayMap<String, String> sEnvironmentToBroadcast = new ArrayMap();
    private static SparseIntArray sStateToDescrip = new SparseIntArray();
    private static final Comparator<VolumeInfo> sDescriptionComparator = new Comparator<VolumeInfo>(){

        @Override
        public int compare(VolumeInfo lhs, VolumeInfo rhs) {
            if (VolumeInfo.ID_PRIVATE_INTERNAL.equals(lhs.getId())) {
                return -1;
            }
            if (lhs.getDescription() == null) {
                return 1;
            }
            if (rhs.getDescription() == null) {
                return -1;
            }
            return lhs.getDescription().compareTo(rhs.getDescription());
        }
    };
    public final String id;
    @UnsupportedAppUsage
    public final int type;
    @UnsupportedAppUsage
    public final DiskInfo disk;
    public final String partGuid;
    public int mountFlags = 0;
    public int mountUserId = -10000;
    @UnsupportedAppUsage
    public int state = 0;
    public String fsType;
    @UnsupportedAppUsage
    public String fsUuid;
    @UnsupportedAppUsage
    public String fsLabel;
    @UnsupportedAppUsage
    public String path;
    @UnsupportedAppUsage
    public String internalPath;
    private static final String DOCUMENT_AUTHORITY = "com.android.externalstorage.documents";
    private static final String DOCUMENT_ROOT_PRIMARY_EMULATED = "primary";
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final Parcelable.Creator<VolumeInfo> CREATOR;

    public VolumeInfo(String id2, int type, DiskInfo disk, String partGuid) {
        this.id = Preconditions.checkNotNull(id2);
        this.type = type;
        this.disk = disk;
        this.partGuid = partGuid;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public VolumeInfo(Parcel parcel) {
        this.id = parcel.readString8();
        this.type = parcel.readInt();
        this.disk = parcel.readInt() != 0 ? DiskInfo.CREATOR.createFromParcel(parcel) : null;
        this.partGuid = parcel.readString8();
        this.mountFlags = parcel.readInt();
        this.mountUserId = parcel.readInt();
        this.state = parcel.readInt();
        this.fsType = parcel.readString8();
        this.fsUuid = parcel.readString8();
        this.fsLabel = parcel.readString8();
        this.path = parcel.readString8();
        this.internalPath = parcel.readString8();
    }

    public VolumeInfo(VolumeInfo volumeInfo) {
        this.id = volumeInfo.id;
        this.type = volumeInfo.type;
        this.disk = volumeInfo.disk;
        this.partGuid = volumeInfo.partGuid;
        this.mountFlags = volumeInfo.mountFlags;
        this.mountUserId = volumeInfo.mountUserId;
        this.state = volumeInfo.state;
        this.fsType = volumeInfo.fsType;
        this.fsUuid = volumeInfo.fsUuid;
        this.fsLabel = volumeInfo.fsLabel;
        this.path = volumeInfo.path;
        this.internalPath = volumeInfo.internalPath;
    }

    @UnsupportedAppUsage
    public static String getEnvironmentForState(int state) {
        String envState = sStateToEnvironment.get(state);
        if (envState != null) {
            return envState;
        }
        return "unknown";
    }

    public static String getBroadcastForEnvironment(String envState) {
        return sEnvironmentToBroadcast.get(envState);
    }

    public static String getBroadcastForState(int state) {
        return VolumeInfo.getBroadcastForEnvironment(VolumeInfo.getEnvironmentForState(state));
    }

    public static Comparator<VolumeInfo> getDescriptionComparator() {
        return sDescriptionComparator;
    }

    @UnsupportedAppUsage
    public String getId() {
        return this.id;
    }

    @UnsupportedAppUsage
    public DiskInfo getDisk() {
        return this.disk;
    }

    @UnsupportedAppUsage
    public String getDiskId() {
        return this.disk != null ? this.disk.id : null;
    }

    @UnsupportedAppUsage
    public int getType() {
        return this.type;
    }

    @UnsupportedAppUsage
    public int getState() {
        return this.state;
    }

    public int getStateDescription() {
        return sStateToDescrip.get(this.state, 0);
    }

    @UnsupportedAppUsage
    public String getFsUuid() {
        return this.fsUuid;
    }

    public String getNormalizedFsUuid() {
        return this.fsUuid != null ? this.fsUuid.toLowerCase(Locale.US) : null;
    }

    @UnsupportedAppUsage
    public int getMountUserId() {
        return this.mountUserId;
    }

    @UnsupportedAppUsage
    public String getDescription() {
        if (ID_PRIVATE_INTERNAL.equals(this.id) || this.id.startsWith("emulated;")) {
            return Resources.getSystem().getString(17041601);
        }
        if (!TextUtils.isEmpty(this.fsLabel)) {
            return this.fsLabel;
        }
        return null;
    }

    @UnsupportedAppUsage
    public boolean isMountedReadable() {
        return this.state == 2 || this.state == 3;
    }

    @UnsupportedAppUsage
    public boolean isMountedWritable() {
        return this.state == 2;
    }

    @UnsupportedAppUsage
    public boolean isPrimary() {
        return (this.mountFlags & 1) != 0;
    }

    @UnsupportedAppUsage
    public boolean isPrimaryPhysical() {
        return this.isPrimary() && this.getType() == 0;
    }

    private boolean isVisibleForRead() {
        return (this.mountFlags & 2) != 0;
    }

    private boolean isVisibleForWrite() {
        return (this.mountFlags & 4) != 0;
    }

    @UnsupportedAppUsage
    public boolean isVisible() {
        return this.isVisibleForRead() || this.isVisibleForWrite();
    }

    private boolean isVolumeSupportedForUser(int userId) {
        if (this.mountUserId != userId) {
            return false;
        }
        return this.type == 0 || this.type == 5 || this.type == 2;
    }

    public boolean isVisibleForUser(int userId) {
        return this.isVolumeSupportedForUser(userId) && this.isVisible();
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean isPrimaryEmulatedForUser(int userId) {
        return this.id.equals("emulated;" + userId);
    }

    public boolean isVisibleForRead(int userId) {
        return this.isVolumeSupportedForUser(userId) && this.isVisibleForRead();
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean isVisibleForWrite(int userId) {
        return this.isVolumeSupportedForUser(userId) && this.isVisibleForWrite();
    }

    @UnsupportedAppUsage
    public File getPath() {
        return this.path != null ? new File(this.path) : null;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public File getInternalPath() {
        return this.internalPath != null ? new File(this.internalPath) : null;
    }

    @UnsupportedAppUsage
    public File getPathForUser(int userId) {
        if (this.path == null) {
            return null;
        }
        if (this.type == 0 || this.type == 5) {
            return new File(this.path);
        }
        if (this.type == 2) {
            return new File(this.path, Integer.toString(userId));
        }
        return null;
    }

    @UnsupportedAppUsage
    public File getInternalPathForUser(int userId) {
        if (this.path == null) {
            return null;
        }
        if (this.type == 0 || this.type == 5) {
            return new File(this.path.replace("/storage/", "/mnt/media_rw/"));
        }
        return this.getPathForUser(userId);
    }

    @UnsupportedAppUsage
    public StorageVolume buildStorageVolume(Context context, int userId, boolean reportUnmounted) {
        boolean removable;
        boolean emulated;
        File internalPath;
        StorageManager storage = context.getSystemService(StorageManager.class);
        boolean externallyManaged = this.type == 5;
        boolean allowMassStorage = false;
        String envState = reportUnmounted ? "unmounted" : VolumeInfo.getEnvironmentForState(this.state);
        File userPath = this.getPathForUser(userId);
        if (userPath == null) {
            userPath = new File("/dev/null");
        }
        if ((internalPath = this.getInternalPathForUser(userId)) == null) {
            internalPath = new File("/dev/null");
        }
        String description = null;
        UUID uuid = null;
        String derivedFsUuid = this.fsUuid;
        long maxFileSize = 0L;
        if (this.type == 2) {
            emulated = true;
            VolumeInfo privateVol = storage.findPrivateForEmulated(this);
            if (privateVol != null) {
                description = storage.getBestVolumeDescription(privateVol);
                uuid = StorageManager.convert(privateVol.fsUuid);
                derivedFsUuid = privateVol.fsUuid;
            } else {
                uuid = StorageManager.UUID_DEFAULT;
            }
            removable = !this.isPrimaryEmulatedForUser(userId);
        } else if (this.type == 0 || this.type == 5) {
            emulated = false;
            removable = true;
            description = storage.getBestVolumeDescription(this);
            if ("vfat".equals(this.fsType)) {
                maxFileSize = 0xFFFFFFFFL;
            }
        } else {
            throw new IllegalStateException("Unexpected volume type " + this.type);
        }
        if (description == null) {
            description = context.getString(17039374);
        }
        return new StorageVolume(this.id, userPath, internalPath, description, this.isPrimary(), removable, emulated, externallyManaged, false, maxFileSize, new UserHandle(userId), uuid, derivedFsUuid, envState);
    }

    @UnsupportedAppUsage
    public static int buildStableMtpStorageId(String fsUuid) {
        if (TextUtils.isEmpty(fsUuid)) {
            return 0;
        }
        int hash = 0;
        for (int i = 0; i < fsUuid.length(); ++i) {
            hash = 31 * hash + fsUuid.charAt(i);
        }
        if ((hash = (hash ^ hash << 16) & 0xFFFF0000) == 0) {
            hash = 131072;
        }
        if (hash == 65536) {
            hash = 131072;
        }
        if (hash == -65536) {
            hash = -131072;
        }
        return hash | 1;
    }

    @UnsupportedAppUsage
    public Intent buildBrowseIntent() {
        return this.buildBrowseIntentForUser(UserHandle.myUserId());
    }

    public Intent buildBrowseIntentForUser(int userId) {
        Uri uri;
        if ((this.type == 0 || this.type == 5) && this.mountUserId == userId) {
            uri = DocumentsContract.buildRootUri(DOCUMENT_AUTHORITY, this.fsUuid);
        } else if (this.type == 2 && this.isPrimary()) {
            uri = DocumentsContract.buildRootUri(DOCUMENT_AUTHORITY, DOCUMENT_ROOT_PRIMARY_EMULATED);
        } else {
            return null;
        }
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addCategory("android.intent.category.DEFAULT");
        intent.setDataAndType(uri, "vnd.android.document/root");
        intent.putExtra("android.provider.extra.SHOW_ADVANCED", this.isPrimary());
        return intent;
    }

    public String toString() {
        CharArrayWriter writer = new CharArrayWriter();
        this.dump(new IndentingPrintWriter((Writer)writer, "    ", 80));
        return writer.toString();
    }

    public void dump(IndentingPrintWriter pw) {
        pw.println("VolumeInfo{" + this.id + "}:");
        pw.increaseIndent();
        pw.printPair("type", DebugUtils.valueToString(this.getClass(), "TYPE_", this.type));
        pw.printPair("diskId", this.getDiskId());
        pw.printPair("partGuid", this.partGuid);
        pw.printPair("mountFlags", DebugUtils.flagsToString(this.getClass(), "MOUNT_FLAG_", this.mountFlags));
        pw.printPair("mountUserId", this.mountUserId);
        pw.printPair("state", DebugUtils.valueToString(this.getClass(), "STATE_", this.state));
        pw.println();
        pw.printPair("fsType", this.fsType);
        pw.printPair("fsUuid", this.fsUuid);
        pw.printPair("fsLabel", this.fsLabel);
        pw.println();
        pw.printPair("path", this.path);
        pw.printPair("internalPath", this.internalPath);
        pw.decreaseIndent();
        pw.println();
    }

    public VolumeInfo clone() {
        Parcel temp = Parcel.obtain();
        try {
            this.writeToParcel(temp, 0);
            temp.setDataPosition(0);
            VolumeInfo volumeInfo = CREATOR.createFromParcel(temp);
            return volumeInfo;
        }
        finally {
            temp.recycle();
        }
    }

    public boolean equals(Object o) {
        if (o instanceof VolumeInfo) {
            return Objects.equals(this.id, ((VolumeInfo)o).id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeString8(this.id);
        parcel.writeInt(this.type);
        if (this.disk != null) {
            parcel.writeInt(1);
            this.disk.writeToParcel(parcel, flags);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeString8(this.partGuid);
        parcel.writeInt(this.mountFlags);
        parcel.writeInt(this.mountUserId);
        parcel.writeInt(this.state);
        parcel.writeString8(this.fsType);
        parcel.writeString8(this.fsUuid);
        parcel.writeString8(this.fsLabel);
        parcel.writeString8(this.path);
        parcel.writeString8(this.internalPath);
    }

    static {
        sStateToEnvironment.put(0, "unmounted");
        sStateToEnvironment.put(1, "checking");
        sStateToEnvironment.put(2, "mounted");
        sStateToEnvironment.put(3, "mounted_ro");
        sStateToEnvironment.put(4, "unmounted");
        sStateToEnvironment.put(5, "ejecting");
        sStateToEnvironment.put(6, "unmountable");
        sStateToEnvironment.put(7, "removed");
        sStateToEnvironment.put(8, "bad_removal");
        sEnvironmentToBroadcast.put("unmounted", "android.intent.action.MEDIA_UNMOUNTED");
        sEnvironmentToBroadcast.put("checking", "android.intent.action.MEDIA_CHECKING");
        sEnvironmentToBroadcast.put("mounted", "android.intent.action.MEDIA_MOUNTED");
        sEnvironmentToBroadcast.put("mounted_ro", "android.intent.action.MEDIA_MOUNTED");
        sEnvironmentToBroadcast.put("ejecting", "android.intent.action.MEDIA_EJECT");
        sEnvironmentToBroadcast.put("unmountable", "android.intent.action.MEDIA_UNMOUNTABLE");
        sEnvironmentToBroadcast.put("removed", "android.intent.action.MEDIA_REMOVED");
        sEnvironmentToBroadcast.put("bad_removal", "android.intent.action.MEDIA_BAD_REMOVAL");
        sStateToDescrip.put(0, 17040253);
        sStateToDescrip.put(1, 17040245);
        sStateToDescrip.put(2, 17040249);
        sStateToDescrip.put(3, 17040250);
        sStateToDescrip.put(4, 17040247);
        sStateToDescrip.put(5, 17040246);
        sStateToDescrip.put(6, 17040252);
        sStateToDescrip.put(7, 17040251);
        sStateToDescrip.put(8, 17040244);
        CREATOR = new Parcelable.Creator<VolumeInfo>(){

            @Override
            public VolumeInfo createFromParcel(Parcel in) {
                return new VolumeInfo(in);
            }

            public VolumeInfo[] newArray(int size) {
                return new VolumeInfo[size];
            }
        };
    }
}

