/*
 * Decompiled with CFR 0.152.
 */
package android.os.storage;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import android.text.TextUtils;
import com.android.internal.util.Preconditions;

public class CrateInfo
implements Parcelable {
    private static final String TAG = "CrateInfo";
    private CharSequence mLabel;
    private long mExpiration;
    private int mUid;
    private String mPackageName;
    private String mId;
    public static final Parcelable.Creator<CrateInfo> CREATOR = new Parcelable.Creator<CrateInfo>(){

        @Override
        public CrateInfo createFromParcel(Parcel in) {
            CrateInfo crateInfo = new CrateInfo();
            crateInfo.readFromParcel(in);
            return crateInfo;
        }

        public CrateInfo[] newArray(int size) {
            return new CrateInfo[size];
        }
    };

    private CrateInfo() {
        this.mExpiration = 0L;
    }

    public CrateInfo(CharSequence label, long expiration) {
        Preconditions.checkStringNotEmpty(label, "Label should not be either null or empty string");
        Preconditions.checkArgumentNonnegative(expiration, "Expiration should be non negative number");
        this.mLabel = label;
        this.mExpiration = expiration;
    }

    public CrateInfo(CharSequence label) {
        this(label, 0L);
    }

    public CharSequence getLabel() {
        if (TextUtils.isEmpty(this.mLabel)) {
            return this.mId;
        }
        return this.mLabel;
    }

    public long getExpirationMillis() {
        return this.mExpiration;
    }

    public void setExpiration(long expiration) {
        Preconditions.checkArgumentNonnegative(expiration);
        this.mExpiration = expiration;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof CrateInfo) {
            CrateInfo crateInfo = (CrateInfo)obj;
            if (!TextUtils.isEmpty(this.mId) && TextUtils.equals(this.mId, crateInfo.mId)) {
                return true;
            }
        }
        return super.equals(obj);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (dest == null) {
            return;
        }
        dest.writeCharSequence(this.mLabel);
        dest.writeLong(this.mExpiration);
        dest.writeInt(this.mUid);
        dest.writeString(this.mPackageName);
        dest.writeString(this.mId);
    }

    public void readFromParcel(Parcel in) {
        if (in == null) {
            return;
        }
        this.mLabel = in.readCharSequence();
        this.mExpiration = in.readLong();
        this.mUid = in.readInt();
        this.mPackageName = in.readString();
        this.mId = in.readString();
    }

    public static CrateInfo copyFrom(int uid, String packageName, String id2) {
        if (!UserHandle.isApp(uid) || TextUtils.isEmpty(packageName) || TextUtils.isEmpty(id2)) {
            return null;
        }
        CrateInfo crateInfo = new CrateInfo(id2, 0L);
        crateInfo.mUid = uid;
        crateInfo.mPackageName = packageName;
        crateInfo.mId = id2;
        return crateInfo;
    }
}

