/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Set;
import java.util.WeakHashMap;

public abstract class TokenWatcher {
    private Runnable mNotificationTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int value;
            WeakHashMap<IBinder, Death> weakHashMap = TokenWatcher.this.mTokens;
            synchronized (weakHashMap) {
                value = TokenWatcher.this.mNotificationQueue;
                TokenWatcher.this.mNotificationQueue = -1;
            }
            if (value == 1) {
                TokenWatcher.this.acquired();
            } else if (value == 0) {
                TokenWatcher.this.released();
            }
        }
    };
    private WeakHashMap<IBinder, Death> mTokens = new WeakHashMap();
    private Handler mHandler;
    private String mTag;
    private int mNotificationQueue = -1;
    private volatile boolean mAcquired = false;

    public TokenWatcher(Handler h, String tag) {
        this.mHandler = h;
        this.mTag = tag != null ? tag : "TokenWatcher";
    }

    public abstract void acquired();

    public abstract void released();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire(IBinder token, String tag) {
        WeakHashMap<IBinder, Death> weakHashMap = this.mTokens;
        synchronized (weakHashMap) {
            if (this.mTokens.containsKey(token)) {
                return;
            }
            int oldSize = this.mTokens.size();
            Death d = new Death(token, tag);
            try {
                token.linkToDeath(d, 0);
            }
            catch (RemoteException e) {
                return;
            }
            this.mTokens.put(token, d);
            if (oldSize == 0 && !this.mAcquired) {
                this.sendNotificationLocked(true);
                this.mAcquired = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup(IBinder token, boolean unlink) {
        WeakHashMap<IBinder, Death> weakHashMap = this.mTokens;
        synchronized (weakHashMap) {
            Death d = this.mTokens.remove(token);
            if (unlink && d != null) {
                d.token.unlinkToDeath(d, 0);
                d.token = null;
            }
            if (this.mTokens.size() == 0 && this.mAcquired) {
                this.sendNotificationLocked(false);
                this.mAcquired = false;
            }
        }
    }

    public void release(IBinder token) {
        this.cleanup(token, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAcquired() {
        WeakHashMap<IBinder, Death> weakHashMap = this.mTokens;
        synchronized (weakHashMap) {
            return this.mAcquired;
        }
    }

    public void dump() {
        ArrayList<String> a = this.dumpInternal();
        for (String s : a) {
            Log.i(this.mTag, s);
        }
    }

    public void dump(PrintWriter pw) {
        ArrayList<String> a = this.dumpInternal();
        for (String s : a) {
            pw.println(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> dumpInternal() {
        ArrayList<String> a = new ArrayList<String>();
        WeakHashMap<IBinder, Death> weakHashMap = this.mTokens;
        synchronized (weakHashMap) {
            Set<IBinder> keys = this.mTokens.keySet();
            a.add("Token count: " + this.mTokens.size());
            int i = 0;
            for (IBinder b : keys) {
                a.add("[" + i + "] " + this.mTokens.get((Object)b).tag + " - " + b);
                ++i;
            }
        }
        return a;
    }

    private void sendNotificationLocked(boolean on) {
        int value;
        int n = value = on ? 1 : 0;
        if (this.mNotificationQueue == -1) {
            this.mNotificationQueue = value;
            this.mHandler.post(this.mNotificationTask);
        } else if (this.mNotificationQueue != value) {
            this.mNotificationQueue = -1;
            this.mHandler.removeCallbacks(this.mNotificationTask);
        }
    }

    private class Death
    implements IBinder.DeathRecipient {
        IBinder token;
        String tag;

        Death(IBinder token, String tag) {
            this.token = token;
            this.tag = tag;
        }

        @Override
        public void binderDied() {
            TokenWatcher.this.cleanup(this.token, false);
        }

        protected void finalize() throws Throwable {
            try {
                if (this.token != null) {
                    Log.w(TokenWatcher.this.mTag, "cleaning up leaked reference: " + this.tag);
                    TokenWatcher.this.release(this.token);
                }
            }
            finally {
                super.finalize();
            }
        }
    }
}

