/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.os.CombinedVibration;
import android.os.NullVibrator;
import android.os.VibrationAttributes;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.os.VibratorInfo;
import android.os.VibratorManager;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Range;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Function;

public class SystemVibrator
extends Vibrator {
    private static final String TAG = "Vibrator";
    private final VibratorManager mVibratorManager;
    private final Context mContext;
    @GuardedBy(value={"mBrokenListeners"})
    private final ArrayList<AllVibratorsStateListener> mBrokenListeners = new ArrayList();
    @GuardedBy(value={"mRegisteredListeners"})
    private final ArrayMap<Vibrator.OnVibratorStateChangedListener, AllVibratorsStateListener> mRegisteredListeners = new ArrayMap();
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private VibratorInfo mVibratorInfo;

    @UnsupportedAppUsage
    public SystemVibrator(Context context) {
        super(context);
        this.mContext = context;
        this.mVibratorManager = this.mContext.getSystemService(VibratorManager.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected VibratorInfo getInfo() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mVibratorInfo != null) {
                return this.mVibratorInfo;
            }
            if (this.mVibratorManager == null) {
                Log.w(TAG, "Failed to retrieve vibrator info; no vibrator manager.");
                return VibratorInfo.EMPTY_VIBRATOR_INFO;
            }
            int[] vibratorIds = this.mVibratorManager.getVibratorIds();
            if (vibratorIds.length == 0) {
                this.mVibratorInfo = new NoVibratorInfo();
                return this.mVibratorInfo;
            }
            VibratorInfo[] vibratorInfos = new VibratorInfo[vibratorIds.length];
            for (int i = 0; i < vibratorIds.length; ++i) {
                Vibrator vibrator = this.mVibratorManager.getVibrator(vibratorIds[i]);
                if (vibrator instanceof NullVibrator) {
                    Log.w(TAG, "Vibrator manager service not ready; Info not yet available for vibrator: " + vibratorIds[i]);
                    return VibratorInfo.EMPTY_VIBRATOR_INFO;
                }
                vibratorInfos[i] = vibrator.getInfo();
            }
            if (vibratorInfos.length == 1) {
                this.mVibratorInfo = new VibratorInfo(-1, vibratorInfos[0]);
                return this.mVibratorInfo;
            }
            this.mVibratorInfo = new MultiVibratorInfo(vibratorInfos);
            return this.mVibratorInfo;
        }
    }

    @Override
    public boolean hasVibrator() {
        if (this.mVibratorManager == null) {
            Log.w(TAG, "Failed to check if vibrator exists; no vibrator manager.");
            return false;
        }
        return this.mVibratorManager.getVibratorIds().length > 0;
    }

    @Override
    public boolean isVibrating() {
        if (this.mVibratorManager == null) {
            Log.w(TAG, "Failed to vibrate; no vibrator manager.");
            return false;
        }
        for (int vibratorId : this.mVibratorManager.getVibratorIds()) {
            if (!this.mVibratorManager.getVibrator(vibratorId).isVibrating()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addVibratorStateListener(Vibrator.OnVibratorStateChangedListener listener) {
        Objects.requireNonNull(listener);
        if (this.mContext == null) {
            Log.w(TAG, "Failed to add vibrate state listener; no vibrator context.");
            return;
        }
        this.addVibratorStateListener(this.mContext.getMainExecutor(), listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addVibratorStateListener(Executor executor, Vibrator.OnVibratorStateChangedListener listener) {
        Objects.requireNonNull(listener);
        Objects.requireNonNull(executor);
        if (this.mVibratorManager == null) {
            Log.w(TAG, "Failed to add vibrate state listener; no vibrator manager.");
            return;
        }
        AllVibratorsStateListener delegate = null;
        try {
            ArrayMap<Vibrator.OnVibratorStateChangedListener, AllVibratorsStateListener> arrayMap = this.mRegisteredListeners;
            synchronized (arrayMap) {
                block19: {
                    if (!this.mRegisteredListeners.containsKey(listener)) break block19;
                    Log.w(TAG, "Listener already registered.");
                    return;
                }
                delegate = new AllVibratorsStateListener(executor, listener);
                delegate.register(this.mVibratorManager);
                this.mRegisteredListeners.put(listener, delegate);
                delegate = null;
            }
        }
        finally {
            if (delegate != null && delegate.hasRegisteredListeners()) {
                ArrayList<AllVibratorsStateListener> arrayList = this.mBrokenListeners;
                synchronized (arrayList) {
                    this.mBrokenListeners.add(delegate);
                }
            }
            this.tryUnregisterBrokenListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeVibratorStateListener(Vibrator.OnVibratorStateChangedListener listener) {
        Objects.requireNonNull(listener);
        if (this.mVibratorManager == null) {
            Log.w(TAG, "Failed to remove vibrate state listener; no vibrator manager.");
            return;
        }
        ArrayMap<Vibrator.OnVibratorStateChangedListener, AllVibratorsStateListener> arrayMap = this.mRegisteredListeners;
        synchronized (arrayMap) {
            if (this.mRegisteredListeners.containsKey(listener)) {
                AllVibratorsStateListener delegate = this.mRegisteredListeners.get(listener);
                delegate.unregister(this.mVibratorManager);
                this.mRegisteredListeners.remove(listener);
            }
        }
        this.tryUnregisterBrokenListeners();
    }

    @Override
    public boolean hasAmplitudeControl() {
        return this.getInfo().hasAmplitudeControl();
    }

    @Override
    public boolean setAlwaysOnEffect(int uid, String opPkg, int alwaysOnId, VibrationEffect effect, VibrationAttributes attrs) {
        if (this.mVibratorManager == null) {
            Log.w(TAG, "Failed to set always-on effect; no vibrator manager.");
            return false;
        }
        CombinedVibration combinedEffect = CombinedVibration.createParallel(effect);
        return this.mVibratorManager.setAlwaysOnEffect(uid, opPkg, alwaysOnId, combinedEffect, attrs);
    }

    @Override
    public void vibrate(int uid, String opPkg, VibrationEffect effect, String reason, VibrationAttributes attributes) {
        if (this.mVibratorManager == null) {
            Log.w(TAG, "Failed to vibrate; no vibrator manager.");
            return;
        }
        CombinedVibration combinedEffect = CombinedVibration.createParallel(effect);
        this.mVibratorManager.vibrate(uid, opPkg, combinedEffect, reason, attributes);
    }

    @Override
    public void cancel() {
        if (this.mVibratorManager == null) {
            Log.w(TAG, "Failed to cancel vibrate; no vibrator manager.");
            return;
        }
        this.mVibratorManager.cancel();
    }

    @Override
    public void cancel(int usageFilter) {
        if (this.mVibratorManager == null) {
            Log.w(TAG, "Failed to cancel vibrate; no vibrator manager.");
            return;
        }
        this.mVibratorManager.cancel(usageFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryUnregisterBrokenListeners() {
        ArrayList<AllVibratorsStateListener> arrayList = this.mBrokenListeners;
        synchronized (arrayList) {
            try {
                int i = this.mBrokenListeners.size();
                while (--i >= 0) {
                    this.mBrokenListeners.get(i).unregister(this.mVibratorManager);
                    this.mBrokenListeners.remove(i);
                }
            }
            catch (RuntimeException e) {
                Log.w(TAG, "Failed to unregister broken listener", e);
            }
        }
    }

    private static class AllVibratorsStateListener {
        private final Object mLock = new Object();
        private final Executor mExecutor;
        private final Vibrator.OnVibratorStateChangedListener mDelegate;
        @GuardedBy(value={"mLock"})
        private final SparseArray<SingleVibratorStateListener> mVibratorListeners = new SparseArray();
        @GuardedBy(value={"mLock"})
        private int mInitializedMask;
        @GuardedBy(value={"mLock"})
        private int mVibratingMask;

        AllVibratorsStateListener(Executor executor, Vibrator.OnVibratorStateChangedListener listener) {
            this.mExecutor = executor;
            this.mDelegate = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean hasRegisteredListeners() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mVibratorListeners.size() > 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void register(VibratorManager vibratorManager) {
            int[] vibratorIds = vibratorManager.getVibratorIds();
            Object object = this.mLock;
            synchronized (object) {
                for (int i = 0; i < vibratorIds.length; ++i) {
                    int vibratorId = vibratorIds[i];
                    SingleVibratorStateListener listener = new SingleVibratorStateListener(this, i);
                    try {
                        vibratorManager.getVibrator(vibratorId).addVibratorStateListener(this.mExecutor, listener);
                        this.mVibratorListeners.put(vibratorId, listener);
                        continue;
                    }
                    catch (RuntimeException e) {
                        try {
                            this.unregister(vibratorManager);
                        }
                        catch (RuntimeException e1) {
                            Log.w(SystemVibrator.TAG, "Failed to unregister listener while recovering from a failed register call", e1);
                        }
                        throw e;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void unregister(VibratorManager vibratorManager) {
            Object object = this.mLock;
            synchronized (object) {
                int i = this.mVibratorListeners.size();
                while (--i >= 0) {
                    int vibratorId = this.mVibratorListeners.keyAt(i);
                    SingleVibratorStateListener listener = this.mVibratorListeners.valueAt(i);
                    vibratorManager.getVibrator(vibratorId).removeVibratorStateListener(listener);
                    this.mVibratorListeners.removeAt(i);
                }
            }
        }

        void onVibrating(int vibratorIdx, boolean vibrating) {
            this.mExecutor.execute(() -> {
                boolean anyVibrating;
                Object object = this.mLock;
                synchronized (object) {
                    int allInitializedMask = (1 << this.mVibratorListeners.size()) - 1;
                    int vibratorMask = 1 << vibratorIdx;
                    if ((this.mInitializedMask & vibratorMask) == 0) {
                        this.mInitializedMask |= vibratorMask;
                        this.mVibratingMask |= vibrating ? vibratorMask : 0;
                    } else {
                        boolean prevVibrating;
                        boolean bl = prevVibrating = (this.mVibratingMask & vibratorMask) != 0;
                        if (prevVibrating != vibrating) {
                            this.mVibratingMask ^= vibratorMask;
                        }
                    }
                    if (this.mInitializedMask != allInitializedMask) {
                        return;
                    }
                    anyVibrating = this.mVibratingMask != 0;
                }
                this.mDelegate.onVibratorStateChanged(anyVibrating);
            });
        }
    }

    @VisibleForTesting
    public static class MultiVibratorInfo
    extends VibratorInfo {
        private static final float EPSILON = 1.0E-5f;

        public MultiVibratorInfo(VibratorInfo[] vibrators) {
            super(-1, MultiVibratorInfo.capabilitiesIntersection(vibrators), MultiVibratorInfo.supportedEffectsIntersection(vibrators), MultiVibratorInfo.supportedBrakingIntersection(vibrators), MultiVibratorInfo.supportedPrimitivesAndDurationsIntersection(vibrators), MultiVibratorInfo.integerLimitIntersection(vibrators, VibratorInfo::getPrimitiveDelayMax), MultiVibratorInfo.integerLimitIntersection(vibrators, VibratorInfo::getCompositionSizeMax), MultiVibratorInfo.integerLimitIntersection(vibrators, VibratorInfo::getPwlePrimitiveDurationMax), MultiVibratorInfo.integerLimitIntersection(vibrators, VibratorInfo::getPwleSizeMax), MultiVibratorInfo.floatPropertyIntersection(vibrators, VibratorInfo::getQFactor), MultiVibratorInfo.frequencyProfileIntersection(vibrators));
        }

        private static int capabilitiesIntersection(VibratorInfo[] infos) {
            int intersection = -1;
            for (VibratorInfo info : infos) {
                intersection = (int)((long)intersection & info.getCapabilities());
            }
            return intersection;
        }

        private static SparseBooleanArray supportedBrakingIntersection(VibratorInfo[] infos) {
            for (VibratorInfo info : infos) {
                if (info.isBrakingSupportKnown()) continue;
                return null;
            }
            SparseBooleanArray intersection = new SparseBooleanArray();
            SparseBooleanArray firstVibratorBraking = infos[0].getSupportedBraking();
            block1: for (int i = 0; i < firstVibratorBraking.size(); ++i) {
                int brakingId = firstVibratorBraking.keyAt(i);
                if (!firstVibratorBraking.valueAt(i)) continue;
                for (int j = 1; j < infos.length; ++j) {
                    if (!infos[j].hasBrakingSupport(brakingId)) continue block1;
                }
                intersection.put(brakingId, true);
            }
            return intersection;
        }

        private static SparseBooleanArray supportedEffectsIntersection(VibratorInfo[] infos) {
            for (VibratorInfo info : infos) {
                if (info.isEffectSupportKnown()) continue;
                return null;
            }
            SparseBooleanArray intersection = new SparseBooleanArray();
            SparseBooleanArray firstVibratorEffects = infos[0].getSupportedEffects();
            block1: for (int i = 0; i < firstVibratorEffects.size(); ++i) {
                int effectId = firstVibratorEffects.keyAt(i);
                if (!firstVibratorEffects.valueAt(i)) continue;
                for (int j = 1; j < infos.length; ++j) {
                    if (infos[j].isEffectSupported(effectId) != 1) continue block1;
                }
                intersection.put(effectId, true);
            }
            return intersection;
        }

        private static SparseIntArray supportedPrimitivesAndDurationsIntersection(VibratorInfo[] infos) {
            SparseIntArray intersection = new SparseIntArray();
            SparseIntArray firstVibratorPrimitives = infos[0].getSupportedPrimitives();
            block0: for (int i = 0; i < firstVibratorPrimitives.size(); ++i) {
                int primitiveId = firstVibratorPrimitives.keyAt(i);
                int primitiveDuration = firstVibratorPrimitives.valueAt(i);
                if (primitiveDuration == 0) continue;
                for (int j = 1; j < infos.length; ++j) {
                    int vibratorPrimitiveDuration = infos[j].getPrimitiveDuration(primitiveId);
                    if (vibratorPrimitiveDuration == 0) continue block0;
                    primitiveDuration = Math.max(primitiveDuration, vibratorPrimitiveDuration);
                }
                intersection.put(primitiveId, primitiveDuration);
            }
            return intersection;
        }

        private static int integerLimitIntersection(VibratorInfo[] infos, Function<VibratorInfo, Integer> propertyGetter) {
            int limit = 0;
            for (VibratorInfo info : infos) {
                int vibratorLimit = propertyGetter.apply(info);
                if (limit != 0 && (vibratorLimit <= 0 || vibratorLimit >= limit)) continue;
                limit = vibratorLimit;
            }
            return limit;
        }

        private static float floatPropertyIntersection(VibratorInfo[] infos, Function<VibratorInfo, Float> propertyGetter) {
            float property = propertyGetter.apply(infos[0]).floatValue();
            if (Float.isNaN(property)) {
                return Float.NaN;
            }
            for (int i = 1; i < infos.length; ++i) {
                if (Float.compare(property, propertyGetter.apply(infos[i]).floatValue()) == 0) continue;
                return Float.NaN;
            }
            return property;
        }

        private static VibratorInfo.FrequencyProfile frequencyProfileIntersection(VibratorInfo[] infos) {
            float freqResolution = MultiVibratorInfo.floatPropertyIntersection(infos, info -> Float.valueOf(info.getFrequencyProfile().getFrequencyResolutionHz()));
            float resonantFreq = MultiVibratorInfo.floatPropertyIntersection(infos, VibratorInfo::getResonantFrequencyHz);
            Range<Float> freqRange = MultiVibratorInfo.frequencyRangeIntersection(infos, freqResolution);
            if (freqRange == null || Float.isNaN(freqResolution)) {
                return new VibratorInfo.FrequencyProfile(resonantFreq, Float.NaN, freqResolution, null);
            }
            int amplitudeCount = Math.round(1.0f + (freqRange.getUpper().floatValue() - freqRange.getLower().floatValue()) / freqResolution);
            float[] maxAmplitudes = new float[amplitudeCount];
            Arrays.fill(maxAmplitudes, Float.MAX_VALUE);
            for (VibratorInfo info2 : infos) {
                Range<Float> vibratorFreqRange = info2.getFrequencyProfile().getFrequencyRangeHz();
                float[] vibratorMaxAmplitudes = info2.getFrequencyProfile().getMaxAmplitudes();
                int vibratorStartIdx = Math.round((freqRange.getLower().floatValue() - vibratorFreqRange.getLower().floatValue()) / freqResolution);
                int vibratorEndIdx = vibratorStartIdx + maxAmplitudes.length - 1;
                if (vibratorStartIdx < 0 || vibratorEndIdx >= vibratorMaxAmplitudes.length) {
                    Slog.w(SystemVibrator.TAG, "Error calculating the intersection of vibrator frequency profiles: attempted to fetch from vibrator " + info2.getId() + " max amplitude with bad index " + vibratorStartIdx);
                    return new VibratorInfo.FrequencyProfile(resonantFreq, Float.NaN, Float.NaN, null);
                }
                for (int i = 0; i < maxAmplitudes.length; ++i) {
                    maxAmplitudes[i] = Math.min(maxAmplitudes[i], vibratorMaxAmplitudes[vibratorStartIdx + i]);
                }
            }
            return new VibratorInfo.FrequencyProfile(resonantFreq, freqRange.getLower().floatValue(), freqResolution, maxAmplitudes);
        }

        private static Range<Float> frequencyRangeIntersection(VibratorInfo[] infos, float frequencyResolution) {
            Range<Float> firstRange = infos[0].getFrequencyProfile().getFrequencyRangeHz();
            if (firstRange == null) {
                return null;
            }
            float intersectionLower = firstRange.getLower().floatValue();
            float intersectionUpper = firstRange.getUpper().floatValue();
            for (int i = 1; i < infos.length; ++i) {
                Range<Float> vibratorRange = infos[i].getFrequencyProfile().getFrequencyRangeHz();
                if (vibratorRange == null) {
                    return null;
                }
                if (vibratorRange.getLower().floatValue() >= intersectionUpper || vibratorRange.getUpper().floatValue() <= intersectionLower) {
                    return null;
                }
                float frequencyDelta = Math.abs(intersectionLower - vibratorRange.getLower().floatValue());
                if (frequencyDelta % frequencyResolution > 1.0E-5f) {
                    return null;
                }
                intersectionLower = Math.max(intersectionLower, vibratorRange.getLower().floatValue());
                intersectionUpper = Math.min(intersectionUpper, vibratorRange.getUpper().floatValue());
            }
            if (intersectionUpper - intersectionLower < frequencyResolution) {
                return null;
            }
            return Range.create(Float.valueOf(intersectionLower), Float.valueOf(intersectionUpper));
        }
    }

    @VisibleForTesting
    public static class NoVibratorInfo
    extends VibratorInfo {
        public NoVibratorInfo() {
            super(-1, 0L, new SparseBooleanArray(), new SparseBooleanArray(), new SparseIntArray(), 0, 0, 0, 0, Float.NaN, new VibratorInfo.FrequencyProfile(Float.NaN, Float.NaN, Float.NaN, null));
        }
    }

    private static class SingleVibratorStateListener
    implements Vibrator.OnVibratorStateChangedListener {
        private final AllVibratorsStateListener mAllVibratorsListener;
        private final int mVibratorIdx;

        SingleVibratorStateListener(AllVibratorsStateListener listener, int vibratorIdx) {
            this.mAllVibratorsListener = listener;
            this.mVibratorIdx = vibratorIdx;
        }

        @Override
        public void onVibratorStateChanged(boolean isVibrating) {
            this.mAllVibratorsListener.onVibrating(this.mVibratorIdx, isVibrating);
        }
    }
}

