/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Handler;
import android.os.Message;
import android.os.SystemClock_Delegate;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.impl.RenderAction;
import com.android.layoutlib.bridge.util.HandlerMessageQueue;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;

public class Handler_Delegate {
    private static final ThreadLocal<IHandlerCallback> sCallbacks = new ThreadLocal();

    @LayoutlibDelegate
    static boolean sendMessageAtTime(Handler handler, Message msg, long uptimeMillis) {
        IHandlerCallback callback = sCallbacks.get();
        if (callback != null) {
            callback.sendMessageAtTime(handler, msg, uptimeMillis);
        } else if (msg.callback != null) {
            BridgeContext context = RenderAction.getCurrentContext();
            if (context == null) {
                return true;
            }
            context.getSessionInteractiveData().getHandlerMessageQueue().add(handler, uptimeMillis, msg.callback);
        }
        return true;
    }

    @LayoutlibDelegate
    static boolean sendMessageAtFrontOfQueue(Handler handler, Message msg) {
        if (msg.callback != null) {
            BridgeContext context = RenderAction.getCurrentContext();
            if (context == null) {
                return true;
            }
            context.getSessionInteractiveData().getHandlerMessageQueue().add(handler, 0L, msg.callback);
        }
        return true;
    }

    public static boolean executeCallbacks() {
        Runnable r;
        BridgeContext context = RenderAction.getCurrentContext();
        if (context == null) {
            return false;
        }
        HandlerMessageQueue queue = context.getSessionInteractiveData().getHandlerMessageQueue();
        long uptimeMillis = SystemClock_Delegate.uptimeMillis();
        while ((r = queue.extractFirst(uptimeMillis)) != null) {
            Handler_Delegate.executeSafely(r);
        }
        return queue.isNotEmpty();
    }

    public static void setCallback(IHandlerCallback callback) {
        sCallbacks.set(callback);
    }

    private static void executeSafely(Runnable r) {
        try {
            r.run();
        }
        catch (Throwable t) {
            Bridge.getLog().error("broken", "Failed executing Handler callback", t, null, null);
        }
    }

    public static interface IHandlerCallback {
        public void sendMessageAtTime(Handler var1, Message var2, long var3);
    }
}

