/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.nl80211;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.util.Objects;

@SystemApi
public class DeviceWiphyCapabilities
implements Parcelable {
    private static final String TAG = "DeviceWiphyCapabilities";
    private boolean m80211nSupported = false;
    private boolean m80211acSupported = false;
    private boolean m80211axSupported = false;
    private boolean m80211beSupported = false;
    private boolean mChannelWidth160MhzSupported = false;
    private boolean mChannelWidth80p80MhzSupported = false;
    private boolean mChannelWidth320MhzSupported = false;
    private int mMaxNumberTxSpatialStreams = 1;
    private int mMaxNumberRxSpatialStreams = 1;
    public static final Parcelable.Creator<DeviceWiphyCapabilities> CREATOR = new Parcelable.Creator<DeviceWiphyCapabilities>(){

        @Override
        public DeviceWiphyCapabilities createFromParcel(Parcel in) {
            DeviceWiphyCapabilities capabilities = new DeviceWiphyCapabilities();
            capabilities.m80211nSupported = in.readBoolean();
            capabilities.m80211acSupported = in.readBoolean();
            capabilities.m80211axSupported = in.readBoolean();
            capabilities.m80211beSupported = in.readBoolean();
            capabilities.mChannelWidth160MhzSupported = in.readBoolean();
            capabilities.mChannelWidth80p80MhzSupported = in.readBoolean();
            capabilities.mChannelWidth320MhzSupported = in.readBoolean();
            capabilities.mMaxNumberTxSpatialStreams = in.readInt();
            capabilities.mMaxNumberRxSpatialStreams = in.readInt();
            return capabilities;
        }

        public DeviceWiphyCapabilities[] newArray(int size) {
            return new DeviceWiphyCapabilities[size];
        }
    };

    public boolean isWifiStandardSupported(int standard) {
        switch (standard) {
            case 1: {
                return true;
            }
            case 4: {
                return this.m80211nSupported;
            }
            case 5: {
                return this.m80211acSupported;
            }
            case 6: {
                return this.m80211axSupported;
            }
            case 8: {
                return this.m80211beSupported;
            }
        }
        Log.e(TAG, "isWifiStandardSupported called with invalid standard: " + standard);
        return false;
    }

    public void setWifiStandardSupport(int standard, boolean support) {
        switch (standard) {
            case 4: {
                this.m80211nSupported = support;
                break;
            }
            case 5: {
                this.m80211acSupported = support;
                break;
            }
            case 6: {
                this.m80211axSupported = support;
                break;
            }
            case 8: {
                this.m80211beSupported = support;
                break;
            }
            default: {
                Log.e(TAG, "setWifiStandardSupport called with invalid standard: " + standard);
            }
        }
    }

    public boolean isChannelWidthSupported(int chWidth) {
        switch (chWidth) {
            case 0: {
                return true;
            }
            case 1: {
                return this.m80211nSupported || this.m80211acSupported || this.m80211axSupported || this.m80211beSupported;
            }
            case 2: {
                return this.m80211acSupported || this.m80211axSupported || this.m80211beSupported;
            }
            case 3: {
                return this.mChannelWidth160MhzSupported;
            }
            case 4: {
                return this.mChannelWidth80p80MhzSupported;
            }
            case 5: {
                return this.mChannelWidth320MhzSupported;
            }
        }
        Log.e(TAG, "isChannelWidthSupported called with invalid channel width: " + chWidth);
        return false;
    }

    public void setChannelWidthSupported(int chWidth, boolean support) {
        switch (chWidth) {
            case 3: {
                this.mChannelWidth160MhzSupported = support;
                break;
            }
            case 4: {
                this.mChannelWidth80p80MhzSupported = support;
                break;
            }
            case 5: {
                this.mChannelWidth320MhzSupported = support;
                break;
            }
            default: {
                Log.e(TAG, "setChannelWidthSupported called with Invalid channel width: " + chWidth);
            }
        }
    }

    public int getMaxNumberTxSpatialStreams() {
        return this.mMaxNumberTxSpatialStreams;
    }

    public void setMaxNumberTxSpatialStreams(int streams) {
        this.mMaxNumberTxSpatialStreams = streams;
    }

    public int getMaxNumberRxSpatialStreams() {
        return this.mMaxNumberRxSpatialStreams;
    }

    public void setMaxNumberRxSpatialStreams(int streams) {
        this.mMaxNumberRxSpatialStreams = streams;
    }

    public boolean equals(Object rhs) {
        if (this == rhs) {
            return true;
        }
        if (!(rhs instanceof DeviceWiphyCapabilities)) {
            return false;
        }
        DeviceWiphyCapabilities capa = (DeviceWiphyCapabilities)rhs;
        return this.m80211nSupported == capa.m80211nSupported && this.m80211acSupported == capa.m80211acSupported && this.m80211axSupported == capa.m80211axSupported && this.m80211beSupported == capa.m80211beSupported && this.mChannelWidth160MhzSupported == capa.mChannelWidth160MhzSupported && this.mChannelWidth80p80MhzSupported == capa.mChannelWidth80p80MhzSupported && this.mChannelWidth320MhzSupported == capa.mChannelWidth320MhzSupported && this.mMaxNumberTxSpatialStreams == capa.mMaxNumberTxSpatialStreams && this.mMaxNumberRxSpatialStreams == capa.mMaxNumberRxSpatialStreams;
    }

    public int hashCode() {
        return Objects.hash(this.m80211nSupported, this.m80211acSupported, this.m80211axSupported, this.m80211beSupported, this.mChannelWidth160MhzSupported, this.mChannelWidth80p80MhzSupported, this.mChannelWidth320MhzSupported, this.mMaxNumberTxSpatialStreams, this.mMaxNumberRxSpatialStreams);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeBoolean(this.m80211nSupported);
        out.writeBoolean(this.m80211acSupported);
        out.writeBoolean(this.m80211axSupported);
        out.writeBoolean(this.m80211beSupported);
        out.writeBoolean(this.mChannelWidth160MhzSupported);
        out.writeBoolean(this.mChannelWidth80p80MhzSupported);
        out.writeBoolean(this.mChannelWidth320MhzSupported);
        out.writeInt(this.mMaxNumberTxSpatialStreams);
        out.writeInt(this.mMaxNumberRxSpatialStreams);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("m80211nSupported:").append(this.m80211nSupported ? "Yes" : "No");
        sb.append("m80211acSupported:").append(this.m80211acSupported ? "Yes" : "No");
        sb.append("m80211axSupported:").append(this.m80211axSupported ? "Yes" : "No");
        sb.append("m80211beSupported:").append(this.m80211beSupported ? "Yes" : "No");
        sb.append("mChannelWidth160MhzSupported: ").append(this.mChannelWidth160MhzSupported ? "Yes" : "No");
        sb.append("mChannelWidth80p80MhzSupported: ").append(this.mChannelWidth80p80MhzSupported ? "Yes" : "No");
        sb.append("mChannelWidth320MhzSupported: ").append(this.mChannelWidth320MhzSupported ? "Yes" : "No");
        sb.append("mMaxNumberTxSpatialStreams: ").append(this.mMaxNumberTxSpatialStreams);
        sb.append("mMaxNumberRxSpatialStreams: ").append(this.mMaxNumberRxSpatialStreams);
        return sb.toString();
    }
}

