/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;

@SystemApi
public class WifiUsabilityStatsEntry
implements Parcelable {
    private static final String TAG = "WifiUsabilityStatsEntry";
    public static final int PROBE_STATUS_UNKNOWN = 0;
    public static final int PROBE_STATUS_NO_PROBE = 1;
    public static final int PROBE_STATUS_SUCCESS = 2;
    public static final int PROBE_STATUS_FAILURE = 3;
    private final long mTimeStampMillis;
    private final int mRssi;
    private final int mLinkSpeedMbps;
    private final long mTotalTxSuccess;
    private final long mTotalTxRetries;
    private final long mTotalTxBad;
    private final long mTotalRxSuccess;
    private final long mTotalRadioOnTimeMillis;
    private final long mTotalRadioTxTimeMillis;
    private final long mTotalRadioRxTimeMillis;
    private final long mTotalScanTimeMillis;
    private final long mTotalNanScanTimeMillis;
    private final long mTotalBackgroundScanTimeMillis;
    private final long mTotalRoamScanTimeMillis;
    private final long mTotalPnoScanTimeMillis;
    private final long mTotalHotspot2ScanTimeMillis;
    private final long mTotalCcaBusyFreqTimeMillis;
    private final long mTotalRadioOnFreqTimeMillis;
    private final long mTotalBeaconRx;
    private final int mProbeStatusSinceLastUpdate;
    private final int mProbeElapsedTimeSinceLastUpdateMillis;
    private final int mProbeMcsRateSinceLastUpdate;
    private final int mRxLinkSpeedMbps;
    private final int mTimeSliceDutyCycleInPercent;
    public static final int WME_ACCESS_CATEGORY_BE = 0;
    public static final int WME_ACCESS_CATEGORY_BK = 1;
    public static final int WME_ACCESS_CATEGORY_VI = 2;
    public static final int WME_ACCESS_CATEGORY_VO = 3;
    public static final int NUM_WME_ACCESS_CATEGORIES = 4;
    private final ContentionTimeStats[] mContentionTimeStats;
    public static final int WIFI_PREAMBLE_OFDM = 0;
    public static final int WIFI_PREAMBLE_CCK = 1;
    public static final int WIFI_PREAMBLE_HT = 2;
    public static final int WIFI_PREAMBLE_VHT = 3;
    public static final int WIFI_PREAMBLE_HE = 5;
    public static final int WIFI_PREAMBLE_EHT = 6;
    public static final int WIFI_PREAMBLE_INVALID = -1;
    public static final int WIFI_SPATIAL_STREAMS_ONE = 1;
    public static final int WIFI_SPATIAL_STREAMS_TWO = 2;
    public static final int WIFI_SPATIAL_STREAMS_THREE = 3;
    public static final int WIFI_SPATIAL_STREAMS_FOUR = 4;
    public static final int WIFI_SPATIAL_STREAMS_INVALID = -1;
    public static final int WIFI_BANDWIDTH_20_MHZ = 0;
    public static final int WIFI_BANDWIDTH_40_MHZ = 1;
    public static final int WIFI_BANDWIDTH_80_MHZ = 2;
    public static final int WIFI_BANDWIDTH_160_MHZ = 3;
    public static final int WIFI_BANDWIDTH_80P80_MHZ = 4;
    public static final int WIFI_BANDWIDTH_5_MHZ = 5;
    public static final int WIFI_BANDWIDTH_10_MHZ = 6;
    public static final int WIFI_BANDWIDTH_320_MHZ = 7;
    public static final int WIFI_BANDWIDTH_INVALID = -1;
    private final RateStats[] mRateStats;
    private final RadioStats[] mRadioStats;
    private final int mChannelUtilizationRatio;
    private final boolean mIsThroughputSufficient;
    private final boolean mIsWifiScoringEnabled;
    private final boolean mIsCellularDataAvailable;
    private final int mCellularDataNetworkType;
    private final int mCellularSignalStrengthDbm;
    private final int mCellularSignalStrengthDb;
    private final boolean mIsSameRegisteredCell;
    public static final Parcelable.Creator<WifiUsabilityStatsEntry> CREATOR = new Parcelable.Creator<WifiUsabilityStatsEntry>(){

        @Override
        public WifiUsabilityStatsEntry createFromParcel(Parcel in) {
            return new WifiUsabilityStatsEntry(in.readLong(), in.readInt(), in.readInt(), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readInt(), in.readInt(), in.readInt(), in.readInt(), in.readInt(), in.createTypedArray(ContentionTimeStats.CREATOR), in.createTypedArray(RateStats.CREATOR), in.createTypedArray(RadioStats.CREATOR), in.readInt(), in.readBoolean(), in.readBoolean(), in.readBoolean(), in.readInt(), in.readInt(), in.readInt(), in.readBoolean());
        }

        public WifiUsabilityStatsEntry[] newArray(int size) {
            return new WifiUsabilityStatsEntry[size];
        }
    };

    public WifiUsabilityStatsEntry(long timeStampMillis, int rssi, int linkSpeedMbps, long totalTxSuccess, long totalTxRetries, long totalTxBad, long totalRxSuccess, long totalRadioOnTimeMillis, long totalRadioTxTimeMillis, long totalRadioRxTimeMillis, long totalScanTimeMillis, long totalNanScanTimeMillis, long totalBackgroundScanTimeMillis, long totalRoamScanTimeMillis, long totalPnoScanTimeMillis, long totalHotspot2ScanTimeMillis, long totalCcaBusyFreqTimeMillis, long totalRadioOnFreqTimeMillis, long totalBeaconRx, int probeStatusSinceLastUpdate, int probeElapsedTimeSinceLastUpdateMillis, int probeMcsRateSinceLastUpdate, int rxLinkSpeedMbps, int timeSliceDutyCycleInPercent, ContentionTimeStats[] contentionTimeStats, RateStats[] rateStats, RadioStats[] radiostats, int channelUtilizationRatio, boolean isThroughputSufficient, boolean isWifiScoringEnabled, boolean isCellularDataAvailable, int cellularDataNetworkType, int cellularSignalStrengthDbm, int cellularSignalStrengthDb, boolean isSameRegisteredCell) {
        this.mTimeStampMillis = timeStampMillis;
        this.mRssi = rssi;
        this.mLinkSpeedMbps = linkSpeedMbps;
        this.mTotalTxSuccess = totalTxSuccess;
        this.mTotalTxRetries = totalTxRetries;
        this.mTotalTxBad = totalTxBad;
        this.mTotalRxSuccess = totalRxSuccess;
        this.mTotalRadioOnTimeMillis = totalRadioOnTimeMillis;
        this.mTotalRadioTxTimeMillis = totalRadioTxTimeMillis;
        this.mTotalRadioRxTimeMillis = totalRadioRxTimeMillis;
        this.mTotalScanTimeMillis = totalScanTimeMillis;
        this.mTotalNanScanTimeMillis = totalNanScanTimeMillis;
        this.mTotalBackgroundScanTimeMillis = totalBackgroundScanTimeMillis;
        this.mTotalRoamScanTimeMillis = totalRoamScanTimeMillis;
        this.mTotalPnoScanTimeMillis = totalPnoScanTimeMillis;
        this.mTotalHotspot2ScanTimeMillis = totalHotspot2ScanTimeMillis;
        this.mTotalCcaBusyFreqTimeMillis = totalCcaBusyFreqTimeMillis;
        this.mTotalRadioOnFreqTimeMillis = totalRadioOnFreqTimeMillis;
        this.mTotalBeaconRx = totalBeaconRx;
        this.mProbeStatusSinceLastUpdate = probeStatusSinceLastUpdate;
        this.mProbeElapsedTimeSinceLastUpdateMillis = probeElapsedTimeSinceLastUpdateMillis;
        this.mProbeMcsRateSinceLastUpdate = probeMcsRateSinceLastUpdate;
        this.mRxLinkSpeedMbps = rxLinkSpeedMbps;
        this.mTimeSliceDutyCycleInPercent = timeSliceDutyCycleInPercent;
        this.mContentionTimeStats = contentionTimeStats;
        this.mRateStats = rateStats;
        this.mRadioStats = radiostats;
        this.mChannelUtilizationRatio = channelUtilizationRatio;
        this.mIsThroughputSufficient = isThroughputSufficient;
        this.mIsWifiScoringEnabled = isWifiScoringEnabled;
        this.mIsCellularDataAvailable = isCellularDataAvailable;
        this.mCellularDataNetworkType = cellularDataNetworkType;
        this.mCellularSignalStrengthDbm = cellularSignalStrengthDbm;
        this.mCellularSignalStrengthDb = cellularSignalStrengthDb;
        this.mIsSameRegisteredCell = isSameRegisteredCell;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mTimeStampMillis);
        dest.writeInt(this.mRssi);
        dest.writeInt(this.mLinkSpeedMbps);
        dest.writeLong(this.mTotalTxSuccess);
        dest.writeLong(this.mTotalTxRetries);
        dest.writeLong(this.mTotalTxBad);
        dest.writeLong(this.mTotalRxSuccess);
        dest.writeLong(this.mTotalRadioOnTimeMillis);
        dest.writeLong(this.mTotalRadioTxTimeMillis);
        dest.writeLong(this.mTotalRadioRxTimeMillis);
        dest.writeLong(this.mTotalScanTimeMillis);
        dest.writeLong(this.mTotalNanScanTimeMillis);
        dest.writeLong(this.mTotalBackgroundScanTimeMillis);
        dest.writeLong(this.mTotalRoamScanTimeMillis);
        dest.writeLong(this.mTotalPnoScanTimeMillis);
        dest.writeLong(this.mTotalHotspot2ScanTimeMillis);
        dest.writeLong(this.mTotalCcaBusyFreqTimeMillis);
        dest.writeLong(this.mTotalRadioOnFreqTimeMillis);
        dest.writeLong(this.mTotalBeaconRx);
        dest.writeInt(this.mProbeStatusSinceLastUpdate);
        dest.writeInt(this.mProbeElapsedTimeSinceLastUpdateMillis);
        dest.writeInt(this.mProbeMcsRateSinceLastUpdate);
        dest.writeInt(this.mRxLinkSpeedMbps);
        dest.writeInt(this.mTimeSliceDutyCycleInPercent);
        dest.writeTypedArray(this.mContentionTimeStats, flags);
        dest.writeTypedArray(this.mRateStats, flags);
        dest.writeTypedArray(this.mRadioStats, flags);
        dest.writeInt(this.mChannelUtilizationRatio);
        dest.writeBoolean(this.mIsThroughputSufficient);
        dest.writeBoolean(this.mIsWifiScoringEnabled);
        dest.writeBoolean(this.mIsCellularDataAvailable);
        dest.writeInt(this.mCellularDataNetworkType);
        dest.writeInt(this.mCellularSignalStrengthDbm);
        dest.writeInt(this.mCellularSignalStrengthDb);
        dest.writeBoolean(this.mIsSameRegisteredCell);
    }

    public long getTimeStampMillis() {
        return this.mTimeStampMillis;
    }

    public int getRssi() {
        return this.mRssi;
    }

    public int getLinkSpeedMbps() {
        return this.mLinkSpeedMbps;
    }

    public long getTotalTxSuccess() {
        return this.mTotalTxSuccess;
    }

    public long getTotalTxRetries() {
        return this.mTotalTxRetries;
    }

    public long getTotalTxBad() {
        return this.mTotalTxBad;
    }

    public long getTotalRxSuccess() {
        return this.mTotalRxSuccess;
    }

    public long getTotalRadioOnTimeMillis() {
        return this.mTotalRadioOnTimeMillis;
    }

    public long getTotalRadioTxTimeMillis() {
        return this.mTotalRadioTxTimeMillis;
    }

    public long getTotalRadioRxTimeMillis() {
        return this.mTotalRadioRxTimeMillis;
    }

    public long getTotalScanTimeMillis() {
        return this.mTotalScanTimeMillis;
    }

    public long getTotalNanScanTimeMillis() {
        return this.mTotalNanScanTimeMillis;
    }

    public long getTotalBackgroundScanTimeMillis() {
        return this.mTotalBackgroundScanTimeMillis;
    }

    public long getTotalRoamScanTimeMillis() {
        return this.mTotalRoamScanTimeMillis;
    }

    public long getTotalPnoScanTimeMillis() {
        return this.mTotalPnoScanTimeMillis;
    }

    public long getTotalHotspot2ScanTimeMillis() {
        return this.mTotalHotspot2ScanTimeMillis;
    }

    public long getTotalCcaBusyFreqTimeMillis() {
        return this.mTotalCcaBusyFreqTimeMillis;
    }

    public long getTotalRadioOnFreqTimeMillis() {
        return this.mTotalRadioOnFreqTimeMillis;
    }

    public long getTotalBeaconRx() {
        return this.mTotalBeaconRx;
    }

    public int getProbeStatusSinceLastUpdate() {
        return this.mProbeStatusSinceLastUpdate;
    }

    public int getProbeElapsedTimeSinceLastUpdateMillis() {
        return this.mProbeElapsedTimeSinceLastUpdateMillis;
    }

    public int getProbeMcsRateSinceLastUpdate() {
        return this.mProbeMcsRateSinceLastUpdate;
    }

    public int getRxLinkSpeedMbps() {
        return this.mRxLinkSpeedMbps;
    }

    public int getTimeSliceDutyCycleInPercent() {
        if (this.mTimeSliceDutyCycleInPercent == -1) {
            throw new NoSuchElementException("Unknown value");
        }
        return this.mTimeSliceDutyCycleInPercent;
    }

    public ContentionTimeStats getContentionTimeStats(int ac) {
        if (this.mContentionTimeStats != null && this.mContentionTimeStats.length == 4) {
            return this.mContentionTimeStats[ac];
        }
        Log.e(TAG, "The ContentionTimeStats is not filled out correctly: " + this.mContentionTimeStats);
        return new ContentionTimeStats();
    }

    public List<RateStats> getRateStats() {
        if (this.mRateStats != null) {
            return Arrays.asList(this.mRateStats);
        }
        return Collections.emptyList();
    }

    public List<RadioStats> getWifiLinkLayerRadioStats() {
        if (this.mRadioStats != null) {
            return Arrays.asList(this.mRadioStats);
        }
        return Collections.emptyList();
    }

    public int getChannelUtilizationRatio() {
        return this.mChannelUtilizationRatio;
    }

    public boolean isThroughputSufficient() {
        return this.mIsThroughputSufficient;
    }

    public boolean isWifiScoringEnabled() {
        return this.mIsWifiScoringEnabled;
    }

    public boolean isCellularDataAvailable() {
        return this.mIsCellularDataAvailable;
    }

    public int getCellularDataNetworkType() {
        return this.mCellularDataNetworkType;
    }

    public int getCellularSignalStrengthDbm() {
        return this.mCellularSignalStrengthDbm;
    }

    public int getCellularSignalStrengthDb() {
        return this.mCellularSignalStrengthDb;
    }

    public boolean isSameRegisteredCell() {
        return this.mIsSameRegisteredCell;
    }

    public static class RadioStats
    implements Parcelable {
        private int mRadioId;
        private long mTotalRadioOnTimeMillis;
        private long mTotalRadioTxTimeMillis;
        private long mTotalRadioRxTimeMillis;
        private long mTotalScanTimeMillis;
        private long mTotalNanScanTimeMillis;
        private long mTotalBackgroundScanTimeMillis;
        private long mTotalRoamScanTimeMillis;
        private long mTotalPnoScanTimeMillis;
        private long mTotalHotspot2ScanTimeMillis;
        public static final Parcelable.Creator<RadioStats> CREATOR = new Parcelable.Creator<RadioStats>(){

            @Override
            public RadioStats createFromParcel(Parcel in) {
                RadioStats stats = new RadioStats();
                stats.mRadioId = in.readInt();
                stats.mTotalRadioOnTimeMillis = in.readLong();
                stats.mTotalRadioTxTimeMillis = in.readLong();
                stats.mTotalRadioRxTimeMillis = in.readLong();
                stats.mTotalScanTimeMillis = in.readLong();
                stats.mTotalNanScanTimeMillis = in.readLong();
                stats.mTotalBackgroundScanTimeMillis = in.readLong();
                stats.mTotalRoamScanTimeMillis = in.readLong();
                stats.mTotalPnoScanTimeMillis = in.readLong();
                stats.mTotalHotspot2ScanTimeMillis = in.readLong();
                return stats;
            }

            public RadioStats[] newArray(int size) {
                return new RadioStats[size];
            }
        };

        public RadioStats() {
        }

        public RadioStats(int radioId, long onTime, long txTime, long rxTime, long onTimeScan, long onTimeNanScan, long onTimeBackgroundScan, long onTimeRoamScan, long onTimePnoScan, long onTimeHs20Scan) {
            this.mRadioId = radioId;
            this.mTotalRadioOnTimeMillis = onTime;
            this.mTotalRadioTxTimeMillis = txTime;
            this.mTotalRadioRxTimeMillis = rxTime;
            this.mTotalScanTimeMillis = onTimeScan;
            this.mTotalNanScanTimeMillis = onTimeNanScan;
            this.mTotalBackgroundScanTimeMillis = onTimeBackgroundScan;
            this.mTotalRoamScanTimeMillis = onTimeRoamScan;
            this.mTotalPnoScanTimeMillis = onTimePnoScan;
            this.mTotalHotspot2ScanTimeMillis = onTimeHs20Scan;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mRadioId);
            dest.writeLong(this.mTotalRadioOnTimeMillis);
            dest.writeLong(this.mTotalRadioTxTimeMillis);
            dest.writeLong(this.mTotalRadioRxTimeMillis);
            dest.writeLong(this.mTotalScanTimeMillis);
            dest.writeLong(this.mTotalNanScanTimeMillis);
            dest.writeLong(this.mTotalBackgroundScanTimeMillis);
            dest.writeLong(this.mTotalRoamScanTimeMillis);
            dest.writeLong(this.mTotalPnoScanTimeMillis);
            dest.writeLong(this.mTotalHotspot2ScanTimeMillis);
        }

        public long getRadioId() {
            return this.mRadioId;
        }

        public long getTotalRadioOnTimeMillis() {
            return this.mTotalRadioOnTimeMillis;
        }

        public long getTotalRadioTxTimeMillis() {
            return this.mTotalRadioTxTimeMillis;
        }

        public long getTotalRadioRxTimeMillis() {
            return this.mTotalRadioRxTimeMillis;
        }

        public long getTotalScanTimeMillis() {
            return this.mTotalScanTimeMillis;
        }

        public long getTotalNanScanTimeMillis() {
            return this.mTotalNanScanTimeMillis;
        }

        public long getTotalBackgroundScanTimeMillis() {
            return this.mTotalBackgroundScanTimeMillis;
        }

        public long getTotalRoamScanTimeMillis() {
            return this.mTotalRoamScanTimeMillis;
        }

        public long getTotalPnoScanTimeMillis() {
            return this.mTotalPnoScanTimeMillis;
        }

        public long getTotalHotspot2ScanTimeMillis() {
            return this.mTotalHotspot2ScanTimeMillis;
        }
    }

    public static class RateStats
    implements Parcelable {
        private int mPreamble;
        private int mNss;
        private int mBw;
        private int mRateMcsIdx;
        private int mBitRateInKbps;
        private int mTxMpdu;
        private int mRxMpdu;
        private int mMpduLost;
        private int mRetries;
        public static final Parcelable.Creator<RateStats> CREATOR = new Parcelable.Creator<RateStats>(){

            @Override
            public RateStats createFromParcel(Parcel in) {
                RateStats stats = new RateStats();
                stats.mPreamble = in.readInt();
                stats.mNss = in.readInt();
                stats.mBw = in.readInt();
                stats.mRateMcsIdx = in.readInt();
                stats.mBitRateInKbps = in.readInt();
                stats.mTxMpdu = in.readInt();
                stats.mRxMpdu = in.readInt();
                stats.mMpduLost = in.readInt();
                stats.mRetries = in.readInt();
                return stats;
            }

            public RateStats[] newArray(int size) {
                return new RateStats[size];
            }
        };

        public RateStats() {
        }

        public RateStats(int preamble, int nss, int bw, int rateMcsIdx, int bitRateInKbps, int txMpdu, int rxMpdu, int mpduLost, int retries) {
            this.mPreamble = preamble;
            this.mNss = nss;
            this.mBw = bw;
            this.mRateMcsIdx = rateMcsIdx;
            this.mBitRateInKbps = bitRateInKbps;
            this.mTxMpdu = txMpdu;
            this.mRxMpdu = rxMpdu;
            this.mMpduLost = mpduLost;
            this.mRetries = retries;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mPreamble);
            dest.writeInt(this.mNss);
            dest.writeInt(this.mBw);
            dest.writeInt(this.mRateMcsIdx);
            dest.writeInt(this.mBitRateInKbps);
            dest.writeInt(this.mTxMpdu);
            dest.writeInt(this.mRxMpdu);
            dest.writeInt(this.mMpduLost);
            dest.writeInt(this.mRetries);
        }

        public int getPreamble() {
            return this.mPreamble;
        }

        public int getNumberOfSpatialStreams() {
            return this.mNss;
        }

        public int getBandwidthInMhz() {
            return this.mBw;
        }

        public int getRateMcsIdx() {
            return this.mRateMcsIdx;
        }

        public int getBitRateInKbps() {
            return this.mBitRateInKbps;
        }

        public int getTxMpdu() {
            return this.mTxMpdu;
        }

        public int getRxMpdu() {
            return this.mRxMpdu;
        }

        public int getMpduLost() {
            return this.mMpduLost;
        }

        public int getRetries() {
            return this.mRetries;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WifiChannelBandwidth {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WifiSpatialStreams {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WifiPreambleType {
    }

    public static class ContentionTimeStats
    implements Parcelable {
        private long mContentionTimeMinMicros;
        private long mContentionTimeMaxMicros;
        private long mContentionTimeAvgMicros;
        private long mContentionNumSamples;
        public static final Parcelable.Creator<ContentionTimeStats> CREATOR = new Parcelable.Creator<ContentionTimeStats>(){

            @Override
            public ContentionTimeStats createFromParcel(Parcel in) {
                ContentionTimeStats stats = new ContentionTimeStats();
                stats.mContentionTimeMinMicros = in.readLong();
                stats.mContentionTimeMaxMicros = in.readLong();
                stats.mContentionTimeAvgMicros = in.readLong();
                stats.mContentionNumSamples = in.readLong();
                return stats;
            }

            public ContentionTimeStats[] newArray(int size) {
                return new ContentionTimeStats[size];
            }
        };

        public ContentionTimeStats() {
        }

        public ContentionTimeStats(long timeMin, long timeMax, long timeAvg, long numSamples) {
            this.mContentionTimeMinMicros = timeMin;
            this.mContentionTimeMaxMicros = timeMax;
            this.mContentionTimeAvgMicros = timeAvg;
            this.mContentionNumSamples = numSamples;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeLong(this.mContentionTimeMinMicros);
            dest.writeLong(this.mContentionTimeMaxMicros);
            dest.writeLong(this.mContentionTimeAvgMicros);
            dest.writeLong(this.mContentionNumSamples);
        }

        public long getContentionTimeMinMicros() {
            return this.mContentionTimeMinMicros;
        }

        public long getContentionTimeMaxMicros() {
            return this.mContentionTimeMaxMicros;
        }

        public long getContentionTimeAvgMicros() {
            return this.mContentionTimeAvgMicros;
        }

        public long getContentionNumSamples() {
            return this.mContentionNumSamples;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WmeAccessCategory {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProbeStatus {
    }
}

