/*
 * Decompiled with CFR 0.152.
 */
package android.net.ipsec.ike;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.eap.EapSessionConfig;
import android.net.ipsec.ike.IkeIdentification;
import android.net.ipsec.ike.IkeSaProposal;
import android.net.ipsec.ike.ike3gpp.Ike3gppExtension;
import android.os.PersistableBundle;
import android.system.OsConstants;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.net.ipsec.ike.message.IkeConfigPayload;
import com.android.internal.net.ipsec.ike.utils.IkeCertUtils;
import com.android.internal.net.utils.build.SdkLevel;
import com.android.internal.net.vcn.util.PersistableBundleUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class IkeSessionParams {
    public static final int IKE_AUTH_METHOD_PSK = 1;
    public static final int IKE_AUTH_METHOD_PUB_KEY_SIGNATURE = 2;
    public static final int IKE_AUTH_METHOD_EAP = 3;
    public static final int AUTH_DIRECTION_LOCAL = 1;
    public static final int AUTH_DIRECTION_REMOTE = 2;
    public static final int AUTH_DIRECTION_BOTH = 3;
    public static final int IKE_OPTION_ACCEPT_ANY_REMOTE_ID = 0;
    public static final int IKE_OPTION_EAP_ONLY_AUTH = 1;
    public static final int IKE_OPTION_MOBIKE = 2;
    public static final int IKE_OPTION_FORCE_PORT_4500 = 3;
    public static final int IKE_OPTION_INITIAL_CONTACT = 4;
    @SystemApi
    public static final int IKE_OPTION_REKEY_MOBILITY = 5;
    private static final int MIN_IKE_OPTION = 0;
    private static final int MAX_IKE_OPTION = 5;
    @VisibleForTesting
    static final int IKE_HARD_LIFETIME_SEC_MINIMUM = 300;
    @VisibleForTesting
    static final int IKE_HARD_LIFETIME_SEC_MAXIMUM = 86400;
    @VisibleForTesting
    static final int IKE_HARD_LIFETIME_SEC_DEFAULT = 14400;
    @VisibleForTesting
    static final int IKE_SOFT_LIFETIME_SEC_MINIMUM = 120;
    @VisibleForTesting
    static final int IKE_SOFT_LIFETIME_SEC_DEFAULT = 7200;
    @VisibleForTesting
    static final int IKE_LIFETIME_MARGIN_SEC_MINIMUM = (int)TimeUnit.MINUTES.toSeconds(1L);
    @VisibleForTesting
    static final int IKE_DPD_DELAY_SEC_MIN = 20;
    @VisibleForTesting
    static final int IKE_DPD_DELAY_SEC_MAX = 1800;
    @VisibleForTesting
    static final int IKE_DPD_DELAY_SEC_DEFAULT = 120;
    @VisibleForTesting
    static final int IKE_NATT_KEEPALIVE_DELAY_SEC_MIN = 10;
    @VisibleForTesting
    static final int IKE_NATT_KEEPALIVE_DELAY_SEC_MAX = 3600;
    @VisibleForTesting
    static final int IKE_NATT_KEEPALIVE_DELAY_SEC_DEFAULT = 10;
    @VisibleForTesting
    static final int DSCP_MIN = 0;
    @VisibleForTesting
    static final int DSCP_MAX = 63;
    @VisibleForTesting
    static final int DSCP_DEFAULT = 0;
    @VisibleForTesting
    static final int IKE_RETRANS_TIMEOUT_MS_MIN = 500;
    @VisibleForTesting
    static final int IKE_RETRANS_TIMEOUT_MS_MAX = (int)TimeUnit.MINUTES.toMillis(30L);
    @VisibleForTesting
    static final int IKE_RETRANS_MAX_ATTEMPTS_MAX = 10;
    @VisibleForTesting
    static final int[] IKE_RETRANS_TIMEOUT_MS_LIST_DEFAULT = new int[]{500, 1000, 2000, 4000, 8000};
    private static final String SERVER_HOST_NAME_KEY = "mServerHostname";
    private static final String SA_PROPOSALS_KEY = "mSaProposals";
    private static final String LOCAL_ID_KEY = "mLocalIdentification";
    private static final String REMOTE_ID_KEY = "mRemoteIdentification";
    private static final String LOCAL_AUTH_KEY = "mLocalAuthConfig";
    private static final String REMOTE_AUTH_KEY = "mRemoteAuthConfig";
    private static final String CONFIG_ATTRIBUTES_KEY = "mConfigRequests";
    private static final String RETRANS_TIMEOUTS_KEY = "mRetransTimeoutMsList";
    private static final String IKE_OPTIONS_KEY = "mIkeOptions";
    private static final String HARD_LIFETIME_SEC_KEY = "mHardLifetimeSec";
    private static final String SOFT_LIFETIME_SEC_KEY = "mSoftLifetimeSec";
    private static final String DPD_DELAY_SEC_KEY = "mDpdDelaySec";
    private static final String NATT_KEEPALIVE_DELAY_SEC_KEY = "mNattKeepaliveDelaySec";
    private static final String DSCP_KEY = "mDscp";
    private static final String IS_IKE_FRAGMENT_SUPPORTED_KEY = "mIsIkeFragmentationSupported";
    private final String mServerHostname;
    private final Network mDefaultOrConfiguredNetwork;
    private final Network mCallerConfiguredNetwork;
    private final IkeSaProposal[] mSaProposals;
    private final IkeIdentification mLocalIdentification;
    private final IkeIdentification mRemoteIdentification;
    private final IkeAuthConfig mLocalAuthConfig;
    private final IkeAuthConfig mRemoteAuthConfig;
    private final IkeConfigPayload.IkeConfigAttribute[] mConfigRequests;
    private final int[] mRetransTimeoutMsList;
    private final Ike3gppExtension mIke3gppExtension;
    private final long mIkeOptions;
    private final int mHardLifetimeSec;
    private final int mSoftLifetimeSec;
    private final int mDpdDelaySec;
    private final int mNattKeepaliveDelaySec;
    private final int mDscp;
    private final boolean mIsIkeFragmentationSupported;

    private IkeSessionParams(String serverHostname, Network defaultOrConfiguredNetwork, Network callerConfiguredNetwork, IkeSaProposal[] proposals, IkeIdentification localIdentification, IkeIdentification remoteIdentification, IkeAuthConfig localAuthConfig, IkeAuthConfig remoteAuthConfig, IkeConfigPayload.IkeConfigAttribute[] configRequests, int[] retransTimeoutMsList, Ike3gppExtension ike3gppExtension, long ikeOptions, int hardLifetimeSec, int softLifetimeSec, int dpdDelaySec, int nattKeepaliveDelaySec, int dscp, boolean isIkeFragmentationSupported) {
        this.mServerHostname = serverHostname;
        this.mDefaultOrConfiguredNetwork = defaultOrConfiguredNetwork;
        this.mCallerConfiguredNetwork = callerConfiguredNetwork;
        this.mSaProposals = proposals;
        this.mLocalIdentification = localIdentification;
        this.mRemoteIdentification = remoteIdentification;
        this.mLocalAuthConfig = localAuthConfig;
        this.mRemoteAuthConfig = remoteAuthConfig;
        this.mConfigRequests = configRequests;
        this.mRetransTimeoutMsList = retransTimeoutMsList;
        this.mIke3gppExtension = ike3gppExtension;
        this.mIkeOptions = ikeOptions;
        this.mHardLifetimeSec = hardLifetimeSec;
        this.mSoftLifetimeSec = softLifetimeSec;
        this.mDpdDelaySec = dpdDelaySec;
        this.mNattKeepaliveDelaySec = nattKeepaliveDelaySec;
        this.mDscp = dscp;
        this.mIsIkeFragmentationSupported = isIkeFragmentationSupported;
    }

    private static void validateIkeOptionOrThrow(int ikeOption) {
        if (ikeOption < 0 || ikeOption > 5) {
            throw new IllegalArgumentException("Invalid IKE Option: " + ikeOption);
        }
    }

    private static long getOptionBitValue(int ikeOption) {
        return 1 << ikeOption;
    }

    public static IkeSessionParams fromPersistableBundle(PersistableBundle in) {
        Objects.requireNonNull(in, "PersistableBundle is null");
        Builder builder = new Builder();
        builder.setServerHostname(in.getString(SERVER_HOST_NAME_KEY));
        PersistableBundle proposalBundle = in.getPersistableBundle(SA_PROPOSALS_KEY);
        Objects.requireNonNull(in, "SA Proposals is null");
        List<IkeSaProposal> saProposals = PersistableBundleUtils.toList(proposalBundle, IkeSaProposal::fromPersistableBundle);
        for (IkeSaProposal proposal : saProposals) {
            builder.addSaProposal(proposal);
        }
        builder.setLocalIdentification(IkeIdentification.fromPersistableBundle(in.getPersistableBundle(LOCAL_ID_KEY)));
        builder.setRemoteIdentification(IkeIdentification.fromPersistableBundle(in.getPersistableBundle(REMOTE_ID_KEY)));
        builder.setAuth(IkeAuthConfig.fromPersistableBundle(in.getPersistableBundle(LOCAL_AUTH_KEY)), IkeAuthConfig.fromPersistableBundle(in.getPersistableBundle(REMOTE_AUTH_KEY)));
        PersistableBundle configBundle = in.getPersistableBundle(CONFIG_ATTRIBUTES_KEY);
        Objects.requireNonNull(configBundle, "configBundle is null");
        List<IkeConfigPayload.ConfigAttribute> configList = PersistableBundleUtils.toList(configBundle, IkeConfigPayload.ConfigAttribute::fromPersistableBundle);
        for (IkeConfigPayload.ConfigAttribute configAttribute : configList) {
            builder.addConfigRequest((IkeConfigPayload.IkeConfigAttribute)configAttribute);
        }
        builder.setRetransmissionTimeoutsMillis(in.getIntArray(RETRANS_TIMEOUTS_KEY));
        long ikeOptions = in.getLong(IKE_OPTIONS_KEY);
        for (int option = 0; option <= 5; ++option) {
            if (IkeSessionParams.hasIkeOption(ikeOptions, option)) {
                builder.addIkeOptionInternal(option);
                continue;
            }
            builder.removeIkeOption(option);
        }
        builder.setLifetimeSeconds(in.getInt(HARD_LIFETIME_SEC_KEY), in.getInt(SOFT_LIFETIME_SEC_KEY));
        builder.setDpdDelaySeconds(in.getInt(DPD_DELAY_SEC_KEY));
        builder.setNattKeepAliveDelaySeconds(in.getInt(NATT_KEEPALIVE_DELAY_SEC_KEY));
        if (!in.getBoolean(IS_IKE_FRAGMENT_SUPPORTED_KEY)) {
            throw new IllegalArgumentException("Invalid fragmentation policy");
        }
        return builder.build();
    }

    public PersistableBundle toPersistableBundle() {
        if (this.mCallerConfiguredNetwork != null || this.mIke3gppExtension != null) {
            throw new IllegalStateException("Cannot convert a IkeSessionParams with a caller configured network or with 3GPP extension enabled");
        }
        PersistableBundle result = new PersistableBundle();
        result.putString(SERVER_HOST_NAME_KEY, this.mServerHostname);
        PersistableBundle saProposalBundle = PersistableBundleUtils.fromList(Arrays.asList(this.mSaProposals), IkeSaProposal::toPersistableBundle);
        result.putPersistableBundle(SA_PROPOSALS_KEY, saProposalBundle);
        result.putPersistableBundle(LOCAL_ID_KEY, this.mLocalIdentification.toPersistableBundle());
        result.putPersistableBundle(REMOTE_ID_KEY, this.mRemoteIdentification.toPersistableBundle());
        result.putPersistableBundle(LOCAL_AUTH_KEY, this.mLocalAuthConfig.toPersistableBundle());
        result.putPersistableBundle(REMOTE_AUTH_KEY, this.mRemoteAuthConfig.toPersistableBundle());
        PersistableBundle configAttributeBundle = PersistableBundleUtils.fromList(Arrays.asList(this.mConfigRequests), IkeConfigPayload.ConfigAttribute::toPersistableBundle);
        result.putPersistableBundle(CONFIG_ATTRIBUTES_KEY, configAttributeBundle);
        result.putIntArray(RETRANS_TIMEOUTS_KEY, this.mRetransTimeoutMsList);
        result.putLong(IKE_OPTIONS_KEY, this.mIkeOptions);
        result.putInt(HARD_LIFETIME_SEC_KEY, this.mHardLifetimeSec);
        result.putInt(SOFT_LIFETIME_SEC_KEY, this.mSoftLifetimeSec);
        result.putInt(DPD_DELAY_SEC_KEY, this.mDpdDelaySec);
        result.putInt(NATT_KEEPALIVE_DELAY_SEC_KEY, this.mNattKeepaliveDelaySec);
        result.putInt(DSCP_KEY, this.mDscp);
        result.putBoolean(IS_IKE_FRAGMENT_SUPPORTED_KEY, this.mIsIkeFragmentationSupported);
        return result;
    }

    public String getServerHostname() {
        return this.mServerHostname;
    }

    public Network getConfiguredNetwork() {
        return this.mCallerConfiguredNetwork;
    }

    public Network getNetwork() {
        return this.mDefaultOrConfiguredNetwork;
    }

    @Deprecated
    @SystemApi
    public List<IkeSaProposal> getSaProposals() {
        return this.getIkeSaProposals();
    }

    public List<IkeSaProposal> getIkeSaProposals() {
        return Arrays.asList(this.mSaProposals);
    }

    public IkeSaProposal[] getSaProposalsInternal() {
        return this.mSaProposals;
    }

    public IkeIdentification getLocalIdentification() {
        return this.mLocalIdentification;
    }

    public IkeIdentification getRemoteIdentification() {
        return this.mRemoteIdentification;
    }

    public IkeAuthConfig getLocalAuthConfig() {
        return this.mLocalAuthConfig;
    }

    public IkeAuthConfig getRemoteAuthConfig() {
        return this.mRemoteAuthConfig;
    }

    @SuppressLint(value={"MethodNameUnits"})
    public int getHardLifetimeSeconds() {
        return this.mHardLifetimeSec;
    }

    @SuppressLint(value={"MethodNameUnits"})
    public int getSoftLifetimeSeconds() {
        return this.mSoftLifetimeSec;
    }

    @SuppressLint(value={"MethodNameUnits"})
    public int getDpdDelaySeconds() {
        return this.mDpdDelaySec;
    }

    @SuppressLint(value={"MethodNameUnits"})
    public int getNattKeepAliveDelaySeconds() {
        return this.mNattKeepaliveDelaySec;
    }

    @SystemApi
    public int getDscp() {
        return this.mDscp;
    }

    public int[] getRetransmissionTimeoutsMillis() {
        return this.mRetransTimeoutMsList;
    }

    @SystemApi
    public Ike3gppExtension getIke3gppExtension() {
        return this.mIke3gppExtension;
    }

    private static boolean hasIkeOption(long ikeOptionsRecord, int ikeOption) {
        IkeSessionParams.validateIkeOptionOrThrow(ikeOption);
        return (ikeOptionsRecord & IkeSessionParams.getOptionBitValue(ikeOption)) != 0L;
    }

    public boolean hasIkeOption(int ikeOption) {
        return IkeSessionParams.hasIkeOption(this.mIkeOptions, ikeOption);
    }

    public long getHardLifetimeMsInternal() {
        return TimeUnit.SECONDS.toMillis(this.mHardLifetimeSec);
    }

    public long getSoftLifetimeMsInternal() {
        return TimeUnit.SECONDS.toMillis(this.mSoftLifetimeSec);
    }

    public boolean isIkeFragmentationSupported() {
        return this.mIsIkeFragmentationSupported;
    }

    public IkeConfigPayload.IkeConfigAttribute[] getConfigurationAttributesInternal() {
        return this.mConfigRequests;
    }

    @SystemApi
    public List<IkeConfigRequest> getConfigurationRequests() {
        return Collections.unmodifiableList(Arrays.asList(this.mConfigRequests));
    }

    public int hashCode() {
        return Objects.hash(this.mServerHostname, this.mCallerConfiguredNetwork, Arrays.hashCode(this.mSaProposals), this.mLocalIdentification, this.mRemoteIdentification, this.mLocalAuthConfig, this.mRemoteAuthConfig, this.mIke3gppExtension, Arrays.hashCode(this.mConfigRequests), Arrays.hashCode(this.mRetransTimeoutMsList), this.mIkeOptions, this.mHardLifetimeSec, this.mSoftLifetimeSec, this.mDpdDelaySec, this.mNattKeepaliveDelaySec, this.mDscp, this.mIsIkeFragmentationSupported);
    }

    public boolean equals(Object o) {
        if (!(o instanceof IkeSessionParams)) {
            return false;
        }
        IkeSessionParams other = (IkeSessionParams)o;
        return this.mServerHostname.equals(other.mServerHostname) && Objects.equals(this.mCallerConfiguredNetwork, other.mCallerConfiguredNetwork) && Arrays.equals(this.mSaProposals, other.mSaProposals) && this.mLocalIdentification.equals(other.mLocalIdentification) && this.mRemoteIdentification.equals(other.mRemoteIdentification) && this.mLocalAuthConfig.equals(other.mLocalAuthConfig) && this.mRemoteAuthConfig.equals(other.mRemoteAuthConfig) && Objects.equals(this.mIke3gppExtension, other.mIke3gppExtension) && Arrays.equals(this.mConfigRequests, other.mConfigRequests) && Arrays.equals(this.mRetransTimeoutMsList, other.mRetransTimeoutMsList) && this.mIkeOptions == other.mIkeOptions && this.mHardLifetimeSec == other.mHardLifetimeSec && this.mSoftLifetimeSec == other.mSoftLifetimeSec && this.mDpdDelaySec == other.mDpdDelaySec && this.mNattKeepaliveDelaySec == other.mNattKeepaliveDelaySec && this.mDscp == other.mDscp && this.mIsIkeFragmentationSupported == other.mIsIkeFragmentationSupported;
    }

    public static class Builder {
        private ConnectivityManager mConnectivityManager;
        private final List<IkeSaProposal> mSaProposalList = new LinkedList<IkeSaProposal>();
        private final List<IkeConfigPayload.IkeConfigAttribute> mConfigRequestList = new ArrayList<IkeConfigPayload.IkeConfigAttribute>();
        private int[] mRetransTimeoutMsList = Arrays.copyOf(IKE_RETRANS_TIMEOUT_MS_LIST_DEFAULT, IKE_RETRANS_TIMEOUT_MS_LIST_DEFAULT.length);
        private String mServerHostname;
        private Network mCallerConfiguredNetwork;
        private IkeIdentification mLocalIdentification;
        private IkeIdentification mRemoteIdentification;
        private IkeAuthConfig mLocalAuthConfig;
        private IkeAuthConfig mRemoteAuthConfig;
        private Ike3gppExtension mIke3gppExtension;
        private long mIkeOptions = 0L;
        private int mHardLifetimeSec = 14400;
        private int mSoftLifetimeSec = 7200;
        private int mDpdDelaySec = 120;
        private int mNattKeepaliveDelaySec = 10;
        private int mDscp = 0;
        private final boolean mIsIkeFragmentationSupported = true;

        @Deprecated
        @SystemApi
        public Builder(Context context) {
            this((ConnectivityManager)context.getSystemService("connectivity"));
        }

        public Builder() {
        }

        @VisibleForTesting
        public Builder(ConnectivityManager connectManager) {
            this.mConnectivityManager = connectManager;
        }

        public Builder(IkeSessionParams ikeSessionParams) {
            this.mSaProposalList.addAll(ikeSessionParams.getSaProposals());
            this.mConfigRequestList.addAll(Arrays.asList(ikeSessionParams.mConfigRequests));
            int[] retransmissionTimeouts = ikeSessionParams.getRetransmissionTimeoutsMillis();
            this.mRetransTimeoutMsList = Arrays.copyOf(retransmissionTimeouts, retransmissionTimeouts.length);
            this.mServerHostname = ikeSessionParams.getServerHostname();
            this.mCallerConfiguredNetwork = ikeSessionParams.getConfiguredNetwork();
            this.mLocalIdentification = ikeSessionParams.getLocalIdentification();
            this.mRemoteIdentification = ikeSessionParams.getRemoteIdentification();
            this.mLocalAuthConfig = ikeSessionParams.getLocalAuthConfig();
            this.mRemoteAuthConfig = ikeSessionParams.getRemoteAuthConfig();
            this.mIke3gppExtension = ikeSessionParams.getIke3gppExtension();
            this.mHardLifetimeSec = ikeSessionParams.getHardLifetimeSeconds();
            this.mSoftLifetimeSec = ikeSessionParams.getSoftLifetimeSeconds();
            this.mDpdDelaySec = ikeSessionParams.getDpdDelaySeconds();
            this.mNattKeepaliveDelaySec = ikeSessionParams.getNattKeepAliveDelaySeconds();
            this.mDscp = ikeSessionParams.getDscp();
            this.mIkeOptions = ikeSessionParams.mIkeOptions;
            if (!ikeSessionParams.mIsIkeFragmentationSupported) {
                throw new IllegalStateException("mIsIkeFragmentationSupported should never be false");
            }
        }

        public Builder setServerHostname(String serverHostname) {
            Objects.requireNonNull(serverHostname, "Required argument not provided");
            this.mServerHostname = serverHostname;
            return this;
        }

        public Builder setNetwork(Network network) {
            this.mCallerConfiguredNetwork = network;
            return this;
        }

        public Builder setLocalIdentification(IkeIdentification identification) {
            if (identification == null) {
                throw new NullPointerException("Required argument not provided");
            }
            this.mLocalIdentification = identification;
            return this;
        }

        public Builder setRemoteIdentification(IkeIdentification identification) {
            if (identification == null) {
                throw new NullPointerException("Required argument not provided");
            }
            this.mRemoteIdentification = identification;
            return this;
        }

        @Deprecated
        @SystemApi
        public Builder addSaProposal(IkeSaProposal proposal) {
            return this.addIkeSaProposal(proposal);
        }

        public Builder addIkeSaProposal(IkeSaProposal proposal) {
            if (proposal == null) {
                throw new NullPointerException("Required argument not provided");
            }
            if (proposal.getProtocolId() != 1) {
                throw new IllegalArgumentException("Expected IKE SA Proposal but received Child SA proposal");
            }
            this.mSaProposalList.add(proposal);
            return this;
        }

        private Builder setAuth(IkeAuthConfig local, IkeAuthConfig remote) {
            this.mLocalAuthConfig = local;
            this.mRemoteAuthConfig = remote;
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setAuthPsk(byte[] sharedKey) {
            if (sharedKey == null) {
                throw new NullPointerException("Required argument not provided");
            }
            return this.setAuth(new IkeAuthPskConfig(sharedKey), new IkeAuthPskConfig(sharedKey));
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setAuthEap(X509Certificate serverCaCert, EapSessionConfig eapConfig) {
            if (eapConfig == null) {
                throw new NullPointerException("Required argument not provided");
            }
            return this.setAuth(new IkeAuthEapConfig(eapConfig), new IkeAuthDigitalSignRemoteConfig(serverCaCert));
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setAuthDigitalSignature(X509Certificate serverCaCert, X509Certificate clientEndCert, PrivateKey clientPrivateKey) {
            return this.setAuthDigitalSignature(serverCaCert, clientEndCert, new LinkedList<X509Certificate>(), clientPrivateKey);
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setAuthDigitalSignature(X509Certificate serverCaCert, X509Certificate clientEndCert, List<X509Certificate> clientIntermediateCerts, PrivateKey clientPrivateKey) {
            if (clientEndCert == null || clientIntermediateCerts == null || clientPrivateKey == null) {
                throw new NullPointerException("Required argument not provided");
            }
            if (!(clientPrivateKey instanceof RSAKey)) {
                throw new IllegalArgumentException("Unsupported private key type");
            }
            IkeAuthDigitalSignLocalConfig localConfig = new IkeAuthDigitalSignLocalConfig(clientEndCert, clientIntermediateCerts, clientPrivateKey);
            IkeAuthDigitalSignRemoteConfig remoteConfig = new IkeAuthDigitalSignRemoteConfig(serverCaCert);
            return this.setAuth(localConfig, remoteConfig);
        }

        private Builder addConfigRequest(IkeConfigPayload.IkeConfigAttribute configReq) {
            this.mConfigRequestList.add(configReq);
            return this;
        }

        @SystemApi
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder addPcscfServerRequest(InetAddress address) {
            if (address == null) {
                throw new NullPointerException("Required argument not provided");
            }
            if (address instanceof Inet4Address) {
                return this.addConfigRequest(new IkeConfigPayload.ConfigAttributeIpv4Pcscf((Inet4Address)address));
            }
            if (address instanceof Inet6Address) {
                return this.addConfigRequest(new IkeConfigPayload.ConfigAttributeIpv6Pcscf((Inet6Address)address));
            }
            throw new IllegalArgumentException("Invalid address family");
        }

        @SystemApi
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder addPcscfServerRequest(int addressFamily) {
            if (addressFamily == OsConstants.AF_INET) {
                return this.addConfigRequest(new IkeConfigPayload.ConfigAttributeIpv4Pcscf());
            }
            if (addressFamily == OsConstants.AF_INET6) {
                return this.addConfigRequest(new IkeConfigPayload.ConfigAttributeIpv6Pcscf());
            }
            throw new IllegalArgumentException("Invalid address family: " + addressFamily);
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setLifetimeSeconds(int hardLifetimeSeconds, int softLifetimeSeconds) {
            if (hardLifetimeSeconds < 300 || hardLifetimeSeconds > 86400 || softLifetimeSeconds < 120 || hardLifetimeSeconds - softLifetimeSeconds < IKE_LIFETIME_MARGIN_SEC_MINIMUM) {
                throw new IllegalArgumentException("Invalid lifetime value");
            }
            this.mHardLifetimeSec = hardLifetimeSeconds;
            this.mSoftLifetimeSec = softLifetimeSeconds;
            return this;
        }

        public Builder setDpdDelaySeconds(int dpdDelaySeconds) {
            if (dpdDelaySeconds < 20 || dpdDelaySeconds > 1800) {
                throw new IllegalArgumentException("Invalid DPD delay value");
            }
            this.mDpdDelaySec = dpdDelaySeconds;
            return this;
        }

        public Builder setNattKeepAliveDelaySeconds(int nattKeepaliveDelaySeconds) {
            if (nattKeepaliveDelaySeconds < 10 || nattKeepaliveDelaySeconds > 3600) {
                throw new IllegalArgumentException("Invalid NATT keepalive delay value");
            }
            this.mNattKeepaliveDelaySec = nattKeepaliveDelaySeconds;
            return this;
        }

        @SystemApi
        public Builder setDscp(int dscp) {
            if (dscp < 0 || dscp > 63) {
                throw new IllegalArgumentException("Invalid DSCP value");
            }
            this.mDscp = dscp;
            return this;
        }

        public Builder setRetransmissionTimeoutsMillis(int[] retransTimeoutMillisList) {
            boolean isValid = true;
            if (retransTimeoutMillisList == null || retransTimeoutMillisList.length == 0 || retransTimeoutMillisList.length > 10) {
                isValid = false;
            }
            for (int t : retransTimeoutMillisList) {
                if (t >= 500 && t <= IKE_RETRANS_TIMEOUT_MS_MAX) continue;
                isValid = false;
            }
            if (!isValid) {
                throw new IllegalArgumentException("Invalid retransmission timeout list");
            }
            this.mRetransTimeoutMsList = retransTimeoutMillisList;
            return this;
        }

        @SystemApi
        public Builder setIke3gppExtension(Ike3gppExtension ike3gppExtension) {
            Objects.requireNonNull(ike3gppExtension, "ike3gppExtension must not be null");
            this.mIke3gppExtension = ike3gppExtension;
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder addIkeOption(int ikeOption) {
            return this.addIkeOptionInternal(ikeOption);
        }

        public Builder addIkeOptionInternal(int ikeOption) {
            IkeSessionParams.validateIkeOptionOrThrow(ikeOption);
            if (ikeOption == 2 || ikeOption == 5) {
                if (!SdkLevel.isAtLeastS()) {
                    throw new UnsupportedOperationException("Mobility only supported for S/S+");
                }
                if (!SdkLevel.isAtLeastT() && ikeOption == 2) {
                    this.mIkeOptions |= IkeSessionParams.getOptionBitValue(5);
                }
            }
            this.mIkeOptions |= IkeSessionParams.getOptionBitValue(ikeOption);
            return this;
        }

        @SuppressLint(value={"BuilderSetStyle"})
        public Builder removeIkeOption(int ikeOption) {
            IkeSessionParams.validateIkeOptionOrThrow(ikeOption);
            this.mIkeOptions &= IkeSessionParams.getOptionBitValue(ikeOption) ^ 0xFFFFFFFFFFFFFFFFL;
            return this;
        }

        public IkeSessionParams build() {
            if (this.mSaProposalList.isEmpty()) {
                throw new IllegalArgumentException("IKE SA proposal not found");
            }
            Network defaultOrConfiguredNetwork = this.mCallerConfiguredNetwork;
            if (this.mConnectivityManager != null && defaultOrConfiguredNetwork == null && (defaultOrConfiguredNetwork = this.mConnectivityManager.getActiveNetwork()) == null) {
                throw new IllegalArgumentException("Network not found");
            }
            if (this.mServerHostname == null || this.mLocalIdentification == null || this.mRemoteIdentification == null || this.mLocalAuthConfig == null || this.mRemoteAuthConfig == null) {
                throw new IllegalArgumentException("Necessary parameter missing.");
            }
            if ((this.mIkeOptions & IkeSessionParams.getOptionBitValue(1)) != 0L) {
                if (!(this.mLocalAuthConfig instanceof IkeAuthEapConfig)) {
                    throw new IllegalArgumentException("If IKE_OPTION_EAP_ONLY_AUTH is set, eap authentication needs to be configured.");
                }
                IkeAuthEapConfig ikeAuthEapConfig = (IkeAuthEapConfig)this.mLocalAuthConfig;
                if (!ikeAuthEapConfig.getEapConfig().areAllMethodsEapOnlySafe()) {
                    throw new IllegalArgumentException("Only EAP-only safe method allowed when using EAP-only option.");
                }
            }
            if (!(this.mIke3gppExtension == null || this.mIke3gppExtension.getIke3gppParams().getMobileDeviceIdentity() == null || this.mLocalAuthConfig instanceof IkeAuthEapConfig && ((IkeAuthEapConfig)this.mLocalAuthConfig).getEapConfig().getEapAkaConfig() != null)) {
                throw new IllegalArgumentException("If device identity is set in Ike3gppParams, then EAP-KA MUST be configured as an acceptable authentication method");
            }
            if (this.mLocalAuthConfig.mAuthMethod == 2 && this.mLocalIdentification.idType == 11) {
                throw new IllegalArgumentException("It is not allowed to use KEY_ID as local ID when local authentication method is digital-signature-based");
            }
            return new IkeSessionParams(this.mServerHostname, defaultOrConfiguredNetwork, this.mCallerConfiguredNetwork, this.mSaProposalList.toArray(new IkeSaProposal[0]), this.mLocalIdentification, this.mRemoteIdentification, this.mLocalAuthConfig, this.mRemoteAuthConfig, this.mConfigRequestList.toArray(new IkeConfigPayload.IkeConfigAttribute[0]), this.mRetransTimeoutMsList, this.mIke3gppExtension, this.mIkeOptions, this.mHardLifetimeSec, this.mSoftLifetimeSec, this.mDpdDelaySec, this.mNattKeepaliveDelaySec, this.mDscp, true);
        }
    }

    public static class IkeAuthEapConfig
    extends IkeAuthConfig {
        private static final String EAP_CONFIG_KEY = "mEapConfig";
        public final EapSessionConfig mEapConfig;

        @VisibleForTesting
        IkeAuthEapConfig(EapSessionConfig eapConfig) {
            super(3, 1);
            this.mEapConfig = eapConfig;
        }

        public static IkeAuthEapConfig fromPersistableBundle(PersistableBundle in) {
            Objects.requireNonNull(in, "PersistableBundle null");
            PersistableBundle eapBundle = in.getPersistableBundle(EAP_CONFIG_KEY);
            Objects.requireNonNull(in, "EAP Config bundle is null");
            EapSessionConfig eapConfig = EapSessionConfig.fromPersistableBundle(eapBundle);
            Objects.requireNonNull(eapConfig, "EAP Config is null");
            return new IkeAuthEapConfig(eapConfig);
        }

        @Override
        public PersistableBundle toPersistableBundle() {
            PersistableBundle result = super.toPersistableBundle();
            result.putPersistableBundle(EAP_CONFIG_KEY, this.mEapConfig.toPersistableBundle());
            return result;
        }

        public EapSessionConfig getEapConfig() {
            return this.mEapConfig;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.mEapConfig);
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o) || !(o instanceof IkeAuthEapConfig)) {
                return false;
            }
            return this.mEapConfig.equals(((IkeAuthEapConfig)o).mEapConfig);
        }
    }

    public static class IkeAuthDigitalSignLocalConfig
    extends IkeAuthConfig {
        private static final String END_CERT_KEY = "mEndCert";
        private static final String INTERMEDIATE_CERTS_KEY = "mIntermediateCerts";
        private static final String PRIVATE_KEY_KEY = "mPrivateKey";
        public final X509Certificate mEndCert;
        public final List<X509Certificate> mIntermediateCerts;
        public final PrivateKey mPrivateKey;

        @VisibleForTesting
        IkeAuthDigitalSignLocalConfig(X509Certificate clientEndCert, List<X509Certificate> clientIntermediateCerts, PrivateKey privateKey) {
            super(2, 1);
            this.mEndCert = clientEndCert;
            this.mIntermediateCerts = clientIntermediateCerts;
            this.mPrivateKey = privateKey;
        }

        public static IkeAuthDigitalSignLocalConfig fromPersistableBundle(PersistableBundle in) {
            Objects.requireNonNull(in, "PersistableBundle is null");
            PersistableBundle endCertBundle = in.getPersistableBundle(END_CERT_KEY);
            Objects.requireNonNull(endCertBundle, "End cert not provided");
            byte[] encodedCert = PersistableBundleUtils.toByteArray(endCertBundle);
            X509Certificate endCert = IkeCertUtils.certificateFromByteArray(encodedCert);
            PersistableBundle certsBundle = in.getPersistableBundle(INTERMEDIATE_CERTS_KEY);
            Objects.requireNonNull(certsBundle, "Intermediate certs not provided");
            List<byte[]> encodedCertList = PersistableBundleUtils.toList(certsBundle, PersistableBundleUtils::toByteArray);
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>(encodedCertList.size());
            for (byte[] encoded : encodedCertList) {
                certList.add(IkeCertUtils.certificateFromByteArray(encoded));
            }
            PersistableBundle privateKeyBundle = in.getPersistableBundle(PRIVATE_KEY_KEY);
            Objects.requireNonNull(privateKeyBundle, "PrivateKey bundle is null");
            RSAPrivateKey privateKey = IkeCertUtils.privateKeyFromByteArray(PersistableBundleUtils.toByteArray(privateKeyBundle));
            Objects.requireNonNull(privateKeyBundle, "PrivateKey is null");
            return new IkeAuthDigitalSignLocalConfig(endCert, certList, privateKey);
        }

        @Override
        public PersistableBundle toPersistableBundle() {
            PersistableBundle result = super.toPersistableBundle();
            try {
                result.putPersistableBundle(END_CERT_KEY, PersistableBundleUtils.fromByteArray(this.mEndCert.getEncoded()));
                ArrayList<byte[]> encodedCertList = new ArrayList<byte[]>(this.mIntermediateCerts.size());
                for (X509Certificate cert : this.mIntermediateCerts) {
                    encodedCertList.add(cert.getEncoded());
                }
                PersistableBundle certsBundle = PersistableBundleUtils.fromList(encodedCertList, PersistableBundleUtils::fromByteArray);
                result.putPersistableBundle(INTERMEDIATE_CERTS_KEY, certsBundle);
            }
            catch (CertificateEncodingException e) {
                throw new IllegalArgumentException("Fail to encode certificate");
            }
            result.putPersistableBundle(PRIVATE_KEY_KEY, PersistableBundleUtils.fromByteArray(this.mPrivateKey.getEncoded()));
            return result;
        }

        public X509Certificate getClientEndCertificate() {
            return this.mEndCert;
        }

        public List<X509Certificate> getIntermediateCertificates() {
            return this.mIntermediateCerts;
        }

        public PrivateKey getPrivateKey() {
            return this.mPrivateKey;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.mEndCert, this.mIntermediateCerts, this.mPrivateKey);
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o) || !(o instanceof IkeAuthDigitalSignLocalConfig)) {
                return false;
            }
            IkeAuthDigitalSignLocalConfig other = (IkeAuthDigitalSignLocalConfig)o;
            return this.mEndCert.equals(other.mEndCert) && this.mIntermediateCerts.equals(other.mIntermediateCerts) && this.mPrivateKey.equals(other.mPrivateKey);
        }
    }

    public static class IkeAuthDigitalSignRemoteConfig
    extends IkeAuthConfig {
        private static final String TRUST_CERT_KEY = "TRUST_CERT_KEY";
        public final TrustAnchor mTrustAnchor;

        @VisibleForTesting
        IkeAuthDigitalSignRemoteConfig(X509Certificate caCert) {
            super(2, 2);
            this.mTrustAnchor = caCert == null ? null : new TrustAnchor(caCert, null);
        }

        public static IkeAuthDigitalSignRemoteConfig fromPersistableBundle(PersistableBundle in) {
            Objects.requireNonNull(in, "PersistableBundle is null");
            PersistableBundle trustCertBundle = in.getPersistableBundle(TRUST_CERT_KEY);
            X509Certificate caCert = null;
            if (trustCertBundle != null) {
                byte[] encodedCert = PersistableBundleUtils.toByteArray(trustCertBundle);
                caCert = IkeCertUtils.certificateFromByteArray(encodedCert);
            }
            return new IkeAuthDigitalSignRemoteConfig(caCert);
        }

        @Override
        public PersistableBundle toPersistableBundle() {
            PersistableBundle result = super.toPersistableBundle();
            try {
                if (this.mTrustAnchor != null) {
                    result.putPersistableBundle(TRUST_CERT_KEY, PersistableBundleUtils.fromByteArray(this.mTrustAnchor.getTrustedCert().getEncoded()));
                }
            }
            catch (CertificateEncodingException e) {
                throw new IllegalArgumentException("Fail to encode the certificate");
            }
            return result;
        }

        public X509Certificate getRemoteCaCert() {
            if (this.mTrustAnchor == null) {
                return null;
            }
            return this.mTrustAnchor.getTrustedCert();
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.mTrustAnchor == null ? null : this.mTrustAnchor.getTrustedCert());
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o) || !(o instanceof IkeAuthDigitalSignRemoteConfig)) {
                return false;
            }
            IkeAuthDigitalSignRemoteConfig other = (IkeAuthDigitalSignRemoteConfig)o;
            if (this.mTrustAnchor == null && other.mTrustAnchor == null) {
                return true;
            }
            return this.mTrustAnchor != null && other.mTrustAnchor != null && Objects.equals(this.mTrustAnchor.getTrustedCert(), other.mTrustAnchor.getTrustedCert());
        }
    }

    public static class IkeAuthPskConfig
    extends IkeAuthConfig {
        private static final String PSK_KEY = "mPsk";
        public final byte[] mPsk;

        @VisibleForTesting
        IkeAuthPskConfig(byte[] psk) {
            super(1, 3);
            this.mPsk = psk;
        }

        public static IkeAuthPskConfig fromPersistableBundle(PersistableBundle in) {
            Objects.requireNonNull(in, "PersistableBundle is null");
            PersistableBundle pskBundle = in.getPersistableBundle(PSK_KEY);
            Objects.requireNonNull(in, "PSK bundle is null");
            return new IkeAuthPskConfig(PersistableBundleUtils.toByteArray(pskBundle));
        }

        @Override
        public PersistableBundle toPersistableBundle() {
            PersistableBundle result = super.toPersistableBundle();
            result.putPersistableBundle(PSK_KEY, PersistableBundleUtils.fromByteArray(this.mPsk));
            return result;
        }

        public byte[] getPsk() {
            return Arrays.copyOf(this.mPsk, this.mPsk.length);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), Arrays.hashCode(this.mPsk));
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o) || !(o instanceof IkeAuthPskConfig)) {
                return false;
            }
            return Arrays.equals(this.mPsk, ((IkeAuthPskConfig)o).mPsk);
        }
    }

    public static abstract class IkeAuthConfig {
        private static final String AUTH_METHOD_KEY = "mAuthMethod";
        private static final String AUTH_DIRECTION_KEY = "mAuthDirection";
        public final int mAuthMethod;
        public final int mAuthDirection;

        IkeAuthConfig(int authMethod, int authDirection) {
            this.mAuthMethod = authMethod;
            this.mAuthDirection = authDirection;
        }

        public static IkeAuthConfig fromPersistableBundle(PersistableBundle in) {
            Objects.requireNonNull(in, "PersistableBundle is null");
            int authMethod = in.getInt(AUTH_METHOD_KEY);
            switch (authMethod) {
                case 1: {
                    return IkeAuthPskConfig.fromPersistableBundle(in);
                }
                case 2: {
                    switch (in.getInt(AUTH_DIRECTION_KEY)) {
                        case 1: {
                            return IkeAuthDigitalSignLocalConfig.fromPersistableBundle(in);
                        }
                        case 2: {
                            return IkeAuthDigitalSignRemoteConfig.fromPersistableBundle(in);
                        }
                    }
                    throw new IllegalArgumentException("Digital-signature-based auth configuration with invalid direction: " + in.getInt(AUTH_DIRECTION_KEY));
                }
                case 3: {
                    return IkeAuthEapConfig.fromPersistableBundle(in);
                }
            }
            throw new IllegalArgumentException("Invalid Auth Method: " + authMethod);
        }

        protected PersistableBundle toPersistableBundle() {
            PersistableBundle result = new PersistableBundle();
            result.putInt(AUTH_METHOD_KEY, this.mAuthMethod);
            result.putInt(AUTH_DIRECTION_KEY, this.mAuthDirection);
            return result;
        }

        public int hashCode() {
            return Objects.hash(this.mAuthMethod, this.mAuthDirection);
        }

        public boolean equals(Object o) {
            if (!(o instanceof IkeAuthConfig)) {
                return false;
            }
            IkeAuthConfig other = (IkeAuthConfig)o;
            return this.mAuthMethod == other.mAuthMethod && this.mAuthDirection == other.mAuthDirection;
        }
    }

    @SystemApi
    public static interface ConfigRequestIpv6PcscfServer
    extends IkeConfigRequest {
        public Inet6Address getAddress();
    }

    @SystemApi
    public static interface ConfigRequestIpv4PcscfServer
    extends IkeConfigRequest {
        public Inet4Address getAddress();
    }

    @SystemApi
    public static interface IkeConfigRequest {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IkeOption {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AuthDirection {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IkeAuthMethod {
    }
}

