/*
 * Decompiled with CFR 0.152.
 */
package android.net.ipsec.ike;

import android.net.InetAddresses;
import android.net.ipsec.ike.IkeIdentification;
import android.net.ipsec.ike.exceptions.AuthenticationFailedException;
import android.os.PersistableBundle;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.security.cert.X509Certificate;
import java.util.Objects;

public class IkeIpv4AddrIdentification
extends IkeIdentification {
    private static final String IP_ADDRESS_KEY = "ipv4Address";
    public final Inet4Address ipv4Address;

    public IkeIpv4AddrIdentification(byte[] ipv4AddrBytes) throws AuthenticationFailedException {
        super(1);
        try {
            this.ipv4Address = (Inet4Address)Inet4Address.getByAddress(ipv4AddrBytes);
        }
        catch (ClassCastException | UnknownHostException e) {
            throw new AuthenticationFailedException(e);
        }
    }

    public IkeIpv4AddrIdentification(Inet4Address address) {
        super(1);
        this.ipv4Address = address;
    }

    public static IkeIpv4AddrIdentification fromPersistableBundle(PersistableBundle in) {
        Objects.requireNonNull(in, "PersistableBundle is null");
        return new IkeIpv4AddrIdentification((Inet4Address)InetAddresses.parseNumericAddress(in.getString(IP_ADDRESS_KEY)));
    }

    @Override
    public PersistableBundle toPersistableBundle() {
        PersistableBundle result = super.toPersistableBundle();
        result.putString(IP_ADDRESS_KEY, this.ipv4Address.getHostAddress());
        return result;
    }

    public int hashCode() {
        return Objects.hash(this.idType, this.ipv4Address);
    }

    public boolean equals(Object o) {
        if (!(o instanceof IkeIpv4AddrIdentification)) {
            return false;
        }
        return this.ipv4Address.equals(((IkeIpv4AddrIdentification)o).ipv4Address);
    }

    @Override
    public String getIdTypeString() {
        return "IPv4 Address";
    }

    @Override
    public void validateEndCertIdOrThrow(X509Certificate endCert) throws AuthenticationFailedException {
        this.validateEndCertSanOrThrow(endCert, 7, this.ipv4Address.getHostAddress());
    }

    @Override
    public byte[] getEncodedIdData() {
        return this.ipv4Address.getAddress();
    }
}

