/*
 * Decompiled with CFR 0.152.
 */
package android.net.eap;

import android.annotation.SystemApi;
import android.os.PersistableBundle;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.net.ipsec.ike.utils.IkeCertUtils;
import com.android.internal.net.vcn.util.PersistableBundleUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.security.cert.CertificateEncodingException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class EapSessionConfig {
    private static final String EAP_ID_KEY = "eapIdentity";
    private static final String EAP_METHOD_CONFIGS_KEY = "eapConfigs";
    private static final byte[] DEFAULT_IDENTITY = new byte[0];
    private final Map<Integer, EapMethodConfig> mEapConfigs;
    private final byte[] mEapIdentity;

    @VisibleForTesting
    public EapSessionConfig(Map<Integer, EapMethodConfig> eapConfigs, byte[] eapIdentity) {
        Objects.requireNonNull(eapConfigs, "eapConfigs must not be null");
        Objects.requireNonNull(eapIdentity, "eapIdentity must not be null");
        this.mEapConfigs = Collections.unmodifiableMap(eapConfigs);
        this.mEapIdentity = eapIdentity;
    }

    public Map<Integer, EapMethodConfig> getEapConfigs() {
        return this.mEapConfigs;
    }

    public static EapSessionConfig fromPersistableBundle(PersistableBundle in) {
        Objects.requireNonNull(in, "PersistableBundle is null");
        Builder builder = new Builder();
        PersistableBundle eapIdBundle = in.getPersistableBundle(EAP_ID_KEY);
        Objects.requireNonNull(eapIdBundle, "EAP ID bundle is null");
        byte[] eapId = PersistableBundleUtils.toByteArray(eapIdBundle);
        builder.setEapIdentity(eapId);
        PersistableBundle configsBundle = in.getPersistableBundle(EAP_METHOD_CONFIGS_KEY);
        Objects.requireNonNull(configsBundle, "EAP method configs bundle is null");
        LinkedHashMap<Integer, EapMethodConfig> eapMethodConfigs = PersistableBundleUtils.toMap(configsBundle, PersistableBundleUtils.INTEGER_DESERIALIZER, EapMethodConfig::fromPersistableBundle);
        for (EapMethodConfig config : eapMethodConfigs.values()) {
            builder.addEapMethodConfig(config);
        }
        return builder.build();
    }

    public PersistableBundle toPersistableBundle() {
        PersistableBundle result = new PersistableBundle();
        result.putPersistableBundle(EAP_ID_KEY, PersistableBundleUtils.fromByteArray(this.mEapIdentity));
        PersistableBundle configsBundle = PersistableBundleUtils.fromMap(this.mEapConfigs, PersistableBundleUtils.INTEGER_SERIALIZER, EapMethodConfig::toPersistableBundle);
        result.putPersistableBundle(EAP_METHOD_CONFIGS_KEY, configsBundle);
        return result;
    }

    public byte[] getEapIdentity() {
        return (byte[])this.mEapIdentity.clone();
    }

    public EapSimConfig getEapSimConfig() {
        return (EapSimConfig)this.mEapConfigs.get(18);
    }

    public EapAkaConfig getEapAkaConfig() {
        return (EapAkaConfig)this.mEapConfigs.get(23);
    }

    public EapAkaPrimeConfig getEapAkaPrimeConfig() {
        return (EapAkaPrimeConfig)this.mEapConfigs.get(50);
    }

    public EapMsChapV2Config getEapMsChapV2Config() {
        return (EapMsChapV2Config)this.mEapConfigs.get(26);
    }

    @Deprecated
    @SystemApi
    public EapMsChapV2Config getEapMsChapV2onfig() {
        return this.getEapMsChapV2Config();
    }

    public EapTtlsConfig getEapTtlsConfig() {
        return (EapTtlsConfig)this.mEapConfigs.get(21);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.mEapIdentity), this.mEapConfigs);
    }

    public boolean equals(Object o) {
        if (!(o instanceof EapSessionConfig)) {
            return false;
        }
        EapSessionConfig other = (EapSessionConfig)o;
        return Arrays.equals(this.mEapIdentity, other.mEapIdentity) && this.mEapConfigs.equals(other.mEapConfigs);
    }

    public boolean areAllMethodsEapOnlySafe() {
        for (Map.Entry<Integer, EapMethodConfig> eapConfigsEntry : this.mEapConfigs.entrySet()) {
            if (eapConfigsEntry.getValue().isEapOnlySafeMethod()) continue;
            return false;
        }
        return true;
    }

    public static class EapAkaOption {
        private static final String REAUTH_ID_KEY = "reauthId";
        private final byte[] mReauthId;

        @VisibleForTesting
        public EapAkaOption(byte[] reauthId) {
            if (reauthId != null) {
                this.mReauthId = new byte[reauthId.length];
                System.arraycopy(reauthId, 0, this.mReauthId, 0, reauthId.length);
            } else {
                this.mReauthId = null;
            }
        }

        public static EapAkaOption fromPersistableBundle(PersistableBundle in) {
            Objects.requireNonNull(in, "PersistableBundle is null");
            Builder builder = new Builder();
            PersistableBundle reauthIdBundle = in.getPersistableBundle(REAUTH_ID_KEY);
            if (reauthIdBundle != null) {
                byte[] reauthId = PersistableBundleUtils.toByteArray(reauthIdBundle);
                builder.setReauthId(reauthId);
            }
            return builder.build();
        }

        protected PersistableBundle toPersistableBundle() {
            PersistableBundle result = new PersistableBundle();
            if (this.mReauthId != null) {
                result.putPersistableBundle(REAUTH_ID_KEY, PersistableBundleUtils.fromByteArray(this.mReauthId));
            }
            return result;
        }

        public byte[] getReauthId() {
            return this.mReauthId;
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.mReauthId);
        }

        public boolean equals(Object o) {
            if (!(o instanceof EapAkaOption)) {
                return false;
            }
            EapAkaOption other = (EapAkaOption)o;
            return Arrays.equals(this.mReauthId, other.mReauthId);
        }

        public static class Builder {
            byte[] mReauthId;

            public Builder setReauthId(byte[] reauthId) {
                this.mReauthId = reauthId;
                return this;
            }

            public EapAkaOption build() {
                return new EapAkaOption(this.mReauthId);
            }
        }
    }

    public static class EapTtlsConfig
    extends EapMethodConfig {
        private static final String TRUST_CERT_KEY = "TRUST_CERT_KEY";
        private static final String EAP_SESSION_CONFIG_KEY = "EAP_SESSION_CONFIG_KEY";
        private final TrustAnchor mOverrideTrustAnchor;
        private final EapSessionConfig mInnerEapSessionConfig;

        @VisibleForTesting
        public EapTtlsConfig(X509Certificate serverCaCert, EapSessionConfig innerEapSessionConfig) {
            super(21);
            this.mInnerEapSessionConfig = Objects.requireNonNull(innerEapSessionConfig, "innerEapSessionConfig must not be null");
            if (this.mInnerEapSessionConfig.getEapConfigs().containsKey(21)) {
                throw new IllegalArgumentException("Recursive EAP-TTLS method configs not allowed");
            }
            this.mOverrideTrustAnchor = serverCaCert == null ? null : new TrustAnchor(serverCaCert, null);
        }

        public static EapTtlsConfig fromPersistableBundle(PersistableBundle in) {
            Objects.requireNonNull(in, "PersistableBundle is null");
            PersistableBundle trustCertBundle = in.getPersistableBundle(TRUST_CERT_KEY);
            X509Certificate caCert = null;
            if (trustCertBundle != null) {
                byte[] encodedCert = PersistableBundleUtils.toByteArray(trustCertBundle);
                caCert = IkeCertUtils.certificateFromByteArray(encodedCert);
            }
            PersistableBundle eapSessionConfigBundle = in.getPersistableBundle(EAP_SESSION_CONFIG_KEY);
            Objects.requireNonNull(eapSessionConfigBundle, "eapSessionConfigBundle is null");
            EapSessionConfig eapSessionConfig = EapSessionConfig.fromPersistableBundle(eapSessionConfigBundle);
            return new EapTtlsConfig(caCert, eapSessionConfig);
        }

        @Override
        protected PersistableBundle toPersistableBundle() {
            PersistableBundle result = super.toPersistableBundle();
            try {
                if (this.mOverrideTrustAnchor != null) {
                    result.putPersistableBundle(TRUST_CERT_KEY, PersistableBundleUtils.fromByteArray(this.mOverrideTrustAnchor.getTrustedCert().getEncoded()));
                }
                result.putPersistableBundle(EAP_SESSION_CONFIG_KEY, this.mInnerEapSessionConfig.toPersistableBundle());
            }
            catch (CertificateEncodingException e) {
                throw new IllegalArgumentException("Fail to encode the certificate");
            }
            return result;
        }

        @Override
        public boolean isEapOnlySafeMethod() {
            return true;
        }

        public X509Certificate getServerCaCert() {
            return this.mOverrideTrustAnchor == null ? null : this.mOverrideTrustAnchor.getTrustedCert();
        }

        public EapSessionConfig getInnerEapSessionConfig() {
            return this.mInnerEapSessionConfig;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.mInnerEapSessionConfig, this.mOverrideTrustAnchor == null ? null : this.mOverrideTrustAnchor.getTrustedCert());
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o) || !(o instanceof EapTtlsConfig)) {
                return false;
            }
            EapTtlsConfig other = (EapTtlsConfig)o;
            if (!Objects.equals(this.mInnerEapSessionConfig, other.mInnerEapSessionConfig)) {
                return false;
            }
            if (this.mOverrideTrustAnchor == null && other.mOverrideTrustAnchor == null) {
                return true;
            }
            return this.mOverrideTrustAnchor != null && other.mOverrideTrustAnchor != null && Objects.equals(this.mOverrideTrustAnchor.getTrustedCert(), other.mOverrideTrustAnchor.getTrustedCert());
        }
    }

    public static class EapMsChapV2Config
    extends EapMethodConfig {
        private static final String USERNAME_KEY = "username";
        private static final String PASSWORD_KEY = "password";
        private final String mUsername;
        private final String mPassword;

        @VisibleForTesting
        public EapMsChapV2Config(String username, String password) {
            super(26);
            Objects.requireNonNull(username, "username must not be null");
            Objects.requireNonNull(password, "password must not be null");
            this.mUsername = username;
            this.mPassword = password;
        }

        public static EapMsChapV2Config fromPersistableBundle(PersistableBundle in) {
            Objects.requireNonNull(in, "PersistableBundle is null");
            return new EapMsChapV2Config(in.getString(USERNAME_KEY), in.getString(PASSWORD_KEY));
        }

        @Override
        protected PersistableBundle toPersistableBundle() {
            PersistableBundle result = super.toPersistableBundle();
            result.putString(USERNAME_KEY, this.mUsername);
            result.putString(PASSWORD_KEY, this.mPassword);
            return result;
        }

        public String getUsername() {
            return this.mUsername;
        }

        public String getPassword() {
            return this.mPassword;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.mUsername, this.mPassword);
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o) || !(o instanceof EapMsChapV2Config)) {
                return false;
            }
            EapMsChapV2Config other = (EapMsChapV2Config)o;
            return this.mUsername.equals(other.mUsername) && this.mPassword.equals(other.mPassword);
        }
    }

    public static class EapAkaPrimeConfig
    extends EapAkaConfig {
        private static final String NETWORK_NAME_KEY = "networkName";
        private static final String ALL_MISMATCHED_NETWORK_KEY = "allowMismatchedNetworkNames";
        private final String mNetworkName;
        private final boolean mAllowMismatchedNetworkNames;

        @VisibleForTesting
        public EapAkaPrimeConfig(int subId, int apptype, String networkName, boolean allowMismatchedNetworkNames) {
            super(50, subId, apptype, null);
            Objects.requireNonNull(networkName, "networkName must not be null");
            this.mNetworkName = networkName;
            this.mAllowMismatchedNetworkNames = allowMismatchedNetworkNames;
        }

        public static EapAkaPrimeConfig fromPersistableBundle(PersistableBundle in) {
            Objects.requireNonNull(in, "PersistableBundle is null");
            return new EapAkaPrimeConfig(in.getInt("subId"), in.getInt("apptype"), in.getString(NETWORK_NAME_KEY), in.getBoolean(ALL_MISMATCHED_NETWORK_KEY));
        }

        @Override
        protected PersistableBundle toPersistableBundle() {
            PersistableBundle result = super.toPersistableBundle();
            result.putString(NETWORK_NAME_KEY, this.mNetworkName);
            result.putBoolean(ALL_MISMATCHED_NETWORK_KEY, this.mAllowMismatchedNetworkNames);
            return result;
        }

        public String getNetworkName() {
            return this.mNetworkName;
        }

        public boolean allowsMismatchedNetworkNames() {
            return this.mAllowMismatchedNetworkNames;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.mNetworkName, this.mAllowMismatchedNetworkNames);
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o) || !(o instanceof EapAkaPrimeConfig)) {
                return false;
            }
            EapAkaPrimeConfig other = (EapAkaPrimeConfig)o;
            return this.mNetworkName.equals(other.mNetworkName) && this.mAllowMismatchedNetworkNames == other.mAllowMismatchedNetworkNames;
        }
    }

    public static class EapAkaConfig
    extends EapUiccConfig {
        private static final String AKA_OPTION_KEY = "akaOption";
        private final EapAkaOption mEapAkaOption;

        @VisibleForTesting
        public EapAkaConfig(int subId, int apptype) {
            this(23, subId, apptype, null);
        }

        @VisibleForTesting
        public EapAkaConfig(int subId, int apptype, EapAkaOption options) {
            this(23, subId, apptype, options);
        }

        EapAkaConfig(int methodType, int subId, int apptype, EapAkaOption options) {
            super(methodType, subId, apptype);
            this.mEapAkaOption = options;
        }

        public static EapAkaConfig fromPersistableBundle(PersistableBundle in) {
            Objects.requireNonNull(in, "PersistableBundle is null");
            EapAkaOption eapAkaOption = null;
            PersistableBundle bundle = in.getPersistableBundle(AKA_OPTION_KEY);
            if (bundle != null) {
                eapAkaOption = EapAkaOption.fromPersistableBundle(bundle);
            }
            return new EapAkaConfig(in.getInt("subId"), in.getInt("apptype"), eapAkaOption);
        }

        @Override
        protected PersistableBundle toPersistableBundle() {
            PersistableBundle result = super.toPersistableBundle();
            if (this.mEapAkaOption != null) {
                result.putPersistableBundle(AKA_OPTION_KEY, this.mEapAkaOption.toPersistableBundle());
            }
            return result;
        }

        public EapAkaOption getEapAkaOption() {
            return this.mEapAkaOption;
        }
    }

    public static class EapSimConfig
    extends EapUiccConfig {
        @VisibleForTesting
        public EapSimConfig(int subId, int apptype) {
            super(18, subId, apptype);
        }

        public static EapSimConfig fromPersistableBundle(PersistableBundle in) {
            Objects.requireNonNull(in, "PersistableBundle is null");
            return new EapSimConfig(in.getInt("subId"), in.getInt("apptype"));
        }
    }

    @Deprecated
    @SystemApi
    public static abstract class EapUiccConfig
    extends EapMethodConfig {
        protected static final String SUB_ID_KEY = "subId";
        protected static final String APP_TYPE_KEY = "apptype";
        private final int mSubId;
        private final int mApptype;

        private EapUiccConfig(int methodType, int subId, int apptype) {
            super(methodType);
            this.mSubId = subId;
            this.mApptype = apptype;
        }

        @Override
        protected PersistableBundle toPersistableBundle() {
            PersistableBundle result = super.toPersistableBundle();
            result.putInt(SUB_ID_KEY, this.mSubId);
            result.putInt(APP_TYPE_KEY, this.mApptype);
            return result;
        }

        public int getSubId() {
            return this.mSubId;
        }

        public int getAppType() {
            return this.mApptype;
        }

        @Override
        public boolean isEapOnlySafeMethod() {
            return true;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.mSubId, this.mApptype);
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o) || !(o instanceof EapUiccConfig)) {
                return false;
            }
            EapUiccConfig other = (EapUiccConfig)o;
            return this.mSubId == other.mSubId && this.mApptype == other.mApptype;
        }
    }

    public static abstract class EapMethodConfig {
        private static final String METHOD_TYPE = "methodType";
        public static final int EAP_TYPE_SIM = 18;
        public static final int EAP_TYPE_TTLS = 21;
        public static final int EAP_TYPE_AKA = 23;
        public static final int EAP_TYPE_MSCHAP_V2 = 26;
        public static final int EAP_TYPE_AKA_PRIME = 50;
        private final int mMethodType;

        EapMethodConfig(int methodType) {
            this.mMethodType = methodType;
        }

        public static EapMethodConfig fromPersistableBundle(PersistableBundle in) {
            Objects.requireNonNull(in, "PersistableBundle is null");
            int methodType = in.getInt(METHOD_TYPE);
            switch (methodType) {
                case 18: {
                    return EapSimConfig.fromPersistableBundle(in);
                }
                case 23: {
                    return EapAkaConfig.fromPersistableBundle(in);
                }
                case 50: {
                    return EapAkaPrimeConfig.fromPersistableBundle(in);
                }
                case 26: {
                    return EapMsChapV2Config.fromPersistableBundle(in);
                }
                case 21: {
                    return EapTtlsConfig.fromPersistableBundle(in);
                }
            }
            throw new IllegalArgumentException("Invalid EAP Type: " + methodType);
        }

        protected PersistableBundle toPersistableBundle() {
            PersistableBundle result = new PersistableBundle();
            result.putInt(METHOD_TYPE, this.mMethodType);
            return result;
        }

        public int getMethodType() {
            return this.mMethodType;
        }

        public boolean isEapOnlySafeMethod() {
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.mMethodType);
        }

        public boolean equals(Object o) {
            if (!(o instanceof EapMethodConfig)) {
                return false;
            }
            return this.mMethodType == ((EapMethodConfig)o).mMethodType;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface EapMethod {
        }
    }

    public static class Builder {
        private final Map<Integer, EapMethodConfig> mEapConfigs = new HashMap<Integer, EapMethodConfig>();
        private byte[] mEapIdentity = DEFAULT_IDENTITY;

        public Builder setEapIdentity(byte[] eapIdentity) {
            Objects.requireNonNull(eapIdentity, "eapIdentity must not be null");
            this.mEapIdentity = (byte[])eapIdentity.clone();
            return this;
        }

        public Builder setEapSimConfig(int subId, int apptype) {
            this.mEapConfigs.put(18, new EapSimConfig(subId, apptype));
            return this;
        }

        public Builder setEapAkaConfig(int subId, int apptype) {
            this.setEapAkaConfig(subId, apptype, null);
            return this;
        }

        public Builder setEapAkaConfig(int subId, int apptype, EapAkaOption options) {
            this.mEapConfigs.put(23, new EapAkaConfig(subId, apptype, options));
            return this;
        }

        public Builder setEapAkaPrimeConfig(int subId, int apptype, String networkName, boolean allowMismatchedNetworkNames) {
            this.mEapConfigs.put(50, new EapAkaPrimeConfig(subId, apptype, networkName, allowMismatchedNetworkNames));
            return this;
        }

        public Builder setEapMsChapV2Config(String username, String password) {
            this.mEapConfigs.put(26, new EapMsChapV2Config(username, password));
            return this;
        }

        public Builder setEapTtlsConfig(X509Certificate serverCaCert, EapSessionConfig innerEapSessionConfig) {
            this.mEapConfigs.put(21, new EapTtlsConfig(serverCaCert, innerEapSessionConfig));
            return this;
        }

        public Builder addEapMethodConfig(EapMethodConfig config) {
            Objects.requireNonNull(config, "EapMethodConfig is null");
            this.mEapConfigs.put(config.mMethodType, config);
            return this;
        }

        public EapSessionConfig build() {
            if (this.mEapConfigs.isEmpty()) {
                throw new IllegalStateException("Must have at least one EAP method configured");
            }
            return new EapSessionConfig(this.mEapConfigs, this.mEapIdentity);
        }
    }
}

