/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.com.android.net.module.util;

import android.util.SparseArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;

public class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T> boolean isEmpty(T[] array2) {
        return array2 == null || array2.length == 0;
    }

    public static <T> boolean isEmpty(Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }

    public static int[] toIntArray(Collection<Integer> list) {
        int[] array2 = new int[list.size()];
        int i = 0;
        for (Integer item : list) {
            array2[i] = item;
            ++i;
        }
        return array2;
    }

    public static long[] toLongArray(Collection<Long> list) {
        long[] array2 = new long[list.size()];
        int i = 0;
        for (Long item : list) {
            array2[i] = item;
            ++i;
        }
        return array2;
    }

    public static <T> boolean all(Collection<T> elem, Predicate<T> predicate) {
        for (T e : elem) {
            if (predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean any(Collection<T> elem, Predicate<T> predicate) {
        return CollectionUtils.indexOf(elem, predicate) >= 0;
    }

    public static <T> int indexOf(Collection<T> elem, Predicate<T> predicate) {
        int idx = 0;
        for (T e : elem) {
            if (predicate.test(e)) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public static <T> boolean any(SparseArray<T> array2, Predicate<T> predicate) {
        for (int i = 0; i < array2.size(); ++i) {
            if (!predicate.test(array2.valueAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(short[] array2, short value) {
        if (array2 == null) {
            return false;
        }
        for (short element : array2) {
            if (element != value) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(int[] array2, int value) {
        if (array2 == null) {
            return false;
        }
        for (int element : array2) {
            if (element != value) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean contains(T[] array2, T value) {
        return CollectionUtils.indexOf(array2, value) != -1;
    }

    public static <T> int indexOf(T[] array2, T value) {
        if (array2 == null) {
            return -1;
        }
        for (int i = 0; i < array2.length; ++i) {
            if (!Objects.equals(array2[i], value)) continue;
            return i;
        }
        return -1;
    }

    public static <T> ArrayList<T> filter(Collection<T> source, Predicate<T> test) {
        ArrayList<T> matches = new ArrayList<T>();
        for (T e : source) {
            if (!test.test(e)) continue;
            matches.add(e);
        }
        return matches;
    }

    public static long total(long[] array2) {
        long total = 0L;
        if (array2 != null) {
            for (long value : array2) {
                total += value;
            }
        }
        return total;
    }

    public static <T> boolean containsAny(Collection<T> haystack, Collection<? extends T> needles) {
        for (T needle : needles) {
            if (!haystack.contains(needle)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean containsAll(Collection<T> haystack, Collection<? extends T> needles) {
        return haystack.containsAll(needles);
    }
}

