/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.android.util;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;

public class IndentingPrintWriter
extends PrintWriter {
    private final String mSingleIndent;
    private final int mWrapLength;
    private StringBuilder mIndentBuilder = new StringBuilder();
    private char[] mCurrentIndent;
    private int mCurrentLength;
    private boolean mEmptyLine = true;
    private char[] mSingleChar = new char[1];

    public IndentingPrintWriter(Writer writer) {
        this(writer, "  ", -1);
    }

    public IndentingPrintWriter(Writer writer, String singleIndent) {
        this(writer, singleIndent, null, -1);
    }

    public IndentingPrintWriter(Writer writer, String singleIndent, String prefix) {
        this(writer, singleIndent, prefix, -1);
    }

    public IndentingPrintWriter(Writer writer, String singleIndent, int wrapLength) {
        this(writer, singleIndent, null, wrapLength);
    }

    public IndentingPrintWriter(Writer writer, String singleIndent, String prefix, int wrapLength) {
        super(writer);
        this.mSingleIndent = singleIndent;
        this.mWrapLength = wrapLength;
        if (prefix != null) {
            this.mIndentBuilder.append(prefix);
        }
    }

    @Deprecated
    public IndentingPrintWriter setIndent(String indent) {
        this.mIndentBuilder.setLength(0);
        this.mIndentBuilder.append(indent);
        this.mCurrentIndent = null;
        return this;
    }

    @Deprecated
    public IndentingPrintWriter setIndent(int indent) {
        this.mIndentBuilder.setLength(0);
        for (int i = 0; i < indent; ++i) {
            this.increaseIndent();
        }
        return this;
    }

    public IndentingPrintWriter increaseIndent() {
        this.mIndentBuilder.append(this.mSingleIndent);
        this.mCurrentIndent = null;
        return this;
    }

    public IndentingPrintWriter decreaseIndent() {
        this.mIndentBuilder.delete(0, this.mSingleIndent.length());
        this.mCurrentIndent = null;
        return this;
    }

    public IndentingPrintWriter print(String key, Object value) {
        String string2 = value == null ? "null" : (value.getClass().isArray() ? (value.getClass() == boolean[].class ? Arrays.toString((boolean[])value) : (value.getClass() == byte[].class ? Arrays.toString((byte[])value) : (value.getClass() == char[].class ? Arrays.toString((char[])value) : (value.getClass() == double[].class ? Arrays.toString((double[])value) : (value.getClass() == float[].class ? Arrays.toString((float[])value) : (value.getClass() == int[].class ? Arrays.toString((int[])value) : (value.getClass() == long[].class ? Arrays.toString((long[])value) : (value.getClass() == short[].class ? Arrays.toString((short[])value) : Arrays.toString((Object[])value))))))))) : String.valueOf(value));
        this.print(key + "=" + string2 + " ");
        return this;
    }

    public IndentingPrintWriter printHexInt(String key, int value) {
        this.print(key + "=0x" + Integer.toHexString(value) + " ");
        return this;
    }

    @Override
    public void println() {
        this.write(10);
    }

    @Override
    public void write(int c) {
        this.mSingleChar[0] = (char)c;
        this.write(this.mSingleChar, 0, 1);
    }

    @Override
    public void write(String s, int off, int len) {
        char[] buf = new char[len];
        s.getChars(off, len - off, buf, 0);
        this.write(buf, 0, len);
    }

    @Override
    public void write(char[] buf, int offset, int count) {
        int indentLength = this.mIndentBuilder.length();
        int bufferEnd = offset + count;
        int lineStart = offset;
        int lineEnd = offset;
        while (lineEnd < bufferEnd) {
            char ch = buf[lineEnd++];
            ++this.mCurrentLength;
            if (ch == '\n') {
                this.maybeWriteIndent();
                super.write(buf, lineStart, lineEnd - lineStart);
                lineStart = lineEnd;
                this.mEmptyLine = true;
                this.mCurrentLength = 0;
            }
            if (this.mWrapLength <= 0 || this.mCurrentLength < this.mWrapLength - indentLength) continue;
            if (!this.mEmptyLine) {
                super.write(10);
                this.mEmptyLine = true;
                this.mCurrentLength = lineEnd - lineStart;
                continue;
            }
            this.maybeWriteIndent();
            super.write(buf, lineStart, lineEnd - lineStart);
            super.write(10);
            this.mEmptyLine = true;
            lineStart = lineEnd;
            this.mCurrentLength = 0;
        }
        if (lineStart != lineEnd) {
            this.maybeWriteIndent();
            super.write(buf, lineStart, lineEnd - lineStart);
        }
    }

    private void maybeWriteIndent() {
        if (this.mEmptyLine) {
            this.mEmptyLine = false;
            if (this.mIndentBuilder.length() != 0) {
                if (this.mCurrentIndent == null) {
                    this.mCurrentIndent = this.mIndentBuilder.toString().toCharArray();
                }
                super.write(this.mCurrentIndent, 0, this.mCurrentIndent.length);
            }
        }
    }
}

