/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.compat.annotation.UnsupportedAppUsage;
import android.net.NetworkTemplate;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.BackupUtils;
import android.util.Log;
import android.util.Range;
import android.util.RecurrenceRule;
import com.android.internal.util.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;

public class NetworkPolicy
implements Parcelable,
Comparable<NetworkPolicy> {
    private static final String TAG = NetworkPolicy.class.getSimpleName();
    private static final int VERSION_INIT = 1;
    private static final int VERSION_RULE = 2;
    private static final int VERSION_RAPID = 3;
    private static final int TEMPLATE_BACKUP_VERSION_1_INIT = 1;
    private static final int TEMPLATE_BACKUP_VERSION_2_UNSUPPORTED = 2;
    private static final int TEMPLATE_BACKUP_VERSION_3_SUPPORT_CARRIER_TEMPLATE = 3;
    private static final int TEMPLATE_BACKUP_VERSION_LATEST = 3;
    public static final int CYCLE_NONE = -1;
    public static final long WARNING_DISABLED = -1L;
    public static final long LIMIT_DISABLED = -1L;
    public static final long SNOOZE_NEVER = -1L;
    @UnsupportedAppUsage
    public NetworkTemplate template;
    public RecurrenceRule cycleRule;
    @UnsupportedAppUsage
    public long warningBytes = -1L;
    @UnsupportedAppUsage
    public long limitBytes = -1L;
    public long lastWarningSnooze = -1L;
    public long lastLimitSnooze = -1L;
    public long lastRapidSnooze = -1L;
    @Deprecated
    @UnsupportedAppUsage
    public boolean metered = true;
    @UnsupportedAppUsage
    public boolean inferred = false;
    private static final long DEFAULT_MTU = 1500L;
    @UnsupportedAppUsage
    public static final Parcelable.Creator<NetworkPolicy> CREATOR = new Parcelable.Creator<NetworkPolicy>(){

        @Override
        public NetworkPolicy createFromParcel(Parcel in) {
            return new NetworkPolicy(in);
        }

        public NetworkPolicy[] newArray(int size) {
            return new NetworkPolicy[size];
        }
    };

    public static RecurrenceRule buildRule(int cycleDay, ZoneId cycleTimezone) {
        if (cycleDay != -1) {
            return RecurrenceRule.buildRecurringMonthly(cycleDay, cycleTimezone);
        }
        return RecurrenceRule.buildNever();
    }

    @Deprecated
    public NetworkPolicy(NetworkTemplate template, int cycleDay, String cycleTimezone, long warningBytes, long limitBytes, boolean metered) {
        this(template, cycleDay, cycleTimezone, warningBytes, limitBytes, -1L, -1L, metered, false);
    }

    @Deprecated
    @UnsupportedAppUsage
    public NetworkPolicy(NetworkTemplate template, int cycleDay, String cycleTimezone, long warningBytes, long limitBytes, long lastWarningSnooze, long lastLimitSnooze, boolean metered, boolean inferred) {
        this(template, NetworkPolicy.buildRule(cycleDay, ZoneId.of(cycleTimezone)), warningBytes, limitBytes, lastWarningSnooze, lastLimitSnooze, metered, inferred);
    }

    @Deprecated
    public NetworkPolicy(NetworkTemplate template, RecurrenceRule cycleRule, long warningBytes, long limitBytes, long lastWarningSnooze, long lastLimitSnooze, boolean metered, boolean inferred) {
        this(template, cycleRule, warningBytes, limitBytes, lastWarningSnooze, lastLimitSnooze, -1L, metered, inferred);
    }

    public NetworkPolicy(NetworkTemplate template, RecurrenceRule cycleRule, long warningBytes, long limitBytes, long lastWarningSnooze, long lastLimitSnooze, long lastRapidSnooze, boolean metered, boolean inferred) {
        this.template = Preconditions.checkNotNull(template, "missing NetworkTemplate");
        this.cycleRule = Preconditions.checkNotNull(cycleRule, "missing RecurrenceRule");
        this.warningBytes = warningBytes;
        this.limitBytes = limitBytes;
        this.lastWarningSnooze = lastWarningSnooze;
        this.lastLimitSnooze = lastLimitSnooze;
        this.lastRapidSnooze = lastRapidSnooze;
        this.metered = metered;
        this.inferred = inferred;
    }

    private NetworkPolicy(Parcel source) {
        this.template = source.readParcelable(null, NetworkTemplate.class);
        this.cycleRule = source.readParcelable(null, RecurrenceRule.class);
        this.warningBytes = source.readLong();
        this.limitBytes = source.readLong();
        this.lastWarningSnooze = source.readLong();
        this.lastLimitSnooze = source.readLong();
        this.lastRapidSnooze = source.readLong();
        this.metered = source.readInt() != 0;
        this.inferred = source.readInt() != 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.template, flags);
        dest.writeParcelable(this.cycleRule, flags);
        dest.writeLong(this.warningBytes);
        dest.writeLong(this.limitBytes);
        dest.writeLong(this.lastWarningSnooze);
        dest.writeLong(this.lastLimitSnooze);
        dest.writeLong(this.lastRapidSnooze);
        dest.writeInt(this.metered ? 1 : 0);
        dest.writeInt(this.inferred ? 1 : 0);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public Iterator<Range<ZonedDateTime>> cycleIterator() {
        return this.cycleRule.cycleIterator();
    }

    @UnsupportedAppUsage
    public boolean isOverWarning(long totalBytes) {
        return this.warningBytes != -1L && totalBytes >= this.warningBytes;
    }

    @UnsupportedAppUsage
    public boolean isOverLimit(long totalBytes) {
        return this.limitBytes != -1L && (totalBytes += 3000L) >= this.limitBytes;
    }

    @UnsupportedAppUsage
    public void clearSnooze() {
        this.lastWarningSnooze = -1L;
        this.lastLimitSnooze = -1L;
        this.lastRapidSnooze = -1L;
    }

    public boolean hasCycle() {
        return this.cycleRule.cycleIterator().hasNext();
    }

    @Override
    @UnsupportedAppUsage
    public int compareTo(NetworkPolicy another) {
        if (another == null || another.limitBytes == -1L) {
            return -1;
        }
        if (this.limitBytes == -1L || another.limitBytes < this.limitBytes) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        return Objects.hash(this.template, this.cycleRule, this.warningBytes, this.limitBytes, this.lastWarningSnooze, this.lastLimitSnooze, this.lastRapidSnooze, this.metered, this.inferred);
    }

    public boolean equals(Object obj) {
        if (obj instanceof NetworkPolicy) {
            NetworkPolicy other = (NetworkPolicy)obj;
            return this.warningBytes == other.warningBytes && this.limitBytes == other.limitBytes && this.lastWarningSnooze == other.lastWarningSnooze && this.lastLimitSnooze == other.lastLimitSnooze && this.lastRapidSnooze == other.lastRapidSnooze && this.metered == other.metered && this.inferred == other.inferred && Objects.equals(this.template, other.template) && Objects.equals(this.cycleRule, other.cycleRule);
        }
        return false;
    }

    public String toString() {
        return "NetworkPolicy{" + "template=" + this.template + " cycleRule=" + this.cycleRule + " warningBytes=" + this.warningBytes + " limitBytes=" + this.limitBytes + " lastWarningSnooze=" + this.lastWarningSnooze + " lastLimitSnooze=" + this.lastLimitSnooze + " lastRapidSnooze=" + this.lastRapidSnooze + " metered=" + this.metered + " inferred=" + this.inferred + "}";
    }

    public byte[] getBytesForBackup() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        out.writeInt(3);
        out.write(this.getNetworkTemplateBytesForBackup());
        this.cycleRule.writeToStream(out);
        out.writeLong(this.warningBytes);
        out.writeLong(this.limitBytes);
        out.writeLong(this.lastWarningSnooze);
        out.writeLong(this.lastLimitSnooze);
        out.writeLong(this.lastRapidSnooze);
        out.writeInt(this.metered ? 1 : 0);
        out.writeInt(this.inferred ? 1 : 0);
        return baos.toByteArray();
    }

    public static NetworkPolicy getNetworkPolicyFromBackup(DataInputStream in) throws IOException, BackupUtils.BadVersionException {
        RecurrenceRule cycleRule;
        int version = in.readInt();
        if (version < 1 || version > 3) {
            throw new BackupUtils.BadVersionException("Unknown backup version: " + version);
        }
        NetworkTemplate template = NetworkPolicy.getNetworkTemplateFromBackup(in);
        if (version >= 2) {
            cycleRule = new RecurrenceRule(in);
        } else {
            int cycleDay = in.readInt();
            String cycleTimezone = BackupUtils.readString(in);
            cycleRule = NetworkPolicy.buildRule(cycleDay, ZoneId.of(cycleTimezone));
        }
        long warningBytes = in.readLong();
        long limitBytes = in.readLong();
        long lastWarningSnooze = in.readLong();
        long lastLimitSnooze = in.readLong();
        long lastRapidSnooze = version >= 3 ? in.readLong() : -1L;
        boolean metered = in.readInt() == 1;
        boolean inferred = in.readInt() == 1;
        return new NetworkPolicy(template, cycleRule, warningBytes, limitBytes, lastWarningSnooze, lastLimitSnooze, lastRapidSnooze, metered, inferred);
    }

    private byte[] getNetworkTemplateBytesForBackup() throws IOException {
        if (!NetworkPolicy.isTemplatePersistable(this.template)) {
            Log.wtf(TAG, "Trying to backup non-persistable template: " + this);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        out.writeInt(3);
        out.writeInt(this.template.getMatchRule());
        Set<String> subscriberIds = this.template.getSubscriberIds();
        BackupUtils.writeString(out, subscriberIds.isEmpty() ? null : subscriberIds.iterator().next());
        BackupUtils.writeString(out, this.template.getWifiNetworkKeys().isEmpty() ? null : this.template.getWifiNetworkKeys().iterator().next());
        out.writeInt(this.template.getMeteredness());
        return baos.toByteArray();
    }

    private static NetworkTemplate getNetworkTemplateFromBackup(DataInputStream in) throws IOException, BackupUtils.BadVersionException {
        int version = in.readInt();
        if (version < 1 || version > 3 || version == 2) {
            throw new BackupUtils.BadVersionException("Unknown Backup Serialization Version");
        }
        int matchRule = in.readInt();
        String subscriberId = BackupUtils.readString(in);
        String wifiNetworkKey = BackupUtils.readString(in);
        int metered = version >= 3 ? in.readInt() : (matchRule == 1 || matchRule == 10 ? 1 : -1);
        try {
            NetworkTemplate.Builder builder = new NetworkTemplate.Builder(matchRule).setMeteredness(metered);
            if (subscriberId != null) {
                builder.setSubscriberIds(Set.of(subscriberId));
            }
            if (wifiNetworkKey != null) {
                builder.setWifiNetworkKeys(Set.of(wifiNetworkKey));
            }
            return builder.build();
        }
        catch (IllegalArgumentException e) {
            throw new BackupUtils.BadVersionException("Restored network template contains unknown match rule " + matchRule, e);
        }
    }

    public static boolean isTemplatePersistable(NetworkTemplate template) {
        switch (template.getMatchRule()) {
            case 5: 
            case 8: {
                return true;
            }
            case 1: 
            case 10: {
                return !template.getSubscriberIds().isEmpty() && template.getMeteredness() == 1;
            }
            case 4: {
                return !template.getWifiNetworkKeys().isEmpty() || !template.getSubscriberIds().isEmpty();
            }
        }
        return false;
    }
}

