/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.SystemApi;
import android.net.InvalidPacketException;
import android.net.connectivity.com.android.net.module.util.IpUtils;
import android.util.Log;
import java.net.InetAddress;

@SystemApi
public class KeepalivePacketData {
    private static final String TAG = "KeepalivePacketData";
    private final InetAddress mSrcAddress;
    private final InetAddress mDstAddress;
    private final int mSrcPort;
    private final int mDstPort;
    private final byte[] mPacket;

    protected KeepalivePacketData(InetAddress srcAddress, int srcPort, InetAddress dstAddress, int dstPort, byte[] data) throws InvalidPacketException {
        this.mSrcAddress = srcAddress;
        this.mDstAddress = dstAddress;
        this.mSrcPort = srcPort;
        this.mDstPort = dstPort;
        this.mPacket = data;
        if (srcAddress == null || dstAddress == null || !srcAddress.getClass().getName().equals(dstAddress.getClass().getName())) {
            Log.e(TAG, "Invalid or mismatched InetAddresses in KeepalivePacketData");
            throw new InvalidPacketException(-21);
        }
        if (!IpUtils.isValidUdpOrTcpPort(srcPort) || !IpUtils.isValidUdpOrTcpPort(dstPort)) {
            Log.e(TAG, "Invalid ports in KeepalivePacketData");
            throw new InvalidPacketException(-22);
        }
    }

    public InetAddress getSrcAddress() {
        return this.mSrcAddress;
    }

    public InetAddress getDstAddress() {
        return this.mDstAddress;
    }

    public int getSrcPort() {
        return this.mSrcPort;
    }

    public int getDstPort() {
        return this.mDstPort;
    }

    public byte[] getPacket() {
        return (byte[])this.mPacket.clone();
    }

    public String toString() {
        return "KeepalivePacketData[srcAddress=" + this.mSrcAddress + ", dstAddress=" + this.mDstAddress + ", srcPort=" + this.mSrcPort + ", dstPort=" + this.mDstPort + ", packet.length=" + this.mPacket.length + ']';
    }
}

