/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.res.Resources;
import android.os.Parcel;
import android.os.Parcelable;
import android.os._Original_Build;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class IpSecAlgorithm
implements Parcelable {
    private static final String TAG = "IpSecAlgorithm";
    public static final String CRYPT_NULL = "ecb(cipher_null)";
    public static final String CRYPT_AES_CBC = "cbc(aes)";
    public static final String CRYPT_AES_CTR = "rfc3686(ctr(aes))";
    public static final String AUTH_HMAC_MD5 = "hmac(md5)";
    public static final String AUTH_HMAC_SHA1 = "hmac(sha1)";
    public static final String AUTH_HMAC_SHA256 = "hmac(sha256)";
    public static final String AUTH_HMAC_SHA384 = "hmac(sha384)";
    public static final String AUTH_HMAC_SHA512 = "hmac(sha512)";
    public static final String AUTH_AES_XCBC = "xcbc(aes)";
    public static final String AUTH_AES_CMAC = "cmac(aes)";
    public static final String AUTH_CRYPT_AES_GCM = "rfc4106(gcm(aes))";
    public static final String AUTH_CRYPT_CHACHA20_POLY1305 = "rfc7539esp(chacha20,poly1305)";
    @VisibleForTesting
    public static final Map<String, Integer> ALGO_TO_REQUIRED_FIRST_SDK = new HashMap<String, Integer>();
    private static final int SDK_VERSION_ZERO = 0;
    private static final Set<String> ENABLED_ALGOS;
    private final String mName;
    private final byte[] mKey;
    private final int mTruncLenBits;
    public static final Parcelable.Creator<IpSecAlgorithm> CREATOR;

    public IpSecAlgorithm(String algorithm, byte[] key) {
        this(algorithm, key, 0);
    }

    public IpSecAlgorithm(String algorithm, byte[] key, int truncLenBits) {
        this.mName = algorithm;
        this.mKey = (byte[])key.clone();
        this.mTruncLenBits = truncLenBits;
        IpSecAlgorithm.checkValidOrThrow(this.mName, this.mKey.length * 8, this.mTruncLenBits);
    }

    public String getName() {
        return this.mName;
    }

    public byte[] getKey() {
        return (byte[])this.mKey.clone();
    }

    public int getTruncationLengthBits() {
        return this.mTruncLenBits;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.mName);
        out.writeByteArray(this.mKey);
        out.writeInt(this.mTruncLenBits);
    }

    public static Set<String> getSupportedAlgorithms() {
        return ENABLED_ALGOS;
    }

    @VisibleForTesting
    public static Set<String> loadAlgos(Resources systemResources) {
        HashSet<String> enabledAlgos = new HashSet<String>();
        String[] resourceAlgos = systemResources.getStringArray(17235974);
        for (String str : resourceAlgos) {
            if (ALGO_TO_REQUIRED_FIRST_SDK.containsKey(str) && enabledAlgos.add(str)) continue;
            throw new IllegalArgumentException("Invalid or repeated algorithm " + str);
        }
        for (Map.Entry entry : ALGO_TO_REQUIRED_FIRST_SDK.entrySet()) {
            if (_Original_Build.VERSION.DEVICE_INITIAL_SDK_INT < (Integer)entry.getValue()) continue;
            enabledAlgos.add((String)entry.getKey());
        }
        return enabledAlgos;
    }

    private static void checkValidOrThrow(String name, int keyLen, int truncLen) {
        boolean isValidTruncLen;
        boolean isValidLen;
        if (!IpSecAlgorithm.getSupportedAlgorithms().contains(name)) {
            throw new IllegalArgumentException("Unsupported algorithm: " + name);
        }
        switch (name) {
            case "cbc(aes)": {
                isValidLen = keyLen == 128 || keyLen == 192 || keyLen == 256;
                isValidTruncLen = true;
                break;
            }
            case "rfc3686(ctr(aes))": {
                isValidLen = keyLen == 160 || keyLen == 224 || keyLen == 288;
                isValidTruncLen = true;
                break;
            }
            case "hmac(md5)": {
                isValidLen = keyLen == 128;
                isValidTruncLen = truncLen >= 96 && truncLen <= 128;
                break;
            }
            case "hmac(sha1)": {
                isValidLen = keyLen == 160;
                isValidTruncLen = truncLen >= 96 && truncLen <= 160;
                break;
            }
            case "hmac(sha256)": {
                isValidLen = keyLen == 256;
                isValidTruncLen = truncLen >= 96 && truncLen <= 256;
                break;
            }
            case "hmac(sha384)": {
                isValidLen = keyLen == 384;
                isValidTruncLen = truncLen >= 192 && truncLen <= 384;
                break;
            }
            case "hmac(sha512)": {
                isValidLen = keyLen == 512;
                isValidTruncLen = truncLen >= 256 && truncLen <= 512;
                break;
            }
            case "xcbc(aes)": {
                isValidLen = keyLen == 128;
                isValidTruncLen = truncLen == 96;
                break;
            }
            case "cmac(aes)": {
                isValidLen = keyLen == 128;
                isValidTruncLen = truncLen == 96;
                break;
            }
            case "rfc4106(gcm(aes))": {
                isValidLen = keyLen == 160 || keyLen == 224 || keyLen == 288;
                isValidTruncLen = truncLen == 64 || truncLen == 96 || truncLen == 128;
                break;
            }
            case "rfc7539esp(chacha20,poly1305)": {
                isValidLen = keyLen == 288;
                isValidTruncLen = truncLen == 128;
                break;
            }
            default: {
                throw new IllegalArgumentException("Couldn't find an algorithm: " + name);
            }
        }
        if (!isValidLen) {
            throw new IllegalArgumentException("Invalid key material keyLength: " + keyLen);
        }
        if (!isValidTruncLen) {
            throw new IllegalArgumentException("Invalid truncation keyLength: " + truncLen);
        }
    }

    public boolean isAuthentication() {
        switch (this.getName()) {
            case "hmac(md5)": 
            case "hmac(sha1)": 
            case "hmac(sha256)": 
            case "hmac(sha384)": 
            case "hmac(sha512)": 
            case "xcbc(aes)": 
            case "cmac(aes)": {
                return true;
            }
        }
        return false;
    }

    public boolean isEncryption() {
        switch (this.getName()) {
            case "cbc(aes)": 
            case "rfc3686(ctr(aes))": {
                return true;
            }
        }
        return false;
    }

    public boolean isAead() {
        switch (this.getName()) {
            case "rfc4106(gcm(aes))": 
            case "rfc7539esp(chacha20,poly1305)": {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "{mName=" + this.mName + ", mTruncLenBits=" + this.mTruncLenBits + "}";
    }

    @VisibleForTesting
    public static boolean equals(IpSecAlgorithm lhs, IpSecAlgorithm rhs) {
        if (lhs == null || rhs == null) {
            return lhs == rhs;
        }
        return lhs.mName.equals(rhs.mName) && Arrays.equals(lhs.mKey, rhs.mKey) && lhs.mTruncLenBits == rhs.mTruncLenBits;
    }

    static {
        ALGO_TO_REQUIRED_FIRST_SDK.put(CRYPT_AES_CBC, 0);
        ALGO_TO_REQUIRED_FIRST_SDK.put(AUTH_HMAC_MD5, 0);
        ALGO_TO_REQUIRED_FIRST_SDK.put(AUTH_HMAC_SHA1, 0);
        ALGO_TO_REQUIRED_FIRST_SDK.put(AUTH_HMAC_SHA256, 0);
        ALGO_TO_REQUIRED_FIRST_SDK.put(AUTH_HMAC_SHA384, 0);
        ALGO_TO_REQUIRED_FIRST_SDK.put(AUTH_HMAC_SHA512, 0);
        ALGO_TO_REQUIRED_FIRST_SDK.put(AUTH_CRYPT_AES_GCM, 0);
        ALGO_TO_REQUIRED_FIRST_SDK.put(CRYPT_AES_CTR, 31);
        ALGO_TO_REQUIRED_FIRST_SDK.put(AUTH_AES_XCBC, 31);
        ALGO_TO_REQUIRED_FIRST_SDK.put(AUTH_AES_CMAC, 31);
        ALGO_TO_REQUIRED_FIRST_SDK.put(AUTH_CRYPT_CHACHA20_POLY1305, 31);
        ENABLED_ALGOS = Collections.unmodifiableSet(IpSecAlgorithm.loadAlgos(Resources.getSystem()));
        CREATOR = new Parcelable.Creator<IpSecAlgorithm>(){

            @Override
            public IpSecAlgorithm createFromParcel(Parcel in) {
                String name = in.readString();
                byte[] key = in.createByteArray();
                int truncLenBits = in.readInt();
                return new IpSecAlgorithm(name, key, truncLenBits);
            }

            public IpSecAlgorithm[] newArray(int size) {
                return new IpSecAlgorithm[size];
            }
        };
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AlgorithmName {
    }
}

