/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.compat.annotation.UnsupportedAppUsage;
import android.net.DataUsageRequest;
import android.net.INetworkStatsSession;
import android.net.Network;
import android.net.NetworkStateSnapshot;
import android.net.NetworkStats;
import android.net.UnderlyingNetworkInfo;
import android.net.netstats.IUsageCallback;
import android.net.netstats.provider.INetworkStatsProvider;
import android.net.netstats.provider.INetworkStatsProviderCallback;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface INetworkStatsService
extends IInterface {
    @UnsupportedAppUsage(overrideSourcePosition="packages/modules/Connectivity/framework-t/src/android/net/INetworkStatsService.aidl:37:1:37:25")
    public INetworkStatsSession openSession() throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="packages/modules/Connectivity/framework-t/src/android/net/INetworkStatsService.aidl:46:1:46:69")
    public INetworkStatsSession openSessionForUsageStats(int var1, String var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="packages/modules/Connectivity/framework-t/src/android/net/INetworkStatsService.aidl:50:1:50:25")
    public NetworkStats getDataLayerSnapshotForUid(int var1) throws RemoteException;

    public NetworkStats getUidStatsForTransport(int var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="packages/modules/Connectivity/framework-t/src/android/net/INetworkStatsService.aidl:57:1:57:25")
    public String[] getMobileIfaces() throws RemoteException;

    public void incrementOperationCount(int var1, int var2, int var3) throws RemoteException;

    public void notifyNetworkStatus(Network[] var1, NetworkStateSnapshot[] var2, String var3, UnderlyingNetworkInfo[] var4) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="packages/modules/Connectivity/framework-t/src/android/net/INetworkStatsService.aidl:70:1:70:25")
    public void forceUpdate() throws RemoteException;

    public DataUsageRequest registerUsageCallback(String var1, DataUsageRequest var2, IUsageCallback var3) throws RemoteException;

    public void unregisterUsageRequest(DataUsageRequest var1) throws RemoteException;

    public long getUidStats(int var1, int var2) throws RemoteException;

    public long getIfaceStats(String var1, int var2) throws RemoteException;

    public long getTotalStats(int var1) throws RemoteException;

    public INetworkStatsProviderCallback registerNetworkStatsProvider(String var1, INetworkStatsProvider var2) throws RemoteException;

    public void noteUidForeground(int var1, boolean var2) throws RemoteException;

    public void advisePersistThreshold(long var1) throws RemoteException;

    public void setStatsProviderWarningAndLimitAsync(String var1, long var2, long var4) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements INetworkStatsService {
        public static final String DESCRIPTOR = "android.net.INetworkStatsService";
        static final int TRANSACTION_openSession = 1;
        static final int TRANSACTION_openSessionForUsageStats = 2;
        static final int TRANSACTION_getDataLayerSnapshotForUid = 3;
        static final int TRANSACTION_getUidStatsForTransport = 4;
        static final int TRANSACTION_getMobileIfaces = 5;
        static final int TRANSACTION_incrementOperationCount = 6;
        static final int TRANSACTION_notifyNetworkStatus = 7;
        static final int TRANSACTION_forceUpdate = 8;
        static final int TRANSACTION_registerUsageCallback = 9;
        static final int TRANSACTION_unregisterUsageRequest = 10;
        static final int TRANSACTION_getUidStats = 11;
        static final int TRANSACTION_getIfaceStats = 12;
        static final int TRANSACTION_getTotalStats = 13;
        static final int TRANSACTION_registerNetworkStatsProvider = 14;
        static final int TRANSACTION_noteUidForeground = 15;
        static final int TRANSACTION_advisePersistThreshold = 16;
        static final int TRANSACTION_setStatsProviderWarningAndLimitAsync = 17;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static INetworkStatsService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof INetworkStatsService) {
                return (INetworkStatsService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "openSession";
                }
                case 2: {
                    return "openSessionForUsageStats";
                }
                case 3: {
                    return "getDataLayerSnapshotForUid";
                }
                case 4: {
                    return "getUidStatsForTransport";
                }
                case 5: {
                    return "getMobileIfaces";
                }
                case 6: {
                    return "incrementOperationCount";
                }
                case 7: {
                    return "notifyNetworkStatus";
                }
                case 8: {
                    return "forceUpdate";
                }
                case 9: {
                    return "registerUsageCallback";
                }
                case 10: {
                    return "unregisterUsageRequest";
                }
                case 11: {
                    return "getUidStats";
                }
                case 12: {
                    return "getIfaceStats";
                }
                case 13: {
                    return "getTotalStats";
                }
                case 14: {
                    return "registerNetworkStatsProvider";
                }
                case 15: {
                    return "noteUidForeground";
                }
                case 16: {
                    return "advisePersistThreshold";
                }
                case 17: {
                    return "setStatsProviderWarningAndLimitAsync";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    INetworkStatsSession _result = this.openSession();
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    INetworkStatsSession _result = this.openSessionForUsageStats(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    NetworkStats _result = this.getDataLayerSnapshotForUid(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    NetworkStats _result = this.getUidStatsForTransport(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 5: {
                    String[] _result = this.getMobileIfaces();
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.incrementOperationCount(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    Network[] _arg0 = data.createTypedArray(Network.CREATOR);
                    NetworkStateSnapshot[] _arg1 = data.createTypedArray(NetworkStateSnapshot.CREATOR);
                    String _arg2 = data.readString();
                    UnderlyingNetworkInfo[] _arg3 = data.createTypedArray(UnderlyingNetworkInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifyNetworkStatus(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    this.forceUpdate();
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    DataUsageRequest _arg1 = data.readTypedObject(DataUsageRequest.CREATOR);
                    IUsageCallback _arg2 = IUsageCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    DataUsageRequest _result = this.registerUsageCallback(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 10: {
                    DataUsageRequest _arg0 = data.readTypedObject(DataUsageRequest.CREATOR);
                    data.enforceNoDataAvail();
                    this.unregisterUsageRequest(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    long _result = this.getUidStats(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 12: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    long _result = this.getIfaceStats(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    long _result = this.getTotalStats(_arg0);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 14: {
                    String _arg0 = data.readString();
                    INetworkStatsProvider _arg1 = INetworkStatsProvider.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    INetworkStatsProviderCallback _result = this.registerNetworkStatsProvider(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 15: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.noteUidForeground(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    this.advisePersistThreshold(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    String _arg0 = data.readString();
                    long _arg1 = data.readLong();
                    long _arg2 = data.readLong();
                    data.enforceNoDataAvail();
                    this.setStatsProviderWarningAndLimitAsync(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 16;
        }

        private static class Proxy
        implements INetworkStatsService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public INetworkStatsSession openSession() throws RemoteException {
                INetworkStatsSession _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = INetworkStatsSession.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public INetworkStatsSession openSessionForUsageStats(int flags, String callingPackage) throws RemoteException {
                INetworkStatsSession _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(flags);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = INetworkStatsSession.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NetworkStats getDataLayerSnapshotForUid(int uid) throws RemoteException {
                NetworkStats _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(NetworkStats.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NetworkStats getUidStatsForTransport(int transport) throws RemoteException {
                NetworkStats _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(transport);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(NetworkStats.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] getMobileIfaces() throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void incrementOperationCount(int uid, int tag, int operationCount) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeInt(tag);
                    _data.writeInt(operationCount);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyNetworkStatus(Network[] defaultNetworks, NetworkStateSnapshot[] snapshots, String activeIface, UnderlyingNetworkInfo[] underlyingNetworkInfos) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedArray(defaultNetworks, 0);
                    _data.writeTypedArray(snapshots, 0);
                    _data.writeString(activeIface);
                    _data.writeTypedArray(underlyingNetworkInfos, 0);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void forceUpdate() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public DataUsageRequest registerUsageCallback(String callingPackage, DataUsageRequest request, IUsageCallback callback) throws RemoteException {
                DataUsageRequest _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeTypedObject(request, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(DataUsageRequest.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterUsageRequest(DataUsageRequest request) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getUidStats(int uid, int type) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeInt(type);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getIfaceStats(String iface, int type) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(iface);
                    _data.writeInt(type);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getTotalStats(int type) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(type);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public INetworkStatsProviderCallback registerNetworkStatsProvider(String tag, INetworkStatsProvider provider) throws RemoteException {
                INetworkStatsProviderCallback _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(tag);
                    _data.writeStrongInterface(provider);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = INetworkStatsProviderCallback.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteUidForeground(int uid, boolean uidForeground) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeBoolean(uidForeground);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void advisePersistThreshold(long thresholdBytes) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(thresholdBytes);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setStatsProviderWarningAndLimitAsync(String iface, long warning, long limit) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(iface);
                    _data.writeLong(warning);
                    _data.writeLong(limit);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements INetworkStatsService {
        @Override
        public INetworkStatsSession openSession() throws RemoteException {
            return null;
        }

        @Override
        public INetworkStatsSession openSessionForUsageStats(int flags, String callingPackage) throws RemoteException {
            return null;
        }

        @Override
        public NetworkStats getDataLayerSnapshotForUid(int uid) throws RemoteException {
            return null;
        }

        @Override
        public NetworkStats getUidStatsForTransport(int transport) throws RemoteException {
            return null;
        }

        @Override
        public String[] getMobileIfaces() throws RemoteException {
            return null;
        }

        @Override
        public void incrementOperationCount(int uid, int tag, int operationCount) throws RemoteException {
        }

        @Override
        public void notifyNetworkStatus(Network[] defaultNetworks, NetworkStateSnapshot[] snapshots, String activeIface, UnderlyingNetworkInfo[] underlyingNetworkInfos) throws RemoteException {
        }

        @Override
        public void forceUpdate() throws RemoteException {
        }

        @Override
        public DataUsageRequest registerUsageCallback(String callingPackage, DataUsageRequest request, IUsageCallback callback) throws RemoteException {
            return null;
        }

        @Override
        public void unregisterUsageRequest(DataUsageRequest request) throws RemoteException {
        }

        @Override
        public long getUidStats(int uid, int type) throws RemoteException {
            return 0L;
        }

        @Override
        public long getIfaceStats(String iface, int type) throws RemoteException {
            return 0L;
        }

        @Override
        public long getTotalStats(int type) throws RemoteException {
            return 0L;
        }

        @Override
        public INetworkStatsProviderCallback registerNetworkStatsProvider(String tag, INetworkStatsProvider provider) throws RemoteException {
            return null;
        }

        @Override
        public void noteUidForeground(int uid, boolean uidForeground) throws RemoteException {
        }

        @Override
        public void advisePersistThreshold(long thresholdBytes) throws RemoteException {
        }

        @Override
        public void setStatsProviderWarningAndLimitAsync(String iface, long warning, long limit) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

