/*
 * Decompiled with CFR 0.152.
 */
package android.nearby;

import android.annotation.SystemApi;
import android.net.connectivity.com.android.internal.util.Preconditions;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;
import java.util.Objects;

@SystemApi
public class CredentialElement
implements Parcelable {
    private final String mKey;
    private final byte[] mValue;
    public static final Parcelable.Creator<CredentialElement> CREATOR = new Parcelable.Creator<CredentialElement>(){

        @Override
        public CredentialElement createFromParcel(Parcel in) {
            String key = in.readString();
            byte[] value = new byte[in.readInt()];
            in.readByteArray(value);
            return new CredentialElement(key, value);
        }

        public CredentialElement[] newArray(int size) {
            return new CredentialElement[size];
        }
    };

    public CredentialElement(String key, byte[] value) {
        Preconditions.checkState(key != null && value != null, "neither key or value can be null");
        this.mKey = key;
        this.mValue = value;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mKey);
        dest.writeInt(this.mValue.length);
        dest.writeByteArray(this.mValue);
    }

    public String getKey() {
        return this.mKey;
    }

    public byte[] getValue() {
        return this.mValue;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CredentialElement) {
            CredentialElement that = (CredentialElement)obj;
            return this.mKey.equals(that.mKey) && Arrays.equals(this.mValue, that.mValue);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mKey.hashCode(), Arrays.hashCode(this.mValue));
    }
}

