/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.media.tv.BroadcastInfoResponse;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public class DsmccResponse
extends BroadcastInfoResponse
implements Parcelable {
    private static final int RESPONSE_TYPE = 6;
    public static final String BIOP_MESSAGE_TYPE_DIRECTORY = "directory";
    public static final String BIOP_MESSAGE_TYPE_FILE = "file";
    public static final String BIOP_MESSAGE_TYPE_STREAM = "stream";
    public static final String BIOP_MESSAGE_TYPE_SERVICE_GATEWAY = "service_gateway";
    public static final Parcelable.Creator<DsmccResponse> CREATOR = new Parcelable.Creator<DsmccResponse>(){

        @Override
        public DsmccResponse createFromParcel(Parcel source) {
            source.readInt();
            return DsmccResponse.createFromParcelBody(source);
        }

        public DsmccResponse[] newArray(int size) {
            return new DsmccResponse[size];
        }
    };
    private final String mBiopMessageType;
    private final ParcelFileDescriptor mFileDescriptor;
    private final List<String> mChildList;
    private final int[] mEventIds;
    private final String[] mEventNames;

    static DsmccResponse createFromParcelBody(Parcel in) {
        return new DsmccResponse(in);
    }

    public DsmccResponse(int requestId, int sequence, int responseResult, ParcelFileDescriptor file) {
        super(6, requestId, sequence, responseResult);
        this.mBiopMessageType = BIOP_MESSAGE_TYPE_FILE;
        this.mFileDescriptor = file;
        this.mChildList = null;
        this.mEventIds = null;
        this.mEventNames = null;
    }

    public DsmccResponse(int requestId, int sequence, int responseResult, boolean isServiceGateway, List<String> childList) {
        super(6, requestId, sequence, responseResult);
        this.mBiopMessageType = isServiceGateway ? BIOP_MESSAGE_TYPE_SERVICE_GATEWAY : BIOP_MESSAGE_TYPE_DIRECTORY;
        this.mFileDescriptor = null;
        this.mChildList = childList;
        this.mEventIds = null;
        this.mEventNames = null;
    }

    public DsmccResponse(int requestId, int sequence, int responseResult, int[] eventIds, String[] eventNames) {
        super(6, requestId, sequence, responseResult);
        this.mBiopMessageType = BIOP_MESSAGE_TYPE_STREAM;
        this.mFileDescriptor = null;
        this.mChildList = null;
        if (!(eventIds != null && eventNames != null && eventIds.length == eventNames.length || eventIds == null && eventNames == null)) {
            throw new IllegalStateException("The size of eventIds and eventNames must be equal");
        }
        this.mEventIds = eventIds;
        this.mEventNames = eventNames;
    }

    private DsmccResponse(Parcel source) {
        super(6, source);
        switch (this.mBiopMessageType = source.readString()) {
            case "service_gateway": 
            case "directory": {
                int childNum = source.readInt();
                if (childNum > 0) {
                    this.mChildList = new ArrayList<String>();
                    for (int i = 0; i < childNum; ++i) {
                        this.mChildList.add(source.readString());
                    }
                } else {
                    this.mChildList = null;
                }
                this.mFileDescriptor = null;
                this.mEventIds = null;
                this.mEventNames = null;
                break;
            }
            case "file": {
                this.mFileDescriptor = source.readFileDescriptor();
                this.mChildList = null;
                this.mEventIds = null;
                this.mEventNames = null;
                break;
            }
            case "stream": {
                int eventNum = source.readInt();
                if (eventNum > 0) {
                    this.mEventIds = new int[eventNum];
                    this.mEventNames = new String[eventNum];
                    for (int i = 0; i < eventNum; ++i) {
                        this.mEventIds[i] = source.readInt();
                        this.mEventNames[i] = source.readString();
                    }
                } else {
                    this.mEventIds = null;
                    this.mEventNames = null;
                }
                this.mChildList = null;
                this.mFileDescriptor = null;
                break;
            }
            default: {
                throw new IllegalStateException("unexpected BIOP message type");
            }
        }
    }

    public String getBiopMessageType() {
        return this.mBiopMessageType;
    }

    public ParcelFileDescriptor getFile() {
        if (!this.mBiopMessageType.equals(BIOP_MESSAGE_TYPE_FILE)) {
            throw new IllegalStateException("Not file object");
        }
        return this.mFileDescriptor;
    }

    public List<String> getChildList() {
        if (!this.mBiopMessageType.equals(BIOP_MESSAGE_TYPE_DIRECTORY) && !this.mBiopMessageType.equals(BIOP_MESSAGE_TYPE_SERVICE_GATEWAY)) {
            throw new IllegalStateException("Not directory object");
        }
        return this.mChildList != null ? new ArrayList<String>(this.mChildList) : new ArrayList();
    }

    public int[] getStreamEventIds() {
        if (!this.mBiopMessageType.equals(BIOP_MESSAGE_TYPE_STREAM)) {
            throw new IllegalStateException("Not stream event object");
        }
        return this.mEventIds != null ? this.mEventIds : new int[]{};
    }

    public String[] getStreamEventNames() {
        if (!this.mBiopMessageType.equals(BIOP_MESSAGE_TYPE_STREAM)) {
            throw new IllegalStateException("Not stream event object");
        }
        return this.mEventNames != null ? this.mEventNames : new String[]{};
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.mBiopMessageType);
        switch (this.mBiopMessageType) {
            case "service_gateway": 
            case "directory": {
                if (this.mChildList != null && this.mChildList.size() > 0) {
                    dest.writeInt(this.mChildList.size());
                    for (String child : this.mChildList) {
                        dest.writeString(child);
                    }
                    break;
                }
                dest.writeInt(0);
                break;
            }
            case "file": {
                dest.writeFileDescriptor(this.mFileDescriptor.getFileDescriptor());
                break;
            }
            case "stream": {
                if (this.mEventIds != null && this.mEventIds.length > 0) {
                    dest.writeInt(this.mEventIds.length);
                    for (int i = 0; i < this.mEventIds.length; ++i) {
                        dest.writeInt(this.mEventIds[i]);
                        dest.writeString(this.mEventNames[i]);
                    }
                    break;
                }
                dest.writeInt(0);
                break;
            }
            default: {
                throw new IllegalStateException("unexpected BIOP message type");
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BiopMessageType {
    }
}

