/*
 * Decompiled with CFR 0.152.
 */
package android.media.session;

import android.app.PendingIntent;
import android.content.pm.ParceledListSlice;
import android.media.MediaMetadata;
import android.media.Rating;
import android.media.session.ISessionControllerCallback;
import android.media.session.MediaController;
import android.media.session.PlaybackState;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.text.TextUtils;
import android.view.KeyEvent;

public interface ISessionController
extends IInterface {
    public void sendCommand(String var1, String var2, Bundle var3, ResultReceiver var4) throws RemoteException;

    public boolean sendMediaButton(String var1, KeyEvent var2) throws RemoteException;

    public void registerCallback(String var1, ISessionControllerCallback var2) throws RemoteException;

    public void unregisterCallback(ISessionControllerCallback var1) throws RemoteException;

    public String getPackageName() throws RemoteException;

    public String getTag() throws RemoteException;

    public Bundle getSessionInfo() throws RemoteException;

    public PendingIntent getLaunchPendingIntent() throws RemoteException;

    public long getFlags() throws RemoteException;

    public MediaController.PlaybackInfo getVolumeAttributes() throws RemoteException;

    public void adjustVolume(String var1, String var2, int var3, int var4) throws RemoteException;

    public void setVolumeTo(String var1, String var2, int var3, int var4) throws RemoteException;

    public void prepare(String var1) throws RemoteException;

    public void prepareFromMediaId(String var1, String var2, Bundle var3) throws RemoteException;

    public void prepareFromSearch(String var1, String var2, Bundle var3) throws RemoteException;

    public void prepareFromUri(String var1, Uri var2, Bundle var3) throws RemoteException;

    public void play(String var1) throws RemoteException;

    public void playFromMediaId(String var1, String var2, Bundle var3) throws RemoteException;

    public void playFromSearch(String var1, String var2, Bundle var3) throws RemoteException;

    public void playFromUri(String var1, Uri var2, Bundle var3) throws RemoteException;

    public void skipToQueueItem(String var1, long var2) throws RemoteException;

    public void pause(String var1) throws RemoteException;

    public void stop(String var1) throws RemoteException;

    public void next(String var1) throws RemoteException;

    public void previous(String var1) throws RemoteException;

    public void fastForward(String var1) throws RemoteException;

    public void rewind(String var1) throws RemoteException;

    public void seekTo(String var1, long var2) throws RemoteException;

    public void rate(String var1, Rating var2) throws RemoteException;

    public void setPlaybackSpeed(String var1, float var2) throws RemoteException;

    public void sendCustomAction(String var1, String var2, Bundle var3) throws RemoteException;

    public MediaMetadata getMetadata() throws RemoteException;

    public PlaybackState getPlaybackState() throws RemoteException;

    public ParceledListSlice getQueue() throws RemoteException;

    public CharSequence getQueueTitle() throws RemoteException;

    public Bundle getExtras() throws RemoteException;

    public int getRatingType() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISessionController {
        public static final String DESCRIPTOR = "android.media.session.ISessionController";
        static final int TRANSACTION_sendCommand = 1;
        static final int TRANSACTION_sendMediaButton = 2;
        static final int TRANSACTION_registerCallback = 3;
        static final int TRANSACTION_unregisterCallback = 4;
        static final int TRANSACTION_getPackageName = 5;
        static final int TRANSACTION_getTag = 6;
        static final int TRANSACTION_getSessionInfo = 7;
        static final int TRANSACTION_getLaunchPendingIntent = 8;
        static final int TRANSACTION_getFlags = 9;
        static final int TRANSACTION_getVolumeAttributes = 10;
        static final int TRANSACTION_adjustVolume = 11;
        static final int TRANSACTION_setVolumeTo = 12;
        static final int TRANSACTION_prepare = 13;
        static final int TRANSACTION_prepareFromMediaId = 14;
        static final int TRANSACTION_prepareFromSearch = 15;
        static final int TRANSACTION_prepareFromUri = 16;
        static final int TRANSACTION_play = 17;
        static final int TRANSACTION_playFromMediaId = 18;
        static final int TRANSACTION_playFromSearch = 19;
        static final int TRANSACTION_playFromUri = 20;
        static final int TRANSACTION_skipToQueueItem = 21;
        static final int TRANSACTION_pause = 22;
        static final int TRANSACTION_stop = 23;
        static final int TRANSACTION_next = 24;
        static final int TRANSACTION_previous = 25;
        static final int TRANSACTION_fastForward = 26;
        static final int TRANSACTION_rewind = 27;
        static final int TRANSACTION_seekTo = 28;
        static final int TRANSACTION_rate = 29;
        static final int TRANSACTION_setPlaybackSpeed = 30;
        static final int TRANSACTION_sendCustomAction = 31;
        static final int TRANSACTION_getMetadata = 32;
        static final int TRANSACTION_getPlaybackState = 33;
        static final int TRANSACTION_getQueue = 34;
        static final int TRANSACTION_getQueueTitle = 35;
        static final int TRANSACTION_getExtras = 36;
        static final int TRANSACTION_getRatingType = 37;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ISessionController asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ISessionController) {
                return (ISessionController)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "sendCommand";
                }
                case 2: {
                    return "sendMediaButton";
                }
                case 3: {
                    return "registerCallback";
                }
                case 4: {
                    return "unregisterCallback";
                }
                case 5: {
                    return "getPackageName";
                }
                case 6: {
                    return "getTag";
                }
                case 7: {
                    return "getSessionInfo";
                }
                case 8: {
                    return "getLaunchPendingIntent";
                }
                case 9: {
                    return "getFlags";
                }
                case 10: {
                    return "getVolumeAttributes";
                }
                case 11: {
                    return "adjustVolume";
                }
                case 12: {
                    return "setVolumeTo";
                }
                case 13: {
                    return "prepare";
                }
                case 14: {
                    return "prepareFromMediaId";
                }
                case 15: {
                    return "prepareFromSearch";
                }
                case 16: {
                    return "prepareFromUri";
                }
                case 17: {
                    return "play";
                }
                case 18: {
                    return "playFromMediaId";
                }
                case 19: {
                    return "playFromSearch";
                }
                case 20: {
                    return "playFromUri";
                }
                case 21: {
                    return "skipToQueueItem";
                }
                case 22: {
                    return "pause";
                }
                case 23: {
                    return "stop";
                }
                case 24: {
                    return "next";
                }
                case 25: {
                    return "previous";
                }
                case 26: {
                    return "fastForward";
                }
                case 27: {
                    return "rewind";
                }
                case 28: {
                    return "seekTo";
                }
                case 29: {
                    return "rate";
                }
                case 30: {
                    return "setPlaybackSpeed";
                }
                case 31: {
                    return "sendCustomAction";
                }
                case 32: {
                    return "getMetadata";
                }
                case 33: {
                    return "getPlaybackState";
                }
                case 34: {
                    return "getQueue";
                }
                case 35: {
                    return "getQueueTitle";
                }
                case 36: {
                    return "getExtras";
                }
                case 37: {
                    return "getRatingType";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    ResultReceiver _arg3 = data.readTypedObject(ResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.sendCommand(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    KeyEvent _arg1 = data.readTypedObject(KeyEvent.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.sendMediaButton(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    ISessionControllerCallback _arg1 = ISessionControllerCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerCallback(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    ISessionControllerCallback _arg0 = ISessionControllerCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    String _result = this.getPackageName();
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 6: {
                    String _result = this.getTag();
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 7: {
                    Bundle _result = this.getSessionInfo();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 8: {
                    PendingIntent _result = this.getLaunchPendingIntent();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 9: {
                    long _result = this.getFlags();
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 10: {
                    MediaController.PlaybackInfo _result = this.getVolumeAttributes();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 11: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.adjustVolume(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setVolumeTo(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.prepare(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.prepareFromMediaId(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.prepareFromSearch(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    String _arg0 = data.readString();
                    Uri _arg1 = data.readTypedObject(Uri.CREATOR);
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.prepareFromUri(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.play(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.playFromMediaId(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.playFromSearch(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 20: {
                    String _arg0 = data.readString();
                    Uri _arg1 = data.readTypedObject(Uri.CREATOR);
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.playFromUri(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 21: {
                    String _arg0 = data.readString();
                    long _arg1 = data.readLong();
                    data.enforceNoDataAvail();
                    this.skipToQueueItem(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 22: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.pause(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.stop(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 24: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.next(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 25: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.previous(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 26: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.fastForward(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 27: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.rewind(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 28: {
                    String _arg0 = data.readString();
                    long _arg1 = data.readLong();
                    data.enforceNoDataAvail();
                    this.seekTo(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 29: {
                    String _arg0 = data.readString();
                    Rating _arg1 = data.readTypedObject(Rating.CREATOR);
                    data.enforceNoDataAvail();
                    this.rate(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 30: {
                    String _arg0 = data.readString();
                    float _arg1 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.setPlaybackSpeed(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 31: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.sendCustomAction(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 32: {
                    MediaMetadata _result = this.getMetadata();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 33: {
                    PlaybackState _result = this.getPlaybackState();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 34: {
                    ParceledListSlice _result = this.getQueue();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 35: {
                    CharSequence _result = this.getQueueTitle();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        TextUtils.writeToParcel(_result, reply, 1);
                        break;
                    }
                    reply.writeInt(0);
                    break;
                }
                case 36: {
                    Bundle _result = this.getExtras();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 37: {
                    int _result = this.getRatingType();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 36;
        }

        private static class Proxy
        implements ISessionController {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendCommand(String packageName, String command, Bundle args, ResultReceiver cb) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(command);
                    _data.writeTypedObject(args, 0);
                    _data.writeTypedObject(cb, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean sendMediaButton(String packageName, KeyEvent mediaButton) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(mediaButton, 0);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerCallback(String packageName, ISessionControllerCallback cb) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeStrongInterface(cb);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterCallback(ISessionControllerCallback cb) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(cb);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getPackageName() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getTag() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Bundle getSessionInfo() throws RemoteException {
                Bundle _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Bundle.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PendingIntent getLaunchPendingIntent() throws RemoteException {
                PendingIntent _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(PendingIntent.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getFlags() throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public MediaController.PlaybackInfo getVolumeAttributes() throws RemoteException {
                MediaController.PlaybackInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(MediaController.PlaybackInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void adjustVolume(String packageName, String opPackageName, int direction, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(opPackageName);
                    _data.writeInt(direction);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setVolumeTo(String packageName, String opPackageName, int value, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(opPackageName);
                    _data.writeInt(value);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void prepare(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void prepareFromMediaId(String packageName, String mediaId, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(mediaId);
                    _data.writeTypedObject(extras, 0);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void prepareFromSearch(String packageName, String string2, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(string2);
                    _data.writeTypedObject(extras, 0);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void prepareFromUri(String packageName, Uri uri, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(uri, 0);
                    _data.writeTypedObject(extras, 0);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void play(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void playFromMediaId(String packageName, String mediaId, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(mediaId);
                    _data.writeTypedObject(extras, 0);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void playFromSearch(String packageName, String string2, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(string2);
                    _data.writeTypedObject(extras, 0);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void playFromUri(String packageName, Uri uri, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(uri, 0);
                    _data.writeTypedObject(extras, 0);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void skipToQueueItem(String packageName, long id2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeLong(id2);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void pause(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stop(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void next(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void previous(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void fastForward(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void rewind(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void seekTo(String packageName, long pos) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeLong(pos);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void rate(String packageName, Rating rating) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(rating, 0);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPlaybackSpeed(String packageName, float speed) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeFloat(speed);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendCustomAction(String packageName, String action, Bundle args) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(action);
                    _data.writeTypedObject(args, 0);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public MediaMetadata getMetadata() throws RemoteException {
                MediaMetadata _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(MediaMetadata.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PlaybackState getPlaybackState() throws RemoteException {
                PlaybackState _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(PlaybackState.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getQueue() throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CharSequence getQueueTitle() throws RemoteException {
                CharSequence _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(TextUtils.CHAR_SEQUENCE_CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Bundle getExtras() throws RemoteException {
                Bundle _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Bundle.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getRatingType() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements ISessionController {
        @Override
        public void sendCommand(String packageName, String command, Bundle args, ResultReceiver cb) throws RemoteException {
        }

        @Override
        public boolean sendMediaButton(String packageName, KeyEvent mediaButton) throws RemoteException {
            return false;
        }

        @Override
        public void registerCallback(String packageName, ISessionControllerCallback cb) throws RemoteException {
        }

        @Override
        public void unregisterCallback(ISessionControllerCallback cb) throws RemoteException {
        }

        @Override
        public String getPackageName() throws RemoteException {
            return null;
        }

        @Override
        public String getTag() throws RemoteException {
            return null;
        }

        @Override
        public Bundle getSessionInfo() throws RemoteException {
            return null;
        }

        @Override
        public PendingIntent getLaunchPendingIntent() throws RemoteException {
            return null;
        }

        @Override
        public long getFlags() throws RemoteException {
            return 0L;
        }

        @Override
        public MediaController.PlaybackInfo getVolumeAttributes() throws RemoteException {
            return null;
        }

        @Override
        public void adjustVolume(String packageName, String opPackageName, int direction, int flags) throws RemoteException {
        }

        @Override
        public void setVolumeTo(String packageName, String opPackageName, int value, int flags) throws RemoteException {
        }

        @Override
        public void prepare(String packageName) throws RemoteException {
        }

        @Override
        public void prepareFromMediaId(String packageName, String mediaId, Bundle extras) throws RemoteException {
        }

        @Override
        public void prepareFromSearch(String packageName, String string2, Bundle extras) throws RemoteException {
        }

        @Override
        public void prepareFromUri(String packageName, Uri uri, Bundle extras) throws RemoteException {
        }

        @Override
        public void play(String packageName) throws RemoteException {
        }

        @Override
        public void playFromMediaId(String packageName, String mediaId, Bundle extras) throws RemoteException {
        }

        @Override
        public void playFromSearch(String packageName, String string2, Bundle extras) throws RemoteException {
        }

        @Override
        public void playFromUri(String packageName, Uri uri, Bundle extras) throws RemoteException {
        }

        @Override
        public void skipToQueueItem(String packageName, long id2) throws RemoteException {
        }

        @Override
        public void pause(String packageName) throws RemoteException {
        }

        @Override
        public void stop(String packageName) throws RemoteException {
        }

        @Override
        public void next(String packageName) throws RemoteException {
        }

        @Override
        public void previous(String packageName) throws RemoteException {
        }

        @Override
        public void fastForward(String packageName) throws RemoteException {
        }

        @Override
        public void rewind(String packageName) throws RemoteException {
        }

        @Override
        public void seekTo(String packageName, long pos) throws RemoteException {
        }

        @Override
        public void rate(String packageName, Rating rating) throws RemoteException {
        }

        @Override
        public void setPlaybackSpeed(String packageName, float speed) throws RemoteException {
        }

        @Override
        public void sendCustomAction(String packageName, String action, Bundle args) throws RemoteException {
        }

        @Override
        public MediaMetadata getMetadata() throws RemoteException {
            return null;
        }

        @Override
        public PlaybackState getPlaybackState() throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice getQueue() throws RemoteException {
            return null;
        }

        @Override
        public CharSequence getQueueTitle() throws RemoteException {
            return null;
        }

        @Override
        public Bundle getExtras() throws RemoteException {
            return null;
        }

        @Override
        public int getRatingType() throws RemoteException {
            return 0;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

