/*
 * Decompiled with CFR 0.152.
 */
package android.media.projection;

import android.compat.annotation.UnsupportedAppUsage;
import android.media.projection.IMediaProjection;
import android.media.projection.IMediaProjectionWatcherCallback;
import android.media.projection.MediaProjectionInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.ContentRecordingSession;

public interface IMediaProjectionManager
extends IInterface {
    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/media/java/android/media/projection/IMediaProjectionManager.aidl:28:1:28:25")
    public boolean hasProjectionPermission(int var1, String var2) throws RemoteException;

    public IMediaProjection createProjection(int var1, String var2, int var3, boolean var4) throws RemoteException;

    public boolean isValidMediaProjection(IMediaProjection var1) throws RemoteException;

    public MediaProjectionInfo getActiveProjectionInfo() throws RemoteException;

    public void stopActiveProjection() throws RemoteException;

    public void addCallback(IMediaProjectionWatcherCallback var1) throws RemoteException;

    public void removeCallback(IMediaProjectionWatcherCallback var1) throws RemoteException;

    public void setContentRecordingSession(ContentRecordingSession var1, IMediaProjection var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMediaProjectionManager {
        public static final String DESCRIPTOR = "android.media.projection.IMediaProjectionManager";
        static final int TRANSACTION_hasProjectionPermission = 1;
        static final int TRANSACTION_createProjection = 2;
        static final int TRANSACTION_isValidMediaProjection = 3;
        static final int TRANSACTION_getActiveProjectionInfo = 4;
        static final int TRANSACTION_stopActiveProjection = 5;
        static final int TRANSACTION_addCallback = 6;
        static final int TRANSACTION_removeCallback = 7;
        static final int TRANSACTION_setContentRecordingSession = 8;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IMediaProjectionManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IMediaProjectionManager) {
                return (IMediaProjectionManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "hasProjectionPermission";
                }
                case 2: {
                    return "createProjection";
                }
                case 3: {
                    return "isValidMediaProjection";
                }
                case 4: {
                    return "getActiveProjectionInfo";
                }
                case 5: {
                    return "stopActiveProjection";
                }
                case 6: {
                    return "addCallback";
                }
                case 7: {
                    return "removeCallback";
                }
                case 8: {
                    return "setContentRecordingSession";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.hasProjectionPermission(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    boolean _arg3 = data.readBoolean();
                    data.enforceNoDataAvail();
                    IMediaProjection _result = this.createProjection(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 3: {
                    IMediaProjection _arg0 = IMediaProjection.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    boolean _result = this.isValidMediaProjection(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 4: {
                    MediaProjectionInfo _result = this.getActiveProjectionInfo();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 5: {
                    this.stopActiveProjection();
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    IMediaProjectionWatcherCallback _arg0 = IMediaProjectionWatcherCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.addCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    IMediaProjectionWatcherCallback _arg0 = IMediaProjectionWatcherCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    ContentRecordingSession _arg0 = data.readTypedObject(ContentRecordingSession.CREATOR);
                    IMediaProjection _arg1 = IMediaProjection.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setContentRecordingSession(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 7;
        }

        private static class Proxy
        implements IMediaProjectionManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasProjectionPermission(int uid, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IMediaProjection createProjection(int uid, String packageName, int type, boolean permanentGrant) throws RemoteException {
                IMediaProjection _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeString(packageName);
                    _data.writeInt(type);
                    _data.writeBoolean(permanentGrant);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = IMediaProjection.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isValidMediaProjection(IMediaProjection projection) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(projection);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public MediaProjectionInfo getActiveProjectionInfo() throws RemoteException {
                MediaProjectionInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(MediaProjectionInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopActiveProjection() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addCallback(IMediaProjectionWatcherCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeCallback(IMediaProjectionWatcherCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setContentRecordingSession(ContentRecordingSession incomingSession, IMediaProjection projection) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(incomingSession, 0);
                    _data.writeStrongInterface(projection);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IMediaProjectionManager {
        @Override
        public boolean hasProjectionPermission(int uid, String packageName) throws RemoteException {
            return false;
        }

        @Override
        public IMediaProjection createProjection(int uid, String packageName, int type, boolean permanentGrant) throws RemoteException {
            return null;
        }

        @Override
        public boolean isValidMediaProjection(IMediaProjection projection) throws RemoteException {
            return false;
        }

        @Override
        public MediaProjectionInfo getActiveProjectionInfo() throws RemoteException {
            return null;
        }

        @Override
        public void stopActiveProjection() throws RemoteException {
        }

        @Override
        public void addCallback(IMediaProjectionWatcherCallback callback) throws RemoteException {
        }

        @Override
        public void removeCallback(IMediaProjectionWatcherCallback callback) throws RemoteException {
        }

        @Override
        public void setContentRecordingSession(ContentRecordingSession incomingSession, IMediaProjection projection) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

