/*
 * Decompiled with CFR 0.152.
 */
package android.media.musicrecognition;

import android.media.MediaMetadata;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IMusicRecognitionManagerCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.media.musicrecognition.IMusicRecognitionManagerCallback";

    public void onRecognitionSucceeded(MediaMetadata var1, Bundle var2) throws RemoteException;

    public void onRecognitionFailed(int var1) throws RemoteException;

    public void onAudioStreamClosed() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMusicRecognitionManagerCallback {
        static final int TRANSACTION_onRecognitionSucceeded = 1;
        static final int TRANSACTION_onRecognitionFailed = 2;
        static final int TRANSACTION_onAudioStreamClosed = 3;

        public Stub() {
            this.attachInterface(this, IMusicRecognitionManagerCallback.DESCRIPTOR);
        }

        public static IMusicRecognitionManagerCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IMusicRecognitionManagerCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IMusicRecognitionManagerCallback) {
                return (IMusicRecognitionManagerCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onRecognitionSucceeded";
                }
                case 2: {
                    return "onRecognitionFailed";
                }
                case 3: {
                    return "onAudioStreamClosed";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IMusicRecognitionManagerCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    MediaMetadata _arg0 = data.readTypedObject(MediaMetadata.CREATOR);
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.onRecognitionSucceeded(_arg0, _arg1);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onRecognitionFailed(_arg0);
                    break;
                }
                case 3: {
                    this.onAudioStreamClosed();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 2;
        }

        private static class Proxy
        implements IMusicRecognitionManagerCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IMusicRecognitionManagerCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRecognitionSucceeded(MediaMetadata result, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMusicRecognitionManagerCallback.DESCRIPTOR);
                    _data.writeTypedObject(result, 0);
                    _data.writeTypedObject(extras, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRecognitionFailed(int failureCode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMusicRecognitionManagerCallback.DESCRIPTOR);
                    _data.writeInt(failureCode);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onAudioStreamClosed() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMusicRecognitionManagerCallback.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IMusicRecognitionManagerCallback {
        @Override
        public void onRecognitionSucceeded(MediaMetadata result, Bundle extras) throws RemoteException {
        }

        @Override
        public void onRecognitionFailed(int failureCode) throws RemoteException {
        }

        @Override
        public void onAudioStreamClosed() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

