/*
 * Decompiled with CFR 0.152.
 */
package android.media.metrics;

import android.annotation.NonNull;
import android.media.metrics.LogSessionId;
import android.media.metrics.MediaMetricsManager;
import android.os.PersistableBundle;
import com.android.internal.util.AnnotationValidations;
import java.util.Objects;

public class BundleSession
implements AutoCloseable {
    private final String mId;
    private final MediaMetricsManager mManager;
    private final LogSessionId mLogSessionId;
    public static final String KEY_STATSD_ATOM = "bundlesession-statsd-atom";

    public BundleSession(String id2, MediaMetricsManager manager) {
        this.mId = id2;
        this.mManager = manager;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mId);
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mManager);
        this.mLogSessionId = new LogSessionId(this.mId);
    }

    public void reportBundleMetrics(PersistableBundle metrics) {
        this.mManager.reportBundleMetrics(this.mId, metrics);
    }

    public LogSessionId getSessionId() {
        return this.mLogSessionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BundleSession that = (BundleSession)o;
        return Objects.equals(this.mId, that.mId);
    }

    public int hashCode() {
        return Objects.hash(this.mId);
    }

    @Override
    public void close() {
        this.mManager.releaseSessionId(this.mLogSessionId.getStringId());
    }
}

