/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.compat.annotation.UnsupportedAppUsage;
import android.media.InterpolatorConfig;
import android.media.InterpolatorType;
import android.media.PlayerBase;
import android.media.VolumeShaperConfiguration;
import android.media.VolumeShaperConfigurationType;
import android.media.VolumeShaperOperation;
import android.media.VolumeShaperState;
import android.os.BadParcelableException;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Objects;

public class VolumeShaper
implements AutoCloseable {
    private int mId;
    private final WeakReference<PlayerBase> mWeakPlayerBase;

    VolumeShaper(Configuration configuration, PlayerBase playerBase) {
        this.mWeakPlayerBase = new WeakReference<PlayerBase>(playerBase);
        this.mId = this.applyPlayer(configuration, new Operation.Builder().defer().build());
    }

    int getId() {
        return this.mId;
    }

    public void apply(Operation operation) {
        this.applyPlayer(new Configuration(this.mId), operation);
    }

    public void replace(Configuration configuration, Operation operation, boolean join) {
        this.mId = this.applyPlayer(configuration, new Operation.Builder(operation).replace(this.mId, join).build());
    }

    public float getVolume() {
        return this.getStatePlayer(this.mId).getVolume();
    }

    @Override
    public void close() {
        try {
            this.applyPlayer(new Configuration(this.mId), new Operation.Builder().terminate().build());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (this.mWeakPlayerBase != null) {
            this.mWeakPlayerBase.clear();
        }
    }

    protected void finalize() {
        this.close();
    }

    private int applyPlayer(Configuration configuration, Operation operation) {
        PlayerBase player;
        if (this.mWeakPlayerBase != null) {
            player = (PlayerBase)this.mWeakPlayerBase.get();
            if (player == null) {
                throw new IllegalStateException("player deallocated");
            }
        } else {
            throw new IllegalStateException("uninitialized shaper");
        }
        int id2 = player.playerApplyVolumeShaper(configuration, operation);
        if (id2 < 0) {
            int VOLUME_SHAPER_INVALID_OPERATION = -38;
            if (id2 == -38) {
                throw new IllegalStateException("player or VolumeShaper deallocated");
            }
            throw new IllegalArgumentException("invalid configuration or operation: " + id2);
        }
        return id2;
    }

    private State getStatePlayer(int id2) {
        PlayerBase player;
        if (this.mWeakPlayerBase != null) {
            player = (PlayerBase)this.mWeakPlayerBase.get();
            if (player == null) {
                throw new IllegalStateException("player deallocated");
            }
        } else {
            throw new IllegalStateException("uninitialized shaper");
        }
        State state = player.playerGetVolumeShaperState(id2);
        if (state == null) {
            throw new IllegalStateException("shaper cannot be found");
        }
        return state;
    }

    public static class State
    implements Parcelable {
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        private float mVolume;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        private float mXOffset;
        public static final Parcelable.Creator<State> CREATOR = new Parcelable.Creator<State>(){

            @Override
            public State createFromParcel(Parcel p) {
                return State.fromParcelable(VolumeShaperState.CREATOR.createFromParcel(p));
            }

            public State[] newArray(int size) {
                return new State[size];
            }
        };

        public String toString() {
            return "VolumeShaper.State{mVolume = " + this.mVolume + ", mXOffset = " + this.mXOffset + "}";
        }

        public int hashCode() {
            return Objects.hash(Float.valueOf(this.mVolume), Float.valueOf(this.mXOffset));
        }

        public boolean equals(Object o) {
            if (!(o instanceof State)) {
                return false;
            }
            if (o == this) {
                return true;
            }
            State other = (State)o;
            return this.mVolume == other.mVolume && this.mXOffset == other.mXOffset;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            this.toParcelable().writeToParcel(dest, flags);
        }

        public VolumeShaperState toParcelable() {
            VolumeShaperState result = new VolumeShaperState();
            result.volume = this.mVolume;
            result.xOffset = this.mXOffset;
            return result;
        }

        public static State fromParcelable(VolumeShaperState p) {
            return new State(p.volume, p.xOffset);
        }

        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        State(float volume, float xOffset) {
            this.mVolume = volume;
            this.mXOffset = xOffset;
        }

        public float getVolume() {
            return this.mVolume;
        }

        public float getXOffset() {
            return this.mXOffset;
        }
    }

    public static class Operation
    implements Parcelable {
        public static final Operation PLAY = new Builder().build();
        public static final Operation REVERSE = new Builder().reverse().build();
        private static final int FLAG_NONE = 0;
        private static final int FLAG_REVERSE = 1;
        private static final int FLAG_TERMINATE = 2;
        private static final int FLAG_JOIN = 4;
        private static final int FLAG_DEFER = 8;
        private static final int FLAG_CREATE_IF_NEEDED = 16;
        private static final int FLAG_PUBLIC_ALL = 3;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        private final int mFlags;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        private final int mReplaceId;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        private final float mXOffset;
        public static final Parcelable.Creator<Operation> CREATOR = new Parcelable.Creator<Operation>(){

            @Override
            public Operation createFromParcel(Parcel p) {
                return Operation.fromParcelable(VolumeShaperOperation.CREATOR.createFromParcel(p));
            }

            public Operation[] newArray(int size) {
                return new Operation[size];
            }
        };

        public String toString() {
            return "VolumeShaper.Operation{mFlags = 0x" + Integer.toHexString(this.mFlags).toUpperCase() + ", mReplaceId = " + this.mReplaceId + ", mXOffset = " + this.mXOffset + "}";
        }

        public int hashCode() {
            return Objects.hash(this.mFlags, this.mReplaceId, Float.valueOf(this.mXOffset));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Operation)) {
                return false;
            }
            if (o == this) {
                return true;
            }
            Operation other = (Operation)o;
            return this.mFlags == other.mFlags && this.mReplaceId == other.mReplaceId && Float.compare(this.mXOffset, other.mXOffset) == 0;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            this.toParcelable().writeToParcel(dest, flags);
        }

        public VolumeShaperOperation toParcelable() {
            VolumeShaperOperation result = new VolumeShaperOperation();
            result.flags = Operation.flagsToAidl(this.mFlags);
            result.replaceId = this.mReplaceId;
            result.xOffset = this.mXOffset;
            return result;
        }

        public static Operation fromParcelable(VolumeShaperOperation parcelable) {
            return new Operation(Operation.flagsFromAidl(parcelable.flags), parcelable.replaceId, parcelable.xOffset);
        }

        private static int flagsFromAidl(int aidl) {
            int result = 0;
            if ((aidl & 1) != 0) {
                result |= 1;
            }
            if ((aidl & 2) != 0) {
                result |= 2;
            }
            if ((aidl & 4) != 0) {
                result |= 4;
            }
            if ((aidl & 8) != 0) {
                result |= 8;
            }
            if ((aidl & 0x10) != 0) {
                result |= 0x10;
            }
            return result;
        }

        private static int flagsToAidl(int flags) {
            int result = 0;
            if ((flags & 1) != 0) {
                result |= 1;
            }
            if ((flags & 2) != 0) {
                result |= 2;
            }
            if ((flags & 4) != 0) {
                result |= 4;
            }
            if ((flags & 8) != 0) {
                result |= 8;
            }
            if ((flags & 0x10) != 0) {
                result |= 0x10;
            }
            return result;
        }

        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        private Operation(int flags, int replaceId, float xOffset) {
            this.mFlags = flags;
            this.mReplaceId = replaceId;
            this.mXOffset = xOffset;
        }

        public static class Builder {
            int mFlags;
            int mReplaceId;
            float mXOffset;

            public Builder() {
                this.mFlags = 0;
                this.mReplaceId = -1;
                this.mXOffset = Float.NaN;
            }

            public Builder(Operation operation) {
                this.mReplaceId = operation.mReplaceId;
                this.mFlags = operation.mFlags;
                this.mXOffset = operation.mXOffset;
            }

            public Builder replace(int id2, boolean join) {
                this.mReplaceId = id2;
                this.mFlags = join ? (this.mFlags |= 4) : (this.mFlags &= 0xFFFFFFFB);
                return this;
            }

            public Builder defer() {
                this.mFlags |= 8;
                return this;
            }

            public Builder terminate() {
                this.mFlags |= 2;
                return this;
            }

            public Builder reverse() {
                this.mFlags ^= 1;
                return this;
            }

            public Builder createIfNeeded() {
                this.mFlags |= 0x10;
                return this;
            }

            public Builder setXOffset(float xOffset) {
                if (xOffset < -0.0f) {
                    throw new IllegalArgumentException("Negative xOffset not allowed");
                }
                if (xOffset > 1.0f) {
                    throw new IllegalArgumentException("xOffset > 1.f not allowed");
                }
                this.mXOffset = xOffset;
                return this;
            }

            private Builder setFlags(int flags) {
                if ((flags & 0xFFFFFFFC) != 0) {
                    throw new IllegalArgumentException("flag has unknown bits set: " + flags);
                }
                this.mFlags = this.mFlags & 0xFFFFFFFC | flags;
                return this;
            }

            public Operation build() {
                return new Operation(this.mFlags, this.mReplaceId, this.mXOffset);
            }
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Flag {
        }
    }

    public static class Configuration
    implements Parcelable {
        private static final int MAXIMUM_CURVE_POINTS = 16;
        static final int TYPE_ID = 0;
        static final int TYPE_SCALE = 1;
        public static final int INTERPOLATOR_TYPE_STEP = 0;
        public static final int INTERPOLATOR_TYPE_LINEAR = 1;
        public static final int INTERPOLATOR_TYPE_CUBIC = 2;
        public static final int INTERPOLATOR_TYPE_CUBIC_MONOTONIC = 3;
        public static final int OPTION_FLAG_VOLUME_IN_DBFS = 1;
        public static final int OPTION_FLAG_CLOCK_TIME = 2;
        private static final int OPTION_FLAG_PUBLIC_ALL = 3;
        public static final Configuration LINEAR_RAMP = new Builder().setInterpolatorType(1).setCurve(new float[]{0.0f, 1.0f}, new float[]{0.0f, 1.0f}).setDuration(1000L).build();
        public static final Configuration CUBIC_RAMP = new Builder().setInterpolatorType(2).setCurve(new float[]{0.0f, 1.0f}, new float[]{0.0f, 1.0f}).setDuration(1000L).build();
        public static final Configuration SINE_RAMP;
        public static final Configuration SCURVE_RAMP;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        private final int mType;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        private final int mId;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        private final int mOptionFlags;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        private final double mDurationMs;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        private final int mInterpolatorType;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        private final float[] mTimes;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        private final float[] mVolumes;
        public static final Parcelable.Creator<Configuration> CREATOR;

        public static int getMaximumCurvePoints() {
            return 16;
        }

        public String toString() {
            return "VolumeShaper.Configuration{mType = " + this.mType + ", mId = " + this.mId + (this.mType == 0 ? "}" : ", mOptionFlags = 0x" + Integer.toHexString(this.mOptionFlags).toUpperCase() + ", mDurationMs = " + this.mDurationMs + ", mInterpolatorType = " + this.mInterpolatorType + ", mTimes[] = " + Arrays.toString(this.mTimes) + ", mVolumes[] = " + Arrays.toString(this.mVolumes) + "}");
        }

        public int hashCode() {
            return this.mType == 0 ? Objects.hash(this.mType, this.mId) : Objects.hash(this.mType, this.mId, this.mOptionFlags, this.mDurationMs, this.mInterpolatorType, Arrays.hashCode(this.mTimes), Arrays.hashCode(this.mVolumes));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Configuration)) {
                return false;
            }
            if (o == this) {
                return true;
            }
            Configuration other = (Configuration)o;
            return this.mType == other.mType && this.mId == other.mId && (this.mType == 0 || this.mOptionFlags == other.mOptionFlags && this.mDurationMs == other.mDurationMs && this.mInterpolatorType == other.mInterpolatorType && Arrays.equals(this.mTimes, other.mTimes) && Arrays.equals(this.mVolumes, other.mVolumes));
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            VolumeShaperConfiguration parcelable = this.toParcelable();
            parcelable.writeToParcel(dest, flags);
        }

        public VolumeShaperConfiguration toParcelable() {
            VolumeShaperConfiguration parcelable = new VolumeShaperConfiguration();
            parcelable.type = Configuration.typeToAidl(this.mType);
            parcelable.id = this.mId;
            if (this.mType != 0) {
                parcelable.optionFlags = Configuration.optionFlagsToAidl(this.mOptionFlags);
                parcelable.durationMs = this.mDurationMs;
                parcelable.interpolatorConfig = this.toInterpolatorParcelable();
            }
            return parcelable;
        }

        private InterpolatorConfig toInterpolatorParcelable() {
            InterpolatorConfig parcelable = new InterpolatorConfig();
            parcelable.type = Configuration.interpolatorTypeToAidl(this.mInterpolatorType);
            parcelable.firstSlope = 0.0f;
            parcelable.lastSlope = 0.0f;
            parcelable.xy = new float[this.mTimes.length * 2];
            for (int i = 0; i < this.mTimes.length; ++i) {
                parcelable.xy[i * 2] = this.mTimes[i];
                parcelable.xy[i * 2 + 1] = this.mVolumes[i];
            }
            return parcelable;
        }

        public static Configuration fromParcelable(VolumeShaperConfiguration parcelable) {
            int type = Configuration.typeFromAidl(parcelable.type);
            int id2 = parcelable.id;
            if (type == 0) {
                return new Configuration(id2);
            }
            int optionFlags = Configuration.optionFlagsFromAidl(parcelable.optionFlags);
            double durationMs = parcelable.durationMs;
            int interpolatorType = Configuration.interpolatorTypeFromAidl(parcelable.interpolatorConfig.type);
            int length = parcelable.interpolatorConfig.xy.length;
            if (length % 2 != 0) {
                throw new BadParcelableException("xy length must be even");
            }
            float[] times = new float[length / 2];
            float[] volumes = new float[length / 2];
            for (int i = 0; i < length / 2; ++i) {
                times[i] = parcelable.interpolatorConfig.xy[i * 2];
                volumes[i] = parcelable.interpolatorConfig.xy[i * 2 + 1];
            }
            return new Configuration(type, id2, optionFlags, durationMs, interpolatorType, times, volumes);
        }

        private static int interpolatorTypeFromAidl(@android.media.InterpolatorType int aidl) {
            switch (aidl) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
            }
            throw new BadParcelableException("Unknown interpolator type");
        }

        @android.media.InterpolatorType
        private static int interpolatorTypeToAidl(int type) {
            switch (type) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
            }
            throw new RuntimeException("Unknown interpolator type");
        }

        private static int typeFromAidl(@VolumeShaperConfigurationType int aidl) {
            switch (aidl) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
            }
            throw new BadParcelableException("Unknown type");
        }

        @VolumeShaperConfigurationType
        private static int typeToAidl(int type) {
            switch (type) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
            }
            throw new RuntimeException("Unknown type");
        }

        private static int optionFlagsFromAidl(int aidl) {
            int result = 0;
            if ((aidl & 1) != 0) {
                result |= 1;
            }
            if ((aidl & 2) != 0) {
                result |= 2;
            }
            return result;
        }

        private static int optionFlagsToAidl(int flags) {
            int result = 0;
            if ((flags & 1) != 0) {
                result |= 1;
            }
            if ((flags & 2) != 0) {
                result |= 2;
            }
            return result;
        }

        public Configuration(int id2) {
            if (id2 < 0) {
                throw new IllegalArgumentException("negative id " + id2);
            }
            this.mType = 0;
            this.mId = id2;
            this.mInterpolatorType = 0;
            this.mOptionFlags = 0;
            this.mDurationMs = 0.0;
            this.mTimes = null;
            this.mVolumes = null;
        }

        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        private Configuration(int type, int id2, int optionFlags, double durationMs, int interpolatorType, float[] times, float[] volumes) {
            this.mType = type;
            this.mId = id2;
            this.mOptionFlags = optionFlags;
            this.mDurationMs = durationMs;
            this.mInterpolatorType = interpolatorType;
            this.mTimes = times;
            this.mVolumes = volumes;
        }

        public int getType() {
            return this.mType;
        }

        public int getId() {
            return this.mId;
        }

        public int getInterpolatorType() {
            return this.mInterpolatorType;
        }

        public int getOptionFlags() {
            return this.mOptionFlags & 3;
        }

        int getAllOptionFlags() {
            return this.mOptionFlags;
        }

        public long getDuration() {
            return (long)this.mDurationMs;
        }

        public float[] getTimes() {
            return this.mTimes;
        }

        public float[] getVolumes() {
            return this.mVolumes;
        }

        private static String checkCurveForErrors(float[] times, float[] volumes, boolean log) {
            int i;
            if (times == null) {
                return "times array must be non-null";
            }
            if (volumes == null) {
                return "volumes array must be non-null";
            }
            if (times.length != volumes.length) {
                return "array length must match";
            }
            if (times.length < 2) {
                return "array length must be at least 2";
            }
            if (times.length > 16) {
                return "array length must be no larger than 16";
            }
            if (times[0] != 0.0f) {
                return "times must start at 0.f";
            }
            if (times[times.length - 1] != 1.0f) {
                return "times must end at 1.f";
            }
            for (i = 1; i < times.length; ++i) {
                if (times[i] > times[i - 1]) continue;
                return "times not monotonic increasing, check index " + i;
            }
            if (log) {
                for (i = 0; i < volumes.length; ++i) {
                    if (volumes[i] <= 0.0f) continue;
                    return "volumes for log scale cannot be positive, check index " + i;
                }
            } else {
                for (i = 0; i < volumes.length; ++i) {
                    if (volumes[i] >= 0.0f && volumes[i] <= 1.0f) continue;
                    return "volumes for linear scale must be between 0.f and 1.f, check index " + i;
                }
            }
            return null;
        }

        private static void checkCurveForErrorsAndThrowException(float[] times, float[] volumes, boolean log, boolean ise) {
            String error = Configuration.checkCurveForErrors(times, volumes, log);
            if (error != null) {
                if (ise) {
                    throw new IllegalStateException(error);
                }
                throw new IllegalArgumentException(error);
            }
        }

        private static void checkValidVolumeAndThrowException(float volume, boolean log) {
            if (log) {
                if (!(volume <= 0.0f)) {
                    throw new IllegalArgumentException("dbfs volume must be 0.f or less");
                }
            } else if (!(volume >= 0.0f) || !(volume <= 1.0f)) {
                throw new IllegalArgumentException("volume must be >= 0.f and <= 1.f");
            }
        }

        private static void clampVolume(float[] volumes, boolean log) {
            if (log) {
                for (int i = 0; i < volumes.length; ++i) {
                    if (volumes[i] <= 0.0f) continue;
                    volumes[i] = 0.0f;
                }
            } else {
                for (int i = 0; i < volumes.length; ++i) {
                    if (!(volumes[i] >= 0.0f)) {
                        volumes[i] = 0.0f;
                        continue;
                    }
                    if (volumes[i] <= 1.0f) continue;
                    volumes[i] = 1.0f;
                }
            }
        }

        static {
            int POINTS = 16;
            float[] times = new float[16];
            float[] sines = new float[16];
            float[] scurve = new float[16];
            for (int i = 0; i < 16; ++i) {
                float sine;
                times[i] = (float)i / 15.0f;
                sines[i] = sine = (float)Math.sin((double)times[i] * Math.PI / 2.0);
                scurve[i] = sine * sine;
            }
            SINE_RAMP = new Builder().setInterpolatorType(2).setCurve(times, sines).setDuration(1000L).build();
            SCURVE_RAMP = new Builder().setInterpolatorType(2).setCurve(times, scurve).setDuration(1000L).build();
            CREATOR = new Parcelable.Creator<Configuration>(){

                @Override
                public Configuration createFromParcel(Parcel p) {
                    return Configuration.fromParcelable(VolumeShaperConfiguration.CREATOR.createFromParcel(p));
                }

                public Configuration[] newArray(int size) {
                    return new Configuration[size];
                }
            };
        }

        public static class Builder {
            private int mType = 1;
            private int mId = -1;
            private int mInterpolatorType = 2;
            private int mOptionFlags = 2;
            private double mDurationMs = 1000.0;
            private float[] mTimes = null;
            private float[] mVolumes = null;

            public Builder() {
            }

            public Builder(Configuration configuration) {
                this.mType = configuration.getType();
                this.mId = configuration.getId();
                this.mOptionFlags = configuration.getAllOptionFlags();
                this.mInterpolatorType = configuration.getInterpolatorType();
                this.mDurationMs = configuration.getDuration();
                this.mTimes = (float[])configuration.getTimes().clone();
                this.mVolumes = (float[])configuration.getVolumes().clone();
            }

            public Builder setId(int id2) {
                if (id2 < -1) {
                    throw new IllegalArgumentException("invalid id: " + id2);
                }
                this.mId = id2;
                return this;
            }

            public Builder setInterpolatorType(int interpolatorType) {
                switch (interpolatorType) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        this.mInterpolatorType = interpolatorType;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid interpolatorType: " + interpolatorType);
                    }
                }
                return this;
            }

            public Builder setOptionFlags(int optionFlags) {
                if ((optionFlags & 0xFFFFFFFC) != 0) {
                    throw new IllegalArgumentException("invalid bits in flag: " + optionFlags);
                }
                this.mOptionFlags = this.mOptionFlags & 0xFFFFFFFC | optionFlags;
                return this;
            }

            public Builder setDuration(long durationMillis) {
                if (durationMillis <= 0L) {
                    throw new IllegalArgumentException("duration: " + durationMillis + " not positive");
                }
                this.mDurationMs = durationMillis;
                return this;
            }

            public Builder setCurve(float[] times, float[] volumes) {
                boolean log = (this.mOptionFlags & 1) != 0;
                Configuration.checkCurveForErrorsAndThrowException(times, volumes, log, false);
                this.mTimes = (float[])times.clone();
                this.mVolumes = (float[])volumes.clone();
                return this;
            }

            public Builder reflectTimes() {
                int i;
                boolean log = (this.mOptionFlags & 1) != 0;
                Configuration.checkCurveForErrorsAndThrowException(this.mTimes, this.mVolumes, log, true);
                for (i = 0; i < this.mTimes.length / 2; ++i) {
                    float temp = this.mTimes[i];
                    this.mTimes[i] = 1.0f - this.mTimes[this.mTimes.length - 1 - i];
                    this.mTimes[this.mTimes.length - 1 - i] = 1.0f - temp;
                    temp = this.mVolumes[i];
                    this.mVolumes[i] = this.mVolumes[this.mVolumes.length - 1 - i];
                    this.mVolumes[this.mVolumes.length - 1 - i] = temp;
                }
                if ((this.mTimes.length & 1) != 0) {
                    this.mTimes[i] = 1.0f - this.mTimes[i];
                }
                return this;
            }

            public Builder invertVolumes() {
                boolean log = (this.mOptionFlags & 1) != 0;
                Configuration.checkCurveForErrorsAndThrowException(this.mTimes, this.mVolumes, log, true);
                float min = this.mVolumes[0];
                float max = this.mVolumes[0];
                for (int i = 1; i < this.mVolumes.length; ++i) {
                    if (this.mVolumes[i] < min) {
                        min = this.mVolumes[i];
                        continue;
                    }
                    if (!(this.mVolumes[i] > max)) continue;
                    max = this.mVolumes[i];
                }
                float maxmin = max + min;
                for (int i = 0; i < this.mVolumes.length; ++i) {
                    this.mVolumes[i] = maxmin - this.mVolumes[i];
                }
                return this;
            }

            public Builder scaleToEndVolume(float volume) {
                boolean log = (this.mOptionFlags & 1) != 0;
                Configuration.checkCurveForErrorsAndThrowException(this.mTimes, this.mVolumes, log, true);
                Configuration.checkValidVolumeAndThrowException(volume, log);
                float startVolume = this.mVolumes[0];
                float endVolume = this.mVolumes[this.mVolumes.length - 1];
                if (endVolume == startVolume) {
                    float offset = volume - startVolume;
                    for (int i = 0; i < this.mVolumes.length; ++i) {
                        this.mVolumes[i] = this.mVolumes[i] + offset * this.mTimes[i];
                    }
                } else {
                    float scale = (volume - startVolume) / (endVolume - startVolume);
                    for (int i = 0; i < this.mVolumes.length; ++i) {
                        this.mVolumes[i] = scale * (this.mVolumes[i] - startVolume) + startVolume;
                    }
                }
                Configuration.clampVolume(this.mVolumes, log);
                return this;
            }

            public Builder scaleToStartVolume(float volume) {
                boolean log = (this.mOptionFlags & 1) != 0;
                Configuration.checkCurveForErrorsAndThrowException(this.mTimes, this.mVolumes, log, true);
                Configuration.checkValidVolumeAndThrowException(volume, log);
                float startVolume = this.mVolumes[0];
                float endVolume = this.mVolumes[this.mVolumes.length - 1];
                if (endVolume == startVolume) {
                    float offset = volume - startVolume;
                    for (int i = 0; i < this.mVolumes.length; ++i) {
                        this.mVolumes[i] = this.mVolumes[i] + offset * (1.0f - this.mTimes[i]);
                    }
                } else {
                    float scale = (volume - endVolume) / (startVolume - endVolume);
                    for (int i = 0; i < this.mVolumes.length; ++i) {
                        this.mVolumes[i] = scale * (this.mVolumes[i] - endVolume) + endVolume;
                    }
                }
                Configuration.clampVolume(this.mVolumes, log);
                return this;
            }

            public Configuration build() {
                boolean log = (this.mOptionFlags & 1) != 0;
                Configuration.checkCurveForErrorsAndThrowException(this.mTimes, this.mVolumes, log, true);
                return new Configuration(this.mType, this.mId, this.mOptionFlags, this.mDurationMs, this.mInterpolatorType, this.mTimes, this.mVolumes);
            }
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface OptionFlag {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface InterpolatorType {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Type {
        }
    }
}

