/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ISpatializerHeadTrackingCallback
extends IInterface {
    public static final String DESCRIPTOR = "android$media$ISpatializerHeadTrackingCallback".replace('$', '.');

    public void onHeadTrackingModeChanged(byte var1) throws RemoteException;

    public void onHeadToSoundStagePoseUpdated(float[] var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISpatializerHeadTrackingCallback {
        static final int TRANSACTION_onHeadTrackingModeChanged = 1;
        static final int TRANSACTION_onHeadToSoundStagePoseUpdated = 2;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ISpatializerHeadTrackingCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ISpatializerHeadTrackingCallback) {
                return (ISpatializerHeadTrackingCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    byte _arg0 = data.readByte();
                    data.enforceNoDataAvail();
                    this.onHeadTrackingModeChanged(_arg0);
                    break;
                }
                case 2: {
                    float[] _arg0 = data.createFloatArray();
                    data.enforceNoDataAvail();
                    this.onHeadToSoundStagePoseUpdated(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements ISpatializerHeadTrackingCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onHeadTrackingModeChanged(byte mode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeByte(mode);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onHeadToSoundStagePoseUpdated(float[] headToStage) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeFloatArray(headToStage);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ISpatializerHeadTrackingCallback {
        @Override
        public void onHeadTrackingModeChanged(byte mode) throws RemoteException {
        }

        @Override
        public void onHeadToSoundStagePoseUpdated(float[] headToStage) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

