/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.IMediaRouter2;
import android.media.IMediaRouter2Manager;
import android.media.IMediaRouterClient;
import android.media.MediaRoute2Info;
import android.media.MediaRouterClientState;
import android.media.RouteDiscoveryPreference;
import android.media.RoutingSessionInfo;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IMediaRouterService
extends IInterface {
    public void registerClientAsUser(IMediaRouterClient var1, String var2, int var3) throws RemoteException;

    public void unregisterClient(IMediaRouterClient var1) throws RemoteException;

    public void registerClientGroupId(IMediaRouterClient var1, String var2) throws RemoteException;

    public MediaRouterClientState getState(IMediaRouterClient var1) throws RemoteException;

    public boolean isPlaybackActive(IMediaRouterClient var1) throws RemoteException;

    public void setBluetoothA2dpOn(IMediaRouterClient var1, boolean var2) throws RemoteException;

    public void setDiscoveryRequest(IMediaRouterClient var1, int var2, boolean var3) throws RemoteException;

    public void setSelectedRoute(IMediaRouterClient var1, String var2, boolean var3) throws RemoteException;

    public void requestSetVolume(IMediaRouterClient var1, String var2, int var3) throws RemoteException;

    public void requestUpdateVolume(IMediaRouterClient var1, String var2, int var3) throws RemoteException;

    public void enforceMediaContentControlPermission() throws RemoteException;

    public List<MediaRoute2Info> getSystemRoutes() throws RemoteException;

    public RoutingSessionInfo getSystemSessionInfo() throws RemoteException;

    public void registerRouter2(IMediaRouter2 var1, String var2) throws RemoteException;

    public void unregisterRouter2(IMediaRouter2 var1) throws RemoteException;

    public void setDiscoveryRequestWithRouter2(IMediaRouter2 var1, RouteDiscoveryPreference var2) throws RemoteException;

    public void setRouteVolumeWithRouter2(IMediaRouter2 var1, MediaRoute2Info var2, int var3) throws RemoteException;

    public void requestCreateSessionWithRouter2(IMediaRouter2 var1, int var2, long var3, RoutingSessionInfo var5, MediaRoute2Info var6, Bundle var7) throws RemoteException;

    public void selectRouteWithRouter2(IMediaRouter2 var1, String var2, MediaRoute2Info var3) throws RemoteException;

    public void deselectRouteWithRouter2(IMediaRouter2 var1, String var2, MediaRoute2Info var3) throws RemoteException;

    public void transferToRouteWithRouter2(IMediaRouter2 var1, String var2, MediaRoute2Info var3) throws RemoteException;

    public void setSessionVolumeWithRouter2(IMediaRouter2 var1, String var2, int var3) throws RemoteException;

    public void releaseSessionWithRouter2(IMediaRouter2 var1, String var2) throws RemoteException;

    public List<RoutingSessionInfo> getRemoteSessions(IMediaRouter2Manager var1) throws RemoteException;

    public RoutingSessionInfo getSystemSessionInfoForPackage(IMediaRouter2Manager var1, String var2) throws RemoteException;

    public void registerManager(IMediaRouter2Manager var1, String var2) throws RemoteException;

    public void unregisterManager(IMediaRouter2Manager var1) throws RemoteException;

    public void setRouteVolumeWithManager(IMediaRouter2Manager var1, int var2, MediaRoute2Info var3, int var4) throws RemoteException;

    public void startScan(IMediaRouter2Manager var1) throws RemoteException;

    public void stopScan(IMediaRouter2Manager var1) throws RemoteException;

    public void requestCreateSessionWithManager(IMediaRouter2Manager var1, int var2, RoutingSessionInfo var3, MediaRoute2Info var4) throws RemoteException;

    public void selectRouteWithManager(IMediaRouter2Manager var1, int var2, String var3, MediaRoute2Info var4) throws RemoteException;

    public void deselectRouteWithManager(IMediaRouter2Manager var1, int var2, String var3, MediaRoute2Info var4) throws RemoteException;

    public void transferToRouteWithManager(IMediaRouter2Manager var1, int var2, String var3, MediaRoute2Info var4) throws RemoteException;

    public void setSessionVolumeWithManager(IMediaRouter2Manager var1, int var2, String var3, int var4) throws RemoteException;

    public void releaseSessionWithManager(IMediaRouter2Manager var1, int var2, String var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMediaRouterService {
        public static final String DESCRIPTOR = "android.media.IMediaRouterService";
        static final int TRANSACTION_registerClientAsUser = 1;
        static final int TRANSACTION_unregisterClient = 2;
        static final int TRANSACTION_registerClientGroupId = 3;
        static final int TRANSACTION_getState = 4;
        static final int TRANSACTION_isPlaybackActive = 5;
        static final int TRANSACTION_setBluetoothA2dpOn = 6;
        static final int TRANSACTION_setDiscoveryRequest = 7;
        static final int TRANSACTION_setSelectedRoute = 8;
        static final int TRANSACTION_requestSetVolume = 9;
        static final int TRANSACTION_requestUpdateVolume = 10;
        static final int TRANSACTION_enforceMediaContentControlPermission = 11;
        static final int TRANSACTION_getSystemRoutes = 12;
        static final int TRANSACTION_getSystemSessionInfo = 13;
        static final int TRANSACTION_registerRouter2 = 14;
        static final int TRANSACTION_unregisterRouter2 = 15;
        static final int TRANSACTION_setDiscoveryRequestWithRouter2 = 16;
        static final int TRANSACTION_setRouteVolumeWithRouter2 = 17;
        static final int TRANSACTION_requestCreateSessionWithRouter2 = 18;
        static final int TRANSACTION_selectRouteWithRouter2 = 19;
        static final int TRANSACTION_deselectRouteWithRouter2 = 20;
        static final int TRANSACTION_transferToRouteWithRouter2 = 21;
        static final int TRANSACTION_setSessionVolumeWithRouter2 = 22;
        static final int TRANSACTION_releaseSessionWithRouter2 = 23;
        static final int TRANSACTION_getRemoteSessions = 24;
        static final int TRANSACTION_getSystemSessionInfoForPackage = 25;
        static final int TRANSACTION_registerManager = 26;
        static final int TRANSACTION_unregisterManager = 27;
        static final int TRANSACTION_setRouteVolumeWithManager = 28;
        static final int TRANSACTION_startScan = 29;
        static final int TRANSACTION_stopScan = 30;
        static final int TRANSACTION_requestCreateSessionWithManager = 31;
        static final int TRANSACTION_selectRouteWithManager = 32;
        static final int TRANSACTION_deselectRouteWithManager = 33;
        static final int TRANSACTION_transferToRouteWithManager = 34;
        static final int TRANSACTION_setSessionVolumeWithManager = 35;
        static final int TRANSACTION_releaseSessionWithManager = 36;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IMediaRouterService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IMediaRouterService) {
                return (IMediaRouterService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "registerClientAsUser";
                }
                case 2: {
                    return "unregisterClient";
                }
                case 3: {
                    return "registerClientGroupId";
                }
                case 4: {
                    return "getState";
                }
                case 5: {
                    return "isPlaybackActive";
                }
                case 6: {
                    return "setBluetoothA2dpOn";
                }
                case 7: {
                    return "setDiscoveryRequest";
                }
                case 8: {
                    return "setSelectedRoute";
                }
                case 9: {
                    return "requestSetVolume";
                }
                case 10: {
                    return "requestUpdateVolume";
                }
                case 11: {
                    return "enforceMediaContentControlPermission";
                }
                case 12: {
                    return "getSystemRoutes";
                }
                case 13: {
                    return "getSystemSessionInfo";
                }
                case 14: {
                    return "registerRouter2";
                }
                case 15: {
                    return "unregisterRouter2";
                }
                case 16: {
                    return "setDiscoveryRequestWithRouter2";
                }
                case 17: {
                    return "setRouteVolumeWithRouter2";
                }
                case 18: {
                    return "requestCreateSessionWithRouter2";
                }
                case 19: {
                    return "selectRouteWithRouter2";
                }
                case 20: {
                    return "deselectRouteWithRouter2";
                }
                case 21: {
                    return "transferToRouteWithRouter2";
                }
                case 22: {
                    return "setSessionVolumeWithRouter2";
                }
                case 23: {
                    return "releaseSessionWithRouter2";
                }
                case 24: {
                    return "getRemoteSessions";
                }
                case 25: {
                    return "getSystemSessionInfoForPackage";
                }
                case 26: {
                    return "registerManager";
                }
                case 27: {
                    return "unregisterManager";
                }
                case 28: {
                    return "setRouteVolumeWithManager";
                }
                case 29: {
                    return "startScan";
                }
                case 30: {
                    return "stopScan";
                }
                case 31: {
                    return "requestCreateSessionWithManager";
                }
                case 32: {
                    return "selectRouteWithManager";
                }
                case 33: {
                    return "deselectRouteWithManager";
                }
                case 34: {
                    return "transferToRouteWithManager";
                }
                case 35: {
                    return "setSessionVolumeWithManager";
                }
                case 36: {
                    return "releaseSessionWithManager";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    IMediaRouterClient _arg0 = IMediaRouterClient.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.registerClientAsUser(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    IMediaRouterClient _arg0 = IMediaRouterClient.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterClient(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    IMediaRouterClient _arg0 = IMediaRouterClient.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.registerClientGroupId(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    IMediaRouterClient _arg0 = IMediaRouterClient.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    MediaRouterClientState _result = this.getState(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 5: {
                    IMediaRouterClient _arg0 = IMediaRouterClient.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    boolean _result = this.isPlaybackActive(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 6: {
                    IMediaRouterClient _arg0 = IMediaRouterClient.Stub.asInterface(data.readStrongBinder());
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setBluetoothA2dpOn(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    IMediaRouterClient _arg0 = IMediaRouterClient.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setDiscoveryRequest(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    IMediaRouterClient _arg0 = IMediaRouterClient.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setSelectedRoute(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    IMediaRouterClient _arg0 = IMediaRouterClient.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.requestSetVolume(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    IMediaRouterClient _arg0 = IMediaRouterClient.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.requestUpdateVolume(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    this.enforceMediaContentControlPermission();
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    List<MediaRoute2Info> _result = this.getSystemRoutes();
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    break;
                }
                case 13: {
                    RoutingSessionInfo _result = this.getSystemSessionInfo();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 14: {
                    IMediaRouter2 _arg0 = IMediaRouter2.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.registerRouter2(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    IMediaRouter2 _arg0 = IMediaRouter2.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterRouter2(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    IMediaRouter2 _arg0 = IMediaRouter2.Stub.asInterface(data.readStrongBinder());
                    RouteDiscoveryPreference _arg1 = data.readTypedObject(RouteDiscoveryPreference.CREATOR);
                    data.enforceNoDataAvail();
                    this.setDiscoveryRequestWithRouter2(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    IMediaRouter2 _arg0 = IMediaRouter2.Stub.asInterface(data.readStrongBinder());
                    MediaRoute2Info _arg1 = data.readTypedObject(MediaRoute2Info.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setRouteVolumeWithRouter2(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    IMediaRouter2 _arg0 = IMediaRouter2.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    long _arg2 = data.readLong();
                    RoutingSessionInfo _arg3 = data.readTypedObject(RoutingSessionInfo.CREATOR);
                    MediaRoute2Info _arg4 = data.readTypedObject(MediaRoute2Info.CREATOR);
                    Bundle _arg5 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.requestCreateSessionWithRouter2(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    IMediaRouter2 _arg0 = IMediaRouter2.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    MediaRoute2Info _arg2 = data.readTypedObject(MediaRoute2Info.CREATOR);
                    data.enforceNoDataAvail();
                    this.selectRouteWithRouter2(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 20: {
                    IMediaRouter2 _arg0 = IMediaRouter2.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    MediaRoute2Info _arg2 = data.readTypedObject(MediaRoute2Info.CREATOR);
                    data.enforceNoDataAvail();
                    this.deselectRouteWithRouter2(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 21: {
                    IMediaRouter2 _arg0 = IMediaRouter2.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    MediaRoute2Info _arg2 = data.readTypedObject(MediaRoute2Info.CREATOR);
                    data.enforceNoDataAvail();
                    this.transferToRouteWithRouter2(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 22: {
                    IMediaRouter2 _arg0 = IMediaRouter2.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setSessionVolumeWithRouter2(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    IMediaRouter2 _arg0 = IMediaRouter2.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.releaseSessionWithRouter2(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 24: {
                    IMediaRouter2Manager _arg0 = IMediaRouter2Manager.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    List<RoutingSessionInfo> _result = this.getRemoteSessions(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    break;
                }
                case 25: {
                    IMediaRouter2Manager _arg0 = IMediaRouter2Manager.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    RoutingSessionInfo _result = this.getSystemSessionInfoForPackage(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 26: {
                    IMediaRouter2Manager _arg0 = IMediaRouter2Manager.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.registerManager(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 27: {
                    IMediaRouter2Manager _arg0 = IMediaRouter2Manager.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterManager(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 28: {
                    IMediaRouter2Manager _arg0 = IMediaRouter2Manager.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    MediaRoute2Info _arg2 = data.readTypedObject(MediaRoute2Info.CREATOR);
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setRouteVolumeWithManager(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 29: {
                    IMediaRouter2Manager _arg0 = IMediaRouter2Manager.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.startScan(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 30: {
                    IMediaRouter2Manager _arg0 = IMediaRouter2Manager.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.stopScan(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 31: {
                    IMediaRouter2Manager _arg0 = IMediaRouter2Manager.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    RoutingSessionInfo _arg2 = data.readTypedObject(RoutingSessionInfo.CREATOR);
                    MediaRoute2Info _arg3 = data.readTypedObject(MediaRoute2Info.CREATOR);
                    data.enforceNoDataAvail();
                    this.requestCreateSessionWithManager(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 32: {
                    IMediaRouter2Manager _arg0 = IMediaRouter2Manager.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    MediaRoute2Info _arg3 = data.readTypedObject(MediaRoute2Info.CREATOR);
                    data.enforceNoDataAvail();
                    this.selectRouteWithManager(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 33: {
                    IMediaRouter2Manager _arg0 = IMediaRouter2Manager.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    MediaRoute2Info _arg3 = data.readTypedObject(MediaRoute2Info.CREATOR);
                    data.enforceNoDataAvail();
                    this.deselectRouteWithManager(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 34: {
                    IMediaRouter2Manager _arg0 = IMediaRouter2Manager.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    MediaRoute2Info _arg3 = data.readTypedObject(MediaRoute2Info.CREATOR);
                    data.enforceNoDataAvail();
                    this.transferToRouteWithManager(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 35: {
                    IMediaRouter2Manager _arg0 = IMediaRouter2Manager.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setSessionVolumeWithManager(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 36: {
                    IMediaRouter2Manager _arg0 = IMediaRouter2Manager.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.releaseSessionWithManager(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 35;
        }

        private static class Proxy
        implements IMediaRouterService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerClientAsUser(IMediaRouterClient client, String packageName, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(client);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterClient(IMediaRouterClient client) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(client);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerClientGroupId(IMediaRouterClient client, String groupId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(client);
                    _data.writeString(groupId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public MediaRouterClientState getState(IMediaRouterClient client) throws RemoteException {
                MediaRouterClientState _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(client);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(MediaRouterClientState.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isPlaybackActive(IMediaRouterClient client) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(client);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setBluetoothA2dpOn(IMediaRouterClient client, boolean on) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(client);
                    _data.writeBoolean(on);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDiscoveryRequest(IMediaRouterClient client, int routeTypes, boolean activeScan) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(client);
                    _data.writeInt(routeTypes);
                    _data.writeBoolean(activeScan);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSelectedRoute(IMediaRouterClient client, String routeId, boolean explicit) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(client);
                    _data.writeString(routeId);
                    _data.writeBoolean(explicit);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestSetVolume(IMediaRouterClient client, String routeId, int volume) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(client);
                    _data.writeString(routeId);
                    _data.writeInt(volume);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestUpdateVolume(IMediaRouterClient client, String routeId, int direction) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(client);
                    _data.writeString(routeId);
                    _data.writeInt(direction);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enforceMediaContentControlPermission() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<MediaRoute2Info> getSystemRoutes() throws RemoteException {
                ArrayList<MediaRoute2Info> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(MediaRoute2Info.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public RoutingSessionInfo getSystemSessionInfo() throws RemoteException {
                RoutingSessionInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(RoutingSessionInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerRouter2(IMediaRouter2 router, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(router);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterRouter2(IMediaRouter2 router) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(router);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDiscoveryRequestWithRouter2(IMediaRouter2 router, RouteDiscoveryPreference preference) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(router);
                    _data.writeTypedObject(preference, 0);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRouteVolumeWithRouter2(IMediaRouter2 router, MediaRoute2Info route, int volume) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(router);
                    _data.writeTypedObject(route, 0);
                    _data.writeInt(volume);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestCreateSessionWithRouter2(IMediaRouter2 router, int requestId, long managerRequestId, RoutingSessionInfo oldSession, MediaRoute2Info route, Bundle sessionHints) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(router);
                    _data.writeInt(requestId);
                    _data.writeLong(managerRequestId);
                    _data.writeTypedObject(oldSession, 0);
                    _data.writeTypedObject(route, 0);
                    _data.writeTypedObject(sessionHints, 0);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void selectRouteWithRouter2(IMediaRouter2 router, String sessionId, MediaRoute2Info route) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(router);
                    _data.writeString(sessionId);
                    _data.writeTypedObject(route, 0);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deselectRouteWithRouter2(IMediaRouter2 router, String sessionId, MediaRoute2Info route) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(router);
                    _data.writeString(sessionId);
                    _data.writeTypedObject(route, 0);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void transferToRouteWithRouter2(IMediaRouter2 router, String sessionId, MediaRoute2Info route) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(router);
                    _data.writeString(sessionId);
                    _data.writeTypedObject(route, 0);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSessionVolumeWithRouter2(IMediaRouter2 router, String sessionId, int volume) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(router);
                    _data.writeString(sessionId);
                    _data.writeInt(volume);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseSessionWithRouter2(IMediaRouter2 router, String sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(router);
                    _data.writeString(sessionId);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<RoutingSessionInfo> getRemoteSessions(IMediaRouter2Manager manager) throws RemoteException {
                ArrayList<RoutingSessionInfo> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(manager);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(RoutingSessionInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public RoutingSessionInfo getSystemSessionInfoForPackage(IMediaRouter2Manager manager, String packageName) throws RemoteException {
                RoutingSessionInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(manager);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(RoutingSessionInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerManager(IMediaRouter2Manager manager, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(manager);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterManager(IMediaRouter2Manager manager) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(manager);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRouteVolumeWithManager(IMediaRouter2Manager manager, int requestId, MediaRoute2Info route, int volume) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(manager);
                    _data.writeInt(requestId);
                    _data.writeTypedObject(route, 0);
                    _data.writeInt(volume);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startScan(IMediaRouter2Manager manager) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(manager);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopScan(IMediaRouter2Manager manager) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(manager);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestCreateSessionWithManager(IMediaRouter2Manager manager, int requestId, RoutingSessionInfo oldSession, MediaRoute2Info route) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(manager);
                    _data.writeInt(requestId);
                    _data.writeTypedObject(oldSession, 0);
                    _data.writeTypedObject(route, 0);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void selectRouteWithManager(IMediaRouter2Manager manager, int requestId, String sessionId, MediaRoute2Info route) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(manager);
                    _data.writeInt(requestId);
                    _data.writeString(sessionId);
                    _data.writeTypedObject(route, 0);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deselectRouteWithManager(IMediaRouter2Manager manager, int requestId, String sessionId, MediaRoute2Info route) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(manager);
                    _data.writeInt(requestId);
                    _data.writeString(sessionId);
                    _data.writeTypedObject(route, 0);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void transferToRouteWithManager(IMediaRouter2Manager manager, int requestId, String sessionId, MediaRoute2Info route) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(manager);
                    _data.writeInt(requestId);
                    _data.writeString(sessionId);
                    _data.writeTypedObject(route, 0);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSessionVolumeWithManager(IMediaRouter2Manager manager, int requestId, String sessionId, int volume) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(manager);
                    _data.writeInt(requestId);
                    _data.writeString(sessionId);
                    _data.writeInt(volume);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseSessionWithManager(IMediaRouter2Manager manager, int requestId, String sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(manager);
                    _data.writeInt(requestId);
                    _data.writeString(sessionId);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IMediaRouterService {
        @Override
        public void registerClientAsUser(IMediaRouterClient client, String packageName, int userId) throws RemoteException {
        }

        @Override
        public void unregisterClient(IMediaRouterClient client) throws RemoteException {
        }

        @Override
        public void registerClientGroupId(IMediaRouterClient client, String groupId) throws RemoteException {
        }

        @Override
        public MediaRouterClientState getState(IMediaRouterClient client) throws RemoteException {
            return null;
        }

        @Override
        public boolean isPlaybackActive(IMediaRouterClient client) throws RemoteException {
            return false;
        }

        @Override
        public void setBluetoothA2dpOn(IMediaRouterClient client, boolean on) throws RemoteException {
        }

        @Override
        public void setDiscoveryRequest(IMediaRouterClient client, int routeTypes, boolean activeScan) throws RemoteException {
        }

        @Override
        public void setSelectedRoute(IMediaRouterClient client, String routeId, boolean explicit) throws RemoteException {
        }

        @Override
        public void requestSetVolume(IMediaRouterClient client, String routeId, int volume) throws RemoteException {
        }

        @Override
        public void requestUpdateVolume(IMediaRouterClient client, String routeId, int direction) throws RemoteException {
        }

        @Override
        public void enforceMediaContentControlPermission() throws RemoteException {
        }

        @Override
        public List<MediaRoute2Info> getSystemRoutes() throws RemoteException {
            return null;
        }

        @Override
        public RoutingSessionInfo getSystemSessionInfo() throws RemoteException {
            return null;
        }

        @Override
        public void registerRouter2(IMediaRouter2 router, String packageName) throws RemoteException {
        }

        @Override
        public void unregisterRouter2(IMediaRouter2 router) throws RemoteException {
        }

        @Override
        public void setDiscoveryRequestWithRouter2(IMediaRouter2 router, RouteDiscoveryPreference preference) throws RemoteException {
        }

        @Override
        public void setRouteVolumeWithRouter2(IMediaRouter2 router, MediaRoute2Info route, int volume) throws RemoteException {
        }

        @Override
        public void requestCreateSessionWithRouter2(IMediaRouter2 router, int requestId, long managerRequestId, RoutingSessionInfo oldSession, MediaRoute2Info route, Bundle sessionHints) throws RemoteException {
        }

        @Override
        public void selectRouteWithRouter2(IMediaRouter2 router, String sessionId, MediaRoute2Info route) throws RemoteException {
        }

        @Override
        public void deselectRouteWithRouter2(IMediaRouter2 router, String sessionId, MediaRoute2Info route) throws RemoteException {
        }

        @Override
        public void transferToRouteWithRouter2(IMediaRouter2 router, String sessionId, MediaRoute2Info route) throws RemoteException {
        }

        @Override
        public void setSessionVolumeWithRouter2(IMediaRouter2 router, String sessionId, int volume) throws RemoteException {
        }

        @Override
        public void releaseSessionWithRouter2(IMediaRouter2 router, String sessionId) throws RemoteException {
        }

        @Override
        public List<RoutingSessionInfo> getRemoteSessions(IMediaRouter2Manager manager) throws RemoteException {
            return null;
        }

        @Override
        public RoutingSessionInfo getSystemSessionInfoForPackage(IMediaRouter2Manager manager, String packageName) throws RemoteException {
            return null;
        }

        @Override
        public void registerManager(IMediaRouter2Manager manager, String packageName) throws RemoteException {
        }

        @Override
        public void unregisterManager(IMediaRouter2Manager manager) throws RemoteException {
        }

        @Override
        public void setRouteVolumeWithManager(IMediaRouter2Manager manager, int requestId, MediaRoute2Info route, int volume) throws RemoteException {
        }

        @Override
        public void startScan(IMediaRouter2Manager manager) throws RemoteException {
        }

        @Override
        public void stopScan(IMediaRouter2Manager manager) throws RemoteException {
        }

        @Override
        public void requestCreateSessionWithManager(IMediaRouter2Manager manager, int requestId, RoutingSessionInfo oldSession, MediaRoute2Info route) throws RemoteException {
        }

        @Override
        public void selectRouteWithManager(IMediaRouter2Manager manager, int requestId, String sessionId, MediaRoute2Info route) throws RemoteException {
        }

        @Override
        public void deselectRouteWithManager(IMediaRouter2Manager manager, int requestId, String sessionId, MediaRoute2Info route) throws RemoteException {
        }

        @Override
        public void transferToRouteWithManager(IMediaRouter2Manager manager, int requestId, String sessionId, MediaRoute2Info route) throws RemoteException {
        }

        @Override
        public void setSessionVolumeWithManager(IMediaRouter2Manager manager, int requestId, String sessionId, int volume) throws RemoteException {
        }

        @Override
        public void releaseSessionWithManager(IMediaRouter2Manager manager, int requestId, String sessionId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

