/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.IMediaCommunicationServiceCallback;
import android.media.MediaParceledListSlice;
import android.media.Session2Token;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.KeyEvent;

public interface IMediaCommunicationService
extends IInterface {
    public static final String DESCRIPTOR = "android.media.IMediaCommunicationService";

    public void notifySession2Created(Session2Token var1) throws RemoteException;

    public boolean isTrusted(String var1, int var2, int var3) throws RemoteException;

    public MediaParceledListSlice getSession2Tokens(int var1) throws RemoteException;

    public void dispatchMediaKeyEvent(String var1, KeyEvent var2, boolean var3) throws RemoteException;

    public void registerCallback(IMediaCommunicationServiceCallback var1, String var2) throws RemoteException;

    public void unregisterCallback(IMediaCommunicationServiceCallback var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMediaCommunicationService {
        static final int TRANSACTION_notifySession2Created = 1;
        static final int TRANSACTION_isTrusted = 2;
        static final int TRANSACTION_getSession2Tokens = 3;
        static final int TRANSACTION_dispatchMediaKeyEvent = 4;
        static final int TRANSACTION_registerCallback = 5;
        static final int TRANSACTION_unregisterCallback = 6;

        public Stub() {
            this.attachInterface(this, IMediaCommunicationService.DESCRIPTOR);
        }

        public static IMediaCommunicationService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IMediaCommunicationService.DESCRIPTOR);
            if (iin != null && iin instanceof IMediaCommunicationService) {
                return (IMediaCommunicationService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IMediaCommunicationService.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    Session2Token _arg0 = data.readTypedObject(Session2Token.CREATOR);
                    this.notifySession2Created(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    boolean _result = this.isTrusted(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    MediaParceledListSlice _result = this.getSession2Tokens(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    KeyEvent _arg1 = data.readTypedObject(KeyEvent.CREATOR);
                    boolean _arg2 = data.readBoolean();
                    this.dispatchMediaKeyEvent(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    IMediaCommunicationServiceCallback _arg0 = IMediaCommunicationServiceCallback.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    this.registerCallback(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    IMediaCommunicationServiceCallback _arg0 = IMediaCommunicationServiceCallback.Stub.asInterface(data.readStrongBinder());
                    this.unregisterCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements IMediaCommunicationService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IMediaCommunicationService.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifySession2Created(Session2Token sessionToken) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaCommunicationService.DESCRIPTOR);
                    _data.writeTypedObject(sessionToken, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isTrusted(String controllerPackageName, int controllerPid, int controllerUid) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaCommunicationService.DESCRIPTOR);
                    _data.writeString(controllerPackageName);
                    _data.writeInt(controllerPid);
                    _data.writeInt(controllerUid);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public MediaParceledListSlice getSession2Tokens(int userId) throws RemoteException {
                MediaParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaCommunicationService.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(MediaParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatchMediaKeyEvent(String packageName, KeyEvent keyEvent, boolean asSystemService) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaCommunicationService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(keyEvent, 0);
                    _data.writeBoolean(asSystemService);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerCallback(IMediaCommunicationServiceCallback callback, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaCommunicationService.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterCallback(IMediaCommunicationServiceCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaCommunicationService.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IMediaCommunicationService {
        @Override
        public void notifySession2Created(Session2Token sessionToken) throws RemoteException {
        }

        @Override
        public boolean isTrusted(String controllerPackageName, int controllerPid, int controllerUid) throws RemoteException {
            return false;
        }

        @Override
        public MediaParceledListSlice getSession2Tokens(int userId) throws RemoteException {
            return null;
        }

        @Override
        public void dispatchMediaKeyEvent(String packageName, KeyEvent keyEvent, boolean asSystemService) throws RemoteException {
        }

        @Override
        public void registerCallback(IMediaCommunicationServiceCallback callback, String packageName) throws RemoteException {
        }

        @Override
        public void unregisterCallback(IMediaCommunicationServiceCallback callback) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

