/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.AudioDeviceAttributes;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IDeviceVolumeBehaviorDispatcher
extends IInterface {
    public static final String DESCRIPTOR = "android.media.IDeviceVolumeBehaviorDispatcher";

    public void dispatchDeviceVolumeBehaviorChanged(AudioDeviceAttributes var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IDeviceVolumeBehaviorDispatcher {
        static final int TRANSACTION_dispatchDeviceVolumeBehaviorChanged = 1;

        public Stub() {
            this.attachInterface(this, IDeviceVolumeBehaviorDispatcher.DESCRIPTOR);
        }

        public static IDeviceVolumeBehaviorDispatcher asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IDeviceVolumeBehaviorDispatcher.DESCRIPTOR);
            if (iin != null && iin instanceof IDeviceVolumeBehaviorDispatcher) {
                return (IDeviceVolumeBehaviorDispatcher)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "dispatchDeviceVolumeBehaviorChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IDeviceVolumeBehaviorDispatcher.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.dispatchDeviceVolumeBehaviorChanged(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements IDeviceVolumeBehaviorDispatcher {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IDeviceVolumeBehaviorDispatcher.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatchDeviceVolumeBehaviorChanged(AudioDeviceAttributes device, int deviceVolumeBehavior) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDeviceVolumeBehaviorDispatcher.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(deviceVolumeBehavior);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IDeviceVolumeBehaviorDispatcher {
        @Override
        public void dispatchDeviceVolumeBehaviorChanged(AudioDeviceAttributes device, int deviceVolumeBehavior) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

