/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ICommunicationDeviceDispatcher
extends IInterface {
    public static final String DESCRIPTOR = "android.media.ICommunicationDeviceDispatcher";

    public void dispatchCommunicationDeviceChanged(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ICommunicationDeviceDispatcher {
        static final int TRANSACTION_dispatchCommunicationDeviceChanged = 1;

        public Stub() {
            this.attachInterface(this, ICommunicationDeviceDispatcher.DESCRIPTOR);
        }

        public static ICommunicationDeviceDispatcher asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ICommunicationDeviceDispatcher.DESCRIPTOR);
            if (iin != null && iin instanceof ICommunicationDeviceDispatcher) {
                return (ICommunicationDeviceDispatcher)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "dispatchCommunicationDeviceChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ICommunicationDeviceDispatcher.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.dispatchCommunicationDeviceChanged(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements ICommunicationDeviceDispatcher {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ICommunicationDeviceDispatcher.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatchCommunicationDeviceChanged(int portId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICommunicationDeviceDispatcher.DESCRIPTOR);
                    _data.writeInt(portId);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ICommunicationDeviceDispatcher {
        @Override
        public void dispatchCommunicationDeviceChanged(int portId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

