/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.compat.annotation.UnsupportedAppUsage;
import android.media.AudioDescriptor;
import android.media.AudioDevicePortConfig;
import android.media.AudioGain;
import android.media.AudioGainConfig;
import android.media.AudioHandle;
import android.media.AudioManager;
import android.media.AudioPort;
import android.media.AudioProfile;
import android.media.AudioSystem;
import java.util.Arrays;
import java.util.List;

public class AudioDevicePort
extends AudioPort {
    private final int mType;
    private final String mAddress;
    private final int[] mEncapsulationModes;
    private final int[] mEncapsulationMetadataTypes;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    AudioDevicePort(AudioHandle handle, String deviceName, int[] samplingRates, int[] channelMasks, int[] channelIndexMasks, int[] formats, AudioGain[] gains, int type, String address, int[] encapsulationModes, int[] encapsulationMetadataTypes) {
        super(handle, AudioManager.isInputDevice((int)type) ? 1 : 2, deviceName, samplingRates, channelMasks, channelIndexMasks, formats, gains);
        this.mType = type;
        this.mAddress = address;
        this.mEncapsulationModes = encapsulationModes;
        this.mEncapsulationMetadataTypes = encapsulationMetadataTypes;
    }

    AudioDevicePort(AudioHandle handle, String deviceName, List<AudioProfile> profiles, AudioGain[] gains, int type, String address, int[] encapsulationModes, int[] encapsulationMetadataTypes, List<AudioDescriptor> descriptors) {
        super(handle, AudioManager.isInputDevice((int)type) ? 1 : 2, deviceName, profiles, gains, descriptors);
        this.mType = type;
        this.mAddress = address;
        this.mEncapsulationModes = encapsulationModes;
        this.mEncapsulationMetadataTypes = encapsulationMetadataTypes;
    }

    @UnsupportedAppUsage
    public int type() {
        return this.mType;
    }

    public String address() {
        return this.mAddress;
    }

    public int[] encapsulationModes() {
        if (this.mEncapsulationModes == null) {
            return new int[0];
        }
        return Arrays.stream(this.mEncapsulationModes).boxed().filter(mode -> mode != 2).mapToInt(Integer::intValue).toArray();
    }

    public int[] encapsulationMetadataTypes() {
        if (this.mEncapsulationMetadataTypes == null) {
            return new int[0];
        }
        int[] encapsulationMetadataTypes = new int[this.mEncapsulationMetadataTypes.length];
        System.arraycopy(this.mEncapsulationMetadataTypes, 0, encapsulationMetadataTypes, 0, this.mEncapsulationMetadataTypes.length);
        return encapsulationMetadataTypes;
    }

    @Override
    public AudioDevicePortConfig buildConfig(int samplingRate, int channelMask, int format, AudioGainConfig gain) {
        return new AudioDevicePortConfig(this, samplingRate, channelMask, format, gain);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof AudioDevicePort)) {
            return false;
        }
        AudioDevicePort other = (AudioDevicePort)o;
        if (this.mType != other.type()) {
            return false;
        }
        if (this.mAddress == null && other.address() != null) {
            return false;
        }
        if (!this.mAddress.equals(other.address())) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public String toString() {
        String type = this.mRole == 1 ? AudioSystem.getInputDeviceName(this.mType) : AudioSystem.getOutputDeviceName(this.mType);
        return "{" + super.toString() + ", mType: " + type + ", mAddress: " + this.mAddress + "}";
    }
}

