/*
 * Decompiled with CFR 0.152.
 */
package android.location.provider;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.WorkSource;
import android.util.TimeUtils;
import com.android.internal.util.Preconditions;
import java.util.Objects;

@SystemApi
public class ProviderRequest
implements Parcelable {
    public static final long INTERVAL_DISABLED = Long.MAX_VALUE;
    public static final ProviderRequest EMPTY_REQUEST = new ProviderRequest(Long.MAX_VALUE, 102, 0L, false, false, false, new WorkSource());
    private final long mIntervalMillis;
    private final int mQuality;
    private final long mMaxUpdateDelayMillis;
    private final boolean mLowPower;
    private final boolean mAdasGnssBypass;
    private final boolean mLocationSettingsIgnored;
    private final WorkSource mWorkSource;
    public static final Parcelable.Creator<ProviderRequest> CREATOR = new Parcelable.Creator<ProviderRequest>(){

        @Override
        public ProviderRequest createFromParcel(Parcel in) {
            long intervalMillis = in.readLong();
            if (intervalMillis == Long.MAX_VALUE) {
                return EMPTY_REQUEST;
            }
            return new ProviderRequest(intervalMillis, in.readInt(), in.readLong(), in.readBoolean(), in.readBoolean(), in.readBoolean(), in.readTypedObject(WorkSource.CREATOR));
        }

        public ProviderRequest[] newArray(int size) {
            return new ProviderRequest[size];
        }
    };

    private ProviderRequest(long intervalMillis, int quality, long maxUpdateDelayMillis, boolean lowPower, boolean adasGnssBypass, boolean locationSettingsIgnored, WorkSource workSource) {
        this.mIntervalMillis = intervalMillis;
        this.mQuality = quality;
        this.mMaxUpdateDelayMillis = maxUpdateDelayMillis;
        this.mLowPower = lowPower;
        this.mAdasGnssBypass = adasGnssBypass;
        this.mLocationSettingsIgnored = locationSettingsIgnored;
        this.mWorkSource = Objects.requireNonNull(workSource);
    }

    public boolean isActive() {
        return this.mIntervalMillis != Long.MAX_VALUE;
    }

    public long getIntervalMillis() {
        return this.mIntervalMillis;
    }

    public int getQuality() {
        return this.mQuality;
    }

    public long getMaxUpdateDelayMillis() {
        return this.mMaxUpdateDelayMillis;
    }

    public boolean isLowPower() {
        return this.mLowPower;
    }

    public boolean isAdasGnssBypass() {
        return this.mAdasGnssBypass;
    }

    public boolean isLocationSettingsIgnored() {
        return this.mLocationSettingsIgnored;
    }

    public boolean isBypass() {
        return this.mAdasGnssBypass || this.mLocationSettingsIgnored;
    }

    public WorkSource getWorkSource() {
        return this.mWorkSource;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeLong(this.mIntervalMillis);
        if (this.mIntervalMillis != Long.MAX_VALUE) {
            parcel.writeInt(this.mQuality);
            parcel.writeLong(this.mMaxUpdateDelayMillis);
            parcel.writeBoolean(this.mLowPower);
            parcel.writeBoolean(this.mAdasGnssBypass);
            parcel.writeBoolean(this.mLocationSettingsIgnored);
            parcel.writeTypedObject(this.mWorkSource, flags);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProviderRequest that = (ProviderRequest)o;
        if (this.mIntervalMillis == Long.MAX_VALUE) {
            return that.mIntervalMillis == Long.MAX_VALUE;
        }
        return this.mIntervalMillis == that.mIntervalMillis && this.mQuality == that.mQuality && this.mMaxUpdateDelayMillis == that.mMaxUpdateDelayMillis && this.mLowPower == that.mLowPower && this.mAdasGnssBypass == that.mAdasGnssBypass && this.mLocationSettingsIgnored == that.mLocationSettingsIgnored && this.mWorkSource.equals(that.mWorkSource);
    }

    public int hashCode() {
        return Objects.hash(this.mIntervalMillis, this.mQuality, this.mWorkSource);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("ProviderRequest[");
        if (this.mIntervalMillis != Long.MAX_VALUE) {
            s.append("@");
            TimeUtils.formatDuration(this.mIntervalMillis, s);
            if (this.mQuality != 102) {
                if (this.mQuality == 100) {
                    s.append(", HIGH_ACCURACY");
                } else if (this.mQuality == 104) {
                    s.append(", LOW_POWER");
                }
            }
            if (this.mMaxUpdateDelayMillis / 2L > this.mIntervalMillis) {
                s.append(", maxUpdateDelay=");
                TimeUtils.formatDuration(this.mMaxUpdateDelayMillis, s);
            }
            if (this.mLowPower) {
                s.append(", lowPower");
            }
            if (this.mAdasGnssBypass) {
                s.append(", adasGnssBypass");
            }
            if (this.mLocationSettingsIgnored) {
                s.append(", settingsBypass");
            }
            if (!this.mWorkSource.isEmpty()) {
                s.append(", ").append(this.mWorkSource);
            }
        } else {
            s.append("OFF");
        }
        s.append(']');
        return s.toString();
    }

    public static class Builder {
        private long mIntervalMillis = Long.MAX_VALUE;
        private int mQuality = 102;
        private long mMaxUpdateDelayMillis = 0L;
        private boolean mLowPower;
        private boolean mAdasGnssBypass;
        private boolean mLocationSettingsIgnored;
        private WorkSource mWorkSource = new WorkSource();

        public Builder setIntervalMillis(long intervalMillis) {
            this.mIntervalMillis = Preconditions.checkArgumentInRange(intervalMillis, 0L, Long.MAX_VALUE, "intervalMillis");
            return this;
        }

        public Builder setQuality(int quality) {
            Preconditions.checkArgument(quality == 104 || quality == 102 || quality == 100);
            this.mQuality = quality;
            return this;
        }

        public Builder setMaxUpdateDelayMillis(long maxUpdateDelayMillis) {
            this.mMaxUpdateDelayMillis = Preconditions.checkArgumentInRange(maxUpdateDelayMillis, 0L, Long.MAX_VALUE, "maxUpdateDelayMillis");
            return this;
        }

        public Builder setLowPower(boolean lowPower) {
            this.mLowPower = lowPower;
            return this;
        }

        public Builder setAdasGnssBypass(boolean adasGnssBypass) {
            this.mAdasGnssBypass = adasGnssBypass;
            return this;
        }

        public Builder setLocationSettingsIgnored(boolean locationSettingsIgnored) {
            this.mLocationSettingsIgnored = locationSettingsIgnored;
            return this;
        }

        public Builder setWorkSource(WorkSource workSource) {
            this.mWorkSource = Objects.requireNonNull(workSource);
            return this;
        }

        public ProviderRequest build() {
            if (this.mIntervalMillis == Long.MAX_VALUE) {
                return EMPTY_REQUEST;
            }
            return new ProviderRequest(this.mIntervalMillis, this.mQuality, this.mMaxUpdateDelayMillis, this.mLowPower, this.mAdasGnssBypass, this.mLocationSettingsIgnored, this.mWorkSource);
        }
    }

    public static interface ChangedListener {
        public void onProviderRequestChanged(String var1, ProviderRequest var2);
    }
}

