/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.location.GnssStatus;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;
import java.util.Objects;

public class GnssAutomaticGainControl
implements Parcelable {
    private final double mLevelDb;
    private final int mConstellationType;
    private final long mCarrierFrequencyHz;
    public static final Parcelable.Creator<GnssAutomaticGainControl> CREATOR = new Parcelable.Creator<GnssAutomaticGainControl>(){

        @Override
        public GnssAutomaticGainControl createFromParcel(Parcel parcel) {
            return new GnssAutomaticGainControl(parcel.readDouble(), parcel.readInt(), parcel.readLong());
        }

        public GnssAutomaticGainControl[] newArray(int i) {
            return new GnssAutomaticGainControl[i];
        }
    };

    private GnssAutomaticGainControl(double levelDb, int constellationType, long carrierFrequencyHz) {
        this.mLevelDb = levelDb;
        this.mConstellationType = constellationType;
        this.mCarrierFrequencyHz = carrierFrequencyHz;
    }

    public double getLevelDb() {
        return this.mLevelDb;
    }

    public int getConstellationType() {
        return this.mConstellationType;
    }

    public long getCarrierFrequencyHz() {
        return this.mCarrierFrequencyHz;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flag) {
        parcel.writeDouble(this.mLevelDb);
        parcel.writeInt(this.mConstellationType);
        parcel.writeLong(this.mCarrierFrequencyHz);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("GnssAutomaticGainControl[");
        s.append("Level=").append(this.mLevelDb).append(" dB");
        s.append(" Constellation=").append(GnssStatus.constellationTypeToString(this.mConstellationType));
        s.append(" CarrierFrequency=").append(this.mCarrierFrequencyHz).append(" Hz");
        s.append(']');
        return s.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GnssAutomaticGainControl)) {
            return false;
        }
        GnssAutomaticGainControl other = (GnssAutomaticGainControl)obj;
        if (Double.compare(this.mLevelDb, other.mLevelDb) != 0) {
            return false;
        }
        if (this.mConstellationType != other.mConstellationType) {
            return false;
        }
        return this.mCarrierFrequencyHz == other.mCarrierFrequencyHz;
    }

    public int hashCode() {
        return Objects.hash(this.mLevelDb, this.mConstellationType, this.mCarrierFrequencyHz);
    }

    public static class Builder {
        private double mLevelDb;
        private int mConstellationType;
        private long mCarrierFrequencyHz;

        public Builder() {
        }

        public Builder(GnssAutomaticGainControl agc) {
            this.mLevelDb = agc.getLevelDb();
            this.mConstellationType = agc.getConstellationType();
            this.mCarrierFrequencyHz = agc.getCarrierFrequencyHz();
        }

        public Builder setLevelDb(double levelDb) {
            Preconditions.checkArgument(levelDb >= -10000.0 && levelDb <= 10000.0);
            this.mLevelDb = levelDb;
            return this;
        }

        public Builder setConstellationType(int constellationType) {
            this.mConstellationType = constellationType;
            return this;
        }

        public Builder setCarrierFrequencyHz(long carrierFrequencyHz) {
            Preconditions.checkArgumentNonnegative(carrierFrequencyHz);
            this.mCarrierFrequencyHz = carrierFrequencyHz;
            return this;
        }

        public GnssAutomaticGainControl build() {
            return new GnssAutomaticGainControl(this.mLevelDb, this.mConstellationType, this.mCarrierFrequencyHz);
        }
    }
}

