/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.animation.ValueAnimator;
import android.graphics.Insets;
import android.graphics.Rect;
import android.graphics.Region;
import android.inputmethodservice.InputMethodService;
import android.inputmethodservice.SoftInputWindow;
import android.inputmethodservice.navigationbar.NavigationBarFrame;
import android.inputmethodservice.navigationbar.NavigationBarView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowInsets;
import android.view.animation.Interpolator;
import android.view.animation.PathInterpolator;
import android.widget.FrameLayout;
import java.util.Objects;

class NavigationBarController {
    private final Callback mImpl;

    NavigationBarController(InputMethodService inputMethodService) {
        this.mImpl = InputMethodService.canImeRenderGesturalNavButtons() ? new Impl(inputMethodService) : Callback.NOOP;
    }

    void updateTouchableInsets(InputMethodService.Insets originalInsets, ViewTreeObserver.InternalInsetsInfo dest) {
        this.mImpl.updateTouchableInsets(originalInsets, dest);
    }

    void onSoftInputWindowCreated(SoftInputWindow softInputWindow) {
        this.mImpl.onSoftInputWindowCreated(softInputWindow);
    }

    void onViewInitialized() {
        this.mImpl.onViewInitialized();
    }

    void onWindowShown() {
        this.mImpl.onWindowShown();
    }

    void onDestroy() {
        this.mImpl.onDestroy();
    }

    void onNavButtonFlagsChanged(int navButtonFlags) {
        this.mImpl.onNavButtonFlagsChanged(navButtonFlags);
    }

    String toDebugString() {
        return this.mImpl.toDebugString();
    }

    private static class Impl
    implements Callback,
    Window.DecorCallback {
        private static final int DEFAULT_COLOR_ADAPT_TRANSITION_TIME = 1700;
        private static final Interpolator LEGACY_DECELERATE = new PathInterpolator(0.0f, 0.0f, 0.2f, 1.0f);
        private final InputMethodService mService;
        private boolean mDestroyed = false;
        private boolean mImeDrawsImeNavBar;
        private NavigationBarFrame mNavigationBarFrame;
        Insets mLastInsets;
        private boolean mShouldShowImeSwitcherWhenImeIsShown;
        private int mAppearance;
        private float mDarkIntensity;
        private ValueAnimator mTintAnimator;
        private boolean mDrawLegacyNavigationBarBackground;
        private final Rect mTempRect = new Rect();
        private final int[] mTempPos = new int[2];

        Impl(InputMethodService inputMethodService) {
            this.mService = inputMethodService;
        }

        private Insets getSystemInsets() {
            if (this.mService.mWindow == null) {
                return null;
            }
            View decorView = this.mService.mWindow.getWindow().getDecorView();
            if (decorView == null) {
                return null;
            }
            WindowInsets windowInsets = decorView.getRootWindowInsets();
            if (windowInsets == null) {
                return null;
            }
            Insets stableBarInsets = windowInsets.getInsetsIgnoringVisibility(WindowInsets.Type.systemBars());
            return Insets.min(windowInsets.getInsets(WindowInsets.Type.systemBars() | WindowInsets.Type.displayCutout()), stableBarInsets);
        }

        private void installNavigationBarFrameIfNecessary() {
            if (!this.mImeDrawsImeNavBar) {
                return;
            }
            if (this.mNavigationBarFrame != null) {
                return;
            }
            View rawDecorView = this.mService.mWindow.getWindow().getDecorView();
            if (!(rawDecorView instanceof ViewGroup)) {
                return;
            }
            ViewGroup decorView = (ViewGroup)rawDecorView;
            this.mNavigationBarFrame = (NavigationBarFrame)decorView.findViewByPredicate(NavigationBarFrame.class::isInstance);
            Insets systemInsets = this.getSystemInsets();
            if (this.mNavigationBarFrame == null) {
                this.mNavigationBarFrame = new NavigationBarFrame(this.mService);
                LayoutInflater.from(this.mService).inflate(0x1090091, (ViewGroup)this.mNavigationBarFrame);
                if (systemInsets != null) {
                    decorView.addView((View)this.mNavigationBarFrame, new FrameLayout.LayoutParams(-1, systemInsets.bottom, 80));
                    this.mLastInsets = systemInsets;
                } else {
                    decorView.addView(this.mNavigationBarFrame);
                }
                NavigationBarView navigationBarView = (NavigationBarView)this.mNavigationBarFrame.findViewByPredicate(NavigationBarView.class::isInstance);
                if (navigationBarView != null) {
                    int hints = 1 | (this.mShouldShowImeSwitcherWhenImeIsShown ? 4 : 0);
                    navigationBarView.setNavigationIconHints(hints);
                }
            } else {
                this.mNavigationBarFrame.setLayoutParams(new FrameLayout.LayoutParams(-1, systemInsets.bottom, 80));
                this.mLastInsets = systemInsets;
            }
            if (this.mDrawLegacyNavigationBarBackground) {
                this.mNavigationBarFrame.setBackgroundColor(-16777216);
            } else {
                this.mNavigationBarFrame.setBackground(null);
            }
            this.setIconTintInternal(Impl.calculateTargetDarkIntensity(this.mAppearance, this.mDrawLegacyNavigationBarBackground));
        }

        private void uninstallNavigationBarFrameIfNecessary() {
            if (this.mNavigationBarFrame == null) {
                return;
            }
            ViewParent parent = this.mNavigationBarFrame.getParent();
            if (parent instanceof ViewGroup) {
                ((ViewGroup)parent).removeView(this.mNavigationBarFrame);
            }
            this.mNavigationBarFrame = null;
        }

        @Override
        public void updateTouchableInsets(InputMethodService.Insets originalInsets, ViewTreeObserver.InternalInsetsInfo dest) {
            if (!this.mImeDrawsImeNavBar || this.mNavigationBarFrame == null || this.mService.isExtractViewShown()) {
                return;
            }
            Insets systemInsets = this.getSystemInsets();
            if (systemInsets != null) {
                boolean insetChanged;
                Window window = this.mService.mWindow.getWindow();
                View decor = window.getDecorView();
                Region touchableRegion = null;
                FrameLayout inputFrame = this.mService.mInputFrame;
                switch (originalInsets.touchableInsets) {
                    case 0: {
                        if (inputFrame.getVisibility() != 0) break;
                        inputFrame.getLocationInWindow(this.mTempPos);
                        this.mTempRect.set(this.mTempPos[0], this.mTempPos[1], this.mTempPos[0] + inputFrame.getWidth(), this.mTempPos[1] + inputFrame.getHeight());
                        touchableRegion = new Region(this.mTempRect);
                        break;
                    }
                    case 1: {
                        if (inputFrame.getVisibility() != 0) break;
                        inputFrame.getLocationInWindow(this.mTempPos);
                        this.mTempRect.set(this.mTempPos[0], originalInsets.contentTopInsets, this.mTempPos[0] + inputFrame.getWidth(), this.mTempPos[1] + inputFrame.getHeight());
                        touchableRegion = new Region(this.mTempRect);
                        break;
                    }
                    case 2: {
                        if (inputFrame.getVisibility() != 0) break;
                        inputFrame.getLocationInWindow(this.mTempPos);
                        this.mTempRect.set(this.mTempPos[0], originalInsets.visibleTopInsets, this.mTempPos[0] + inputFrame.getWidth(), this.mTempPos[1] + inputFrame.getHeight());
                        touchableRegion = new Region(this.mTempRect);
                        break;
                    }
                    case 3: {
                        touchableRegion = new Region();
                        touchableRegion.set(originalInsets.touchableRegion);
                    }
                }
                this.mTempRect.set(decor.getLeft(), decor.getBottom() - systemInsets.bottom, decor.getRight(), decor.getBottom());
                if (touchableRegion == null) {
                    touchableRegion = new Region(this.mTempRect);
                } else {
                    touchableRegion.union(this.mTempRect);
                }
                dest.touchableRegion.set(touchableRegion);
                dest.setTouchableInsets(3);
                boolean zOrderChanged = false;
                if (decor instanceof ViewGroup) {
                    ViewGroup decorGroup = (ViewGroup)decor;
                    View navbarBackgroundView = window.getNavigationBarBackgroundView();
                    zOrderChanged = navbarBackgroundView != null && decorGroup.indexOfChild(navbarBackgroundView) > decorGroup.indexOfChild(this.mNavigationBarFrame);
                }
                boolean bl = insetChanged = !Objects.equals(systemInsets, this.mLastInsets);
                if (zOrderChanged || insetChanged) {
                    this.scheduleRelayout();
                }
            }
        }

        private void scheduleRelayout() {
            NavigationBarFrame frame = this.mNavigationBarFrame;
            frame.post(() -> {
                View navbarBackgroundView;
                if (this.mDestroyed) {
                    return;
                }
                if (!frame.isAttachedToWindow()) {
                    return;
                }
                Window window = this.mService.mWindow.getWindow();
                if (window == null) {
                    return;
                }
                View decor = window.peekDecorView();
                if (decor == null) {
                    return;
                }
                if (!(decor instanceof ViewGroup)) {
                    return;
                }
                ViewGroup decorGroup = (ViewGroup)decor;
                Insets currentSystemInsets = this.getSystemInsets();
                if (!Objects.equals(currentSystemInsets, this.mLastInsets)) {
                    frame.setLayoutParams(new FrameLayout.LayoutParams(-1, currentSystemInsets.bottom, 80));
                    this.mLastInsets = currentSystemInsets;
                }
                if ((navbarBackgroundView = window.getNavigationBarBackgroundView()) != null && decorGroup.indexOfChild(navbarBackgroundView) > decorGroup.indexOfChild(frame)) {
                    decorGroup.bringChildToFront(frame);
                }
            });
        }

        @Override
        public void onSoftInputWindowCreated(SoftInputWindow softInputWindow) {
            Window window = softInputWindow.getWindow();
            this.mAppearance = window.getSystemBarAppearance();
            window.setDecorCallback(this);
        }

        @Override
        public void onViewInitialized() {
            if (this.mDestroyed) {
                return;
            }
            this.installNavigationBarFrameIfNecessary();
        }

        @Override
        public void onDestroy() {
            if (this.mDestroyed) {
                return;
            }
            if (this.mTintAnimator != null) {
                this.mTintAnimator.cancel();
                this.mTintAnimator = null;
            }
            this.mDestroyed = true;
        }

        @Override
        public void onWindowShown() {
            if (this.mDestroyed || !this.mImeDrawsImeNavBar || this.mNavigationBarFrame == null) {
                return;
            }
            Insets systemInsets = this.getSystemInsets();
            if (systemInsets != null) {
                Window window;
                View rawDecorView;
                if (!Objects.equals(systemInsets, this.mLastInsets)) {
                    this.mNavigationBarFrame.setLayoutParams(new FrameLayout.LayoutParams(-1, systemInsets.bottom, 80));
                    this.mLastInsets = systemInsets;
                }
                if ((rawDecorView = (window = this.mService.mWindow.getWindow()).getDecorView()) instanceof ViewGroup) {
                    ViewGroup decor = (ViewGroup)rawDecorView;
                    View navbarBackgroundView = window.getNavigationBarBackgroundView();
                    if (navbarBackgroundView != null && decor.indexOfChild(navbarBackgroundView) > decor.indexOfChild(this.mNavigationBarFrame)) {
                        decor.bringChildToFront(this.mNavigationBarFrame);
                    }
                }
                this.mNavigationBarFrame.setVisibility(0);
            }
        }

        @Override
        public void onNavButtonFlagsChanged(int navButtonFlags) {
            if (this.mDestroyed) {
                return;
            }
            boolean imeDrawsImeNavBar = (navButtonFlags & 1) != 0;
            boolean shouldShowImeSwitcherWhenImeIsShown = (navButtonFlags & 2) != 0;
            this.mImeDrawsImeNavBar = imeDrawsImeNavBar;
            boolean prevShouldShowImeSwitcherWhenImeIsShown = this.mShouldShowImeSwitcherWhenImeIsShown;
            this.mShouldShowImeSwitcherWhenImeIsShown = shouldShowImeSwitcherWhenImeIsShown;
            if (imeDrawsImeNavBar) {
                this.installNavigationBarFrameIfNecessary();
                if (this.mNavigationBarFrame == null) {
                    return;
                }
                if (this.mShouldShowImeSwitcherWhenImeIsShown == prevShouldShowImeSwitcherWhenImeIsShown) {
                    return;
                }
                NavigationBarView navigationBarView = (NavigationBarView)this.mNavigationBarFrame.findViewByPredicate(NavigationBarView.class::isInstance);
                if (navigationBarView == null) {
                    return;
                }
                int hints = 1 | (shouldShowImeSwitcherWhenImeIsShown ? 4 : 0);
                navigationBarView.setNavigationIconHints(hints);
            } else {
                this.uninstallNavigationBarFrameIfNecessary();
            }
        }

        @Override
        public void onSystemBarAppearanceChanged(int appearance) {
            if (this.mDestroyed) {
                return;
            }
            this.mAppearance = appearance;
            if (this.mNavigationBarFrame == null) {
                return;
            }
            float targetDarkIntensity = Impl.calculateTargetDarkIntensity(this.mAppearance, this.mDrawLegacyNavigationBarBackground);
            if (this.mTintAnimator != null) {
                this.mTintAnimator.cancel();
            }
            this.mTintAnimator = ValueAnimator.ofFloat(this.mDarkIntensity, targetDarkIntensity);
            this.mTintAnimator.addUpdateListener(animation -> this.setIconTintInternal(((Float)animation.getAnimatedValue()).floatValue()));
            this.mTintAnimator.setDuration(1700L);
            this.mTintAnimator.setStartDelay(0L);
            this.mTintAnimator.setInterpolator(LEGACY_DECELERATE);
            this.mTintAnimator.start();
        }

        private void setIconTintInternal(float darkIntensity) {
            this.mDarkIntensity = darkIntensity;
            if (this.mNavigationBarFrame == null) {
                return;
            }
            NavigationBarView navigationBarView = (NavigationBarView)this.mNavigationBarFrame.findViewByPredicate(NavigationBarView.class::isInstance);
            if (navigationBarView == null) {
                return;
            }
            navigationBarView.setDarkIntensity(darkIntensity);
        }

        private static float calculateTargetDarkIntensity(int appearance, boolean drawLegacyNavigationBarBackground) {
            boolean lightNavBar = !drawLegacyNavigationBarBackground && (appearance & 0x10) != 0;
            return lightNavBar ? 1.0f : 0.0f;
        }

        @Override
        public boolean onDrawLegacyNavigationBarBackgroundChanged(boolean drawLegacyNavigationBarBackground) {
            if (this.mDestroyed) {
                return false;
            }
            if (drawLegacyNavigationBarBackground != this.mDrawLegacyNavigationBarBackground) {
                this.mDrawLegacyNavigationBarBackground = drawLegacyNavigationBarBackground;
                if (this.mNavigationBarFrame != null) {
                    if (this.mDrawLegacyNavigationBarBackground) {
                        this.mNavigationBarFrame.setBackgroundColor(-16777216);
                    } else {
                        this.mNavigationBarFrame.setBackground(null);
                    }
                    this.scheduleRelayout();
                }
                this.onSystemBarAppearanceChanged(this.mAppearance);
            }
            return drawLegacyNavigationBarBackground;
        }

        @Override
        public String toDebugString() {
            return "{mImeDrawsImeNavBar=" + this.mImeDrawsImeNavBar + " mNavigationBarFrame=" + this.mNavigationBarFrame + " mShouldShowImeSwitcherWhenImeIsShown=" + this.mShouldShowImeSwitcherWhenImeIsShown + " mAppearance=0x" + Integer.toHexString(this.mAppearance) + " mDarkIntensity=" + this.mDarkIntensity + " mDrawLegacyNavigationBarBackground=" + this.mDrawLegacyNavigationBarBackground + "}";
        }
    }

    private static interface Callback {
        public static final Callback NOOP = new Callback(){};

        default public void updateTouchableInsets(InputMethodService.Insets originalInsets, ViewTreeObserver.InternalInsetsInfo dest) {
        }

        default public void onSoftInputWindowCreated(SoftInputWindow softInputWindow) {
        }

        default public void onViewInitialized() {
        }

        default public void onWindowShown() {
        }

        default public void onDestroy() {
        }

        default public void onNavButtonFlagsChanged(int navButtonFlags) {
        }

        default public String toDebugString() {
            return "No-op implementation";
        }
    }
}

