/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.duration;

import android.icu.impl.duration.BasicPeriodBuilderFactory;
import android.icu.impl.duration.Period;
import android.icu.impl.duration.PeriodBuilder;
import android.icu.impl.duration.PeriodBuilderImpl;
import android.icu.impl.duration.TimeUnit;

class FixedUnitBuilder
extends PeriodBuilderImpl {
    private TimeUnit unit;

    public static FixedUnitBuilder get(TimeUnit unit, BasicPeriodBuilderFactory.Settings settingsToUse) {
        if (settingsToUse != null && (settingsToUse.effectiveSet() & 1 << unit.ordinal) != 0) {
            return new FixedUnitBuilder(unit, settingsToUse);
        }
        return null;
    }

    FixedUnitBuilder(TimeUnit unit, BasicPeriodBuilderFactory.Settings settings) {
        super(settings);
        this.unit = unit;
    }

    @Override
    protected PeriodBuilder withSettings(BasicPeriodBuilderFactory.Settings settingsToUse) {
        return FixedUnitBuilder.get(this.unit, settingsToUse);
    }

    @Override
    protected Period handleCreate(long duration, long referenceDate, boolean inPast) {
        if (this.unit == null) {
            return null;
        }
        long unitDuration = this.approximateDurationOf(this.unit);
        return Period.at((float)((double)duration / (double)unitDuration), this.unit).inPast(inPast);
    }
}

