/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.companion.virtual.IVirtualDevice;
import android.graphics.PointF;
import android.hardware.input.VirtualMouseButtonEvent;
import android.hardware.input.VirtualMouseRelativeEvent;
import android.hardware.input.VirtualMouseScrollEvent;
import android.os.IBinder;
import android.os.RemoteException;
import java.io.Closeable;

@SystemApi
public class VirtualMouse
implements Closeable {
    private final IVirtualDevice mVirtualDevice;
    private final IBinder mToken;

    public VirtualMouse(IVirtualDevice virtualDevice, IBinder token) {
        this.mVirtualDevice = virtualDevice;
        this.mToken = token;
    }

    @Override
    @RequiresPermission(value="android.permission.CREATE_VIRTUAL_DEVICE")
    public void close() {
        try {
            this.mVirtualDevice.unregisterInputDevice(this.mToken);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.CREATE_VIRTUAL_DEVICE")
    public void sendButtonEvent(VirtualMouseButtonEvent event) {
        try {
            this.mVirtualDevice.sendButtonEvent(this.mToken, event);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.CREATE_VIRTUAL_DEVICE")
    public void sendScrollEvent(VirtualMouseScrollEvent event) {
        try {
            this.mVirtualDevice.sendScrollEvent(this.mToken, event);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.CREATE_VIRTUAL_DEVICE")
    public void sendRelativeEvent(VirtualMouseRelativeEvent event) {
        try {
            this.mVirtualDevice.sendRelativeEvent(this.mToken, event);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.CREATE_VIRTUAL_DEVICE")
    public PointF getCursorPosition() {
        try {
            return this.mVirtualDevice.getCursorPosition(this.mToken);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }
}

