/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.annotation.RequiresPermission;
import android.app.ActivityThread;
import android.app.Application;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.hardware.SensorManager;
import android.hardware.input.IInputDevicesChangedListener;
import android.hardware.input.IInputManager;
import android.hardware.input.IInputSensorEventListener;
import android.hardware.input.ITabletModeChangedListener;
import android.hardware.input.InputDeviceBatteryState;
import android.hardware.input.InputDeviceIdentifier;
import android.hardware.input.InputDeviceLightsManager;
import android.hardware.input.InputDeviceSensorManager;
import android.hardware.input.InputDeviceVibrator;
import android.hardware.input.InputDeviceVibratorManager;
import android.hardware.input.InputSensorInfo;
import android.hardware.input.KeyboardLayout;
import android.hardware.input.TouchCalibration;
import android.hardware.lights.Light;
import android.hardware.lights.LightState;
import android.hardware.lights.LightsManager;
import android.hardware.lights.LightsRequest;
import android.os.Binder;
import android.os.BlockUntrustedTouchesMode;
import android.os.CombinedVibration;
import android.os.Handler;
import android.os.IBinder;
import android.os.IVibratorStateListener;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.os.VibratorManager;
import android.provider.Settings;
import android.util.Log;
import android.util.SparseArray;
import android.view.InputDevice;
import android.view.InputEvent;
import android.view.InputMonitor;
import android.view.PointerIcon;
import android.view.VerifiedInputEvent;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.SomeArgs;
import com.android.internal.util.ArrayUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public class InputManager {
    private static final String TAG = "InputManager";
    private static final boolean DEBUG = false;
    private static final int MSG_DEVICE_ADDED = 1;
    private static final int MSG_DEVICE_REMOVED = 2;
    private static final int MSG_DEVICE_CHANGED = 3;
    public static final int[] BLOCK_UNTRUSTED_TOUCHES_MODES = new int[]{0, 1, 2};
    public static InputManager sInstance;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private final IInputManager mIm;
    private final Object mInputDevicesLock = new Object();
    private SparseArray<InputDevice> mInputDevices;
    private InputDevicesChangedListener mInputDevicesChangedListener;
    private final ArrayList<InputDeviceListenerDelegate> mInputDeviceListeners = new ArrayList();
    private final Object mTabletModeLock = new Object();
    private TabletModeChangedListener mTabletModeChangedListener;
    private List<OnTabletModeChangedListenerDelegate> mOnTabletModeChangedListeners;
    private InputDeviceSensorManager mInputDeviceSensorManager;
    public static final String ACTION_QUERY_KEYBOARD_LAYOUTS = "android.hardware.input.action.QUERY_KEYBOARD_LAYOUTS";
    public static final String META_DATA_KEYBOARD_LAYOUTS = "android.hardware.input.metadata.KEYBOARD_LAYOUTS";
    public static final int MIN_POINTER_SPEED = -7;
    public static final int MAX_POINTER_SPEED = 7;
    public static final int DEFAULT_POINTER_SPEED = 0;
    public static final float DEFAULT_MAXIMUM_OBSCURING_OPACITY_FOR_TOUCH = 0.8f;
    @BlockUntrustedTouchesMode
    public static final int DEFAULT_BLOCK_UNTRUSTED_TOUCHES_MODE = 2;
    public static final long BLOCK_UNTRUSTED_TOUCHES = 158002302L;
    public static final int INJECT_INPUT_EVENT_MODE_ASYNC = 0;
    public static final int INJECT_INPUT_EVENT_MODE_WAIT_FOR_RESULT = 1;
    @UnsupportedAppUsage(trackingBug=171972397L)
    public static final int INJECT_INPUT_EVENT_MODE_WAIT_FOR_FINISH = 2;
    public static final int SWITCH_STATE_UNKNOWN = -1;
    public static final int SWITCH_STATE_OFF = 0;
    public static final int SWITCH_STATE_ON = 1;

    public InputManager(IInputManager im) {
        this.mIm = im;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static InputManager resetInstance(IInputManager inputManagerService) {
        Class<InputManager> clazz = InputManager.class;
        synchronized (InputManager.class) {
            sInstance = new InputManager(inputManagerService);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static void clearInstance() {
        Class<InputManager> clazz = InputManager.class;
        synchronized (InputManager.class) {
            sInstance = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static InputManager getInstance() {
        Class<InputManager> clazz = InputManager.class;
        synchronized (InputManager.class) {
            if (sInstance == null) {
                try {
                    sInstance = new InputManager(IInputManager.Stub.asInterface(ServiceManager.getServiceOrThrow("input")));
                }
                catch (ServiceManager.ServiceNotFoundException e) {
                    throw new IllegalStateException(e);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputDevice getInputDevice(int id2) {
        Object object = this.mInputDevicesLock;
        synchronized (object) {
            this.populateInputDevicesLocked();
            int index = this.mInputDevices.indexOfKey(id2);
            if (index < 0) {
                return null;
            }
            InputDevice inputDevice = this.mInputDevices.valueAt(index);
            if (inputDevice == null) {
                try {
                    inputDevice = this.mIm.getInputDevice(id2);
                }
                catch (RemoteException ex) {
                    throw ex.rethrowFromSystemServer();
                }
                if (inputDevice != null) {
                    this.mInputDevices.setValueAt(index, inputDevice);
                }
            }
            return inputDevice;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputDevice getInputDeviceByDescriptor(String descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException("descriptor must not be null.");
        }
        Object object = this.mInputDevicesLock;
        synchronized (object) {
            this.populateInputDevicesLocked();
            int numDevices = this.mInputDevices.size();
            for (int i = 0; i < numDevices; ++i) {
                InputDevice inputDevice = this.mInputDevices.valueAt(i);
                if (inputDevice == null) {
                    int id2 = this.mInputDevices.keyAt(i);
                    try {
                        inputDevice = this.mIm.getInputDevice(id2);
                    }
                    catch (RemoteException ex) {
                        throw ex.rethrowFromSystemServer();
                    }
                    if (inputDevice == null) continue;
                    this.mInputDevices.setValueAt(i, inputDevice);
                }
                if (!descriptor.equals(inputDevice.getDescriptor())) continue;
                return inputDevice;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getInputDeviceIds() {
        Object object = this.mInputDevicesLock;
        synchronized (object) {
            this.populateInputDevicesLocked();
            int count = this.mInputDevices.size();
            int[] ids = new int[count];
            for (int i = 0; i < count; ++i) {
                ids[i] = this.mInputDevices.keyAt(i);
            }
            return ids;
        }
    }

    public boolean isInputDeviceEnabled(int id2) {
        try {
            return this.mIm.isInputDeviceEnabled(id2);
        }
        catch (RemoteException ex) {
            Log.w(TAG, "Could not check enabled status of input device with id = " + id2);
            throw ex.rethrowFromSystemServer();
        }
    }

    public void enableInputDevice(int id2) {
        try {
            this.mIm.enableInputDevice(id2);
        }
        catch (RemoteException ex) {
            Log.w(TAG, "Could not enable input device with id = " + id2);
            throw ex.rethrowFromSystemServer();
        }
    }

    public void disableInputDevice(int id2) {
        try {
            this.mIm.disableInputDevice(id2);
        }
        catch (RemoteException ex) {
            Log.w(TAG, "Could not disable input device with id = " + id2);
            throw ex.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInputDeviceListener(InputDeviceListener listener, Handler handler) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        Object object = this.mInputDevicesLock;
        synchronized (object) {
            this.populateInputDevicesLocked();
            int index = this.findInputDeviceListenerLocked(listener);
            if (index < 0) {
                this.mInputDeviceListeners.add(new InputDeviceListenerDelegate(listener, handler));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterInputDeviceListener(InputDeviceListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        Object object = this.mInputDevicesLock;
        synchronized (object) {
            int index = this.findInputDeviceListenerLocked(listener);
            if (index >= 0) {
                InputDeviceListenerDelegate d = this.mInputDeviceListeners.get(index);
                d.removeCallbacksAndMessages(null);
                this.mInputDeviceListeners.remove(index);
            }
        }
    }

    private int findInputDeviceListenerLocked(InputDeviceListener listener) {
        int numListeners = this.mInputDeviceListeners.size();
        for (int i = 0; i < numListeners; ++i) {
            if (this.mInputDeviceListeners.get((int)i).mListener != listener) continue;
            return i;
        }
        return -1;
    }

    public int isInTabletMode() {
        try {
            return this.mIm.isInTabletMode();
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOnTabletModeChangedListener(OnTabletModeChangedListener listener, Handler handler) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        Object object = this.mTabletModeLock;
        synchronized (object) {
            int idx;
            if (this.mOnTabletModeChangedListeners == null) {
                this.initializeTabletModeListenerLocked();
            }
            if ((idx = this.findOnTabletModeChangedListenerLocked(listener)) < 0) {
                OnTabletModeChangedListenerDelegate d = new OnTabletModeChangedListenerDelegate(listener, handler);
                this.mOnTabletModeChangedListeners.add(d);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterOnTabletModeChangedListener(OnTabletModeChangedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        Object object = this.mTabletModeLock;
        synchronized (object) {
            int idx = this.findOnTabletModeChangedListenerLocked(listener);
            if (idx >= 0) {
                OnTabletModeChangedListenerDelegate d = this.mOnTabletModeChangedListeners.remove(idx);
                d.removeCallbacksAndMessages(null);
            }
        }
    }

    private void initializeTabletModeListenerLocked() {
        TabletModeChangedListener listener = new TabletModeChangedListener();
        try {
            this.mIm.registerTabletModeChangedListener(listener);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
        this.mTabletModeChangedListener = listener;
        this.mOnTabletModeChangedListeners = new ArrayList<OnTabletModeChangedListenerDelegate>();
    }

    private int findOnTabletModeChangedListenerLocked(OnTabletModeChangedListener listener) {
        int N = this.mOnTabletModeChangedListeners.size();
        for (int i = 0; i < N; ++i) {
            if (this.mOnTabletModeChangedListeners.get((int)i).mListener != listener) continue;
            return i;
        }
        return -1;
    }

    public int isMicMuted() {
        try {
            return this.mIm.isMicMuted();
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public KeyboardLayout[] getKeyboardLayouts() {
        try {
            return this.mIm.getKeyboardLayouts();
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public List<String> getKeyboardLayoutDescriptorsForInputDevice(InputDevice device) {
        KeyboardLayout[] layouts = this.getKeyboardLayoutsForInputDevice(device.getIdentifier());
        ArrayList<String> res = new ArrayList<String>();
        for (KeyboardLayout kl : layouts) {
            res.add(kl.getDescriptor());
        }
        return res;
    }

    public KeyboardLayout[] getKeyboardLayoutsForInputDevice(InputDeviceIdentifier identifier) {
        try {
            return this.mIm.getKeyboardLayoutsForInputDevice(identifier);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public KeyboardLayout getKeyboardLayout(String keyboardLayoutDescriptor) {
        if (keyboardLayoutDescriptor == null) {
            throw new IllegalArgumentException("keyboardLayoutDescriptor must not be null");
        }
        try {
            return this.mIm.getKeyboardLayout(keyboardLayoutDescriptor);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public String getCurrentKeyboardLayoutForInputDevice(InputDeviceIdentifier identifier) {
        try {
            return this.mIm.getCurrentKeyboardLayoutForInputDevice(identifier);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.SET_KEYBOARD_LAYOUT")
    public void setCurrentKeyboardLayoutForInputDevice(InputDeviceIdentifier identifier, String keyboardLayoutDescriptor) {
        if (identifier == null) {
            throw new IllegalArgumentException("identifier must not be null");
        }
        if (keyboardLayoutDescriptor == null) {
            throw new IllegalArgumentException("keyboardLayoutDescriptor must not be null");
        }
        try {
            this.mIm.setCurrentKeyboardLayoutForInputDevice(identifier, keyboardLayoutDescriptor);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public String[] getEnabledKeyboardLayoutsForInputDevice(InputDeviceIdentifier identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException("inputDeviceDescriptor must not be null");
        }
        try {
            return this.mIm.getEnabledKeyboardLayoutsForInputDevice(identifier);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.SET_KEYBOARD_LAYOUT")
    public void addKeyboardLayoutForInputDevice(InputDeviceIdentifier identifier, String keyboardLayoutDescriptor) {
        if (identifier == null) {
            throw new IllegalArgumentException("inputDeviceDescriptor must not be null");
        }
        if (keyboardLayoutDescriptor == null) {
            throw new IllegalArgumentException("keyboardLayoutDescriptor must not be null");
        }
        try {
            this.mIm.addKeyboardLayoutForInputDevice(identifier, keyboardLayoutDescriptor);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.SET_KEYBOARD_LAYOUT")
    public void removeKeyboardLayoutForInputDevice(InputDeviceIdentifier identifier, String keyboardLayoutDescriptor) {
        if (identifier == null) {
            throw new IllegalArgumentException("inputDeviceDescriptor must not be null");
        }
        if (keyboardLayoutDescriptor == null) {
            throw new IllegalArgumentException("keyboardLayoutDescriptor must not be null");
        }
        try {
            this.mIm.removeKeyboardLayoutForInputDevice(identifier, keyboardLayoutDescriptor);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public TouchCalibration getTouchCalibration(String inputDeviceDescriptor, int surfaceRotation) {
        try {
            return this.mIm.getTouchCalibrationForInputDevice(inputDeviceDescriptor, surfaceRotation);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void setTouchCalibration(String inputDeviceDescriptor, int surfaceRotation, TouchCalibration calibration) {
        try {
            this.mIm.setTouchCalibrationForInputDevice(inputDeviceDescriptor, surfaceRotation, calibration);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public int getPointerSpeed(Context context) {
        int speed = 0;
        try {
            speed = Settings.System.getInt(context.getContentResolver(), "pointer_speed");
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            // empty catch block
        }
        return speed;
    }

    public void setPointerSpeed(Context context, int speed) {
        if (speed < -7 || speed > 7) {
            throw new IllegalArgumentException("speed out of range");
        }
        Settings.System.putInt(context.getContentResolver(), "pointer_speed", speed);
    }

    public void tryPointerSpeed(int speed) {
        if (speed < -7 || speed > 7) {
            throw new IllegalArgumentException("speed out of range");
        }
        try {
            this.mIm.tryPointerSpeed(speed);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public float getMaximumObscuringOpacityForTouch() {
        Application context = ActivityThread.currentApplication();
        return Settings.Global.getFloat(((Context)context).getContentResolver(), "maximum_obscuring_opacity_for_touch", 0.8f);
    }

    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public void setMaximumObscuringOpacityForTouch(float opacity) {
        if (opacity < 0.0f || opacity > 1.0f) {
            throw new IllegalArgumentException("Maximum obscuring opacity for touch should be >= 0 and <= 1");
        }
        Application context = ActivityThread.currentApplication();
        Settings.Global.putFloat(((Context)context).getContentResolver(), "maximum_obscuring_opacity_for_touch", opacity);
    }

    @BlockUntrustedTouchesMode
    public int getBlockUntrustedTouchesMode(Context context) {
        int mode = Settings.Global.getInt(context.getContentResolver(), "block_untrusted_touches", 2);
        if (!ArrayUtils.contains(BLOCK_UNTRUSTED_TOUCHES_MODES, mode)) {
            Log.w(TAG, "Unknown block untrusted touches feature mode " + mode + ", using default " + 2);
            return 2;
        }
        return mode;
    }

    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public void setBlockUntrustedTouchesMode(Context context, @BlockUntrustedTouchesMode int mode) {
        if (!ArrayUtils.contains(BLOCK_UNTRUSTED_TOUCHES_MODES, mode)) {
            throw new IllegalArgumentException("Invalid feature mode " + mode);
        }
        Settings.Global.putInt(context.getContentResolver(), "block_untrusted_touches", mode);
    }

    public boolean[] deviceHasKeys(int[] keyCodes) {
        return this.deviceHasKeys(-1, keyCodes);
    }

    public boolean[] deviceHasKeys(int id2, int[] keyCodes) {
        boolean[] ret = new boolean[keyCodes.length];
        try {
            this.mIm.hasKeys(id2, -256, keyCodes, ret);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return ret;
    }

    public int getKeyCodeForKeyLocation(int deviceId, int locationKeyCode) {
        try {
            return this.mIm.getKeyCodeForKeyLocation(deviceId, locationKeyCode);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.INJECT_EVENTS")
    public boolean injectInputEvent(InputEvent event, int mode, int targetUid) {
        if (event == null) {
            throw new IllegalArgumentException("event must not be null");
        }
        if (mode != 0 && mode != 2 && mode != 1) {
            throw new IllegalArgumentException("mode is invalid");
        }
        try {
            return this.mIm.injectInputEventToTarget(event, mode, targetUid);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.INJECT_EVENTS")
    @UnsupportedAppUsage
    public boolean injectInputEvent(InputEvent event, int mode) {
        return this.injectInputEvent(event, mode, -1);
    }

    public VerifiedInputEvent verifyInputEvent(InputEvent event) {
        try {
            return this.mIm.verifyInputEvent(event);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    public void setPointerIconType(int iconId) {
        try {
            this.mIm.setPointerIconType(iconId);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void setCustomPointerIcon(PointerIcon icon) {
        try {
            this.mIm.setCustomPointerIcon(icon);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void requestPointerCapture(IBinder windowToken, boolean enable) {
        try {
            this.mIm.requestPointerCapture(windowToken, enable);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public InputMonitor monitorGestureInput(String name, int displayId) {
        try {
            return this.mIm.monitorGestureInput(new Binder(), name, displayId);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public InputSensorInfo[] getSensorList(int deviceId) {
        try {
            return this.mIm.getSensorList(deviceId);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public boolean enableSensor(int deviceId, int sensorType, int samplingPeriodUs, int maxBatchReportLatencyUs) {
        try {
            return this.mIm.enableSensor(deviceId, sensorType, samplingPeriodUs, maxBatchReportLatencyUs);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void disableSensor(int deviceId, int sensorType) {
        try {
            this.mIm.disableSensor(deviceId, sensorType);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public boolean flushSensor(int deviceId, int sensorType) {
        try {
            return this.mIm.flushSensor(deviceId, sensorType);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public boolean registerSensorListener(IInputSensorEventListener listener) {
        try {
            return this.mIm.registerSensorListener(listener);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void unregisterSensorListener(IInputSensorEventListener listener) {
        try {
            this.mIm.unregisterSensorListener(listener);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public int getBatteryStatus(int deviceId) {
        try {
            return this.mIm.getBatteryStatus(deviceId);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public int getBatteryCapacity(int deviceId) {
        try {
            return this.mIm.getBatteryCapacity(deviceId);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void addPortAssociation(String inputPort, int displayPort) {
        try {
            this.mIm.addPortAssociation(inputPort, displayPort);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void removePortAssociation(String inputPort) {
        try {
            this.mIm.removePortAssociation(inputPort);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void addUniqueIdAssociation(String inputPort, String displayUniqueId) {
        try {
            this.mIm.addUniqueIdAssociation(inputPort, displayUniqueId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void removeUniqueIdAssociation(String inputPort) {
        try {
            this.mIm.removeUniqueIdAssociation(inputPort);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private void populateInputDevicesLocked() {
        if (this.mInputDevicesChangedListener == null) {
            InputDevicesChangedListener listener = new InputDevicesChangedListener();
            try {
                this.mIm.registerInputDevicesChangedListener(listener);
            }
            catch (RemoteException ex) {
                throw ex.rethrowFromSystemServer();
            }
            this.mInputDevicesChangedListener = listener;
        }
        if (this.mInputDevices == null) {
            int[] ids;
            try {
                ids = this.mIm.getInputDeviceIds();
            }
            catch (RemoteException ex) {
                throw ex.rethrowFromSystemServer();
            }
            this.mInputDevices = new SparseArray();
            if (ids != null) {
                for (int i = 0; i < ids.length; ++i) {
                    this.mInputDevices.put(ids[i], null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onInputDevicesChanged(int[] deviceIdAndGeneration) {
        Object object = this.mInputDevicesLock;
        synchronized (object) {
            int deviceId;
            int i = this.mInputDevices.size();
            while (--i > 0) {
                deviceId = this.mInputDevices.keyAt(i);
                if (InputManager.containsDeviceId(deviceIdAndGeneration, deviceId)) continue;
                this.mInputDevices.removeAt(i);
                this.sendMessageToInputDeviceListenersLocked(2, deviceId);
            }
            for (i = 0; i < deviceIdAndGeneration.length; i += 2) {
                deviceId = deviceIdAndGeneration[i];
                int index = this.mInputDevices.indexOfKey(deviceId);
                if (index >= 0) {
                    InputDevice device = this.mInputDevices.valueAt(index);
                    if (device == null) continue;
                    int generation = deviceIdAndGeneration[i + 1];
                    if (device.getGeneration() == generation) continue;
                    this.mInputDevices.setValueAt(index, null);
                    this.sendMessageToInputDeviceListenersLocked(3, deviceId);
                    continue;
                }
                this.mInputDevices.put(deviceId, null);
                this.sendMessageToInputDeviceListenersLocked(1, deviceId);
            }
        }
    }

    private void sendMessageToInputDeviceListenersLocked(int what, int deviceId) {
        int numListeners = this.mInputDeviceListeners.size();
        for (int i = 0; i < numListeners; ++i) {
            InputDeviceListenerDelegate listener = this.mInputDeviceListeners.get(i);
            listener.sendMessage(listener.obtainMessage(what, deviceId, 0));
        }
    }

    private static boolean containsDeviceId(int[] deviceIdAndGeneration, int deviceId) {
        for (int i = 0; i < deviceIdAndGeneration.length; i += 2) {
            if (deviceIdAndGeneration[i] != deviceId) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTabletModeChanged(long whenNanos, boolean inTabletMode) {
        Object object = this.mTabletModeLock;
        synchronized (object) {
            int N = this.mOnTabletModeChangedListeners.size();
            for (int i = 0; i < N; ++i) {
                OnTabletModeChangedListenerDelegate listener = this.mOnTabletModeChangedListeners.get(i);
                listener.sendTabletModeChanged(whenNanos, inTabletMode);
            }
        }
    }

    public Vibrator getInputDeviceVibrator(int deviceId, int vibratorId) {
        return new InputDeviceVibrator(this, deviceId, vibratorId);
    }

    public VibratorManager getInputDeviceVibratorManager(int deviceId) {
        return new InputDeviceVibratorManager(this, deviceId);
    }

    int[] getVibratorIds(int deviceId) {
        try {
            return this.mIm.getVibratorIds(deviceId);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    void vibrate(int deviceId, VibrationEffect effect, IBinder token) {
        try {
            this.mIm.vibrate(deviceId, effect, token);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    void vibrate(int deviceId, CombinedVibration effect, IBinder token) {
        try {
            this.mIm.vibrateCombined(deviceId, effect, token);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    void cancelVibrate(int deviceId, IBinder token) {
        try {
            this.mIm.cancelVibrate(deviceId, token);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    boolean isVibrating(int deviceId) {
        try {
            return this.mIm.isVibrating(deviceId);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    boolean registerVibratorStateListener(int deviceId, IVibratorStateListener listener) {
        try {
            return this.mIm.registerVibratorStateListener(deviceId, listener);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    boolean unregisterVibratorStateListener(int deviceId, IVibratorStateListener listener) {
        try {
            return this.mIm.unregisterVibratorStateListener(deviceId, listener);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public SensorManager getInputDeviceSensorManager(int deviceId) {
        if (this.mInputDeviceSensorManager == null) {
            this.mInputDeviceSensorManager = new InputDeviceSensorManager(this);
        }
        return this.mInputDeviceSensorManager.getSensorManager(deviceId);
    }

    public InputDeviceBatteryState getInputDeviceBatteryState(int deviceId, boolean hasBattery) {
        return new InputDeviceBatteryState(this, deviceId, hasBattery);
    }

    public LightsManager getInputDeviceLightsManager(int deviceId) {
        return new InputDeviceLightsManager(this, deviceId);
    }

    List<Light> getLights(int deviceId) {
        try {
            return this.mIm.getLights(deviceId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    LightState getLightState(int deviceId, Light light) {
        try {
            return this.mIm.getLightState(deviceId, light.getId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    void requestLights(int deviceId, LightsRequest request, IBinder token) {
        try {
            List<Integer> lightIdList = request.getLights();
            int[] lightIds = new int[lightIdList.size()];
            for (int i = 0; i < lightIds.length; ++i) {
                lightIds[i] = lightIdList.get(i);
            }
            List<LightState> lightStateList = request.getLightStates();
            this.mIm.setLightStates(deviceId, lightIds, lightStateList.toArray(new LightState[lightStateList.size()]), token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    void openLightSession(int deviceId, String opPkg, IBinder token) {
        try {
            this.mIm.openLightSession(deviceId, opPkg, token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    void closeLightSession(int deviceId, IBinder token) {
        try {
            this.mIm.closeLightSession(deviceId, token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void cancelCurrentTouch() {
        try {
            this.mIm.cancelCurrentTouch();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static class OnTabletModeChangedListenerDelegate
    extends Handler {
        private static final int MSG_TABLET_MODE_CHANGED = 0;
        public final OnTabletModeChangedListener mListener;

        public OnTabletModeChangedListenerDelegate(OnTabletModeChangedListener listener, Handler handler) {
            super(handler != null ? handler.getLooper() : Looper.myLooper());
            this.mListener = listener;
        }

        public void sendTabletModeChanged(long whenNanos, boolean inTabletMode) {
            SomeArgs args = SomeArgs.obtain();
            args.argi1 = (int)(whenNanos & 0xFFFFFFFFFFFFFFFFL);
            args.argi2 = (int)(whenNanos >> 32);
            args.arg1 = inTabletMode;
            this.obtainMessage(0, args).sendToTarget();
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    long whenNanos = (long)args.argi1 & 0xFFFFFFFFL | (long)args.argi2 << 32;
                    boolean inTabletMode = (Boolean)args.arg1;
                    this.mListener.onTabletModeChanged(whenNanos, inTabletMode);
                }
            }
        }
    }

    private class TabletModeChangedListener
    extends ITabletModeChangedListener.Stub {
        private TabletModeChangedListener() {
        }

        @Override
        public void onTabletModeChanged(long whenNanos, boolean inTabletMode) {
            InputManager.this.onTabletModeChanged(whenNanos, inTabletMode);
        }
    }

    public static interface OnTabletModeChangedListener {
        public void onTabletModeChanged(long var1, boolean var3);
    }

    private static class InputDeviceListenerDelegate
    extends Handler {
        public final InputDeviceListener mListener;

        public InputDeviceListenerDelegate(InputDeviceListener listener, Handler handler) {
            super(handler != null ? handler.getLooper() : Looper.myLooper());
            this.mListener = listener;
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    this.mListener.onInputDeviceAdded(msg.arg1);
                    break;
                }
                case 2: {
                    this.mListener.onInputDeviceRemoved(msg.arg1);
                    break;
                }
                case 3: {
                    this.mListener.onInputDeviceChanged(msg.arg1);
                }
            }
        }
    }

    private class InputDevicesChangedListener
    extends IInputDevicesChangedListener.Stub {
        private InputDevicesChangedListener() {
        }

        @Override
        public void onInputDevicesChanged(int[] deviceIdAndGeneration) throws RemoteException {
            InputManager.this.onInputDevicesChanged(deviceIdAndGeneration);
        }
    }

    public static interface InputDeviceListener {
        public void onInputDeviceAdded(int var1);

        public void onInputDeviceRemoved(int var1);

        public void onInputDeviceChanged(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SwitchState {
    }
}

