/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.compat.annotation.UnsupportedAppUsage;
import android.hardware.input.IInputDevicesChangedListener;
import android.hardware.input.IInputSensorEventListener;
import android.hardware.input.ITabletModeChangedListener;
import android.hardware.input.InputDeviceIdentifier;
import android.hardware.input.InputSensorInfo;
import android.hardware.input.KeyboardLayout;
import android.hardware.input.TouchCalibration;
import android.hardware.lights.Light;
import android.hardware.lights.LightState;
import android.os.Binder;
import android.os.CombinedVibration;
import android.os.IBinder;
import android.os.IInterface;
import android.os.IVibratorStateListener;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.VibrationEffect;
import android.view.InputDevice;
import android.view.InputEvent;
import android.view.InputMonitor;
import android.view.PointerIcon;
import android.view.VerifiedInputEvent;
import java.util.ArrayList;
import java.util.List;

public interface IInputManager
extends IInterface {
    public InputDevice getInputDevice(int var1) throws RemoteException;

    public int[] getInputDeviceIds() throws RemoteException;

    public boolean isInputDeviceEnabled(int var1) throws RemoteException;

    public void enableInputDevice(int var1) throws RemoteException;

    public void disableInputDevice(int var1) throws RemoteException;

    public boolean hasKeys(int var1, int var2, int[] var3, boolean[] var4) throws RemoteException;

    public int getKeyCodeForKeyLocation(int var1, int var2) throws RemoteException;

    public void tryPointerSpeed(int var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/hardware/input/IInputManager.aidl:62:1:62:25")
    public boolean injectInputEvent(InputEvent var1, int var2) throws RemoteException;

    public boolean injectInputEventToTarget(InputEvent var1, int var2, int var3) throws RemoteException;

    public VerifiedInputEvent verifyInputEvent(InputEvent var1) throws RemoteException;

    public TouchCalibration getTouchCalibrationForInputDevice(String var1, int var2) throws RemoteException;

    public void setTouchCalibrationForInputDevice(String var1, int var2, TouchCalibration var3) throws RemoteException;

    public KeyboardLayout[] getKeyboardLayouts() throws RemoteException;

    public KeyboardLayout[] getKeyboardLayoutsForInputDevice(InputDeviceIdentifier var1) throws RemoteException;

    public KeyboardLayout getKeyboardLayout(String var1) throws RemoteException;

    public String getCurrentKeyboardLayoutForInputDevice(InputDeviceIdentifier var1) throws RemoteException;

    public void setCurrentKeyboardLayoutForInputDevice(InputDeviceIdentifier var1, String var2) throws RemoteException;

    public String[] getEnabledKeyboardLayoutsForInputDevice(InputDeviceIdentifier var1) throws RemoteException;

    public void addKeyboardLayoutForInputDevice(InputDeviceIdentifier var1, String var2) throws RemoteException;

    public void removeKeyboardLayoutForInputDevice(InputDeviceIdentifier var1, String var2) throws RemoteException;

    public void registerInputDevicesChangedListener(IInputDevicesChangedListener var1) throws RemoteException;

    public int isInTabletMode() throws RemoteException;

    public void registerTabletModeChangedListener(ITabletModeChangedListener var1) throws RemoteException;

    public int isMicMuted() throws RemoteException;

    public void vibrate(int var1, VibrationEffect var2, IBinder var3) throws RemoteException;

    public void vibrateCombined(int var1, CombinedVibration var2, IBinder var3) throws RemoteException;

    public void cancelVibrate(int var1, IBinder var2) throws RemoteException;

    public int[] getVibratorIds(int var1) throws RemoteException;

    public boolean isVibrating(int var1) throws RemoteException;

    public boolean registerVibratorStateListener(int var1, IVibratorStateListener var2) throws RemoteException;

    public boolean unregisterVibratorStateListener(int var1, IVibratorStateListener var2) throws RemoteException;

    public int getBatteryStatus(int var1) throws RemoteException;

    public int getBatteryCapacity(int var1) throws RemoteException;

    public void setPointerIconType(int var1) throws RemoteException;

    public void setCustomPointerIcon(PointerIcon var1) throws RemoteException;

    public void requestPointerCapture(IBinder var1, boolean var2) throws RemoteException;

    public InputMonitor monitorGestureInput(IBinder var1, String var2, int var3) throws RemoteException;

    public void addPortAssociation(String var1, int var2) throws RemoteException;

    public void removePortAssociation(String var1) throws RemoteException;

    public void addUniqueIdAssociation(String var1, String var2) throws RemoteException;

    public void removeUniqueIdAssociation(String var1) throws RemoteException;

    public InputSensorInfo[] getSensorList(int var1) throws RemoteException;

    public boolean registerSensorListener(IInputSensorEventListener var1) throws RemoteException;

    public void unregisterSensorListener(IInputSensorEventListener var1) throws RemoteException;

    public boolean enableSensor(int var1, int var2, int var3, int var4) throws RemoteException;

    public void disableSensor(int var1, int var2) throws RemoteException;

    public boolean flushSensor(int var1, int var2) throws RemoteException;

    public List<Light> getLights(int var1) throws RemoteException;

    public LightState getLightState(int var1, int var2) throws RemoteException;

    public void setLightStates(int var1, int[] var2, LightState[] var3, IBinder var4) throws RemoteException;

    public void openLightSession(int var1, String var2, IBinder var3) throws RemoteException;

    public void closeLightSession(int var1, IBinder var2) throws RemoteException;

    public void cancelCurrentTouch() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IInputManager {
        public static final String DESCRIPTOR = "android.hardware.input.IInputManager";
        static final int TRANSACTION_getInputDevice = 1;
        static final int TRANSACTION_getInputDeviceIds = 2;
        static final int TRANSACTION_isInputDeviceEnabled = 3;
        static final int TRANSACTION_enableInputDevice = 4;
        static final int TRANSACTION_disableInputDevice = 5;
        static final int TRANSACTION_hasKeys = 6;
        static final int TRANSACTION_getKeyCodeForKeyLocation = 7;
        static final int TRANSACTION_tryPointerSpeed = 8;
        static final int TRANSACTION_injectInputEvent = 9;
        static final int TRANSACTION_injectInputEventToTarget = 10;
        static final int TRANSACTION_verifyInputEvent = 11;
        static final int TRANSACTION_getTouchCalibrationForInputDevice = 12;
        static final int TRANSACTION_setTouchCalibrationForInputDevice = 13;
        static final int TRANSACTION_getKeyboardLayouts = 14;
        static final int TRANSACTION_getKeyboardLayoutsForInputDevice = 15;
        static final int TRANSACTION_getKeyboardLayout = 16;
        static final int TRANSACTION_getCurrentKeyboardLayoutForInputDevice = 17;
        static final int TRANSACTION_setCurrentKeyboardLayoutForInputDevice = 18;
        static final int TRANSACTION_getEnabledKeyboardLayoutsForInputDevice = 19;
        static final int TRANSACTION_addKeyboardLayoutForInputDevice = 20;
        static final int TRANSACTION_removeKeyboardLayoutForInputDevice = 21;
        static final int TRANSACTION_registerInputDevicesChangedListener = 22;
        static final int TRANSACTION_isInTabletMode = 23;
        static final int TRANSACTION_registerTabletModeChangedListener = 24;
        static final int TRANSACTION_isMicMuted = 25;
        static final int TRANSACTION_vibrate = 26;
        static final int TRANSACTION_vibrateCombined = 27;
        static final int TRANSACTION_cancelVibrate = 28;
        static final int TRANSACTION_getVibratorIds = 29;
        static final int TRANSACTION_isVibrating = 30;
        static final int TRANSACTION_registerVibratorStateListener = 31;
        static final int TRANSACTION_unregisterVibratorStateListener = 32;
        static final int TRANSACTION_getBatteryStatus = 33;
        static final int TRANSACTION_getBatteryCapacity = 34;
        static final int TRANSACTION_setPointerIconType = 35;
        static final int TRANSACTION_setCustomPointerIcon = 36;
        static final int TRANSACTION_requestPointerCapture = 37;
        static final int TRANSACTION_monitorGestureInput = 38;
        static final int TRANSACTION_addPortAssociation = 39;
        static final int TRANSACTION_removePortAssociation = 40;
        static final int TRANSACTION_addUniqueIdAssociation = 41;
        static final int TRANSACTION_removeUniqueIdAssociation = 42;
        static final int TRANSACTION_getSensorList = 43;
        static final int TRANSACTION_registerSensorListener = 44;
        static final int TRANSACTION_unregisterSensorListener = 45;
        static final int TRANSACTION_enableSensor = 46;
        static final int TRANSACTION_disableSensor = 47;
        static final int TRANSACTION_flushSensor = 48;
        static final int TRANSACTION_getLights = 49;
        static final int TRANSACTION_getLightState = 50;
        static final int TRANSACTION_setLightStates = 51;
        static final int TRANSACTION_openLightSession = 52;
        static final int TRANSACTION_closeLightSession = 53;
        static final int TRANSACTION_cancelCurrentTouch = 54;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IInputManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IInputManager) {
                return (IInputManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getInputDevice";
                }
                case 2: {
                    return "getInputDeviceIds";
                }
                case 3: {
                    return "isInputDeviceEnabled";
                }
                case 4: {
                    return "enableInputDevice";
                }
                case 5: {
                    return "disableInputDevice";
                }
                case 6: {
                    return "hasKeys";
                }
                case 7: {
                    return "getKeyCodeForKeyLocation";
                }
                case 8: {
                    return "tryPointerSpeed";
                }
                case 9: {
                    return "injectInputEvent";
                }
                case 10: {
                    return "injectInputEventToTarget";
                }
                case 11: {
                    return "verifyInputEvent";
                }
                case 12: {
                    return "getTouchCalibrationForInputDevice";
                }
                case 13: {
                    return "setTouchCalibrationForInputDevice";
                }
                case 14: {
                    return "getKeyboardLayouts";
                }
                case 15: {
                    return "getKeyboardLayoutsForInputDevice";
                }
                case 16: {
                    return "getKeyboardLayout";
                }
                case 17: {
                    return "getCurrentKeyboardLayoutForInputDevice";
                }
                case 18: {
                    return "setCurrentKeyboardLayoutForInputDevice";
                }
                case 19: {
                    return "getEnabledKeyboardLayoutsForInputDevice";
                }
                case 20: {
                    return "addKeyboardLayoutForInputDevice";
                }
                case 21: {
                    return "removeKeyboardLayoutForInputDevice";
                }
                case 22: {
                    return "registerInputDevicesChangedListener";
                }
                case 23: {
                    return "isInTabletMode";
                }
                case 24: {
                    return "registerTabletModeChangedListener";
                }
                case 25: {
                    return "isMicMuted";
                }
                case 26: {
                    return "vibrate";
                }
                case 27: {
                    return "vibrateCombined";
                }
                case 28: {
                    return "cancelVibrate";
                }
                case 29: {
                    return "getVibratorIds";
                }
                case 30: {
                    return "isVibrating";
                }
                case 31: {
                    return "registerVibratorStateListener";
                }
                case 32: {
                    return "unregisterVibratorStateListener";
                }
                case 33: {
                    return "getBatteryStatus";
                }
                case 34: {
                    return "getBatteryCapacity";
                }
                case 35: {
                    return "setPointerIconType";
                }
                case 36: {
                    return "setCustomPointerIcon";
                }
                case 37: {
                    return "requestPointerCapture";
                }
                case 38: {
                    return "monitorGestureInput";
                }
                case 39: {
                    return "addPortAssociation";
                }
                case 40: {
                    return "removePortAssociation";
                }
                case 41: {
                    return "addUniqueIdAssociation";
                }
                case 42: {
                    return "removeUniqueIdAssociation";
                }
                case 43: {
                    return "getSensorList";
                }
                case 44: {
                    return "registerSensorListener";
                }
                case 45: {
                    return "unregisterSensorListener";
                }
                case 46: {
                    return "enableSensor";
                }
                case 47: {
                    return "disableSensor";
                }
                case 48: {
                    return "flushSensor";
                }
                case 49: {
                    return "getLights";
                }
                case 50: {
                    return "getLightState";
                }
                case 51: {
                    return "setLightStates";
                }
                case 52: {
                    return "openLightSession";
                }
                case 53: {
                    return "closeLightSession";
                }
                case 54: {
                    return "cancelCurrentTouch";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    InputDevice _result = this.getInputDevice(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 2: {
                    int[] _result = this.getInputDeviceIds();
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isInputDeviceEnabled(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.enableInputDevice(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.disableInputDevice(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int[] _arg2 = data.createIntArray();
                    int _arg3_length = data.readInt();
                    boolean[] _arg3 = _arg3_length < 0 ? null : new boolean[_arg3_length];
                    data.enforceNoDataAvail();
                    boolean _result = this.hasKeys(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    reply.writeBooleanArray(_arg3);
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getKeyCodeForKeyLocation(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.tryPointerSpeed(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    InputEvent _arg0 = data.readTypedObject(InputEvent.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.injectInputEvent(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 10: {
                    InputEvent _arg0 = data.readTypedObject(InputEvent.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.injectInputEventToTarget(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 11: {
                    InputEvent _arg0 = data.readTypedObject(InputEvent.CREATOR);
                    data.enforceNoDataAvail();
                    VerifiedInputEvent _result = this.verifyInputEvent(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 12: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    TouchCalibration _result = this.getTouchCalibrationForInputDevice(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 13: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    TouchCalibration _arg2 = data.readTypedObject(TouchCalibration.CREATOR);
                    data.enforceNoDataAvail();
                    this.setTouchCalibrationForInputDevice(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    Parcelable[] _result = this.getKeyboardLayouts();
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 15: {
                    InputDeviceIdentifier _arg0 = data.readTypedObject(InputDeviceIdentifier.CREATOR);
                    data.enforceNoDataAvail();
                    Parcelable[] _result = this.getKeyboardLayoutsForInputDevice(_arg0);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 16: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    KeyboardLayout _result = this.getKeyboardLayout(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 17: {
                    InputDeviceIdentifier _arg0 = data.readTypedObject(InputDeviceIdentifier.CREATOR);
                    data.enforceNoDataAvail();
                    String _result = this.getCurrentKeyboardLayoutForInputDevice(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 18: {
                    InputDeviceIdentifier _arg0 = data.readTypedObject(InputDeviceIdentifier.CREATOR);
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.setCurrentKeyboardLayoutForInputDevice(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    InputDeviceIdentifier _arg0 = data.readTypedObject(InputDeviceIdentifier.CREATOR);
                    data.enforceNoDataAvail();
                    String[] _result = this.getEnabledKeyboardLayoutsForInputDevice(_arg0);
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    break;
                }
                case 20: {
                    InputDeviceIdentifier _arg0 = data.readTypedObject(InputDeviceIdentifier.CREATOR);
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.addKeyboardLayoutForInputDevice(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 21: {
                    InputDeviceIdentifier _arg0 = data.readTypedObject(InputDeviceIdentifier.CREATOR);
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.removeKeyboardLayoutForInputDevice(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 22: {
                    IInputDevicesChangedListener _arg0 = IInputDevicesChangedListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerInputDevicesChangedListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    int _result = this.isInTabletMode();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 24: {
                    ITabletModeChangedListener _arg0 = ITabletModeChangedListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerTabletModeChangedListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 25: {
                    int _result = this.isMicMuted();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 26: {
                    int _arg0 = data.readInt();
                    VibrationEffect _arg1 = data.readTypedObject(VibrationEffect.CREATOR);
                    IBinder _arg2 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.vibrate(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 27: {
                    int _arg0 = data.readInt();
                    CombinedVibration _arg1 = data.readTypedObject(CombinedVibration.CREATOR);
                    IBinder _arg2 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.vibrateCombined(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 28: {
                    int _arg0 = data.readInt();
                    IBinder _arg1 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.cancelVibrate(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 29: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int[] _result = this.getVibratorIds(_arg0);
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 30: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isVibrating(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 31: {
                    int _arg0 = data.readInt();
                    IVibratorStateListener _arg1 = IVibratorStateListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    boolean _result = this.registerVibratorStateListener(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 32: {
                    int _arg0 = data.readInt();
                    IVibratorStateListener _arg1 = IVibratorStateListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    boolean _result = this.unregisterVibratorStateListener(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 33: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getBatteryStatus(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 34: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getBatteryCapacity(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 35: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setPointerIconType(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 36: {
                    PointerIcon _arg0 = data.readTypedObject(PointerIcon.CREATOR);
                    data.enforceNoDataAvail();
                    this.setCustomPointerIcon(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 37: {
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.requestPointerCapture(_arg0, _arg1);
                    break;
                }
                case 38: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    InputMonitor _result = this.monitorGestureInput(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 39: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.addPortAssociation(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 40: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.removePortAssociation(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 41: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.addUniqueIdAssociation(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 42: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.removeUniqueIdAssociation(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 43: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    Parcelable[] _result = this.getSensorList(_arg0);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 44: {
                    IInputSensorEventListener _arg0 = IInputSensorEventListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    boolean _result = this.registerSensorListener(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 45: {
                    IInputSensorEventListener _arg0 = IInputSensorEventListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterSensorListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 46: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.enableSensor(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 47: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.disableSensor(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 48: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.flushSensor(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 49: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    List<Light> _result = this.getLights(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    break;
                }
                case 50: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    LightState _result = this.getLightState(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 51: {
                    int _arg0 = data.readInt();
                    int[] _arg1 = data.createIntArray();
                    LightState[] _arg2 = data.createTypedArray(LightState.CREATOR);
                    IBinder _arg3 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.setLightStates(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 52: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    IBinder _arg2 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.openLightSession(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 53: {
                    int _arg0 = data.readInt();
                    IBinder _arg1 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.closeLightSession(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 54: {
                    this.cancelCurrentTouch();
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 53;
        }

        private static class Proxy
        implements IInputManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public InputDevice getInputDevice(int deviceId) throws RemoteException {
                InputDevice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(InputDevice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getInputDeviceIds() throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isInputDeviceEnabled(int deviceId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableInputDevice(int deviceId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disableInputDevice(int deviceId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasKeys(int deviceId, int sourceMask, int[] keyCodes, boolean[] keyExists) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    _data.writeInt(sourceMask);
                    _data.writeIntArray(keyCodes);
                    if (keyExists == null) {
                        _data.writeInt(-1);
                    } else {
                        _data.writeInt(keyExists.length);
                    }
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                    _reply.readBooleanArray(keyExists);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getKeyCodeForKeyLocation(int deviceId, int locationKeyCode) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    _data.writeInt(locationKeyCode);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void tryPointerSpeed(int speed) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(speed);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean injectInputEvent(InputEvent ev, int mode) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(ev, 0);
                    _data.writeInt(mode);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean injectInputEventToTarget(InputEvent ev, int mode, int targetUid) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(ev, 0);
                    _data.writeInt(mode);
                    _data.writeInt(targetUid);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public VerifiedInputEvent verifyInputEvent(InputEvent ev) throws RemoteException {
                VerifiedInputEvent _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(ev, 0);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(VerifiedInputEvent.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public TouchCalibration getTouchCalibrationForInputDevice(String inputDeviceDescriptor, int rotation) throws RemoteException {
                TouchCalibration _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(inputDeviceDescriptor);
                    _data.writeInt(rotation);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(TouchCalibration.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTouchCalibrationForInputDevice(String inputDeviceDescriptor, int rotation, TouchCalibration calibration) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(inputDeviceDescriptor);
                    _data.writeInt(rotation);
                    _data.writeTypedObject(calibration, 0);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public KeyboardLayout[] getKeyboardLayouts() throws RemoteException {
                KeyboardLayout[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(KeyboardLayout.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public KeyboardLayout[] getKeyboardLayoutsForInputDevice(InputDeviceIdentifier identifier) throws RemoteException {
                KeyboardLayout[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(identifier, 0);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(KeyboardLayout.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public KeyboardLayout getKeyboardLayout(String keyboardLayoutDescriptor) throws RemoteException {
                KeyboardLayout _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(keyboardLayoutDescriptor);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(KeyboardLayout.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getCurrentKeyboardLayoutForInputDevice(InputDeviceIdentifier identifier) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(identifier, 0);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCurrentKeyboardLayoutForInputDevice(InputDeviceIdentifier identifier, String keyboardLayoutDescriptor) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(identifier, 0);
                    _data.writeString(keyboardLayoutDescriptor);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] getEnabledKeyboardLayoutsForInputDevice(InputDeviceIdentifier identifier) throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(identifier, 0);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addKeyboardLayoutForInputDevice(InputDeviceIdentifier identifier, String keyboardLayoutDescriptor) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(identifier, 0);
                    _data.writeString(keyboardLayoutDescriptor);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeKeyboardLayoutForInputDevice(InputDeviceIdentifier identifier, String keyboardLayoutDescriptor) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(identifier, 0);
                    _data.writeString(keyboardLayoutDescriptor);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerInputDevicesChangedListener(IInputDevicesChangedListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int isInTabletMode() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerTabletModeChangedListener(ITabletModeChangedListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int isMicMuted() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void vibrate(int deviceId, VibrationEffect effect, IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    _data.writeTypedObject(effect, 0);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void vibrateCombined(int deviceId, CombinedVibration vibration, IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    _data.writeTypedObject(vibration, 0);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelVibrate(int deviceId, IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getVibratorIds(int deviceId) throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isVibrating(int deviceId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean registerVibratorStateListener(int deviceId, IVibratorStateListener listener) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean unregisterVibratorStateListener(int deviceId, IVibratorStateListener listener) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getBatteryStatus(int deviceId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getBatteryCapacity(int deviceId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPointerIconType(int typeId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(typeId);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCustomPointerIcon(PointerIcon icon) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(icon, 0);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestPointerCapture(IBinder inputChannelToken, boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(inputChannelToken);
                    _data.writeBoolean(enabled);
                    boolean bl = this.mRemote.transact(37, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public InputMonitor monitorGestureInput(IBinder token, String name, int displayId) throws RemoteException {
                InputMonitor _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeString(name);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(InputMonitor.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addPortAssociation(String inputPort, int displayPort) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(inputPort);
                    _data.writeInt(displayPort);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removePortAssociation(String inputPort) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(inputPort);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addUniqueIdAssociation(String inputPort, String displayUniqueId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(inputPort);
                    _data.writeString(displayUniqueId);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeUniqueIdAssociation(String inputPort) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(inputPort);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public InputSensorInfo[] getSensorList(int deviceId) throws RemoteException {
                InputSensorInfo[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(InputSensorInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean registerSensorListener(IInputSensorEventListener listener) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterSensorListener(IInputSensorEventListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean enableSensor(int deviceId, int sensorType, int samplingPeriodUs, int maxBatchReportLatencyUs) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    _data.writeInt(sensorType);
                    _data.writeInt(samplingPeriodUs);
                    _data.writeInt(maxBatchReportLatencyUs);
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disableSensor(int deviceId, int sensorType) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    _data.writeInt(sensorType);
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean flushSensor(int deviceId, int sensorType) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    _data.writeInt(sensorType);
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Light> getLights(int deviceId) throws RemoteException {
                ArrayList<Light> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(Light.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public LightState getLightState(int deviceId, int lightId) throws RemoteException {
                LightState _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    _data.writeInt(lightId);
                    boolean _status = this.mRemote.transact(50, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(LightState.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setLightStates(int deviceId, int[] lightIds, LightState[] states, IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    _data.writeIntArray(lightIds);
                    _data.writeTypedArray(states, 0);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(51, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void openLightSession(int deviceId, String opPkg, IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    _data.writeString(opPkg);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(52, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void closeLightSession(int deviceId, IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(53, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelCurrentTouch() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(54, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IInputManager {
        @Override
        public InputDevice getInputDevice(int deviceId) throws RemoteException {
            return null;
        }

        @Override
        public int[] getInputDeviceIds() throws RemoteException {
            return null;
        }

        @Override
        public boolean isInputDeviceEnabled(int deviceId) throws RemoteException {
            return false;
        }

        @Override
        public void enableInputDevice(int deviceId) throws RemoteException {
        }

        @Override
        public void disableInputDevice(int deviceId) throws RemoteException {
        }

        @Override
        public boolean hasKeys(int deviceId, int sourceMask, int[] keyCodes, boolean[] keyExists) throws RemoteException {
            return false;
        }

        @Override
        public int getKeyCodeForKeyLocation(int deviceId, int locationKeyCode) throws RemoteException {
            return 0;
        }

        @Override
        public void tryPointerSpeed(int speed) throws RemoteException {
        }

        @Override
        public boolean injectInputEvent(InputEvent ev, int mode) throws RemoteException {
            return false;
        }

        @Override
        public boolean injectInputEventToTarget(InputEvent ev, int mode, int targetUid) throws RemoteException {
            return false;
        }

        @Override
        public VerifiedInputEvent verifyInputEvent(InputEvent ev) throws RemoteException {
            return null;
        }

        @Override
        public TouchCalibration getTouchCalibrationForInputDevice(String inputDeviceDescriptor, int rotation) throws RemoteException {
            return null;
        }

        @Override
        public void setTouchCalibrationForInputDevice(String inputDeviceDescriptor, int rotation, TouchCalibration calibration) throws RemoteException {
        }

        @Override
        public KeyboardLayout[] getKeyboardLayouts() throws RemoteException {
            return null;
        }

        @Override
        public KeyboardLayout[] getKeyboardLayoutsForInputDevice(InputDeviceIdentifier identifier) throws RemoteException {
            return null;
        }

        @Override
        public KeyboardLayout getKeyboardLayout(String keyboardLayoutDescriptor) throws RemoteException {
            return null;
        }

        @Override
        public String getCurrentKeyboardLayoutForInputDevice(InputDeviceIdentifier identifier) throws RemoteException {
            return null;
        }

        @Override
        public void setCurrentKeyboardLayoutForInputDevice(InputDeviceIdentifier identifier, String keyboardLayoutDescriptor) throws RemoteException {
        }

        @Override
        public String[] getEnabledKeyboardLayoutsForInputDevice(InputDeviceIdentifier identifier) throws RemoteException {
            return null;
        }

        @Override
        public void addKeyboardLayoutForInputDevice(InputDeviceIdentifier identifier, String keyboardLayoutDescriptor) throws RemoteException {
        }

        @Override
        public void removeKeyboardLayoutForInputDevice(InputDeviceIdentifier identifier, String keyboardLayoutDescriptor) throws RemoteException {
        }

        @Override
        public void registerInputDevicesChangedListener(IInputDevicesChangedListener listener) throws RemoteException {
        }

        @Override
        public int isInTabletMode() throws RemoteException {
            return 0;
        }

        @Override
        public void registerTabletModeChangedListener(ITabletModeChangedListener listener) throws RemoteException {
        }

        @Override
        public int isMicMuted() throws RemoteException {
            return 0;
        }

        @Override
        public void vibrate(int deviceId, VibrationEffect effect, IBinder token) throws RemoteException {
        }

        @Override
        public void vibrateCombined(int deviceId, CombinedVibration vibration, IBinder token) throws RemoteException {
        }

        @Override
        public void cancelVibrate(int deviceId, IBinder token) throws RemoteException {
        }

        @Override
        public int[] getVibratorIds(int deviceId) throws RemoteException {
            return null;
        }

        @Override
        public boolean isVibrating(int deviceId) throws RemoteException {
            return false;
        }

        @Override
        public boolean registerVibratorStateListener(int deviceId, IVibratorStateListener listener) throws RemoteException {
            return false;
        }

        @Override
        public boolean unregisterVibratorStateListener(int deviceId, IVibratorStateListener listener) throws RemoteException {
            return false;
        }

        @Override
        public int getBatteryStatus(int deviceId) throws RemoteException {
            return 0;
        }

        @Override
        public int getBatteryCapacity(int deviceId) throws RemoteException {
            return 0;
        }

        @Override
        public void setPointerIconType(int typeId) throws RemoteException {
        }

        @Override
        public void setCustomPointerIcon(PointerIcon icon) throws RemoteException {
        }

        @Override
        public void requestPointerCapture(IBinder inputChannelToken, boolean enabled) throws RemoteException {
        }

        @Override
        public InputMonitor monitorGestureInput(IBinder token, String name, int displayId) throws RemoteException {
            return null;
        }

        @Override
        public void addPortAssociation(String inputPort, int displayPort) throws RemoteException {
        }

        @Override
        public void removePortAssociation(String inputPort) throws RemoteException {
        }

        @Override
        public void addUniqueIdAssociation(String inputPort, String displayUniqueId) throws RemoteException {
        }

        @Override
        public void removeUniqueIdAssociation(String inputPort) throws RemoteException {
        }

        @Override
        public InputSensorInfo[] getSensorList(int deviceId) throws RemoteException {
            return null;
        }

        @Override
        public boolean registerSensorListener(IInputSensorEventListener listener) throws RemoteException {
            return false;
        }

        @Override
        public void unregisterSensorListener(IInputSensorEventListener listener) throws RemoteException {
        }

        @Override
        public boolean enableSensor(int deviceId, int sensorType, int samplingPeriodUs, int maxBatchReportLatencyUs) throws RemoteException {
            return false;
        }

        @Override
        public void disableSensor(int deviceId, int sensorType) throws RemoteException {
        }

        @Override
        public boolean flushSensor(int deviceId, int sensorType) throws RemoteException {
            return false;
        }

        @Override
        public List<Light> getLights(int deviceId) throws RemoteException {
            return null;
        }

        @Override
        public LightState getLightState(int deviceId, int lightId) throws RemoteException {
            return null;
        }

        @Override
        public void setLightStates(int deviceId, int[] lightIds, LightState[] states, IBinder token) throws RemoteException {
        }

        @Override
        public void openLightSession(int deviceId, String opPkg, IBinder token) throws RemoteException {
        }

        @Override
        public void closeLightSession(int deviceId, IBinder token) throws RemoteException {
        }

        @Override
        public void cancelCurrentTouch() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

