/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.display;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.hardware.display.AmbientBrightnessDayStats;
import android.hardware.display.BrightnessChangeEvent;
import android.hardware.display.BrightnessConfiguration;
import android.hardware.display.ColorDisplayManager;
import android.hardware.display.DisplayManagerGlobal;
import android.hardware.display.VirtualDisplay;
import android.hardware.display.VirtualDisplayConfig;
import android.hardware.display.WifiDisplayStatus;
import android.media.projection.MediaProjection;
import android.os.Handler;
import android.os.HandlerExecutor;
import android.os.Looper;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import android.view.Display;
import android.view.Surface;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public class DisplayManager {
    private static final String TAG = "DisplayManager";
    private static final boolean DEBUG = false;
    private final Context mContext;
    private final DisplayManagerGlobal mGlobal;
    private final Object mLock = new Object();
    private final SparseArray<Display> mDisplays = new SparseArray();
    private final ArrayList<Display> mTempDisplays = new ArrayList();
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final String ACTION_WIFI_DISPLAY_STATUS_CHANGED = "android.hardware.display.action.WIFI_DISPLAY_STATUS_CHANGED";
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final String EXTRA_WIFI_DISPLAY_STATUS = "android.hardware.display.extra.WIFI_DISPLAY_STATUS";
    public static final String DISPLAY_CATEGORY_PRESENTATION = "android.hardware.display.category.PRESENTATION";
    public static final String DISPLAY_CATEGORY_ALL_INCLUDING_DISABLED = "android.hardware.display.category.ALL_INCLUDING_DISABLED";
    public static final int VIRTUAL_DISPLAY_FLAG_PUBLIC = 1;
    public static final int VIRTUAL_DISPLAY_FLAG_PRESENTATION = 2;
    public static final int VIRTUAL_DISPLAY_FLAG_SECURE = 4;
    public static final int VIRTUAL_DISPLAY_FLAG_OWN_CONTENT_ONLY = 8;
    public static final int VIRTUAL_DISPLAY_FLAG_AUTO_MIRROR = 16;
    public static final int VIRTUAL_DISPLAY_FLAG_CAN_SHOW_WITH_INSECURE_KEYGUARD = 32;
    public static final int VIRTUAL_DISPLAY_FLAG_SUPPORTS_TOUCH = 64;
    public static final int VIRTUAL_DISPLAY_FLAG_ROTATES_WITH_CONTENT = 128;
    public static final int VIRTUAL_DISPLAY_FLAG_DESTROY_CONTENT_ON_REMOVAL = 256;
    public static final int VIRTUAL_DISPLAY_FLAG_SHOULD_SHOW_SYSTEM_DECORATIONS = 512;
    @SystemApi
    public static final int VIRTUAL_DISPLAY_FLAG_TRUSTED = 1024;
    public static final int VIRTUAL_DISPLAY_FLAG_OWN_DISPLAY_GROUP = 2048;
    public static final int VIRTUAL_DISPLAY_FLAG_ALWAYS_UNLOCKED = 4096;
    public static final int VIRTUAL_DISPLAY_FLAG_TOUCH_FEEDBACK_DISABLED = 8192;
    public static final int MATCH_CONTENT_FRAMERATE_UNKNOWN = -1;
    public static final int MATCH_CONTENT_FRAMERATE_NEVER = 0;
    public static final int MATCH_CONTENT_FRAMERATE_SEAMLESSS_ONLY = 1;
    public static final int MATCH_CONTENT_FRAMERATE_ALWAYS = 2;
    public static final int SWITCHING_TYPE_NONE = 0;
    public static final int SWITCHING_TYPE_WITHIN_GROUPS = 1;
    public static final int SWITCHING_TYPE_ACROSS_AND_WITHIN_GROUPS = 2;
    public static final long EVENT_FLAG_DISPLAY_ADDED = 1L;
    public static final long EVENT_FLAG_DISPLAY_REMOVED = 2L;
    public static final long EVENT_FLAG_DISPLAY_CHANGED = 4L;
    public static final long EVENT_FLAG_DISPLAY_BRIGHTNESS = 8L;

    public DisplayManager(Context context) {
        this.mContext = context;
        this.mGlobal = DisplayManagerGlobal.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Display getDisplay(int displayId) {
        Object object = this.mLock;
        synchronized (object) {
            return this.getOrCreateDisplayLocked(displayId, false);
        }
    }

    public Display[] getDisplays() {
        return this.getDisplays(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Display[] getDisplays(String category) {
        boolean includeDisabledDisplays = category != null && category.equals(DISPLAY_CATEGORY_ALL_INCLUDING_DISABLED);
        int[] displayIds = this.mGlobal.getDisplayIds(includeDisabledDisplays);
        Object object = this.mLock;
        synchronized (object) {
            Display[] displayArray;
            try {
                if (category != null && category.equals(DISPLAY_CATEGORY_PRESENTATION)) {
                    this.addPresentationDisplaysLocked(this.mTempDisplays, displayIds, 3);
                    this.addPresentationDisplaysLocked(this.mTempDisplays, displayIds, 2);
                    this.addPresentationDisplaysLocked(this.mTempDisplays, displayIds, 4);
                    this.addPresentationDisplaysLocked(this.mTempDisplays, displayIds, 5);
                    this.addPresentationDisplaysLocked(this.mTempDisplays, displayIds, 1);
                } else if (category == null || DISPLAY_CATEGORY_ALL_INCLUDING_DISABLED.equals(category)) {
                    this.addAllDisplaysLocked(this.mTempDisplays, displayIds);
                }
                displayArray = this.mTempDisplays.toArray(new Display[this.mTempDisplays.size()]);
                this.mTempDisplays.clear();
            }
            catch (Throwable throwable) {
                this.mTempDisplays.clear();
                throw throwable;
            }
            return displayArray;
        }
    }

    private void addAllDisplaysLocked(ArrayList<Display> displays, int[] displayIds) {
        for (int i = 0; i < displayIds.length; ++i) {
            Display display = this.getOrCreateDisplayLocked(displayIds[i], true);
            if (display == null) continue;
            displays.add(display);
        }
    }

    private void addPresentationDisplaysLocked(ArrayList<Display> displays, int[] displayIds, int matchType) {
        for (int i = 0; i < displayIds.length; ++i) {
            Display display;
            if (displayIds[i] == 0 || (display = this.getOrCreateDisplayLocked(displayIds[i], true)) == null || (display.getFlags() & 8) == 0 || display.getType() != matchType) continue;
            displays.add(display);
        }
    }

    private Display getOrCreateDisplayLocked(int displayId, boolean assumeValid) {
        Display display = this.mDisplays.get(displayId);
        if (display == null) {
            Resources resources = this.mContext.getDisplayId() == displayId ? this.mContext.getResources() : null;
            display = this.mGlobal.getCompatibleDisplay(displayId, resources);
            if (display != null) {
                this.mDisplays.put(displayId, display);
            }
        } else if (!assumeValid && !display.isValid()) {
            display = null;
        }
        return display;
    }

    public void registerDisplayListener(DisplayListener listener, Handler handler) {
        this.registerDisplayListener(listener, handler, 7L);
    }

    public void registerDisplayListener(DisplayListener listener, Handler handler, long eventsMask) {
        this.mGlobal.registerDisplayListener(listener, handler, eventsMask);
    }

    public void unregisterDisplayListener(DisplayListener listener) {
        this.mGlobal.unregisterDisplayListener(listener);
    }

    @UnsupportedAppUsage
    public void startWifiDisplayScan() {
        this.mGlobal.startWifiDisplayScan();
    }

    @UnsupportedAppUsage
    public void stopWifiDisplayScan() {
        this.mGlobal.stopWifiDisplayScan();
    }

    @UnsupportedAppUsage
    public void connectWifiDisplay(String deviceAddress) {
        this.mGlobal.connectWifiDisplay(deviceAddress);
    }

    @UnsupportedAppUsage
    public void pauseWifiDisplay() {
        this.mGlobal.pauseWifiDisplay();
    }

    @UnsupportedAppUsage
    public void resumeWifiDisplay() {
        this.mGlobal.resumeWifiDisplay();
    }

    @UnsupportedAppUsage
    public void disconnectWifiDisplay() {
        this.mGlobal.disconnectWifiDisplay();
    }

    @UnsupportedAppUsage
    public void renameWifiDisplay(String deviceAddress, String alias) {
        this.mGlobal.renameWifiDisplay(deviceAddress, alias);
    }

    @UnsupportedAppUsage
    public void forgetWifiDisplay(String deviceAddress) {
        this.mGlobal.forgetWifiDisplay(deviceAddress);
    }

    @UnsupportedAppUsage
    public WifiDisplayStatus getWifiDisplayStatus() {
        return this.mGlobal.getWifiDisplayStatus();
    }

    @SystemApi
    @RequiresPermission(value="android.permission.CONTROL_DISPLAY_SATURATION")
    public void setSaturationLevel(float level) {
        if (level < 0.0f || level > 1.0f) {
            throw new IllegalArgumentException("Saturation level must be between 0 and 1");
        }
        ColorDisplayManager cdm = this.mContext.getSystemService(ColorDisplayManager.class);
        cdm.setSaturationLevel(Math.round(level * 100.0f));
    }

    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public void setUserDisabledHdrTypes(int[] userDisabledTypes) {
        this.mGlobal.setUserDisabledHdrTypes(userDisabledTypes);
    }

    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public void setAreUserDisabledHdrTypesAllowed(boolean areUserDisabledHdrTypesAllowed) {
        this.mGlobal.setAreUserDisabledHdrTypesAllowed(areUserDisabledHdrTypesAllowed);
    }

    public boolean areUserDisabledHdrTypesAllowed() {
        return this.mGlobal.areUserDisabledHdrTypesAllowed();
    }

    public int[] getUserDisabledHdrTypes() {
        return this.mGlobal.getUserDisabledHdrTypes();
    }

    public VirtualDisplay createVirtualDisplay(String name, int width, int height, int densityDpi, Surface surface, int flags) {
        return this.createVirtualDisplay(name, width, height, densityDpi, surface, flags, null, null);
    }

    public VirtualDisplay createVirtualDisplay(String name, int width, int height, int densityDpi, Surface surface, int flags, VirtualDisplay.Callback callback, Handler handler) {
        VirtualDisplayConfig.Builder builder = new VirtualDisplayConfig.Builder(name, width, height, densityDpi);
        builder.setFlags(flags);
        if (surface != null) {
            builder.setSurface(surface);
        }
        return this.createVirtualDisplay(null, builder.build(), callback, handler, null);
    }

    public VirtualDisplay createVirtualDisplay(MediaProjection projection, String name, int width, int height, int densityDpi, Surface surface, int flags, VirtualDisplay.Callback callback, Handler handler, String uniqueId) {
        VirtualDisplayConfig.Builder builder = new VirtualDisplayConfig.Builder(name, width, height, densityDpi);
        builder.setFlags(flags);
        if (uniqueId != null) {
            builder.setUniqueId(uniqueId);
        }
        if (surface != null) {
            builder.setSurface(surface);
        }
        return this.createVirtualDisplay(projection, builder.build(), callback, handler, null);
    }

    public VirtualDisplay createVirtualDisplay(MediaProjection projection, VirtualDisplayConfig virtualDisplayConfig, VirtualDisplay.Callback callback, Handler handler, Context windowContext) {
        HandlerExecutor executor = null;
        if (callback != null) {
            executor = new HandlerExecutor(Handler.createAsync(handler != null ? handler.getLooper() : Looper.myLooper()));
        }
        return this.mGlobal.createVirtualDisplay(this.mContext, projection, virtualDisplayConfig, callback, executor, windowContext);
    }

    @SystemApi
    public Point getStableDisplaySize() {
        return this.mGlobal.getStableDisplaySize();
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BRIGHTNESS_SLIDER_USAGE")
    public List<BrightnessChangeEvent> getBrightnessEvents() {
        return this.mGlobal.getBrightnessEvents(this.mContext.getOpPackageName());
    }

    @SystemApi
    @RequiresPermission(value="android.permission.ACCESS_AMBIENT_LIGHT_STATS")
    public List<AmbientBrightnessDayStats> getAmbientBrightnessStats() {
        return this.mGlobal.getAmbientBrightnessStats();
    }

    @SystemApi
    @RequiresPermission(value="android.permission.CONFIGURE_DISPLAY_BRIGHTNESS")
    public void setBrightnessConfiguration(BrightnessConfiguration c) {
        this.setBrightnessConfigurationForUser(c, this.mContext.getUserId(), this.mContext.getPackageName());
    }

    @SystemApi
    @RequiresPermission(value="android.permission.CONFIGURE_DISPLAY_BRIGHTNESS")
    public void setBrightnessConfigurationForDisplay(BrightnessConfiguration c, String uniqueId) {
        this.mGlobal.setBrightnessConfigurationForDisplay(c, uniqueId, this.mContext.getUserId(), this.mContext.getPackageName());
    }

    @SystemApi
    @RequiresPermission(value="android.permission.CONFIGURE_DISPLAY_BRIGHTNESS")
    public BrightnessConfiguration getBrightnessConfigurationForDisplay(String uniqueId) {
        return this.mGlobal.getBrightnessConfigurationForDisplay(uniqueId, this.mContext.getUserId());
    }

    public void setBrightnessConfigurationForUser(BrightnessConfiguration c, int userId, String packageName) {
        this.mGlobal.setBrightnessConfigurationForUser(c, userId, packageName);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.CONFIGURE_DISPLAY_BRIGHTNESS")
    public BrightnessConfiguration getBrightnessConfiguration() {
        return this.getBrightnessConfigurationForUser(this.mContext.getUserId());
    }

    public BrightnessConfiguration getBrightnessConfigurationForUser(int userId) {
        return this.mGlobal.getBrightnessConfigurationForUser(userId);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.CONFIGURE_DISPLAY_BRIGHTNESS")
    public BrightnessConfiguration getDefaultBrightnessConfiguration() {
        return this.mGlobal.getDefaultBrightnessConfiguration();
    }

    public boolean isMinimalPostProcessingRequested(int displayId) {
        return this.mGlobal.isMinimalPostProcessingRequested(displayId);
    }

    public void setTemporaryBrightness(int displayId, float brightness) {
        this.mGlobal.setTemporaryBrightness(displayId, brightness);
    }

    @RequiresPermission(value="android.permission.CONTROL_DISPLAY_BRIGHTNESS")
    public void setBrightness(int displayId, float brightness) {
        this.mGlobal.setBrightness(displayId, brightness);
    }

    @RequiresPermission(value="android.permission.CONTROL_DISPLAY_BRIGHTNESS")
    public float getBrightness(int displayId) {
        return this.mGlobal.getBrightness(displayId);
    }

    public void setTemporaryAutoBrightnessAdjustment(float adjustment) {
        this.mGlobal.setTemporaryAutoBrightnessAdjustment(adjustment);
    }

    @SystemApi
    public Pair<float[], float[]> getMinimumBrightnessCurve() {
        return this.mGlobal.getMinimumBrightnessCurve();
    }

    @RequiresPermission(value="android.permission.MODIFY_USER_PREFERRED_DISPLAY_MODE")
    public void setGlobalUserPreferredDisplayMode(Display.Mode mode) {
        Display.Mode preferredMode = new Display.Mode(mode.getPhysicalWidth(), mode.getPhysicalHeight(), mode.getRefreshRate());
        this.mGlobal.setUserPreferredDisplayMode(-1, preferredMode);
    }

    @RequiresPermission(value="android.permission.MODIFY_USER_PREFERRED_DISPLAY_MODE")
    public void clearGlobalUserPreferredDisplayMode() {
        this.mGlobal.setUserPreferredDisplayMode(-1, null);
    }

    public Display.Mode getGlobalUserPreferredDisplayMode() {
        return this.mGlobal.getUserPreferredDisplayMode(-1);
    }

    @RequiresPermission(value="android.permission.OVERRIDE_DISPLAY_MODE_REQUESTS")
    public void setShouldAlwaysRespectAppRequestedMode(boolean enabled) {
        this.mGlobal.setShouldAlwaysRespectAppRequestedMode(enabled);
    }

    @RequiresPermission(value="android.permission.OVERRIDE_DISPLAY_MODE_REQUESTS")
    public boolean shouldAlwaysRespectAppRequestedMode() {
        return this.mGlobal.shouldAlwaysRespectAppRequestedMode();
    }

    @RequiresPermission(value="android.permission.MODIFY_REFRESH_RATE_SWITCHING_TYPE")
    public void setRefreshRateSwitchingType(int newValue) {
        this.mGlobal.setRefreshRateSwitchingType(newValue);
    }

    public int getMatchContentFrameRateUserPreference() {
        return this.toMatchContentFrameRateSetting(this.mGlobal.getRefreshRateSwitchingType());
    }

    private int toMatchContentFrameRateSetting(int switchingType) {
        switch (switchingType) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        Slog.e(TAG, switchingType + " is not a valid value of switching type.");
        return -1;
    }

    public static interface DeviceConfig {
        public static final String KEY_REFRESH_RATE_IN_LOW_ZONE = "refresh_rate_in_zone";
        public static final String KEY_FIXED_REFRESH_RATE_LOW_DISPLAY_BRIGHTNESS_THRESHOLDS = "peak_refresh_rate_brightness_thresholds";
        public static final String KEY_FIXED_REFRESH_RATE_LOW_AMBIENT_BRIGHTNESS_THRESHOLDS = "peak_refresh_rate_ambient_thresholds";
        public static final String KEY_REFRESH_RATE_IN_HIGH_ZONE = "refresh_rate_in_high_zone";
        public static final String KEY_FIXED_REFRESH_RATE_HIGH_DISPLAY_BRIGHTNESS_THRESHOLDS = "fixed_refresh_rate_high_display_brightness_thresholds";
        public static final String KEY_FIXED_REFRESH_RATE_HIGH_AMBIENT_BRIGHTNESS_THRESHOLDS = "fixed_refresh_rate_high_ambient_brightness_thresholds";
        public static final String KEY_REFRESH_RATE_IN_HBM_SUNLIGHT = "refresh_rate_in_hbm_sunlight";
        public static final String KEY_REFRESH_RATE_IN_HBM_HDR = "refresh_rate_in_hbm_hdr";
        public static final String KEY_PEAK_REFRESH_RATE_DEFAULT = "peak_refresh_rate_default";
        public static final String KEY_HIGH_REFRESH_RATE_BLACKLIST = "high_refresh_rate_blacklist";
    }

    public static interface DisplayListener {
        public void onDisplayAdded(int var1);

        public void onDisplayRemoved(int var1);

        public void onDisplayChanged(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EventsMask {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SwitchingType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MatchContentFrameRateType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VirtualDisplayFlag {
    }
}

