/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.biometrics;

import android.hardware.biometrics.BiometricManager;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.List;

public class PromptInfo
implements Parcelable {
    private CharSequence mTitle;
    private boolean mUseDefaultTitle;
    private CharSequence mSubtitle;
    private CharSequence mDescription;
    private CharSequence mDeviceCredentialTitle;
    private CharSequence mDeviceCredentialSubtitle;
    private CharSequence mDeviceCredentialDescription;
    private CharSequence mNegativeButtonText;
    private boolean mConfirmationRequested = true;
    private boolean mDeviceCredentialAllowed;
    @BiometricManager.Authenticators.Types
    private int mAuthenticators;
    private boolean mDisallowBiometricsIfPolicyExists;
    private boolean mReceiveSystemEvents;
    private List<Integer> mAllowedSensorIds = new ArrayList<Integer>();
    private boolean mAllowBackgroundAuthentication;
    private boolean mIgnoreEnrollmentState;
    private boolean mIsForLegacyFingerprintManager = false;
    public static final Parcelable.Creator<PromptInfo> CREATOR = new Parcelable.Creator<PromptInfo>(){

        @Override
        public PromptInfo createFromParcel(Parcel in) {
            return new PromptInfo(in);
        }

        public PromptInfo[] newArray(int size) {
            return new PromptInfo[size];
        }
    };

    public PromptInfo() {
    }

    PromptInfo(Parcel in) {
        this.mTitle = in.readCharSequence();
        this.mUseDefaultTitle = in.readBoolean();
        this.mSubtitle = in.readCharSequence();
        this.mDescription = in.readCharSequence();
        this.mDeviceCredentialTitle = in.readCharSequence();
        this.mDeviceCredentialSubtitle = in.readCharSequence();
        this.mDeviceCredentialDescription = in.readCharSequence();
        this.mNegativeButtonText = in.readCharSequence();
        this.mConfirmationRequested = in.readBoolean();
        this.mDeviceCredentialAllowed = in.readBoolean();
        this.mAuthenticators = in.readInt();
        this.mDisallowBiometricsIfPolicyExists = in.readBoolean();
        this.mReceiveSystemEvents = in.readBoolean();
        this.mAllowedSensorIds = in.readArrayList(Integer.class.getClassLoader(), Integer.class);
        this.mAllowBackgroundAuthentication = in.readBoolean();
        this.mIgnoreEnrollmentState = in.readBoolean();
        this.mIsForLegacyFingerprintManager = in.readBoolean();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeCharSequence(this.mTitle);
        dest.writeBoolean(this.mUseDefaultTitle);
        dest.writeCharSequence(this.mSubtitle);
        dest.writeCharSequence(this.mDescription);
        dest.writeCharSequence(this.mDeviceCredentialTitle);
        dest.writeCharSequence(this.mDeviceCredentialSubtitle);
        dest.writeCharSequence(this.mDeviceCredentialDescription);
        dest.writeCharSequence(this.mNegativeButtonText);
        dest.writeBoolean(this.mConfirmationRequested);
        dest.writeBoolean(this.mDeviceCredentialAllowed);
        dest.writeInt(this.mAuthenticators);
        dest.writeBoolean(this.mDisallowBiometricsIfPolicyExists);
        dest.writeBoolean(this.mReceiveSystemEvents);
        dest.writeList(this.mAllowedSensorIds);
        dest.writeBoolean(this.mAllowBackgroundAuthentication);
        dest.writeBoolean(this.mIgnoreEnrollmentState);
        dest.writeBoolean(this.mIsForLegacyFingerprintManager);
    }

    public boolean containsTestConfigurations() {
        if (this.mIsForLegacyFingerprintManager && this.mAllowedSensorIds.size() == 1 && !this.mAllowBackgroundAuthentication) {
            return false;
        }
        if (!this.mAllowedSensorIds.isEmpty()) {
            return true;
        }
        return this.mAllowBackgroundAuthentication;
    }

    public boolean containsPrivateApiConfigurations() {
        if (this.mDisallowBiometricsIfPolicyExists) {
            return true;
        }
        if (this.mUseDefaultTitle) {
            return true;
        }
        if (this.mDeviceCredentialTitle != null) {
            return true;
        }
        if (this.mDeviceCredentialSubtitle != null) {
            return true;
        }
        if (this.mDeviceCredentialDescription != null) {
            return true;
        }
        return this.mReceiveSystemEvents;
    }

    public void setTitle(CharSequence title) {
        this.mTitle = title;
    }

    public void setUseDefaultTitle(boolean useDefaultTitle) {
        this.mUseDefaultTitle = useDefaultTitle;
    }

    public void setSubtitle(CharSequence subtitle) {
        this.mSubtitle = subtitle;
    }

    public void setDescription(CharSequence description) {
        this.mDescription = description;
    }

    public void setDeviceCredentialTitle(CharSequence deviceCredentialTitle) {
        this.mDeviceCredentialTitle = deviceCredentialTitle;
    }

    public void setDeviceCredentialSubtitle(CharSequence deviceCredentialSubtitle) {
        this.mDeviceCredentialSubtitle = deviceCredentialSubtitle;
    }

    public void setDeviceCredentialDescription(CharSequence deviceCredentialDescription) {
        this.mDeviceCredentialDescription = deviceCredentialDescription;
    }

    public void setNegativeButtonText(CharSequence negativeButtonText) {
        this.mNegativeButtonText = negativeButtonText;
    }

    public void setConfirmationRequested(boolean confirmationRequested) {
        this.mConfirmationRequested = confirmationRequested;
    }

    public void setDeviceCredentialAllowed(boolean deviceCredentialAllowed) {
        this.mDeviceCredentialAllowed = deviceCredentialAllowed;
    }

    public void setAuthenticators(int authenticators) {
        this.mAuthenticators = authenticators;
    }

    public void setDisallowBiometricsIfPolicyExists(boolean disallowBiometricsIfPolicyExists) {
        this.mDisallowBiometricsIfPolicyExists = disallowBiometricsIfPolicyExists;
    }

    public void setReceiveSystemEvents(boolean receiveSystemEvents) {
        this.mReceiveSystemEvents = receiveSystemEvents;
    }

    public void setAllowedSensorIds(List<Integer> sensorIds) {
        this.mAllowedSensorIds.clear();
        this.mAllowedSensorIds.addAll(sensorIds);
    }

    public void setAllowBackgroundAuthentication(boolean allow) {
        this.mAllowBackgroundAuthentication = allow;
    }

    public void setIgnoreEnrollmentState(boolean ignoreEnrollmentState) {
        this.mIgnoreEnrollmentState = ignoreEnrollmentState;
    }

    public void setIsForLegacyFingerprintManager(int sensorId) {
        this.mIsForLegacyFingerprintManager = true;
        this.mAllowedSensorIds.clear();
        this.mAllowedSensorIds.add(sensorId);
    }

    public CharSequence getTitle() {
        return this.mTitle;
    }

    public boolean isUseDefaultTitle() {
        return this.mUseDefaultTitle;
    }

    public CharSequence getSubtitle() {
        return this.mSubtitle;
    }

    public CharSequence getDescription() {
        return this.mDescription;
    }

    public CharSequence getDeviceCredentialTitle() {
        return this.mDeviceCredentialTitle;
    }

    public CharSequence getDeviceCredentialSubtitle() {
        return this.mDeviceCredentialSubtitle;
    }

    public CharSequence getDeviceCredentialDescription() {
        return this.mDeviceCredentialDescription;
    }

    public CharSequence getNegativeButtonText() {
        return this.mNegativeButtonText;
    }

    public boolean isConfirmationRequested() {
        return this.mConfirmationRequested;
    }

    @Deprecated
    public boolean isDeviceCredentialAllowed() {
        return this.mDeviceCredentialAllowed;
    }

    public int getAuthenticators() {
        return this.mAuthenticators;
    }

    public boolean isDisallowBiometricsIfPolicyExists() {
        return this.mDisallowBiometricsIfPolicyExists;
    }

    public boolean isReceiveSystemEvents() {
        return this.mReceiveSystemEvents;
    }

    public List<Integer> getAllowedSensorIds() {
        return this.mAllowedSensorIds;
    }

    public boolean isAllowBackgroundAuthentication() {
        return this.mAllowBackgroundAuthentication;
    }

    public boolean isIgnoreEnrollmentState() {
        return this.mIgnoreEnrollmentState;
    }

    public boolean isForLegacyFingerprintManager() {
        return this.mIsForLegacyFingerprintManager;
    }
}

