/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.ParcelFileDescriptor;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;

public class SerialPort {
    private static final String TAG = "SerialPort";
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private int mNativeContext;
    private final String mName;
    private ParcelFileDescriptor mFileDescriptor;

    public SerialPort(String name) {
        this.mName = name;
    }

    public void open(ParcelFileDescriptor pfd, int speed) throws IOException {
        this.native_open(pfd.getFileDescriptor(), speed);
        this.mFileDescriptor = pfd;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void close() throws IOException {
        if (this.mFileDescriptor != null) {
            this.mFileDescriptor.close();
            this.mFileDescriptor = null;
        }
        this.native_close();
    }

    public String getName() {
        return this.mName;
    }

    public int read(ByteBuffer buffer) throws IOException {
        if (buffer.isDirect()) {
            return this.native_read_direct(buffer, buffer.remaining());
        }
        if (buffer.hasArray()) {
            return this.native_read_array(buffer.array(), buffer.remaining());
        }
        throw new IllegalArgumentException("buffer is not direct and has no array");
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void write(ByteBuffer buffer, int length) throws IOException {
        if (buffer.isDirect()) {
            this.native_write_direct(buffer, length);
        } else if (buffer.hasArray()) {
            this.native_write_array(buffer.array(), length);
        } else {
            throw new IllegalArgumentException("buffer is not direct and has no array");
        }
    }

    public void sendBreak() {
        this.native_send_break();
    }

    private void native_open(FileDescriptor fileDescriptor, int n) throws IOException {
        OverrideMethod.invokeV("android.hardware.SerialPort#native_open(Ljava/io/FileDescriptor;I)V", true, this);
    }

    private void native_close() {
        OverrideMethod.invokeV("android.hardware.SerialPort#native_close()V", true, this);
    }

    private int native_read_array(byte[] byArray, int n) throws IOException {
        return OverrideMethod.invokeI("android.hardware.SerialPort#native_read_array([BI)I", true, this);
    }

    private int native_read_direct(ByteBuffer byteBuffer, int n) throws IOException {
        return OverrideMethod.invokeI("android.hardware.SerialPort#native_read_direct(Ljava/nio/ByteBuffer;I)I", true, this);
    }

    private void native_write_array(byte[] byArray, int n) throws IOException {
        OverrideMethod.invokeV("android.hardware.SerialPort#native_write_array([BI)V", true, this);
    }

    private void native_write_direct(ByteBuffer byteBuffer, int n) throws IOException {
        OverrideMethod.invokeV("android.hardware.SerialPort#native_write_direct(Ljava/nio/ByteBuffer;I)V", true, this);
    }

    private void native_send_break() {
        OverrideMethod.invokeV("android.hardware.SerialPort#native_send_break()V", true, this);
    }
}

