/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.BlendMode;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.MathUtils;

public class ColorStateListDrawable
extends Drawable
implements Drawable.Callback {
    private ColorDrawable mColorDrawable;
    private ColorStateListDrawableState mState;
    private boolean mMutated = false;

    public ColorStateListDrawable() {
        this.mState = new ColorStateListDrawableState();
        this.initializeColorDrawable();
    }

    public ColorStateListDrawable(ColorStateList colorStateList) {
        this.mState = new ColorStateListDrawableState();
        this.initializeColorDrawable();
        this.setColorStateList(colorStateList);
    }

    private ColorStateListDrawable(ColorStateListDrawableState state) {
        this.mState = state;
        this.initializeColorDrawable();
        this.onStateChange(this.getState());
    }

    @Override
    public void draw(Canvas canvas) {
        this.mColorDrawable.draw(canvas);
    }

    @Override
    public int getAlpha() {
        return this.mColorDrawable.getAlpha();
    }

    @Override
    public boolean isStateful() {
        return this.mState.isStateful();
    }

    @Override
    public boolean hasFocusStateSpecified() {
        return this.mState.hasFocusStateSpecified();
    }

    @Override
    public Drawable getCurrent() {
        return this.mColorDrawable;
    }

    @Override
    public void applyTheme(Resources.Theme t) {
        super.applyTheme(t);
        if (this.mState.mColor != null) {
            this.setColorStateList(this.mState.mColor.obtainForTheme(t));
        }
        if (this.mState.mTint != null) {
            this.setTintList(this.mState.mTint.obtainForTheme(t));
        }
    }

    @Override
    public boolean canApplyTheme() {
        return super.canApplyTheme() || this.mState.canApplyTheme();
    }

    @Override
    public void setAlpha(int alpha) {
        this.mState.mAlpha = alpha;
        this.onStateChange(this.getState());
    }

    public void clearAlpha() {
        this.mState.mAlpha = -1;
        this.onStateChange(this.getState());
    }

    @Override
    public void setTintList(ColorStateList tint) {
        this.mState.mTint = tint;
        this.mColorDrawable.setTintList(tint);
        this.onStateChange(this.getState());
    }

    @Override
    public void setTintBlendMode(BlendMode blendMode) {
        this.mState.mBlendMode = blendMode;
        this.mColorDrawable.setTintBlendMode(blendMode);
        this.onStateChange(this.getState());
    }

    @Override
    public ColorFilter getColorFilter() {
        return this.mColorDrawable.getColorFilter();
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        this.mColorDrawable.setColorFilter(colorFilter);
    }

    @Override
    public int getOpacity() {
        return this.mColorDrawable.getOpacity();
    }

    @Override
    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.mColorDrawable.setBounds(bounds);
    }

    @Override
    protected boolean onStateChange(int[] state) {
        if (this.mState.mColor != null) {
            int color2 = this.mState.mColor.getColorForState(state, this.mState.mColor.getDefaultColor());
            if (this.mState.mAlpha != -1) {
                color2 = color2 & 0xFFFFFF | MathUtils.constrain(this.mState.mAlpha, 0, 255) << 24;
            }
            if (color2 != this.mColorDrawable.getColor()) {
                this.mColorDrawable.setColor(color2);
                this.mColorDrawable.setState(state);
                return true;
            }
            return this.mColorDrawable.setState(state);
        }
        return false;
    }

    @Override
    public void invalidateDrawable(Drawable who) {
        if (who == this.mColorDrawable && this.getCallback() != null) {
            this.getCallback().invalidateDrawable(this);
        }
    }

    @Override
    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        if (who == this.mColorDrawable && this.getCallback() != null) {
            this.getCallback().scheduleDrawable(this, what, when);
        }
    }

    @Override
    public void unscheduleDrawable(Drawable who, Runnable what) {
        if (who == this.mColorDrawable && this.getCallback() != null) {
            this.getCallback().unscheduleDrawable(this, what);
        }
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        this.mState.mChangingConfigurations |= this.getChangingConfigurations() & ~this.mState.getChangingConfigurations();
        return this.mState;
    }

    public ColorStateList getColorStateList() {
        if (this.mState.mColor == null) {
            return ColorStateList.valueOf(this.mColorDrawable.getColor());
        }
        return this.mState.mColor;
    }

    @Override
    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mState.getChangingConfigurations();
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mState = new ColorStateListDrawableState(this.mState);
            this.mMutated = true;
        }
        return this;
    }

    @Override
    public void clearMutated() {
        super.clearMutated();
        this.mMutated = false;
    }

    public void setColorStateList(ColorStateList colorStateList) {
        this.mState.mColor = colorStateList;
        this.onStateChange(this.getState());
    }

    private void initializeColorDrawable() {
        this.mColorDrawable = new ColorDrawable();
        this.mColorDrawable.setCallback(this);
        if (this.mState.mTint != null) {
            this.mColorDrawable.setTintList(this.mState.mTint);
        }
        if (this.mState.mBlendMode != DEFAULT_BLEND_MODE) {
            this.mColorDrawable.setTintBlendMode(this.mState.mBlendMode);
        }
    }

    static class ColorStateListDrawableState
    extends Drawable.ConstantState {
        ColorStateList mColor = null;
        ColorStateList mTint = null;
        int mAlpha = -1;
        BlendMode mBlendMode = Drawable.DEFAULT_BLEND_MODE;
        int mChangingConfigurations = 0;

        ColorStateListDrawableState() {
        }

        ColorStateListDrawableState(ColorStateListDrawableState state) {
            this.mColor = state.mColor;
            this.mTint = state.mTint;
            this.mAlpha = state.mAlpha;
            this.mBlendMode = state.mBlendMode;
            this.mChangingConfigurations = state.mChangingConfigurations;
        }

        @Override
        public Drawable newDrawable() {
            return new ColorStateListDrawable(this);
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations | (this.mColor != null ? this.mColor.getChangingConfigurations() : 0) | (this.mTint != null ? this.mTint.getChangingConfigurations() : 0);
        }

        public boolean isStateful() {
            return this.mColor != null && this.mColor.isStateful() || this.mTint != null && this.mTint.isStateful();
        }

        public boolean hasFocusStateSpecified() {
            return this.mColor != null && this.mColor.hasFocusStateSpecified() || this.mTint != null && this.mTint.hasFocusStateSpecified();
        }

        @Override
        public boolean canApplyTheme() {
            return this.mColor != null && this.mColor.canApplyTheme() || this.mTint != null && this.mTint.canApplyTheme();
        }
    }
}

